/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.capable.CurvedReformatCapable;
import com.ge.med.terra.jami.capable.MultiVolumeCapable;
import com.ge.med.terra.jami.capable.SurfaceRenderingCapable;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.J3DBaseVolumeModel;
import com.ge.med.terra.jami.j3d.T3DBaseRenderEngine;
import com.ge.med.terra.jami.j3d.mprender.DefaultMultipassMap;
import com.ge.med.terra.jami.j3d.mprender.MultipassMap;
import com.ge.med.terra.jami.j3d.mprender.MultipassPolicy;
import com.ge.med.terra.jami.j3d.mprender.OnepassAlgorithm;
import java.beans.PropertyChangeEvent;
import java.io.InputStream;

public abstract class J3DBaseRenderEngine
extends T3DBaseRenderEngine
implements CurvedReformatCapable,
IterativeRenderer,
VrCapable,
MultiVolumeCapable,
SurfaceRenderingCapable {
    public static final String SEGMENTATION_MASK = "SEGMENTATION_MASK";
    private static MultipassPolicy mpassPolicy;
    private ParallelTaskManager ptm = null;
    private MultipassAlgorithm onepass = null;

    public J3DBaseRenderEngine() {
        this.ptm = new ParallelTaskManager();
        this.init();
    }

    public J3DBaseRenderEngine(ParallelTaskManager ptm) {
        this.ptm = ptm;
        this.init();
    }

    private void init() {
        this.setMultipassMap(this.createMultipassMap(this.ptm));
        this.onepass = new OnepassAlgorithm(this.ptm);
        this.onepass.setT3DIRenderer(this);
    }

    @Override
    protected boolean calculateVoxelRASTransform(XjVolumeModel vm, CTransform vox2ras, CTransform ras2vox) {
        if (vm != null) {
            J3DBaseVolumeModel jvm = (J3DBaseVolumeModel)vm;
            JnMatrix4d v2r = jvm.getVoxel2RASTransform();
            JnMatrix4d r2v = jvm.getRAS2VoxelTransform();
            vox2ras.set(v2r.m00, v2r.m01, v2r.m02, v2r.m03, v2r.m10, v2r.m11, v2r.m12, v2r.m13, v2r.m20, v2r.m21, v2r.m22, v2r.m23, v2r.m30, v2r.m31, v2r.m32, v2r.m33);
            ras2vox.set(r2v.m00, r2v.m01, r2v.m02, r2v.m03, r2v.m10, r2v.m11, r2v.m12, r2v.m13, r2v.m20, r2v.m21, r2v.m22, r2v.m23, r2v.m30, r2v.m31, r2v.m32, r2v.m33);
            return true;
        }
        return false;
    }

    protected MultipassMap createMultipassMap(ParallelTaskManager ptm) {
        MultipassMap mpMap;
        if (mpassPolicy != null && (mpMap = mpassPolicy.createMultipassMap((IterativeRenderer)this, ptm)) != null) {
            return mpMap;
        }
        return new DefaultMultipassMap(this, ptm);
    }

    protected ParallelTaskManager getParallelTaskManager() {
        return this.ptm;
    }

    @Override
    public void shutdown() {
        this.ptm.destroy();
        super.shutdown();
    }

    protected void finalize() throws Throwable {
        this.ptm.destroy();
        super.finalize();
    }

    @Override
    public void initRender() {
        super.initRender();
    }

    @Override
    public void render(int renderOutputLayer) {
        this.initRender();
        int width = this.getBufferWidth();
        int height = this.getBufferHeight();
        this.onepass.render(0, 0, width, height, renderOutputLayer, 0);
    }

    protected static final void transform4_3(double[] matrix, float[] pt) {
        double x = matrix[0] * (double)pt[0] + matrix[1] * (double)pt[1] + matrix[2] * (double)pt[2] + matrix[3];
        double y = matrix[4] * (double)pt[0] + matrix[5] * (double)pt[1] + matrix[6] * (double)pt[2] + matrix[7];
        double z = matrix[8] * (double)pt[0] + matrix[9] * (double)pt[1] + matrix[10] * (double)pt[2] + matrix[11];
        pt[0] = (float)x;
        pt[1] = (float)y;
        pt[2] = (float)z;
    }

    protected static final void transform4_3_0(double[] matrix, float[] pt) {
        double x = matrix[0] * (double)pt[0] + matrix[1] * (double)pt[1] + matrix[2] * (double)pt[2];
        double y = matrix[4] * (double)pt[0] + matrix[5] * (double)pt[1] + matrix[6] * (double)pt[2];
        double z = matrix[8] * (double)pt[0] + matrix[9] * (double)pt[1] + matrix[10] * (double)pt[2];
        pt[0] = (float)x;
        pt[1] = (float)y;
        pt[2] = (float)z;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    @Override
    public void taskBegin(String taskName, int totalWork) {
        super.taskBegin(taskName, totalWork);
        this.notifyTaskBegin(taskName, totalWork);
    }

    @Override
    public void taskDone(String taskName) {
        super.taskDone(taskName);
        this.notifyTaskDone(taskName);
    }

    @Override
    public void taskProgress(String taskName, int units) {
        super.taskProgress(taskName, units);
        this.notifyTaskProgress(taskName, units);
    }

    @Override
    public void taskFailed(String taskName, String reason, Exception e) {
        super.taskFailed(taskName, reason, e);
    }

    static {
        InputStream is;
        mpassPolicy = null;
        String propValue = XpPropertiesManager.getProperty("com.ge.med.terra.jami.j3d.J3DRenderEngine.MultipassPolicy", null);
        if (propValue == null) {
            propValue = XpPropertiesManager.getProperty("com.ge.med.idc.mprender.MultipassPolicy", "profile,local");
        }
        if ((is = J3DBaseRenderEngine.mpassInputStream(propValue)) != null) {
            mpassPolicy = new MultipassPolicy(is);
        }
    }
}

