/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnQuaternion;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.CustomCursor;
import com.ge.med.terra.jami.j3d.T3DTrackball;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class LargeOrientationCubeVc
extends XpVisualComponent
implements PropertyChangeListener,
MouseInputListener,
SwingConstants {
    protected int position_ = 4;
    private static final Color EDGE_COLOR = Color.RED;
    private static final float SCALE = 200.0f;
    private static final float MAX_SCALE = 200.0f;
    private static final Stroke EDGE_STROKE = new BasicStroke(1.0f);
    private static final Shape CUBE_FACE = new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0);
    private static final double[] VERTICES = new double[]{-0.5, -0.5, -0.5, -0.5, -0.5, 0.5, 0.5, -0.5, 0.5, 0.5, -0.5, -0.5, -0.5, 0.5, -0.5, -0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, -0.5};
    private static final double[] VERTICESX = new double[]{VERTICES[0], VERTICES[3], VERTICES[6], VERTICES[9], VERTICES[12], VERTICES[15], VERTICES[18], VERTICES[21]};
    private static final double[] VERTICESY = new double[]{VERTICES[1], VERTICES[4], VERTICES[7], VERTICES[10], VERTICES[13], VERTICES[16], VERTICES[19], VERTICES[22]};
    private static final double[] VERTICESZ = new double[]{VERTICES[2], VERTICES[5], VERTICES[8], VERTICES[11], VERTICES[14], VERTICES[17], VERTICES[20], VERTICES[23]};
    private static final int[] A_POLYGON = new int[]{3, 2, 1, 0};
    private static final int[] P_POLYGON = new int[]{4, 5, 6, 7};
    private static final int[] S_POLYGON = new int[]{2, 6, 5, 1};
    private static final int[] I_POLYGON = new int[]{7, 3, 0, 4};
    private static final int[] L_POLYGON = new int[]{7, 6, 2, 3};
    private static final int[] R_POLYGON = new int[]{0, 1, 5, 4};
    private static final int[][] POLYGONS = new int[][]{A_POLYGON, P_POLYGON, S_POLYGON, I_POLYGON, L_POLYGON, R_POLYGON};
    private JnMatrix3d rotation_ = new JnMatrix3d();
    private JnVector3d[] transformed_ = new JnVector3d[VERTICESX.length];
    private Point2D[] projected_ = new Point2D[VERTICESX.length];
    private static final int MIN_SIZE = 128;
    private double realScale_ = 1.0;
    private JnVector3d v0 = new JnVector3d();
    private JnVector3d v1 = new JnVector3d();
    private JnVector3d v2 = new JnVector3d();
    private double[] MM = new double[6];
    private double[] PP = new double[6];
    private static final double[] THREE_CORNERS = new double[]{0.5, 0.5, 0.5, -0.5, -0.5, -0.5};
    private static final String[] LABEL_LIST = new String[]{"a", "p", "s", "i", "l", "r"};
    private static Font ORIENTATION_FONT = new Font("Serif", 0, 1);
    protected JnVector3d lookPoint_ = new JnVector3d(0.0, 0.0, 0.0);
    protected JnVector3d eyePoint_ = new JnVector3d(0.0, 0.0, -1.0);
    protected JnVector3d upVector_ = new JnVector3d(0.0, 1.0, 0.0);
    private boolean trackEnabled_ = false;
    private T3DCapable t3dCapable_;
    MouseEvent ePrev_;
    private Cursor3DModel cursor_;

    public LargeOrientationCubeVc(T3DCapable t3dCapable, int dockLocation) {
        this.setCursor(CustomCursor.ROTATION_3D_CURSOR);
        if (t3dCapable != null) {
            this.lookPoint_.set(t3dCapable.getLookPoint(null));
            this.eyePoint_.set(t3dCapable.getEyePoint(null));
            this.upVector_.set(t3dCapable.getUp(null));
            t3dCapable.addPropertyChangeListener(this);
            this.t3dCapable_ = t3dCapable;
        }
        if (dockLocation != 5 && dockLocation != 7 && dockLocation != 1 && dockLocation != 3 && dockLocation != 8 && dockLocation != 2 && dockLocation != 6 && dockLocation != 4) {
            throw new IllegalArgumentException("cube location must be one of the eight NWSE directions");
        }
        this.position_ = dockLocation;
        for (int i = 0; i < this.transformed_.length; ++i) {
            this.transformed_[i] = new JnVector3d();
            this.projected_[i] = new Point2D.Double();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public LargeOrientationCubeVc(T3DCapable capable) {
        this(capable, 4);
    }

    public LargeOrientationCubeVc() {
        this((T3DCapable)null);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.t3dCapable_ == null) {
            return;
        }
        if (this.getWidth() < 128 || this.getHeight() < 128) {
            return;
        }
        this.realScale_ = Math.min(200.0f * (float)Math.min(this.getWidth(), this.getHeight()) / 512.0f, 200.0f);
        JnVector3d zv = new JnVector3d();
        zv.sub(this.lookPoint_, this.eyePoint_);
        zv.normalize();
        zv.x = -zv.x;
        zv.y = -zv.y;
        JnVector3d yv = new JnVector3d();
        yv.set(this.upVector_);
        yv.normalize();
        yv.z = -yv.z;
        JnVector3d xv = JnVector3d.cross(yv, zv);
        this.rotation_.set(xv.x, xv.y, xv.z, yv.x, yv.y, yv.z, zv.x, zv.y, zv.z);
        this.transformPoints();
        this.projectPoints();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(EDGE_COLOR);
        g2.translate(this.getWidth() / 2, this.getHeight() / 2);
        g2.setStroke(EDGE_STROKE);
        for (int i = 0; i < POLYGONS.length; ++i) {
            if (this.backCull(POLYGONS[i])) continue;
            this.paintPolygon(POLYGONS[i], g2, i);
        }
    }

    private void transformPoints() {
        for (int i = 0; i < this.transformed_.length; ++i) {
            this.transformed_[i].set(VERTICESX[i], VERTICESY[i], VERTICESZ[i]);
            this.rotation_.transform(this.transformed_[i]);
        }
    }

    private void projectPoints() {
        for (int i = 0; i < this.projected_.length; ++i) {
            this.projected_[i].setLocation(this.transformed_[i].x, this.transformed_[i].y);
        }
    }

    private boolean backCull(int[] ptIndices) {
        this.v0.set(this.projected_[ptIndices[0]].getX(), this.projected_[ptIndices[0]].getY(), 0.0);
        this.v1.set(this.projected_[ptIndices[1]].getX(), this.projected_[ptIndices[1]].getY(), 0.0);
        this.v2.set(this.projected_[ptIndices[2]].getX(), this.projected_[ptIndices[2]].getY(), 0.0);
        this.v1.sub(this.v0);
        this.v2.sub(this.v0);
        JnVector3d.cross(this.v1, this.v2, this.v0);
        return this.v0.z >= 0.0;
    }

    private void paintPolygon(int[] ptIndices, Graphics2D g, int orientationIndex) {
        Color c = g.getColor();
        Stroke s = g.getStroke();
        this.PP[0] = this.projected_[ptIndices[0]].getX();
        this.PP[1] = this.projected_[ptIndices[0]].getY();
        this.PP[2] = this.projected_[ptIndices[1]].getX();
        this.PP[3] = this.projected_[ptIndices[1]].getY();
        this.PP[4] = this.projected_[ptIndices[2]].getX();
        this.PP[5] = this.projected_[ptIndices[2]].getY();
        LargeOrientationCubeVc.solveAffine(this.PP, this.MM);
        AffineTransform told = g.getTransform();
        AffineTransform at = new AffineTransform(this.MM);
        AffineTransform at2 = new AffineTransform(at);
        TextLayout t = new TextLayout(LABEL_LIST[orientationIndex], ORIENTATION_FONT, g.getFontRenderContext());
        Rectangle2D tBounds = t.getBounds();
        double cx = tBounds.getCenterX();
        double cy = tBounds.getCenterY();
        at2.translate(-cx, -cy);
        Shape textShape = t.getOutline(at2);
        g.scale(this.realScale_, this.realScale_);
        Shape ttt = at.createTransformedShape(CUBE_FACE);
        g.setColor(new Color(128, 128, 180, 100));
        g.fill(ttt);
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke((float)(2.5 / this.realScale_)));
        g.draw(textShape);
        g.setColor(Color.WHITE);
        g.fill(textShape);
        g.setStroke(new BasicStroke((float)(1.0 / this.realScale_), 1, 1));
        g.draw(ttt);
        g.setTransform(told);
        g.setColor(c);
        g.setStroke(s);
    }

    private static final void solveAffine(double[] coords, double[] M) {
        M[0] = -(coords[0] - coords[2]) + (coords[0] - coords[4]);
        M[1] = -(coords[1] - coords[3]) + (coords[1] - coords[5]);
        M[2] = coords[0] - coords[2];
        M[3] = coords[1] - coords[3];
        M[4] = coords[0] - M[0] * THREE_CORNERS[0] - M[2] * THREE_CORNERS[1];
        M[5] = coords[1] - M[1] * THREE_CORNERS[0] - M[3] * THREE_CORNERS[1];
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("eyePoint".equals(evt.getPropertyName())) {
            this.eyePoint_.set((double[])evt.getNewValue());
        } else if ("lookPoint".equals(evt.getPropertyName())) {
            this.lookPoint_.set((double[])evt.getNewValue());
        } else if ("up".equals(evt.getPropertyName())) {
            this.upVector_.set((double[])evt.getNewValue());
        }
    }

    public void setLocation(int location) {
        if (location != 5 && location != 7 && location != 1 && location != 3 && location != 8 && location != 2 && location != 6 && location != 4) {
            throw new IllegalArgumentException("cube location must be one of the eight NWSE directions");
        }
        this.position_ = location;
        this.position_ = location;
        this.repaint();
    }

    public void setTrackballEnabled(boolean enabled) {
        this.trackEnabled_ = enabled;
    }

    public boolean isTrackballEnabled() {
        return this.trackEnabled_;
    }

    @Override
    public boolean contains(int x, int y) {
        if (!this.isTrackballEnabled()) {
            return false;
        }
        Point center = this.computeCenter();
        int width = this.getWidth();
        int height = this.getHeight();
        int scale = (int)Math.min(200.0f * (float)Math.min(width, height) / 512.0f, 200.0f);
        return (double)x > center.getX() - (double)(scale / 2) && (double)x < center.getX() + (double)(scale / 2) && (double)y > center.getY() - (double)(scale / 2) && (double)y < center.getY() + (double)(scale / 2);
    }

    private Point computeCenter() {
        int centerx = 0;
        int centery = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int scale = (int)Math.min(200.0f * (float)Math.min(width, height) / 512.0f, 200.0f);
        centerx = width / 2;
        centery = height / 2;
        return new Point(centerx, centery);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        DMSession dms = new DMSession("file", args == null || args.length == 0 ? "/thesource/images/ThinClient/direct3d" : args[0], null);
        DMVolume xjv = DMVolume.buildVolume("DMObjectVolume", new Object[]{dms.getRelated("series")[0]});
        final T3DViewport port1 = new T3DViewport();
        port1.setVolume(xjv);
        f.getContentPane().add(port1);
        port1.setPreferredSize(new Dimension(512, 512));
        JPanel controlPanel = new JPanel();
        controlPanel.add(new JLabel("zoom:"));
        JSlider zslider = new JSlider();
        controlPanel.add(zslider);
        final double vh = port1.getT3DComponent().getViewHeight();
        zslider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                port1.getT3DComponent().setViewHeight(vh / (((double)slider.getValue() + 1.0) / 50.0));
                port1.getT3DComponent().repaint();
            }
        });
        T3DTrackball tb = new T3DTrackball();
        tb.setInertiaEnabled(true);
        port1.setMouseController(tb);
        final LargeOrientationCubeVc cube = new LargeOrientationCubeVc();
        port1.getT3DComponent().add(cube);
        JButton attachButton = new JButton("Engage Target");
        attachButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                cube.setTarget(port1.getT3DComponent());
            }
        });
        controlPanel.add(attachButton);
        f.getContentPane().add((Component)controlPanel, "South");
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.ePrev_ = event;
    }

    public void setTarget(T3DCapable capable) {
        if (this.t3dCapable_ != null) {
            this.t3dCapable_.removePropertyChangeListener(this);
        }
        this.t3dCapable_ = capable;
        if (this.t3dCapable_ != null) {
            this.lookPoint_.set(this.t3dCapable_.getLookPoint(null));
            this.eyePoint_.set(this.t3dCapable_.getEyePoint(null));
            this.upVector_.set(this.t3dCapable_.getUp(null));
            this.t3dCapable_.addPropertyChangeListener(this);
        }
        this.repaint();
    }

    public void setReferenceCursor(Cursor3DModel cursor) {
        this.cursor_ = cursor;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point ptPrev;
        if (this.t3dCapable_ == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Point center = this.computeCenter();
        int scale = (int)Math.min(200.0f * (float)Math.min(width, height) / 512.0f, 200.0f);
        Point ptPos = event.getPoint();
        JnQuaternion q = LargeOrientationCubeVc.simpleTrackBall(center, ptPos, ptPrev = this.ePrev_.getPoint(), scale);
        if (q == null) {
            return;
        }
        JnMatrix3d mRot = q.build3dRotationMatrix();
        JnVector3d zv = new JnVector3d();
        zv.sub(this.lookPoint_, this.eyePoint_);
        zv.normalize();
        zv.x = -zv.x;
        zv.y = -zv.y;
        JnVector3d yv = new JnVector3d();
        yv.set(this.upVector_);
        yv.normalize();
        yv.z = -yv.z;
        JnVector3d xv = JnVector3d.cross(yv, zv);
        JnMatrix3d mPrev = new JnMatrix3d(new double[]{xv.x, yv.x, zv.x, xv.y, yv.y, zv.y, xv.z, yv.z, zv.z});
        mRot.mul(mPrev);
        if (this.cursor_ != null) {
            this.lookPoint_.set(this.cursor_.getPoint(null));
        }
        this.upVector_.set(mRot.m01, mRot.m11, -mRot.m21);
        this.eyePoint_.set(this.lookPoint_);
        this.eyePoint_.scaleAdd(-1.0, new JnVector3d(-mRot.m02, -mRot.m12, mRot.m22));
        this.t3dCapable_.setCamera(this.eyePoint_.generateArray(), this.lookPoint_.generateArray(), this.upVector_.generateArray());
        this.ePrev_ = event;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    private static final JnQuaternion simpleTrackBall(Point ptCenter, Point ptPos, Point ptPrev, double dRadius) {
        Point vTo = new Point(ptCenter.x - ptPrev.x, ptCenter.y - ptPrev.y);
        Point vFrom = new Point(ptCenter.x - ptPos.x, ptCenter.y - ptPos.y);
        JnVector3d vSphereFrom = new JnVector3d();
        JnVector3d vSphereTo = new JnVector3d();
        double dSqLen = 0.0;
        vSphereFrom.x = (double)vFrom.x / dRadius;
        vSphereFrom.y = (double)vFrom.y / dRadius;
        dSqLen = vSphereFrom.x * vSphereFrom.x + vSphereFrom.y * vSphereFrom.y;
        vSphereFrom.z = Math.sqrt(1.0 - dSqLen);
        if (dSqLen >= 1.0) {
            return null;
        }
        vSphereTo.x = (double)vTo.x / dRadius;
        vSphereTo.y = (double)vTo.y / dRadius;
        dSqLen = vSphereTo.x * vSphereTo.x + vSphereTo.y * vSphereTo.y;
        vSphereTo.z = Math.sqrt(1.0 - dSqLen);
        if (dSqLen >= 1.0) {
            return null;
        }
        JnQuaternion q = LargeOrientationCubeVc.twoVectorsToQuaternion(vSphereFrom, vSphereTo);
        return q;
    }

    public static final JnQuaternion twoVectorsToQuaternion(JnVector3d vFrom, JnVector3d vTo) {
        JnQuaternion q = new JnQuaternion();
        q.x = vFrom.y * vTo.z - vFrom.z * vTo.y;
        q.y = vFrom.z * vTo.x - vFrom.x * vTo.z;
        q.z = vFrom.x * vTo.y - vFrom.y * vTo.x;
        q.w = vFrom.x * vTo.x + vFrom.y * vTo.y + vFrom.z * vTo.z;
        return q;
    }

    public void setCursor3D(Cursor3DModel cursor) {
        this.cursor_ = cursor;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

