/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DDepthBufferCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnQuaternion;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpResponseCurve;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.mpr.MprQuad;
import com.ge.med.terra.jami.j3d.mpr.ProjectedMPR;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.MouseInputAdapter;

public class T3DSlicerVc
extends XpVisualComponent
implements WindowLevelCapable,
ColorMapCapable {
    private ProjectedMPR pmpr = new ProjectedMPR();
    private double[] t3d_eyePoint = new double[3];
    private double[] t3d_lookPoint = new double[3];
    private double[] t3d_upVector = new double[3];
    private double t3d_viewHeight = -1.0;
    private float[] rasbuff = null;
    private boolean dirtyCamera = true;
    private Object lockBuff = new Object();
    private boolean paintReady = false;
    private int[] cmap = null;
    private IndexColorModel icm = null;
    private int selectedQuad = -1;
    private int containsQuad = -1;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;

    public T3DSlicerVc(T3DComponent tc) {
        tc.addPropertyChangeListener("ALL_LAYERS_COMPLETE_PROPERTY", new DepthBufferSync());
        tc.addPropertyChangeListener("RENDER_FINISH", new IterativePaintSync());
        SlicerMouseController smc = new SlicerMouseController();
        this.addMouseListener(smc);
        this.addMouseMotionListener(smc);
    }

    @Override
    public void setColorMap(int[] cmap) {
        this.cmap = cmap;
        this.icm = new XpViewport.JamiIndexColorModel(this.cmap);
        this.setWindowing(this.getWinMin(), this.getWinMax(), this.isVideoInverted());
        this.repaint();
    }

    @Override
    public int[] getColorMap() {
        return this.cmap;
    }

    public int addQuad(CPoint ul, CPoint ur, CPoint br) {
        this.dirtyCamera = true;
        return this.pmpr.addQuad(ul, ur, br);
    }

    public void setQuad(int id, CPoint ul, CPoint ur, CPoint br) {
        this.pmpr.setQuad(id, ul, ur, br);
        this.dirtyCamera = true;
    }

    public MprQuad getQuad(int id) {
        return this.pmpr.getQuad(id);
    }

    public int getNumQuads() {
        return this.pmpr.getNumQuads();
    }

    public int getSelectedQuad() {
        return this.selectedQuad;
    }

    public void setSelectedQuad(int quadIdx) {
        this.selectedQuad = quadIdx;
    }

    private int getCurrentQuad() {
        return this.containsQuad;
    }

    @Override
    public boolean contains(int x, int y) {
        int quadIdx;
        this.containsQuad = quadIdx = this.pmpr.contains(x, y);
        return quadIdx >= 0;
    }

    private static double diffvec(double[] v1, double[] v2) {
        return Math.abs(v1[0] - v2[0]) + Math.abs(v1[1] - v2[1]) + Math.abs(v1[2] - v2[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        long t0 = System.currentTimeMillis();
        T3DComponent t3d = (T3DComponent)this.getParent();
        J3DVolumeModel jvm = (J3DVolumeModel)t3d.getVolumeModel();
        this.rescaleIntercept = jvm.j_vol.rescaleIntercept;
        this.rescaleSlope = jvm.j_vol.rescaleSlope;
        double[] eyepoint = t3d.getRenderedEyePoint(null);
        double[] lookpoint = t3d.getRenderedLookPoint(null);
        double[] up = t3d.getRenderedUp(null);
        double vheight = t3d.getRenderedViewHeight();
        double diffEye = T3DSlicerVc.diffvec(eyepoint, this.t3d_eyePoint);
        double diffLook = T3DSlicerVc.diffvec(lookpoint, this.t3d_lookPoint);
        double diffUp = T3DSlicerVc.diffvec(up, this.t3d_upVector);
        if (!this.paintReady) {
            return;
        }
        boolean changeDisplay = false;
        if (diffEye > 1.0E-10 || diffLook > 1.0E-10 || diffUp > 1.0E-10 || Math.abs(vheight - this.t3d_viewHeight) > 1.0E-10) {
            changeDisplay = true;
        }
        System.arraycopy(eyepoint, 0, this.t3d_eyePoint, 0, 3);
        System.arraycopy(lookpoint, 0, this.t3d_lookPoint, 0, 3);
        System.arraycopy(up, 0, this.t3d_upVector, 0, 3);
        this.t3d_viewHeight = vheight;
        CTransform r2d = t3d.getTransform((byte)2, (byte)1);
        JnMatrix4d ras2display = new JnMatrix4d(r2d.m);
        if (changeDisplay || this.dirtyCamera) {
            this.pmpr.initView(jvm);
            this.pmpr.paintPolys(ras2display);
        }
        this.dirtyCamera = false;
        this.pmpr.wwwlPolys();
        boolean blend = !t3d.getRenderStyle().startsWith("REFORMAT");
        Object object = this.lockBuff;
        synchronized (object) {
            this.pmpr.blendToT3D(this.rasbuff, ras2display, blend);
        }
        g2.drawRenderedImage(this.pmpr.getOutput(), null);
        long t = System.currentTimeMillis() - t0;
    }

    private void setWindowing(double min, double max, boolean ivvideo) {
        double ww = max - min;
        double wl = (max + min) * 0.5;
        double oldMin = this.pmpr.getWW() - this.pmpr.getWW() * 0.5;
        double oldMax = this.pmpr.getWL() + this.pmpr.getWW() * 0.5;
        boolean oldIV = this.pmpr.isInverseVideo();
        boolean changeMin = min != oldMin;
        boolean changeMax = max != oldMax;
        boolean changeIV = ivvideo != oldIV;
        this.pmpr.setWindowing(ww, wl, ivvideo, this.icm, this.rescaleSlope, this.rescaleIntercept);
        if (changeMin) {
            this.firePropertyChange("winMin", oldMin, min);
        }
        if (changeMax) {
            this.firePropertyChange("winMax", oldMax, max);
        }
        if (changeIV) {
            this.firePropertyChange("videoInverted", oldIV, ivvideo);
        }
    }

    @Override
    public double[] getRange() {
        return new double[]{-4096.0, 4096.0};
    }

    @Override
    public void setWinMinMax(double min, double max) {
        this.setWindowing(min, max, this.isVideoInverted());
    }

    @Override
    public double getWinMin() {
        return this.pmpr.getWL() - this.pmpr.getWW() * 0.5;
    }

    @Override
    public void setWinMin(double winMin) {
        this.setWindowing(winMin, this.getWinMax(), this.isVideoInverted());
    }

    @Override
    public double getWinMax() {
        return this.pmpr.getWL() + this.pmpr.getWW() * 0.5;
    }

    @Override
    public void setWinMax(double winMax) {
        this.setWindowing(this.getWinMin(), winMax, this.isVideoInverted());
    }

    @Override
    public void setVideoInverted(boolean inverted) {
        this.setWindowing(this.getWinMin(), this.getWinMax(), inverted);
    }

    @Override
    public boolean isVideoInverted() {
        return this.pmpr.isInverseVideo();
    }

    @Override
    public void resetWindowing() {
        this.setWindowing(0.0, 1200.0, this.isVideoInverted());
    }

    @Override
    public void setWinUpperLimit(double winUpper) {
    }

    @Override
    public double getWinUpperLimit() {
        return 4096.0;
    }

    @Override
    public void setWinLowerLimit(double winLower) {
    }

    @Override
    public double getWinLowerLimit() {
        return -4096.0;
    }

    public Color getBorderColor() {
        return this.pmpr.getBorderColor();
    }

    public void setBorderColor(Color borderColor) {
        this.pmpr.setBorderColor(borderColor);
    }

    public Color getBackgroundColor() {
        return this.pmpr.getBackgroundColor();
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.pmpr.setBackgroundColor(backgroundColor);
    }

    public double getBackgroundAlpha() {
        return this.pmpr.getBackgroundAlpha();
    }

    public void setBackgroundAlpha(double backgroundAlpha) {
        this.pmpr.setBackgroundAlpha(backgroundAlpha);
    }

    public double getOcclusionAlpha() {
        return this.pmpr.getOcclusionAlpha();
    }

    public void setOcclusionAlpha(double occlusionAlpha) {
        this.pmpr.setOcclusionAlpha(occlusionAlpha);
    }

    static /* synthetic */ float[] access$402(T3DSlicerVc x0, float[] x1) {
        x0.rasbuff = x1;
        return x1;
    }

    private static class SlicerMouseController
    extends MouseInputAdapter {
        private static final int CONTRAST_WWWL = 0;
        private static final int CONTRAST_PET = 1;
        private static final int CONTRAST_MINMAX = 2;
        private static double wlSensitivity = 1.0;
        private static double wwSensitivity = 1.0;
        private double[] ulc = new double[3];
        private double[] xside = new double[3];
        private double[] yside = new double[3];
        private double[] zside = new double[3];
        private CPoint displayNormal = new CPoint(1);
        private int wwwlStyle = 0;
        private XpResponseCurve wlResponse = new XpResponseCurve();
        private Point startPt = new Point();
        private MprQuad startQuad = null;
        private double startMin = 0.0;
        private double startMax = 0.0;
        private double startWW = 0.0;
        private double startWL = 0.0;
        private double rescaleSlope = 1.0;
        private JnMatrix3d accumRotation = new JnMatrix3d();
        private MouseEvent ePrev_ = null;
        private double volumeSize_ = 0.0;
        private double radius_ = 0.0;

        private SlicerMouseController() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            T3DSlicerVc slvc = (T3DSlicerVc)e.getSource();
            this.startPt = e.getPoint();
            int currentQuad = slvc.getCurrentQuad();
            this.startMax = slvc.getWinMax();
            this.startMin = slvc.getWinMin();
            this.startWW = this.startMax - this.startMin;
            this.startWL = (this.startMax + this.startMin) * 0.5;
            slvc.setSelectedQuad(currentQuad);
            if (currentQuad >= 0) {
                MprQuad mq = slvc.getQuad(currentQuad);
                this.startQuad = new MprQuad(mq);
                this.accumRotation.setIdentity();
                CTransform ras2display = slvc.getTransform((byte)2, (byte)1);
                CPoint zdir = this.startQuad.getNormal();
                zdir.scale(5.0);
                CPoint p1 = new CPoint(2);
                p1.add(this.startQuad.ul, zdir);
                CPoint d0 = new CPoint(1);
                CPoint d1 = new CPoint(1);
                ras2display.transform(this.startQuad.ul, d0);
                ras2display.transform(p1, d1);
                this.displayNormal.sub(d1, d0);
                this.displayNormal.normalize();
                this.ePrev_ = e;
                this.computeRadius((T3DCapable)((Object)slvc.getParent()), slvc.getWidth(), slvc.getHeight());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            T3DSlicerVc slvc = (T3DSlicerVc)e.getSource();
            slvc.setSelectedQuad(-1);
            this.startQuad = null;
            this.accumRotation.setIdentity();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            Point p = e.getPoint();
            this.dragDispatch(e, p.getX() - this.startPt.getX(), p.getY() - this.startPt.getY());
        }

        protected boolean dragDispatch(MouseEvent e, double dx, double dy) {
            boolean res = false;
            int mod = e.getModifiers();
            boolean b1 = 0 != (mod & 0x10);
            boolean b2 = 0 != (mod & 8);
            boolean b3 = 0 != (mod & 4);
            boolean shift = 0 != (mod & 1);
            T3DSlicerVc slvc = (T3DSlicerVc)e.getSource();
            if (b3 && !shift) {
                this.trackball(e);
                res = true;
            } else if (b1) {
                if (shift) {
                    this.wwwlQuad(slvc, dx, dy);
                } else {
                    this.pageQuad(slvc, dx, dy);
                }
                res = true;
            } else if (b2 || b3 && shift) {
                res = true;
            }
            slvc.repaint();
            return res;
        }

        private static void transformSlicePt(JnMatrix3d m, double[] center, CPoint p, CPoint res) {
            double[] tr = new double[]{p.x, p.y, p.z};
            double[] c = new double[]{center[0], center[1], center[2]};
            JnVector3d.sub(tr, c, tr);
            m.transform(tr);
            JnVector3d.add(tr, c, tr);
            res.set(tr);
        }

        protected void trackball(MouseEvent event) {
            T3DSlicerVc target = (T3DSlicerVc)event.getSource();
            T3DCapable tc = (T3DCapable)((Object)target.getParent());
            int width = target.getWidth();
            int height = target.getHeight();
            Point center = new Point(width / 2, height / 2);
            double[] disp = GeomUtils.RAStoDisplay(tc.getLookPoint(null), tc.getEyePoint(null), tc.getLookPoint(null), tc.getUp(null), tc.getViewHeight(), target.getWidth(), target.getHeight(), new double[3]);
            center.setLocation((int)disp[0], (int)disp[1]);
            Point ptPos = event.getPoint();
            Point ptPrev = this.ePrev_.getPoint();
            JnQuaternion q = SlicerMouseController.simpleTrackBall(center, ptPos, ptPrev, this.radius_);
            if (q == null) {
                return;
            }
            JnMatrix3d mRot = q.build3dRotationMatrix();
            this.accumRotation.mul(mRot);
            int selQuad = target.getSelectedQuad();
            if (selQuad >= 0) {
                MprQuad mq = target.getQuad(selQuad);
                CPoint ul = new CPoint(2);
                CPoint ur = new CPoint(2);
                CPoint br = new CPoint(2);
                double[] _c = mq.getCenter(null);
                SlicerMouseController.transformSlicePt(this.accumRotation, _c, this.startQuad.ul, ul);
                SlicerMouseController.transformSlicePt(this.accumRotation, _c, this.startQuad.ur, ur);
                SlicerMouseController.transformSlicePt(this.accumRotation, _c, this.startQuad.br, br);
                target.setQuad(selQuad, ul, ur, br);
            }
            this.ePrev_ = event;
        }

        protected void wwwlQuad(WindowLevelCapable wlc, double dx, double dy) {
            if (this.wwwlStyle == 0) {
                double wwdelta = wwSensitivity * dx;
                double wldelta = wlSensitivity * dy;
                double ww = this.wlResponse.response(this.startWW, wwdelta);
                double wl = this.wlResponse.response(this.startWL, wldelta);
                double hww = ww * 0.5;
                double min = wl - hww;
                double max = wl + hww;
                wlc.setWinMinMax(min, max);
            } else if (this.wwwlStyle == 1) {
                double maxdelta = -wlSensitivity * 20.0 * this.rescaleSlope * dy;
                double max = this.startMax + maxdelta;
                wlc.setWinMax(max);
            } else {
                double mindelta = wlSensitivity * dx;
                double maxdelta = -wlSensitivity * dy;
                double min = this.startMin + mindelta;
                double max = this.startMax + maxdelta;
                wlc.setWinMinMax(min, max);
            }
        }

        protected void pageQuad(T3DSlicerVc slvc, double dx, double dy) {
            int currentQuad = slvc.getSelectedQuad();
            if (currentQuad >= 0) {
                CPoint ul = new CPoint(this.startQuad.ul);
                CPoint ur = new CPoint(this.startQuad.ur);
                CPoint br = new CPoint(this.startQuad.br);
                CPoint zdir = this.startQuad.getNormal();
                double dot = dx * this.displayNormal.x + dy * this.displayNormal.y;
                double refside = Math.min(JnVector3d.length(this.xside), JnVector3d.length(this.yside));
                refside = Math.min(JnVector3d.length(this.zside), refside) * 0.75;
                double scale = dot / (double)slvc.getHeight() * refside;
                ul.scaleAdd(scale, zdir);
                ur.scaleAdd(scale, zdir);
                br.scaleAdd(scale, zdir);
                slvc.setQuad(currentQuad, ul, ur, br);
            }
        }

        private void computeRadius(T3DCapable t3dCapable_, int width, int height) {
            t3dCapable_.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
            JnVector3d xv = new JnVector3d(this.xside);
            JnVector3d yv = new JnVector3d(this.yside);
            JnVector3d zv = new JnVector3d(this.zside);
            this.volumeSize_ = Math.sqrt(xv.lengthSquared() + yv.lengthSquared() + zv.lengthSquared()) * 0.8;
            double vh = t3dCapable_.getViewHeight();
            if (vh == 0.0) {
                return;
            }
            double asp = t3dCapable_.getAspectRatio();
            if (asp > 1.0) {
                vh *= asp;
            }
            this.radius_ = Math.min(this.volumeSize_ / vh * (double)height * 0.5, (double)height * 0.5);
        }

        private static final JnQuaternion simpleTrackBall(Point ptCenter, Point ptPos, Point ptPrev, double dRadius) {
            double len;
            Point vTo = new Point(ptCenter.x - ptPrev.x, ptCenter.y - ptPrev.y);
            Point vFrom = new Point(ptCenter.x - ptPos.x, ptCenter.y - ptPos.y);
            JnVector3d vSphereFrom = new JnVector3d();
            JnVector3d vSphereTo = new JnVector3d();
            double dSqLen = 0.0;
            vSphereFrom.x = (double)(-vFrom.x) / dRadius;
            vSphereFrom.y = (double)vFrom.y / dRadius;
            dSqLen = vSphereFrom.x * vSphereFrom.x + vSphereFrom.y * vSphereFrom.y;
            if (dSqLen > 1.0) {
                len = Math.sqrt(dSqLen);
                vSphereFrom.x /= len;
                vSphereFrom.y /= len;
                vSphereFrom.z = 0.0;
            } else {
                vSphereFrom.z = Math.sqrt(1.0 - dSqLen);
            }
            vSphereTo.x = (double)(-vTo.x) / dRadius;
            vSphereTo.y = (double)vTo.y / dRadius;
            dSqLen = vSphereTo.x * vSphereTo.x + vSphereTo.y * vSphereTo.y;
            if (dSqLen > 1.0) {
                len = Math.sqrt(dSqLen);
                vSphereTo.x /= len;
                vSphereTo.y /= len;
                vSphereTo.z = 0.0;
            } else {
                vSphereTo.z = Math.sqrt(1.0 - dSqLen);
            }
            JnQuaternion q = SlicerMouseController.twoVectorsToQuaternion(vSphereFrom, vSphereTo);
            return q;
        }

        public static final JnQuaternion twoVectorsToQuaternion(JnVector3d vFrom, JnVector3d vTo) {
            double e = vFrom.dot(vTo);
            JnVector3d cross = JnVector3d.cross(vFrom, vTo);
            JnQuaternion q = new JnQuaternion();
            double vc = 1.0 / Math.sqrt(2.0 * (1.0 + e));
            cross.scale(vc);
            q.x = cross.x;
            q.y = cross.y;
            q.z = cross.z;
            q.w = Math.sqrt(2.0 * (1.0 + e)) * 0.5;
            return q;
        }
    }

    private class IterativePaintSync
    implements PropertyChangeListener {
        private IterativePaintSync() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            T3DSlicerVc.this.repaint();
        }
    }

    private class DepthBufferSync
    implements PropertyChangeListener {
        private DepthBufferSync() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            int width = T3DSlicerVc.this.getWidth();
            int height = T3DSlicerVc.this.getHeight();
            T3DSlicerVc.this.pmpr.syncBuffers(width, height);
            if (T3DSlicerVc.this.rasbuff == null || T3DSlicerVc.this.rasbuff.length != width * height * 3) {
                T3DSlicerVc.access$402(T3DSlicerVc.this, new float[width * height * 3]);
                T3DSlicerVc.this.dirtyCamera = true;
            }
            T3DComponent tc = (T3DComponent)T3DSlicerVc.this.getParent();
            T3DDepthBufferCapable tdbc = (T3DDepthBufferCapable)((Object)tc.getCapable(T3DDepthBufferCapable.class.getCanonicalName()));
            Object object = T3DSlicerVc.this.lockBuff;
            synchronized (object) {
                tdbc.getDepthBuffer(T3DSlicerVc.this.rasbuff);
            }
            T3DSlicerVc.this.paintReady = true;
        }
    }
}

