/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpMouseController;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class ZoomMouseController
extends MouseInputAdapter
implements XpMouseController,
MouseWheelListener {
    private T3DCapable t3d_;
    private double startViewHeight = 1.0;
    private int startY_ = -1;
    long wheelPrevTime_ = 0L;
    static final int WHEEL_SENSITIVITY = 500;
    static final int FAST_WHEEL_SCROLL_AMOUNT = 3;

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.t3d_ == null) {
            return;
        }
        int y = e.getY();
        double height = e.getComponent().getHeight();
        double normVal = (double)(y - this.startY_) / (height * 0.5);
        double scaleVal = Math.exp(normVal);
        double newHeight = this.startViewHeight * scaleVal;
        this.t3d_.setViewHeight(newHeight);
        this.t3d_.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startY_ = e.getY();
        this.startViewHeight = this.t3d_.getViewHeight();
    }

    @Override
    public void setTarget(JComponent jc) {
        if (jc == null) {
            this.t3d_ = null;
        }
        if (jc instanceof T3DCapable) {
            this.t3d_ = (T3DCapable)((Object)jc);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() == 0) {
            int sign = e.getWheelRotation() > 0 ? 1 : -1;
            long t = System.currentTimeMillis();
            int dz = t - this.wheelPrevTime_ > 500L ? 1 : 3;
            dz *= sign;
            this.wheelPrevTime_ = t;
        }
    }
}

