/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.j3d.mpr.MprGeometryListener;
import java.util.HashSet;
import java.util.Set;

public class MprQuad {
    public CPoint ul = new CPoint(2);
    public CPoint ur = new CPoint(2);
    public CPoint br = new CPoint(2);
    public CPoint bl = new CPoint(2);
    private Set<MprGeometryListener> listeners = null;

    public MprQuad(CPoint ul, CPoint ur, CPoint br) {
        this.set(ul, ur, br);
    }

    public MprQuad(double[] ul, double[] ur, double[] br) {
        this.set(ul, ur, br);
    }

    public MprQuad(MprQuad mq) {
        this.set(mq.ul, mq.ur, mq.br);
    }

    public Object clone() {
        return new MprQuad(this);
    }

    public void set(CPoint ul, CPoint ur, CPoint br) {
        this.ul.set(ul);
        this.ur.set(ur);
        this.br.set(br);
        this.calcBL();
        this.notifyGeometryListeners();
    }

    public double[] getCenter(double[] center) {
        if (center == null) {
            center = new double[]{(this.ul.x + this.ur.x + this.br.x + this.bl.x) / 4.0, (this.ul.y + this.ur.y + this.br.y + this.bl.y) / 4.0, (this.ul.z + this.ur.z + this.br.z + this.bl.z) / 4.0};
        }
        return center;
    }

    public double getXLen() {
        JnVector3d vec = new JnVector3d();
        vec.sub(this.ur, this.ul);
        return vec.length();
    }

    public double getYLen() {
        JnVector3d vec = new JnVector3d();
        vec.sub(this.br, this.ur);
        return vec.length();
    }

    public double[] getXDir(double[] xdir) {
        if (xdir == null) {
            xdir = new double[3];
        }
        JnVector3d.sub(this.ur.toArray(), this.ul.toArray(), xdir);
        JnVector3d.normalize(xdir);
        return xdir;
    }

    public double[] getYDir(double[] ydir) {
        if (ydir == null) {
            ydir = new double[3];
        }
        JnVector3d.sub(this.br.toArray(), this.ur.toArray(), ydir);
        JnVector3d.normalize(ydir);
        return ydir;
    }

    public void setSliceOrientation(double[] xdir, double[] ydir) {
        double xlen = this.getXLen();
        double ylen = this.getYLen();
        double[] center = this.getCenter(null);
        double[] xd = new double[]{xdir[0], xdir[1], xdir[2]};
        double[] yd = new double[]{ydir[0], ydir[1], ydir[2]};
        JnVector3d.normalize(xd);
        JnVector3d.normalize(yd);
        double[] ul = new double[3];
        double[] ur = new double[3];
        double[] br = new double[3];
        JnVector3d.scaleAdd(center, xd, -0.5 * xlen, ul);
        JnVector3d.scaleAdd(ul, yd, -0.5 * ylen, ul);
        JnVector3d.scaleAdd(ul, xd, xlen, ur);
        JnVector3d.scaleAdd(ur, yd, ylen, br);
        this.set(ul, ur, br);
    }

    public void setSliceOrientation(JnVector3d xdir, JnVector3d ydir) {
        this.setSliceOrientation(xdir.toArray(), ydir.toArray());
    }

    public CPoint getNormal() {
        JnVector3d xdir = new JnVector3d();
        JnVector3d ydir = new JnVector3d();
        xdir.sub(this.ur, this.ul);
        ydir.sub(this.br, this.ur);
        ydir.normalize();
        xdir.normalize();
        JnVector3d zdir = JnVector3d.cross(xdir, ydir);
        zdir.normalize();
        return new CPoint(zdir.x, zdir.y, zdir.z, 2);
    }

    public void set(double[] ul, double[] ur, double[] br) {
        this.ul.set(ul);
        this.ur.set(ur);
        this.br.set(br);
        this.calcBL();
        this.notifyGeometryListeners();
    }

    private void calcBL() {
        this.bl.sub(this.br, this.ur);
        this.bl.add(this.ul, this.bl);
    }

    public int getNumPoints() {
        return 4;
    }

    public void getPoint(int pointNum, CPoint pt) {
        switch (pointNum) {
            case 0: {
                pt.set(this.ul);
                break;
            }
            case 1: {
                pt.set(this.ur);
                break;
            }
            case 2: {
                pt.set(this.br);
                break;
            }
            case 3: {
                pt.set(this.bl);
            }
        }
    }

    public void addGeometryListener(MprGeometryListener mgl) {
        if (this.listeners == null) {
            this.listeners = new HashSet<MprGeometryListener>();
        }
        this.listeners.add(mgl);
    }

    public void removeGeometryListener(MprGeometryListener mgl) {
        if (this.listeners != null) {
            this.listeners.remove(mgl);
        }
    }

    protected void notifyGeometryListeners() {
        if (this.listeners != null) {
            for (MprGeometryListener mgl : this.listeners) {
                mgl.geometryChange(this);
            }
        }
    }
}

