/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.idc.GridMultipassAlgorithm;
import com.ge.med.idc.IterativeRenderer;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.j3d.mprender.BaseMultipassAlgorithm;

public abstract class BaseGridMultipassAlgorithm
extends BaseMultipassAlgorithm
implements GridMultipassAlgorithm {
    public BaseGridMultipassAlgorithm(boolean parallelRendering) {
        super(parallelRendering);
    }

    public BaseGridMultipassAlgorithm(ParallelTaskManager ptm, boolean parallelRendering) {
        super(ptm, parallelRendering);
    }

    public int[] getPixels(int renderOutputLayer, int passno, int offset, Object pixels) {
        int idx = 0;
        int x0 = this.getXStart(passno);
        int y0 = this.getYStart(passno);
        int xstep = this.getXStep(passno);
        int ystep = this.getYStep(passno);
        IterativeRenderer r = this.getT3DIRenderer();
        int owidth = r.getBufferWidth();
        int oheight = r.getBufferHeight();
        Object pixbuff = r.getPixelBuffer();
        int[] pixelsInfo = new int[3];
        if (xstep != 1 || ystep != 1) {
            if (pixbuff instanceof short[]) {
                short[] lumbuff = (short[])pixels;
                short[] lum_out = (short[])pixbuff;
                for (int y = y0; y < oheight; y += ystep) {
                    int yoffset = y * owidth;
                    int x = x0;
                    while (x < owidth) {
                        lumbuff[offset + idx] = lum_out[yoffset + x];
                        x += xstep;
                        ++idx;
                    }
                }
                pixelsInfo[1] = 16;
                pixelsInfo[2] = 1;
            } else {
                int[] rgbbuff = (int[])pixels;
                int[] rgb_out = (int[])pixbuff;
                for (int y = y0; y < oheight; y += ystep) {
                    int yoffset = y * owidth;
                    int x = x0;
                    while (x < owidth) {
                        rgbbuff[offset + idx] = rgb_out[yoffset + x];
                        x += xstep;
                        ++idx;
                    }
                }
                pixelsInfo[1] = 24;
                pixelsInfo[2] = 3;
            }
        } else if (pixbuff instanceof short[]) {
            short[] lumbuff = (short[])pixels;
            short[] lum_out = (short[])pixbuff;
            System.arraycopy(lum_out, 0, lumbuff, offset, lum_out.length);
            idx = lum_out.length;
            pixelsInfo[1] = 16;
            pixelsInfo[2] = 1;
        } else {
            int[] rgbbuff = (int[])pixels;
            int[] rgb_out = (int[])pixbuff;
            System.arraycopy(rgb_out, 0, rgbbuff, offset, rgb_out.length);
            idx = rgb_out.length;
            pixelsInfo[1] = 24;
            pixelsInfo[2] = 3;
        }
        pixelsInfo[0] = idx;
        return pixelsInfo;
    }

    public void putPixels(int srcOffset, Object srcPixels, int renderOutputLayer, int passno) {
        int x0 = this.getXStart(passno);
        int y0 = this.getYStart(passno);
        int xstep = this.getXStep(passno);
        int ystep = this.getYStep(passno);
        IterativeRenderer r = this.getT3DIRenderer();
        int owidth = r.getBufferWidth();
        int oheight = r.getBufferHeight();
        Object pixbuff = r.getPixelBuffer();
        if (srcPixels instanceof short[]) {
            short[] srcbuff = (short[])srcPixels;
            short[] outbuff = (short[])pixbuff;
            int idx = 0;
            for (int oy = y0; oy < oheight; oy += ystep) {
                int oyoffset = oy * owidth;
                int ox = x0;
                while (ox < owidth) {
                    outbuff[oyoffset + ox] = srcbuff[srcOffset + idx];
                    ox += xstep;
                    ++idx;
                }
            }
        } else {
            int[] srcbuff = (int[])srcPixels;
            int[] outbuff = (int[])pixbuff;
            int idx = 0;
            for (int oy = y0; oy < oheight; oy += ystep) {
                int oyoffset = oy * owidth;
                int ox = x0;
                while (ox < owidth) {
                    outbuff[oyoffset + ox] = srcbuff[srcOffset + idx];
                    ox += xstep;
                    ++idx;
                }
            }
        }
    }
}

