/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.j3d.mprender.IRenderer;
import com.ge.med.terra.jami.j3d.mprender.IterativeRenderEngine;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class BaseIRE
implements IterativeRenderEngine {
    protected String mode = null;
    protected BufferedImage scr;
    protected int[] scrbuff;
    protected Image backBuffer;
    protected BufferedImage scr2;
    protected int[] scrbuff2;
    protected boolean resizeBuffer = false;
    protected int bgColor = 255;
    private int renderMode = 0;
    protected IRenderer ren;
    public final int NOT = Integer.parseInt(System.getProperty("not", Runtime.getRuntime().availableProcessors() + ""));
    protected Object[] thread_data = new Object[this.NOT];
    protected transient boolean noChange = true;
    protected Object lock = new Object();
    protected Component scrcomp;
    protected boolean blue = false;
    protected boolean done = true;
    private boolean keeprunning = true;
    private Rectangle r = new Rectangle(0, 0, 0, 0);

    @Override
    public void setComponent(Component c) {
        this.scrcomp = c;
        this.bufferResize();
        Thread rt = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BaseIRE.this.renderThread();
            }
        };
        rt.setName("render thread");
        rt.setDaemon(true);
        rt.start();
    }

    @Override
    public void setRenderMode(int renderMode) {
        this.renderMode = renderMode;
    }

    @Override
    public int getRenderMode() {
        return this.renderMode;
    }

    @Override
    public boolean isRendered(int x, int y) {
        if (this.scr != null) {
            int w = this.scr.getWidth();
            int i = x + y * w;
            return this.scrbuff[i] < 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.keeprunning = false;
        Object object = this.lock;
        synchronized (object) {
            this.noChange = false;
            this.lock.notify();
        }
    }

    private void bufferResize() {
        int w = this.scrcomp.getWidth();
        int h = this.scrcomp.getHeight();
        if (w == 0 && h == 0) {
            return;
        }
        this.scr = new BufferedImage(w, h, 1);
        this.scrbuff = ((DataBufferInt)this.scr.getRaster().getDataBuffer()).getData();
        this.backBuffer = this.scrcomp.createImage(w, h);
        this.scr2 = new BufferedImage(w, h, 1);
        this.scrbuff2 = ((DataBufferInt)this.scr2.getRaster().getDataBuffer()).getData();
        this.backBuffer = this.scr2;
        XpLog.logger().fine("BASEIRE: bufferResize to " + w + "," + h);
        this.ren.setDisplayBuffer(this.scrbuff, w, h);
        this.ren.updateWorld();
        this.imageChange(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderThread() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                while (this.noChange) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.keeprunning) break;
            if (this.resizeBuffer) {
                this.bufferResize();
                this.resizeBuffer = false;
            }
            if (this.scrbuff == null) {
                this.noChange = true;
                continue;
            }
            this.bgColor = this.scrcomp.getBackground().getRGB() & 0xFFFFFF;
            this.ren.clearDisplayBuffer();
            this.noChange = true;
            try {
                this.ren.updateWorld();
                this.multiPassRender();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        XpLog.logger().fine("-- Goodbye BaseIRE thread.");
        this.scrcomp = null;
        this.ren = null;
    }

    @Override
    public void setRenderable(IRenderer r) {
        this.ren = r;
        for (int i = 0; i < this.NOT; ++i) {
            this.thread_data[i] = r.createThreadData();
        }
    }

    private final int diff(int a, int b) {
        int pne1 = a & 0xFF;
        int pne2 = a >> 8 & 0xFF;
        int pne3 = a >> 16 & 0xFF;
        int pse1 = b & 0xFF;
        int pse2 = b >> 8 & 0xFF;
        int pse3 = b >> 16 & 0xFF;
        int d1 = pne1 - pse1;
        int d2 = pne2 - pse2;
        int d3 = pne3 - pse3;
        return d1 * d1 + d2 * d2 + d3 * d3 >> 5;
    }

    public void multiPassRender() {
        this.r.x = 0;
        this.r.y = 0;
        int baseRes = 32;
        int baseSteps = 4;
        this.r.width = this.scr.getWidth();
        this.r.height = this.scr.getHeight();
        int w = this.scr.getWidth();
        int h = this.scr.getHeight();
        int highbyte = -16777216;
        for (int i = 0; i < this.scrbuff.length; ++i) {
            this.scrbuff[i] = this.bgColor;
        }
        for (int pas = 0; pas < 4; pas += 2) {
            this.r.x += pas;
            this.r.y += pas;
            this.ren.castRays(this.r, 32, 32, 0, 1, null);
            this.r.x -= pas;
            this.r.y -= pas;
            this.highbit(this.scrbuff, w, this.r, 32, 32);
            for (int res = 0; res < 4; ++res) {
                int b;
                int a;
                int pb;
                int test;
                int x;
                int step = 32 >> res;
                int hstep = step / 2;
                int pa = this.scrbuff[0];
                for (x = 0; x < w - step; x += step) {
                    test = x + hstep;
                    pb = this.scrbuff[test + hstep];
                    if (this.scrbuff[test] >= 0) {
                        a = pa >> 1 & 0x7F7F7F;
                        b = pb >> 1 & 0x7F7F7F;
                        this.scrbuff[test] = a + b;
                    }
                    pa = pb;
                }
                pa = this.scrbuff[0];
                for (int y = this.r.y; y < this.r.height - step; y += step) {
                    test = y * w + hstep * w;
                    if (this.scrbuff[test] < 0) continue;
                    pb = this.scrbuff[test + hstep * w];
                    a = pa >> 1 & 0x7F7F7F;
                    b = pb >> 1 & 0x7F7F7F;
                    this.scrbuff[test] = a + b;
                    pa = pb;
                }
                for (int y = this.r.y + hstep; y < this.r.height - step; y += step) {
                    for (x = this.r.x + hstep; x < this.r.width - step; x += step) {
                        int pb2;
                        int pa2;
                        int b2;
                        int a2;
                        int i = y * w + x;
                        int test2 = i + hstep;
                        if (this.scrbuff[test2] >= 0) {
                            int pne = this.scrbuff[test2 - hstep * w];
                            int pse = this.scrbuff[test2 + hstep * w];
                            a2 = pne >> 1 & 0x7F7F7F;
                            b2 = pse >> 1 & 0x7F7F7F;
                            this.scrbuff[test2] = a2 + b2;
                        }
                        if (this.scrbuff[test2 = i + hstep * w] >= 0) {
                            pa2 = this.scrbuff[test2 - hstep];
                            pb2 = this.scrbuff[test2 + hstep];
                            a2 = pa2 >> 1 & 0x7F7F7F;
                            b2 = pb2 >> 1 & 0x7F7F7F;
                            this.scrbuff[test2] = a2 + b2;
                        }
                        if (this.scrbuff[test2 = i] < 0) continue;
                        pa2 = this.scrbuff[test2 - hstep];
                        pb2 = this.scrbuff[test2 + hstep];
                        a2 = pa2 >> 1 & 0x7F7F7F;
                        b2 = pb2 >> 1 & 0x7F7F7F;
                        this.scrbuff[test2] = a2 + b2;
                    }
                }
            }
            for (int y = this.r.y; y < this.r.height - 2; y += 2) {
                for (int x = this.r.x; x < this.r.width - 2; x += 2) {
                    int v21;
                    int v01;
                    int i = x + y * w;
                    int v00 = this.scrbuff[i] >> 1 & 0x7F7F7F;
                    int v02 = this.scrbuff[i + 2] >> 1 & 0x7F7F7F;
                    this.scrbuff[i + 1] = v01 = v00 + v02;
                    int v20 = this.scrbuff[i + 2 * w] >> 1 & 0x7F7F7F;
                    this.scrbuff[i + w] = v00 + v20;
                    int v22 = this.scrbuff[i + 2 * w + 2] >> 1 & 0x7F7F7F;
                    this.scrbuff[i + w * 2 + 1] = v21 = v20 + v22;
                    this.scrbuff[i + w + 2] = v02 + v22;
                    v01 = v01 >> 1 & 0x7F7F7F;
                    v21 = v21 >> 1 & 0x7F7F7F;
                    this.scrbuff[i + w + 1] = v01 + v21;
                }
            }
            Thread.yield();
            this.copyToBackBuff();
            this.scrcomp.repaint();
            if (this.noChange) continue;
            this.ren.updateWorld();
            return;
        }
        ++this.r.x;
        ++this.r.y;
        this.ren.castRays(this.r, 2, 2, 0, 1, null);
        this.highbit(this.scrbuff, w, this.r, 2, 2);
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        --this.r.y;
        this.ren.castRays(this.r, 2, 2, 0, 1, null);
        this.highbit(this.scrbuff, w, this.r, 2, 2);
        this.copyToBackBuff();
        Thread.yield();
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        --this.r.x;
        ++this.r.y;
        this.ren.castRays(this.r, 2, 2, 0, 1, null);
        this.highbit(this.scrbuff, w, this.r, 2, 2);
        --this.r.y;
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        for (int y = this.r.y; y < this.r.height; ++y) {
            for (int x = this.r.x; x < this.r.width; ++x) {
                int i = x + y * w;
                if (this.scrbuff[i] < 0) continue;
                this.scrbuff[i] = this.ren.castRay(x, y, 0, 1, null);
            }
        }
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
    }

    protected void highbit(int[] img, int iw, Rectangle r, int sx, int sy) {
        for (int y = r.y; y < r.height; y += sy) {
            for (int x = r.x; x < r.width; x += sx) {
                int n = iw * y + x;
                img[n] = img[n] | 0xFF000000;
            }
        }
    }

    public void copyToBackBuff() {
        System.arraycopy(this.scrbuff, 0, this.scrbuff2, 0, this.scrbuff2.length);
    }

    public void copyToBackBuffLPF() {
        int p;
        int x;
        int y;
        int h = this.scr.getHeight();
        int w = this.scr.getWidth();
        for (y = 1; y < h - 1; ++y) {
            for (x = 0; x < w - 1; ++x) {
                p = x + y * w;
                int t1 = this.avg(this.scrbuff[p - 1], this.scrbuff[p + 1]);
                int t2 = this.avg(this.scrbuff[p - w], this.scrbuff[p + w]);
                this.scrbuff2[p] = this.avg(t1, t2);
            }
        }
        for (y = 1; y < h - 1; ++y) {
            int p2 = 0 + y * w;
            this.scrbuff[p2] = this.scrbuff[p2];
            this.scrbuff[p2 += w - 1] = this.scrbuff[p2];
        }
        int offy = (h - 1) * w;
        for (x = 0; x < w; ++x) {
            p = x;
            this.scrbuff[p] = this.scrbuff[p];
            this.scrbuff[p += offy] = this.scrbuff[p];
        }
    }

    private final int avg(int a, int b) {
        return (a >> 1 & 0x7F7F7F) + (b >> 1 & 0x7F7F7F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageChange(String str, byte[] ray_mask) {
        this.mode = str;
        Object object = this.lock;
        synchronized (object) {
            this.noChange = false;
            this.lock.notify();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.scr == null || this.scrcomp.getWidth() != this.scr.getWidth() || this.scrcomp.getHeight() != this.scr.getHeight()) {
            this.resizeBuffer = true;
            this.imageChange(null, null);
            return;
        }
        g.drawImage(this.backBuffer, 0, 0, null);
    }

    @Override
    public BufferedImage getDisplayBuffer() {
        return this.scr2;
    }

    @Override
    public boolean isFinal() {
        return this.done;
    }
}

