/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorCTL;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorMapUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.CursorValueUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.HistogramUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.OpacityCTL;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.OpacityMapUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.OpticksUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.TickMarksUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIcontrol;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIelement;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrPresetsEditor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

class CNOplot
extends JPanel {
    UIelement[] ui = new UIelement[]{new OpacityMapUI(), new ColorMapUI(), new TickMarksUI(), new OpacityCTL(), new OpticksUI(), new ColorCTL(), new CursorValueUI(), new HistogramUI()};
    UIcontrol[] uic;
    UIcontrol activeCtl = null;
    Layout layout = new Layout();
    Preset preset;
    Cursor dragCursor = new Cursor(13);
    ImageIcon zoomIcon_ = new ImageIcon(CNOplot.class.getResource("zoomimagea1.png"));
    Cursor zoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.zoomIcon_.getImage(), new Point(this.zoomIcon_.getIconWidth() / 2, this.zoomIcon_.getIconHeight() / 2), "Zoom");
    Rectangle vrect;
    int downX;
    int downY;
    int lastY;
    static final double ZOOM_INCREMENT = 0.05;
    static final double MAX_ZOOM = 40.0;
    static final double MIN_ZOOM = 0.5;
    private double zoom_ = 20.0;
    Rectangle r = new Rectangle();
    private VrHistogram histogram;
    boolean mousePan = true;

    public CNOplot() {
        this.setPreferredSize(new Dimension(2000, 100));
        ArrayList<UIelement> al = new ArrayList<UIelement>();
        for (int i = 0; i < this.ui.length; ++i) {
            this.ui[i].setLayout(this.layout);
            if (!(this.ui[i] instanceof UIcontrol)) continue;
            al.add(this.ui[i]);
        }
        this.uic = al.toArray(new UIcontrol[al.size()]);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CNOplot.this.lastY = e.getY();
                CNOplot.this.activeCtl = null;
                CNOplot.this.vrect = CNOplot.this.getVisibleRect();
                CNOplot.this.downX = e.getX() - CNOplot.this.vrect.x;
                CNOplot.this.downY = e.getY() - CNOplot.this.vrect.y;
                for (int i = 0; i < CNOplot.this.uic.length; ++i) {
                    if (!CNOplot.this.uic[i].mousePressed(e)) continue;
                    CNOplot.this.activeCtl = CNOplot.this.uic[i];
                    break;
                }
                if (CNOplot.this.activeCtl == null) {
                    CNOplot.this.setCursor(CNOplot.this.mousePan ? CNOplot.this.dragCursor : CNOplot.this.zoomCursor);
                } else {
                    CNOplot.this.setCursor(CNOplot.this.dragCursor);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (CNOplot.this.activeCtl != null) {
                    CNOplot.this.activeCtl.mouseReleased(e);
                } else {
                    CNOplot.this.setCursor(null);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CNOplot.this.activeCtl != null) {
                    if (e.getX() >= 0 && e.getX() < CNOplot.this.getWidth() - 1) {
                        CNOplot.this.activeCtl.mouseDragged(e);
                        Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
                        CNOplot.this.scrollRectToVisible(r);
                    }
                } else if (CNOplot.this.mousePan) {
                    Rectangle r = new Rectangle(CNOplot.this.vrect);
                    Rectangle off = CNOplot.this.getVisibleRect();
                    r.translate(CNOplot.this.downX - (e.getX() - off.x), 0);
                    CNOplot.this.scrollRectToVisible(r);
                } else {
                    int y = e.getY();
                    double change = 1.0 - (double)(CNOplot.this.lastY - y) / (double)e.getComponent().getHeight();
                    CNOplot.this.setZoom(Math.min(40.0, Math.max(0.5, CNOplot.this.getZoom() * change)));
                    CNOplot.this.lastY = y;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                for (int i = 0; i < CNOplot.this.uic.length; ++i) {
                    if (!CNOplot.this.uic[i].mouseMoved(e)) continue;
                    return;
                }
                CNOplot.this.setCursor(null);
            }
        });
    }

    public void setPresets(Preset p) {
        this.preset = p;
        for (int i = 0; i < this.ui.length; ++i) {
            this.ui[i].setPresets(p);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("CNOplot.java");
        CNOplot p = new CNOplot();
        p.setPresets(new Preset());
        f.setContentPane(p);
        f.setBounds(100, 100, 512, 512);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.getBackground());
        this.computeVisibleRect(this.r);
        g.fillRect(this.r.x, this.r.y, this.r.width, this.r.height);
        for (int i = 0; i < this.ui.length; ++i) {
            this.ui[i].paint(g, w, h, this.r);
        }
    }

    public void setCursorValue(double value) {
        for (int i = 0; i < this.ui.length; ++i) {
            if (!(this.ui[i] instanceof CursorValueUI)) continue;
            ((CursorValueUI)this.ui[i]).setCursorValue(value);
        }
    }

    public void setCursorColor(Color c) {
        for (int i = 0; i < this.ui.length; ++i) {
            if (!(this.ui[i] instanceof CursorValueUI)) continue;
            ((CursorValueUI)this.ui[i]).setCursorColor(c);
        }
    }

    public void setHistogram(VrHistogram h) {
        this.histogram = h;
        for (int i = 0; i < this.ui.length; ++i) {
            if (!(this.ui[i] instanceof HistogramUI)) continue;
            ((HistogramUI)this.ui[i]).setHistogram(h);
        }
    }

    public void setMousePan(boolean b) {
        this.mousePan = b;
    }

    public double getZoom() {
        return this.zoom_;
    }

    public void setZoom(double zoom) {
        double ratio = zoom / this.zoom_;
        this.zoom_ = zoom;
        Dimension d = new Dimension((int)((double)this.getParent().getParent().getParent().getSize().width * this.zoom_), this.getHeight());
        this.setSize(d);
        d.height = 0;
        this.setPreferredSize(d);
        this.r.x = (int)(ratio * ((double)this.r.x + (double)this.r.width / 2.0)) - this.r.width / 2;
        this.scrollRectToVisible(this.r);
    }

    public void resetPanZoom() {
        if (VrPresetsEditor.FitHistogramOnInit && this.histogram != null && this.histogram.max > this.histogram.min) {
            this.setZoom((Layout.MAX - Layout.MIN) / (double)(this.histogram.max - this.histogram.min));
            int x = this.layout.getXpos(this.getWidth(), this.histogram.intercept);
            Rectangle r = new Rectangle(x, 0, this.getWidth(), 0);
            this.scrollRectToVisible(r);
        }
    }

    public VrHistogram getHistogram() {
        return this.histogram;
    }
}

