/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorWheel;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Messages;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Sphere;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrPresetsEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ColorEditor
extends JPanel {
    ColorWheel wheel = new ColorWheel();
    Sphere sphere = new Sphere();
    JButton jButton1 = new JButton();
    Preset p = null;
    transient Vector actionListeners = new Vector();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    Component component1 = Box.createHorizontalStrut(8);
    Component component2 = Box.createHorizontalStrut(8);
    JSlider jSlider1 = new JSlider();

    public ColorEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!Beans.isDesignTime()) {
            this.setBackground(new Color(0));
            this.setOpaque(false);
            if (VrPresetsEditor.AWmode) {
                this.remove(this.jSlider1);
            }
        }
        this.wheel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double h = ColorEditor.this.wheel.getHue();
                double s = ColorEditor.this.wheel.getSat();
                double b = ColorEditor.this.wheel.getBright();
                Color c = Color.getHSBColor((float)h, (float)s, (float)b);
                ColorEditor.this.sphere.setForeground(c);
                if (ColorEditor.this.p != null && ColorEditor.this.p.rgbSelected != -1) {
                    ColorEditor.this.p.rgbValue[ColorEditor.this.p.rgbSelected] = c.getRGB();
                    ColorEditor.this.p.putProperty("paintCache", null);
                    ColorEditor.this.p.fireActionPerformed(new ActionEvent(this, 0, "color_changed"));
                }
            }
        });
    }

    @Override
    public boolean contains(int x, int y) {
        if (Beans.isDesignTime()) {
            return super.contains(x, y);
        }
        Component[] c = super.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!c[i].getBounds().contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("ColorEditor.java");
        ColorEditor p = new ColorEditor();
        f.setContentPane(p);
        f.setBounds(100, 100, 256, 300);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jButton1.setMargin(new Insets(1, 1, 1, 1));
        this.jButton1.setText(Messages.getString("ColorEditor.Done"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorEditor.this.jButton1_actionPerformed(e);
            }
        });
        this.wheel.setInputVerifier(null);
        this.wheel.setLayout(this.gridBagLayout2);
        this.jSlider1.setOrientation(1);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorEditor.this.jSlider1_stateChanged(e);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.add((Component)this.wheel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.wheel.add(this.component1, new GridBagConstraints(0, 1, 1, 2, 0.3, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.wheel.add((Component)this.sphere, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.3, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.wheel.add(this.component2, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jSlider1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 82, 0), 0, 0));
    }

    public void setPreset(Preset preset) {
        this.p = preset;
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("color_select".equals(e.getActionCommand()) && ColorEditor.this.p.rgbSelected != -1) {
                    int c = ColorEditor.this.p.rgbValue[ColorEditor.this.p.rgbSelected];
                    ColorEditor.this.wheel.setColor(c);
                    ColorEditor.this.sphere.setForeground(new Color(c));
                    ColorEditor.this.jSlider1.setValue((int)(ColorEditor.this.wheel.getBright() * 100.0));
                }
            }
        });
    }

    public void jButton1_actionPerformed(ActionEvent e) {
        this.fireActionPerformed(new ActionEvent(e.getSource(), 0, "OK"));
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    public void jSlider1_stateChanged(ChangeEvent e) {
        this.wheel.setBright((double)this.jSlider1.getValue() / 100.0);
    }
}

