/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.MouseCursors;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIcontrol;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

class OpacityCTL
implements UIcontrol {
    private Layout l;
    private Preset p;
    public static final int HANDLE_HEIGHT = 12;
    static DecimalFormat format = new DecimalFormat("#####.#");
    public int selectedRegion;
    public int cursorOver;
    public int colorPos;
    JComponent source;
    public boolean mousePressed = false;
    public static final int REGION_LEFT = 1;
    public static final int REGION_RIGHT = 2;
    public static final int REGION_MIDDLE = 3;
    public static final int REGION_POS = 4;

    OpacityCTL() {
    }

    @Override
    public void setLayout(Layout layout) {
        this.l = layout;
    }

    @Override
    public void paint(Graphics g, int w, int h, Rectangle r) {
        this.l.setHeight(h);
        double hmin = this.l.op_bottom;
        double hmax = this.l.op_top;
        int tipY = this.l.color_bottom;
        Border ttborder = UIManager.getBorder("ToolTip.border");
        for (int i = 0; i < this.p.opacityPos.length; ++i) {
            int x1 = this.l.getXpos(w, this.p.opacityPos[i]);
            if (this.mousePressed && this.p.opacitySelected == i) {
                String s = format.format(this.p.opacityPos[i]);
                FontMetrics f = g.getFontMetrics();
                Rectangle2D rect = f.getStringBounds(s, g);
                int off = 0;
                int rwidth = 5 + (int)rect.getWidth();
                if (r.x + r.width <= x1 + 1 + rwidth) {
                    off = -rwidth;
                }
                g.setColor(UIManager.getColor("ToolTip.background"));
                int opTextPos = this.l.tick_bottom - 2;
                g.fillRect(x1 + 1 + off, this.l.tick_bottom - f.getHeight() + 1, rwidth, 2 + (int)rect.getHeight());
                g.setColor(Color.BLACK);
                ttborder.paintBorder(this.source, g, x1 + 1 + off, this.l.tick_bottom - f.getHeight() + 1, rwidth, 2 + (int)rect.getHeight());
                g.drawString(s, x1 + 4 + off, opTextPos);
            }
            if (this.p.opacitySelected == i) {
                g.setColor(Color.lightGray);
            } else {
                g.setColor(Color.gray);
            }
            if (this.showLine(i)) {
                if (!this.showRHandle(i) && !this.showLHandle(i)) {
                    g.draw3DRect(x1, this.l.BORDER.top, 1, tipY - this.l.BORDER.top - 1, true);
                } else {
                    int posBefore = (int)(this.p.opacityBefore[i] * (hmax - hmin) + hmin);
                    int posAfter = (int)(this.p.opacityAfter[i] * (hmax - hmin) + hmin);
                    int pos = Math.min(posBefore, posAfter);
                    g.draw3DRect(x1, pos, 1, tipY - pos - 1, true);
                }
            }
            if (!this.showRHandle(i)) continue;
            int pos = (int)(this.p.opacityBefore[i] * (hmax - hmin) + hmin);
            if (this.p.opacityMode == 0 || this.p.opacityMode == 5) {
                if (this.showLHandle(i)) {
                    pos = (int)(this.p.opacityBefore[i] * (hmax - hmin) + hmin);
                    g.fill3DRect(x1 - 5, pos - 6, 6, 12, true);
                }
                pos = (int)(this.p.opacityAfter[i] * (hmax - hmin) + hmin);
                g.fill3DRect(x1, pos - 6, 6, 12, true);
            } else if (this.showLHandle(i) && this.showRHandle(i)) {
                pos = (int)(this.p.opacityAfter[i] * (hmax - hmin) + hmin);
                g.fill3DRect(x1 - 5, pos - 6, 12, 12, true);
            }
            if (!this.mousePressed || this.p.opacitySelected != i) continue;
            double op = -1.0;
            if (this.selectedRegion == 3) {
                op = this.p.opacityBefore[i];
            } else if (this.selectedRegion == 1) {
                op = this.p.opacityBefore[i];
            } else if (this.selectedRegion == 2) {
                op = this.p.opacityAfter[i];
            }
            if (!(op >= 0.0)) continue;
            String s = format.format(op * 100.0) + "%";
            FontMetrics f = g.getFontMetrics();
            Rectangle2D rect = f.getStringBounds(s, g);
            int off = 0;
            int rwidth = 5 + (int)rect.getWidth();
            if (r.x + r.width <= x1 + 8 + rwidth) {
                off = -(rwidth + 16);
            }
            g.setColor(UIManager.getColor("ToolTip.background"));
            g.fillRect(x1 + 8 + off, (int)((double)pos - rect.getHeight() + 1.0), rwidth, 2 + (int)rect.getHeight());
            g.setColor(Color.black);
            ttborder.paintBorder(this.source, g, x1 + 8 + off, (int)((double)pos - rect.getHeight() + 1.0), rwidth, 2 + (int)rect.getHeight());
            g.drawString(s, x1 + 11 + off, pos - f.getDescent() + 3);
        }
    }

    public boolean showRHandle(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return pos == 0;
            }
            case 1: {
                return pos > 0;
            }
            case 5: {
                return pos == 0;
            }
        }
        return false;
    }

    public boolean showLHandle(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return pos == 0;
            }
            case 1: {
                return pos > 0;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    private boolean showAttachObjectControlAt(int pos) {
        if (this.p.opacityMode != 6) {
            throw new IllegalArgumentException("Not in attach object mode!");
        }
        return pos % 5 == 2;
    }

    public boolean showLine(int pos) {
        switch (this.p.opacityMode) {
            case 0: {
                return true;
            }
            case 4: {
                return pos == 0 || pos == 3;
            }
            case 3: {
                return pos == 1 || pos == 2;
            }
            case 6: {
                return this.showAttachObjectControlAt(pos);
            }
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
            case 5: {
                return pos == 0;
            }
        }
        return false;
    }

    @Override
    public void setPresets(Preset p) {
        this.p = p;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        JComponent c = (JComponent)e.getSource();
        this.l.setHeight(c.getHeight());
        double hmin = this.l.op_bottom;
        double hmax = this.l.op_top;
        double pos = ((double)y - hmin) / (hmax - hmin);
        if (pos < 0.0) {
            pos = 0.0;
        }
        if (pos > 1.0) {
            pos = 1.0;
        }
        if (this.selectedRegion == 0) {
            return;
        }
        switch (this.selectedRegion) {
            case 1: {
                this.p.opacityBefore[this.p.opacitySelected] = pos;
                if (!e.isShiftDown()) {
                    this.adjustPos(c, x);
                }
                c.repaint();
                break;
            }
            case 2: {
                this.p.opacityAfter[this.p.opacitySelected] = pos;
                if (!e.isShiftDown()) {
                    this.adjustPos(c, x);
                }
                c.repaint();
                break;
            }
            case 3: {
                if (this.p.opacityMode != 6) {
                    int k;
                    this.p.opacityBefore[this.p.opacitySelected] = pos;
                    this.p.opacityAfter[this.p.opacitySelected] = pos;
                    if (this.p.opacityMode == 3) {
                        k = this.p.opacitySelected + 1;
                        if (k > 2) {
                            k = 1;
                        }
                        this.p.opacityBefore[k] = pos;
                        this.p.opacityAfter[k] = pos;
                    }
                    if (this.p.opacityMode == 4) {
                        k = this.p.opacitySelected + 3;
                        if (k > 3) {
                            k = 0;
                        }
                        this.p.opacityBefore[k] = pos;
                        this.p.opacityAfter[k] = pos;
                    }
                    if (!e.isShiftDown()) {
                        this.adjustPos(c, x);
                    }
                } else {
                    this.updateObjects(c, x, pos);
                }
                c.repaint();
                break;
            }
            case 4: {
                if (this.p.opacityMode != 6) {
                    this.adjustPos(c, x);
                } else {
                    this.updateObjects(c, x, this.p.opacityAtColor[this.p.rgbSelected]);
                }
                c.repaint();
            }
        }
        this.p.fireActionPerformed(new ActionEvent(this, 0, "opacity_mouseDragged"));
    }

    private void updateObjects(JComponent c, int x, double opacity) {
        double v = this.l.getVfromX(c.getWidth(), x);
        this.p.opacityAtColor[this.p.rgbSelected] = opacity;
        this.p.rgbPos[this.p.rgbSelected] = v;
        this.p.sortColor();
        this.p.updateOpacityPts();
    }

    public void adjustPos(JComponent c, int x) {
        double v;
        this.p.opacityPos[this.p.opacitySelected] = v = this.l.getVfromX(c.getWidth(), x);
        if (this.p.opacityMode == 3) {
            this.p.opacityPos[0] = this.p.opacityPos[1] - (this.p.opacityPos[2] - this.p.opacityPos[1]);
            this.p.opacityPos[3] = this.p.opacityPos[2] + (this.p.opacityPos[2] - this.p.opacityPos[1]);
        } else if (this.p.opacityMode == 4) {
            double delta = (this.p.opacityPos[3] - this.p.opacityPos[0]) / 3.0;
            this.p.opacityPos[1] = this.p.opacityPos[0] + delta;
            this.p.opacityPos[2] = this.p.opacityPos[0] + 2.0 * delta;
        }
        this.p.sortOpacity();
        this.p.setOpacityMode(this.p.opacityMode);
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        int region;
        this.source = (JComponent)e.getSource();
        this.selectedRegion = region = this.getSelectedRegion(e);
        if (region == 0) {
            return false;
        }
        this.mousePressed = true;
        this.p.opacitySelected = this.cursorOver;
        if (this.p.opacityMode == 6) {
            this.p.setRGBselected(this.colorPos);
        }
        return true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mousePressed = false;
        ((JComponent)e.getSource()).repaint();
        this.p.fireActionPerformed(new ActionEvent(this, 0, "opacity_mouseReleased"));
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        int region = this.getSelectedRegion(e);
        switch (region) {
            case 1: {
                c.setCursor(MouseCursors.makeLeftUpDown());
                break;
            }
            case 2: {
                c.setCursor(MouseCursors.makeRightUpDown());
                break;
            }
            case 3: {
                c.setCursor(MouseCursors.makeCenterUpDown());
                break;
            }
            case 4: {
                c.setCursor(MouseCursors.makeLeftRightCursor());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int getSelectedRegion(MouseEvent e) {
        if (this.p.opacityMode == 0) {
            return this.getFreeSelectedRegion(e);
        }
        int n = this.getFreeSelectedRegion(e);
        if (n == 4) {
            return n;
        }
        if (n == 0) {
            return 0;
        }
        if (this.p.opacityMode == 5) {
            return 2;
        }
        return 3;
    }

    public int getFreeSelectedRegion(MouseEvent e) {
        int i;
        JComponent c = (JComponent)e.getSource();
        int h = c.getHeight();
        this.l.setHeight(h);
        int x = e.getX();
        int y = e.getY();
        if (this.p.opacityMode == 6) {
            for (i = 0; i < this.p.rgbPos.length; ++i) {
                int x2 = this.l.getXpos(c.getWidth(), this.p.rgbPos[i]);
                if (Math.abs(x2 - x) >= 10 || this.p.opacityAtColor == null || !(this.p.opacityAtColor[i] >= 0.0)) continue;
                this.colorPos = i;
                break;
            }
        }
        for (i = 0; i < this.p.opacityPos.length; ++i) {
            int x1;
            if (!this.showLine(i) || Math.abs((x1 = this.l.getXpos(c.getWidth(), this.p.opacityPos[i])) - x) >= 10) continue;
            this.cursorOver = i;
            double hmin = this.l.op_bottom;
            double hmax = this.l.op_top;
            int posBefore = (int)(this.p.opacityBefore[i] * (hmax - hmin) + hmin);
            int posAfter = (int)(this.p.opacityAfter[i] * (hmax - hmin) + hmin);
            boolean nearPosBefore = Math.abs(posBefore - y) < 6;
            boolean nearPosAfter = Math.abs(posAfter - y) < 6;
            int dx = x1 - x;
            if (!this.showRHandle(i) && y < this.l.color_bottom && y > posBefore && posBefore == posAfter) {
                return 4;
            }
            if (nearPosBefore && nearPosAfter) {
                if (dx > 5) {
                    return 1;
                }
                if (dx < -5) {
                    return 2;
                }
                return 3;
            }
            if (nearPosBefore) {
                return 1;
            }
            if (nearPosAfter) {
                return 2;
            }
            if (y >= this.l.color_bottom) continue;
            if (this.showRHandle(i) || this.showLHandle(i)) {
                if (y <= Math.min(posAfter, posBefore)) continue;
                return 4;
            }
            return 4;
        }
        return 0;
    }
}

