/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Sphere
extends JPanel {
    BufferedImage backImg = null;
    boolean recalc = false;

    public Sphere() {
        this.setForeground(Color.CYAN);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Sphere");
        Sphere p = new Sphere();
        f.setContentPane(p);
        f.setDefaultCloseOperation(3);
        f.setBounds(10, 10, 512, 512);
        f.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.backImg == null || this.backImg.getWidth() != w || this.backImg.getHeight() != h) {
            this.backImg = new BufferedImage(w, h, 2);
            this.recalc = true;
        }
        if (this.recalc) {
            this.renderSphere();
        }
        g.drawImage(this.backImg, 0, 0, null);
    }

    public void renderSphere() {
        int w = this.backImg.getWidth();
        int h = this.backImg.getHeight();
        int rc = this.getForeground().getRed();
        int gc = this.getForeground().getGreen();
        int bc = this.getForeground().getBlue();
        int[] buff = ((DataBufferInt)this.backImg.getRaster().getDataBuffer()).getData();
        double rad = w > h ? (double)h / 2.0 : (double)w / 2.0;
        double radsq = (rad -= 2.0) * rad;
        for (int i = 0; i < buff.length; ++i) {
            double x = (double)(i % w) - (double)w / 2.0;
            double y = (double)h / 2.0 - (double)(i / w);
            double d = x * x + y * y;
            if (d > radsq) {
                buff[i] = 0;
                continue;
            }
            double v = 0.2 + 0.8 * Math.sqrt(radsq - d) / rad;
            buff[i] = ((int)(v * (double)rc) << 16) + ((int)(v * (double)gc) << 8) + (int)(v * (double)bc) + -16777216;
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.recalc = true;
        this.repaint();
    }
}

