/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.BottomControlPanel;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.CNOscrollview;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Messages;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.TopControlPanel;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VrPresetsEditor
extends JPanel {
    CNOscrollview sv = new CNOscrollview();
    TopControlPanel topControl = new TopControlPanel();
    BottomControlPanel bottomControl = new BottomControlPanel();
    JLabel titleLabel = new JLabel(Messages.getString("CNO.title"));
    Preset preset = null;
    public static boolean AWmode = false;
    public static boolean FitHistogramOnInit = true;

    public VrPresetsEditor() {
        if (AWmode) {
            this.setPreferredSize(new Dimension(512, 512));
        } else {
            this.setPreferredSize(new Dimension(256, 384));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.titleLabel, "North");
        JPanel content = new JPanel(new BorderLayout());
        this.add(content);
        content.add(this.sv);
        content.add((Component)this.topControl, "North");
        content.add((Component)this.bottomControl, "South");
        this.sv.setMousePan(false);
    }

    public void setPresets(Preset p) {
        this.preset = p;
        this.sv.setPresets(p);
        this.topControl.setPreset(p);
        this.bottomControl.setPreset(p);
    }

    public Preset getPresets() {
        return this.preset;
    }

    public void setCursorValue(double value) {
        this.sv.setCursorValue(value);
        this.sv.repaint();
    }

    public void setCursorColor(Color c) {
        this.sv.setCursorColor(c);
        this.sv.repaint();
    }

    public void setHistogram(VrHistogram h) {
        this.sv.setHistogram(h);
        this.sv.repaint();
    }

    public VrHistogram getHistogram(VrHistogram h) {
        return this.sv.getHistogram();
    }

    public void setDataRange(double min, double max, String unit) {
        this.sv.setDataRange(min, max, unit);
        if (this.preset != null) {
            this.preset.setStartX(min);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("CNO.java");
        f.setDefaultCloseOperation(3);
        VrPresetsEditor cno = new VrPresetsEditor();
        cno.setPresets(new Preset());
        VrHistogram h = VrHistogram.generateFakeHistogram();
        cno.setHistogram(h);
        f.setContentPane(cno);
        f.pack();
        f.setVisible(true);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }
}

