/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.vr.RayTracer;
import com.ge.med.terra.jami.j3d.vr.VrCamera;
import com.ge.med.terra.jami.j3d.vr.VrColor;
import com.ge.med.terra.jami.j3d.vr.VrContext;
import com.ge.med.terra.jami.j3d.vr.VrPresetCurves;

public class vr {
    private static final double OBJECT_CONTENT_THRESH = 0.98;
    private static final int LIGHT_TABLE_SIZE = 32768;
    private static final double[] LIGHT_TABLE = new double[32768];
    public static final float AMBIENT_LIGHT = 0.2f;
    public static final float DIRECTIONAL_LIGHT = 0.8f;
    private static final int SHIFT = 16;
    private static final int SCALE = 65536;
    private static final int FRAC_MASK = 65535;
    private static final double INV_SCALE = 1.52587890625E-5;
    private static final double[] FRAC = new double[65536];
    private RayTracer rt = new RaySplitColorLut_NonPower2_i();
    private boolean vxColorEnhance = true;
    private double[] XX = new double[]{1.0, 0.0, 0.0};
    private double[] YY = new double[]{0.0, 1.0, 0.0};
    private double[] ZZ = new double[]{0.0, 0.0, 1.0};
    private double[] majorDirs = new double[3];
    private boolean dojitter = true;
    private static final int INTNBITS = 8;
    private static final int SCALE1 = 256;
    private static final int DIV_SCALEF = 16;
    private static final double SCALEF = 1.52587890625E-5;
    private static final int SHIFT_MINUS_INTNBITS = 8;

    public void setRayTracer(RayTracer ray_tracer) {
        this.rt = ray_tracer;
    }

    public RayTracer getRayTracer() {
        return this.rt;
    }

    public void setRayJitter(boolean dojitter) {
        this.dojitter = dojitter;
    }

    public boolean isRayJitter() {
        return this.dojitter;
    }

    private double random() {
        if (this.dojitter) {
            return Math.random() - 0.5;
        }
        return 0.0;
    }

    public int render_vr(int x0, int y0, int xskip, int yskip, VrCamera cam, VrColor color) {
        return this.render_vr(x0, y0, cam.owidth, cam.oheight, xskip, yskip, cam, color);
    }

    private double dotabs(double[] v0, double[] v1) {
        return Math.abs(v0[0] * v1[0] + v0[1] * v1[1] + v0[2] * v1[2]);
    }

    public int render_vr(int x0, int y0, int x1, int y1, int xskip, int yskip, VrCamera cam, VrColor color) {
        this.majorDirs[0] = this.dotabs(cam.zstep, this.XX);
        this.majorDirs[1] = this.dotabs(cam.zstep, this.YY);
        this.majorDirs[2] = this.dotabs(cam.zstep, this.ZZ);
        int md = this.majorDirs[1] > this.majorDirs[0] ? 1 : 0;
        md = this.majorDirs[2] > this.majorDirs[md] ? 2 : md;
        int retval = 0;
        retval = cam.isPerspective() ? this.render_perspectivevr(x0, y0, x1, y1, xskip, yskip, cam, color) : this.render_projectionvr(x0, y0, x1, y1, xskip, yskip, cam, color);
        return retval;
    }

    private int render_projectionvr(int x0, int y0, int x1, int y1, int xskip, int yskip, VrCamera cam, VrColor color) {
        VrContext ctxt = cam.vr_ctxt;
        double[] bg = cam.getBackgroundf();
        byte[] bingrid = ctxt.getBingrid();
        int owidth = cam.owidth;
        int oheight = cam.oheight;
        int olen = cam.lum_raster.length;
        int[] start = cam.startBuff;
        int[] end = cam.endBuff;
        int[] output = cam.output;
        byte[] stencil = cam.stencil_raster;
        short[] lum_raster = cam.lum_raster;
        short[] dbuffer = cam.depth_buffer;
        VrPresetCurves pCurves = ctxt.presetCurves;
        double[] ceTable = pCurves != null ? pCurves.colorEnhanceTable : null;
        double rayx_x = (double)xskip * cam.xstep[0];
        double rayx_y = (double)xskip * cam.xstep[1];
        double rayx_z = (double)xskip * cam.xstep[2];
        double rayy_x = (double)yskip * cam.ystep[0];
        double rayy_y = (double)yskip * cam.ystep[1];
        double rayy_z = (double)yskip * cam.ystep[2];
        double row_x = cam.ul[0] + (double)x0 * cam.xstep[0] + (double)y0 * cam.ystep[0];
        double row_y = cam.ul[1] + (double)x0 * cam.xstep[1] + (double)y0 * cam.ystep[1];
        double row_z = cam.ul[2] + (double)x0 * cam.xstep[2] + (double)y0 * cam.ystep[2];
        int totalrays = 0;
        int totalvox = 0;
        int bgval = cam.getBackground() & 0xFFFFFF;
        double vdx = cam.zstep[0];
        double vdy = cam.zstep[1];
        double vdz = cam.zstep[2];
        int ivdx = (int)(65536.0 * vdx);
        int ivdy = (int)(65536.0 * vdy);
        int ivdz = (int)(65536.0 * vdz);
        double xstep_size = JnVector3d.length(cam.xstep);
        double ystep_size = JnVector3d.length(cam.ystep);
        double minStepSize = Math.min(xstep_size, ystep_size);
        if (bingrid == null) {
            return 0;
        }
        for (int y = y0; y < y1; y += yskip) {
            int offset = y * owidth;
            double ex = row_x;
            double ey = row_y;
            double ez = row_z;
            double RAY_JITTER = this.random() * Math.min(1.0, minStepSize * 0.75);
            for (int x = x0; x < x1; x += xskip) {
                int pix_position = offset + x;
                output[pix_position] = bgval;
                if (cam.ray_raster[pix_position] == 64) {
                    int pixval;
                    int t0 = start[pix_position] + 1;
                    int t1 = end[pix_position] - 1;
                    double jitter = RAY_JITTER;
                    double vx = ex + vdx * ((double)t0 + jitter);
                    double vy = ey + vdy * ((double)t0 + jitter);
                    double vz = ez + vdz * ((double)t0 + jitter);
                    color.step_num = dbuffer[pix_position];
                    color.luminance_val = lum_raster[pix_position];
                    color.filled = stencil[pix_position];
                    color.light = 1.0;
                    totalvox += this.rt.traceRay(vx, vy, vz, vdx, vdy, vdz, ivdx, ivdy, ivdz, t0, t1, color);
                    stencil[pix_position] = 1;
                    ++totalrays;
                    double valf = 1.0;
                    if (this.vxColorEnhance && ceTable != null) {
                        int cidx = (int)(color.light * 131072.0);
                        valf = ceTable[cidx];
                    }
                    double redf = valf * color.red + bg[0] * color.light;
                    double greenf = valf * color.green + bg[1] * color.light;
                    double bluef = valf * color.blue + bg[2] * color.light;
                    int red = (int)(redf * 255.0);
                    int green = (int)(greenf * 255.0);
                    int blue = (int)(bluef * 255.0);
                    red = red < 255 ? red : 255;
                    green = green < 255 ? green : 255;
                    blue = blue < 255 ? blue : 255;
                    output[pix_position] = pixval = red << 16 | green << 8 | blue;
                    dbuffer[pix_position] = color.light < 0.98 ? (int)color.step_num : 8192;
                    lum_raster[pix_position] = (short)color.luminance_val;
                }
                ex += rayx_x;
                ey += rayx_y;
                ez += rayx_z;
            }
            row_x += rayy_x;
            row_y += rayy_y;
            row_z += rayy_z;
        }
        return totalrays;
    }

    private int render_perspectivevr(int x0, int y0, int x1, int y1, int xskip, int yskip, VrCamera cam, VrColor color) {
        VrContext ctxt = cam.vr_ctxt;
        double[] bg = cam.getBackgroundf();
        byte[] bingrid = ctxt.getBingrid();
        int owidth = cam.owidth;
        int[] start = cam.startBuff;
        int[] end = cam.endBuff;
        int[] output = cam.output;
        byte[] stencil = cam.stencil_raster;
        short[] lum_raster = cam.lum_raster;
        short[] dbuffer = cam.depth_buffer;
        double[] ceTable = ctxt.presetCurves.colorEnhanceTable;
        double rayx_x = (double)xskip * cam.xstep[0];
        double rayx_y = (double)xskip * cam.xstep[1];
        double rayx_z = (double)xskip * cam.xstep[2];
        double rayy_x = (double)yskip * cam.ystep[0];
        double rayy_y = (double)yskip * cam.ystep[1];
        double rayy_z = (double)yskip * cam.ystep[2];
        double xstep_size = JnVector3d.length(cam.xstep);
        double ystep_size = JnVector3d.length(cam.ystep);
        double minStepSize = Math.min(xstep_size, ystep_size);
        int bgval = cam.getBackground() & 0xFFFFFF;
        double row_x = cam.ul[0] + (double)x0 * cam.xstep[0] + (double)y0 * cam.ystep[0];
        double row_y = cam.ul[1] + (double)x0 * cam.xstep[1] + (double)y0 * cam.ystep[1];
        double row_z = cam.ul[2] + (double)x0 * cam.xstep[2] + (double)y0 * cam.ystep[2];
        int totalrays = 0;
        int totalvox = 0;
        if (bingrid == null) {
            return 0;
        }
        int rowlen = owidth * 3;
        for (int y = y0; y < y1; y += yskip) {
            int offset = y * owidth;
            int diroffset = rowlen * y;
            double ex = row_x;
            double ey = row_y;
            double ez = row_z;
            double RAY_JITTER = this.random() * Math.min(1.0, minStepSize * 0.75);
            for (int x = x0; x < x1; x += xskip) {
                int pix_position = offset + x;
                output[pix_position] = bgval;
                if (cam.ray_raster[pix_position] == 64) {
                    int pixval;
                    int xx = 3 * x;
                    double vdx = cam.directions[diroffset + xx];
                    double vdy = cam.directions[diroffset + xx + 1];
                    double vdz = cam.directions[diroffset + xx + 2];
                    int ivdx = (int)(65536.0 * vdx);
                    int ivdy = (int)(65536.0 * vdy);
                    int ivdz = (int)(65536.0 * vdz);
                    int t0 = start[pix_position] + 1;
                    int t1 = end[pix_position] - 1;
                    double jitter = RAY_JITTER;
                    double vx = ex + vdx * ((double)t0 + jitter);
                    double vy = ey + vdy * ((double)t0 + jitter);
                    double vz = ez + vdz * ((double)t0 + jitter);
                    color.step_num = dbuffer[pix_position];
                    color.luminance_val = lum_raster[pix_position];
                    color.filled = stencil[pix_position];
                    color.light = 1.0;
                    totalvox += this.rt.traceRay(vx, vy, vz, vdx, vdy, vdz, ivdx, ivdy, ivdz, t0, t1, color);
                    stencil[pix_position] = 1;
                    ++totalrays;
                    double valf = 1.0;
                    if (this.vxColorEnhance) {
                        int cidx = (int)(color.light * 131072.0);
                        valf = ceTable[cidx];
                    }
                    double redf = valf * color.red + bg[0] * color.light;
                    double greenf = valf * color.green + bg[1] * color.light;
                    double bluef = valf * color.blue + bg[2] * color.light;
                    int red = (int)(redf * 255.0);
                    int green = (int)(greenf * 255.0);
                    int blue = (int)(bluef * 255.0);
                    red = red < 255 ? red : 255;
                    green = green < 255 ? green : 255;
                    blue = blue < 255 ? blue : 255;
                    output[pix_position] = pixval = red << 16 | green << 8 | blue;
                    dbuffer[pix_position] = color.light < 0.98 ? (int)color.step_num : 8192;
                    lum_raster[pix_position] = (short)color.luminance_val;
                }
                ex += rayx_x;
                ey += rayx_y;
                ez += rayx_z;
            }
            row_x += rayy_x;
            row_y += rayy_y;
            row_z += rayy_z;
        }
        return totalrays;
    }

    public final int cast_ray_depth(int x0, int y0, double RAY_JITTER, VrCamera cam, VrColor color) {
        int owidth = cam.owidth;
        int[] start = cam.startBuff;
        int[] end = cam.endBuff;
        short[] dbuffer = cam.depth_buffer;
        int[] output = cam.output;
        short[] lum_raster = cam.lum_raster;
        byte[] ray_raster = cam.ray_raster;
        double row_x = cam.ul[0] + (double)x0 * cam.xstep[0] + (double)y0 * cam.ystep[0];
        double row_y = cam.ul[1] + (double)x0 * cam.xstep[1] + (double)y0 * cam.ystep[1];
        double row_z = cam.ul[2] + (double)x0 * cam.xstep[2] + (double)y0 * cam.ystep[2];
        int bgval = cam.getBackground() & 0xFFFFFF;
        double vdx = cam.zstep[0];
        double vdy = cam.zstep[1];
        double vdz = cam.zstep[2];
        int ivdx = (int)(65536.0 * vdx);
        int ivdy = (int)(65536.0 * vdy);
        int ivdz = (int)(65536.0 * vdz);
        int offset = y0 * owidth;
        int pix_position = offset + x0;
        int nsteps = 0;
        if (ray_raster != null && output != null && ray_raster[pix_position] == 64) {
            output[pix_position] = bgval;
            if (cam.isPerspective()) {
                int diridx = owidth * 3 * y0 + 3 * x0;
                vdx = cam.directions[diridx];
                vdy = cam.directions[diridx + 1];
                vdz = cam.directions[diridx + 2];
                ivdx = (int)(65536.0 * vdx);
                ivdy = (int)(65536.0 * vdy);
                ivdz = (int)(65536.0 * vdz);
            }
            int t0 = start[pix_position] + 1;
            int t1 = end[pix_position] - 1;
            double vx = row_x + vdx * ((double)t0 + RAY_JITTER);
            double vy = row_y + vdy * ((double)t0 + RAY_JITTER);
            double vz = row_z + vdz * ((double)t0 + RAY_JITTER);
            color.step_num = dbuffer[pix_position];
            color.luminance_val = lum_raster[pix_position];
            color.filled = 0;
            color.light = 1.0;
            this.rt.setVrSession(cam);
            this.rt.traceRay(vx, vy, vz, vdx, vdy, vdz, ivdx, ivdy, ivdz, t0, t1, color);
            nsteps = color.light < 0.98 ? (int)color.step_num : 8192;
        }
        return nsteps;
    }

    public int cast_ray(int x0, int y0, double RAY_JITTER, VrCamera cam, VrColor color) {
        VrContext ctxt = cam.vr_ctxt;
        double[] bg = cam.getBackgroundf();
        int owidth = cam.owidth;
        int[] start = cam.startBuff;
        int[] end = cam.endBuff;
        byte[] stencil = cam.stencil_raster;
        short[] dbuffer = cam.depth_buffer;
        int[] output = cam.output;
        short[] lum_raster = cam.lum_raster;
        byte[] ray_raster = cam.ray_raster;
        VrPresetCurves pCurves = ctxt.presetCurves;
        double[] ceTable = pCurves != null ? pCurves.colorEnhanceTable : null;
        double row_x = cam.ul[0] + (double)x0 * cam.xstep[0] + (double)y0 * cam.ystep[0];
        double row_y = cam.ul[1] + (double)x0 * cam.xstep[1] + (double)y0 * cam.ystep[1];
        double row_z = cam.ul[2] + (double)x0 * cam.xstep[2] + (double)y0 * cam.ystep[2];
        int bgval = cam.getBackground() & 0xFFFFFF;
        double vdx = cam.zstep[0];
        double vdy = cam.zstep[1];
        double vdz = cam.zstep[2];
        int ivdx = (int)(65536.0 * vdx);
        int ivdy = (int)(65536.0 * vdy);
        int ivdz = (int)(65536.0 * vdz);
        int offset = y0 * owidth;
        int pix_position = offset + x0;
        int pixval = bgval;
        if (ray_raster != null && output != null && ray_raster[pix_position] == 64) {
            output[pix_position] = bgval;
            if (cam.isPerspective()) {
                int diridx = owidth * 3 * y0 + 3 * x0;
                vdx = cam.directions[diridx];
                vdy = cam.directions[diridx + 1];
                vdz = cam.directions[diridx + 2];
                ivdx = (int)(65536.0 * vdx);
                ivdy = (int)(65536.0 * vdy);
                ivdz = (int)(65536.0 * vdz);
            }
            int t0 = start[pix_position] + 1;
            int t1 = end[pix_position] - 1;
            double vx = row_x + vdx * ((double)t0 + RAY_JITTER);
            double vy = row_y + vdy * ((double)t0 + RAY_JITTER);
            double vz = row_z + vdz * ((double)t0 + RAY_JITTER);
            color.step_num = dbuffer[pix_position];
            color.luminance_val = lum_raster[pix_position];
            color.filled = stencil[pix_position];
            color.light = 1.0;
            this.rt.traceRay(vx, vy, vz, vdx, vdy, vdz, ivdx, ivdy, ivdz, t0, t1, color);
            stencil[pix_position] = 1;
            double valf = 1.0;
            if (this.vxColorEnhance && ceTable != null) {
                int cidx = (int)(color.light * 131072.0);
                valf = ceTable[cidx];
            }
            double redf = valf * color.red + bg[0] * color.light;
            double greenf = valf * color.green + bg[1] * color.light;
            double bluef = valf * color.blue + bg[2] * color.light;
            int red = (int)(redf * 255.0);
            int green = (int)(greenf * 255.0);
            int blue = (int)(bluef * 255.0);
            red = red < 255 ? red : 255;
            green = green < 255 ? green : 255;
            blue = blue < 255 ? blue : 255;
            output[pix_position] = pixval = red << 16 | green << 8 | blue;
            dbuffer[pix_position] = color.light < 0.98 ? (int)color.step_num : 8192;
            lum_raster[pix_position] = (short)color.luminance_val;
        }
        return pixval;
    }

    public int render_voxtool(int x0, int y0, int x1, int y1, int xskip, int yskip, VrCamera cam, VrColor color) {
        VrContext ctxt = cam.vr_ctxt;
        JVolume.LinearShort vol = (JVolume.LinearShort)ctxt.vol;
        int VOL_OFFSET = vol.PAD;
        short[] volume = vol.volume;
        byte[] bingrid = ctxt.getBingrid();
        double[] ceTable = ctxt.presetCurves.colorEnhanceTable;
        double[] lightDir = cam.light;
        int owidth = cam.owidth;
        int[] start = cam.startBuff;
        int[] end = cam.endBuff;
        int dx = vol.dx;
        int dy = vol.dy;
        int[] output = cam.output;
        double rayx_x = (double)xskip * cam.xstep[0];
        double rayx_y = (double)xskip * cam.xstep[1];
        double rayx_z = (double)xskip * cam.xstep[2];
        double rayy_x = (double)yskip * cam.ystep[0];
        double rayy_y = (double)yskip * cam.ystep[1];
        double rayy_z = (double)yskip * cam.ystep[2];
        double row_x = cam.ul[0] + (double)x0 * cam.xstep[0] + (double)y0 * cam.ystep[0];
        double row_y = cam.ul[1] + (double)x0 * cam.xstep[1] + (double)y0 * cam.ystep[1];
        double row_z = cam.ul[2] + (double)x0 * cam.xstep[2] + (double)y0 * cam.ystep[2];
        int totalrays = 0;
        int n_interesting = 0;
        int n_contributing = 0;
        int pg_size = dx * dy;
        int SHIFT_Y = vr.LN_2(dy);
        int SHIFT_X = vr.LN_2(dx);
        int SHIFT_PG = SHIFT_Y + SHIFT_X;
        double vdx = cam.zstep[0];
        double vdy = cam.zstep[1];
        double vdz = cam.zstep[2];
        int ivdx = (int)(65536.0 * vdx);
        int ivdy = (int)(65536.0 * vdy);
        int ivdz = (int)(65536.0 * vdz);
        for (int y = y0; y < y1; y += yskip) {
            int offset = y * owidth;
            double ex = row_x;
            double ey = row_y;
            double ez = row_z;
            double RAY_JITTER = this.random();
            for (int x = x0; x < x1; x += xskip) {
                int pix_position = offset + x;
                if (cam.ray_raster[offset + x] == 64) {
                    int pixel;
                    int t0 = start[pix_position] + 1;
                    int t1 = end[pix_position] - 1;
                    ++totalrays;
                    double vx = ex + cam.zstep[0] * ((double)t0 + RAY_JITTER);
                    double vy = ey + cam.zstep[1] * ((double)t0 + RAY_JITTER);
                    double vz = ez + cam.zstep[2] * ((double)t0 + RAY_JITTER);
                    int six = (int)(65536.0 * vx);
                    int siy = (int)(65536.0 * vy);
                    int siz = (int)(65536.0 * vz);
                    double light = 1.0;
                    double vr2 = 0.0;
                    double vg = 0.0;
                    double vb = 0.0;
                    for (int z = t0; z <= t1; ++z) {
                        int iz = siz >> 16;
                        int bz = iz;
                        int iy = siy >> 16;
                        int by = iy;
                        int ix = six >> 16;
                        int bx = ix;
                        int bgrid_offset = (bz << SHIFT_PG) + (by << SHIFT_X) + bx;
                        int bgrid_pos = bgrid_offset >> 3;
                        int bgrid_mod = bgrid_offset & 7;
                        int interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                        if (interesting != 0) {
                            double fx = FRAC[six & 0xFFFF];
                            double fy = FRAC[siy & 0xFFFF];
                            double fz = FRAC[siz & 0xFFFF];
                            double _fx = 1.0 - fx;
                            double _fy = 1.0 - fy;
                            double _fz = 1.0 - fz;
                            ++n_interesting;
                            int iy_0 = iy << SHIFT_X;
                            int iy_down = iy + 1 << SHIFT_X;
                            int iy_downdown = iy + 2 << SHIFT_X;
                            int iy_up = iy - 1 << SHIFT_X;
                            double[] opacity_table = ctxt.presetCurves.opacity_table;
                            int BASE_PG_1 = VOL_OFFSET + (iz << SHIFT_PG);
                            short v7 = volume[BASE_PG_1 + iy_0 + ix];
                            short v8 = volume[BASE_PG_1 + iy_0 + ix + 1];
                            short v11 = volume[BASE_PG_1 + iy_down + ix];
                            short v12 = volume[BASE_PG_1 + iy_down + ix + 1];
                            int BASE_PG_2 = BASE_PG_1 + pg_size;
                            short v19 = volume[BASE_PG_2 + iy_0 + ix];
                            short v20 = volume[BASE_PG_2 + iy_0 + ix + 1];
                            short v23 = volume[BASE_PG_2 + iy_down + ix];
                            short v24 = volume[BASE_PG_2 + iy_down + ix + 1];
                            double val = vr.trilineard(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz, _fx, _fy, _fz);
                            int ival = (int)val;
                            double opacity = opacity_table[ival + 8192];
                            if (opacity > 1.0E-4) {
                                int ifx = (six & 0xFFFF) >> 8;
                                int ify = (siy & 0xFFFF) >> 8;
                                int ifz = (siz & 0xFFFF) >> 8;
                                short v4 = volume[BASE_PG_1 + iy_up + ix];
                                short v5 = volume[BASE_PG_1 + iy_up + ix + 1];
                                short v6 = volume[BASE_PG_1 + iy_0 + ix - 1];
                                short v9 = volume[BASE_PG_1 + iy_0 + ix + 2];
                                short v10 = volume[BASE_PG_1 + iy_down + ix - 1];
                                short v13 = volume[BASE_PG_1 + iy_down + ix + 2];
                                short v14 = volume[BASE_PG_1 + iy_downdown + ix];
                                short v15 = volume[BASE_PG_1 + iy_downdown + ix + 1];
                                short v16 = volume[BASE_PG_2 + iy_up + ix];
                                short v17 = volume[BASE_PG_2 + iy_up + ix + 1];
                                short v18 = volume[BASE_PG_2 + iy_0 + ix - 1];
                                short v21 = volume[BASE_PG_2 + iy_0 + ix + 2];
                                short v22 = volume[BASE_PG_2 + iy_down + ix - 1];
                                short v25 = volume[BASE_PG_2 + iy_down + ix + 2];
                                short v26 = volume[BASE_PG_2 + iy_downdown + ix];
                                short v27 = volume[BASE_PG_2 + iy_downdown + ix + 1];
                                int BASE_PG_0 = VOL_OFFSET + (iz - 1 << SHIFT_PG);
                                short v0 = volume[BASE_PG_0 + iy_0 + ix];
                                short v1 = volume[BASE_PG_0 + iy_0 + ix + 1];
                                short v2 = volume[BASE_PG_0 + iy_down + ix];
                                short v3 = volume[BASE_PG_0 + iy_down + ix + 1];
                                ++n_contributing;
                                int BASE_PG_3 = BASE_PG_2 + pg_size;
                                short v28 = volume[BASE_PG_3 + iy_0 + ix];
                                short v29 = volume[BASE_PG_3 + iy_0 + ix + 1];
                                short v30 = volume[BASE_PG_3 + iy_down + ix];
                                short v31 = volume[BASE_PG_3 + iy_down + ix + 1];
                                double vx0 = vr.trilineardi(v6, v7, v10, v11, v18, v19, v22, v23, ifx, ify, ifz);
                                double vx1 = vr.trilineardi(v8, v9, v12, v13, v20, v21, v24, v25, ifx, ify, ifz);
                                double gr_x = vx1 - vx0;
                                double vy0 = vr.trilineardi(v4, v5, v7, v8, v16, v17, v19, v20, ifx, ify, ifz);
                                double vy1 = vr.trilineardi(v11, v12, v14, v15, v23, v24, v26, v27, ifx, ify, ifz);
                                double gr_y = vy1 - vy0;
                                double vz0 = vr.trilineardi(v0, v1, v2, v3, v7, v8, v11, v12, ifx, ify, ifz);
                                double vz1 = vr.trilineardi(v19, v20, v23, v24, v28, v29, v30, v31, ifx, ify, ifz);
                                double gr_z = vz1 - vz0;
                                double gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                                if (gnrm > 1.0) {
                                    double contrib = opacity * light;
                                    double gcomponent = Math.abs(gr_x * lightDir[0] + gr_y * lightDir[1] + gr_z * lightDir[2]) / Math.sqrt(gnrm);
                                    double lightval = contrib * ((double)0.2f + (double)0.8f * gcomponent);
                                    int rgbidx = 3 * (ival + 8192);
                                    double[] lutrgb = ctxt.presetCurves.lutrgb;
                                    double r = lutrgb[rgbidx];
                                    double g = lutrgb[rgbidx + 1];
                                    double b = lutrgb[rgbidx + 2];
                                    vr2 += r * lightval;
                                    vg += g * lightval;
                                    vb += b * lightval;
                                    light -= contrib;
                                }
                                if (light < (double)0.02f) break;
                            }
                        }
                        six += ivdx;
                        siy += ivdy;
                        siz += ivdz;
                    }
                    int cidx = (int)(light * 131072.0);
                    double valf = this.vxColorEnhance ? ceTable[cidx] : 1.0;
                    double redf = valf * vr2;
                    double greenf = valf * vg;
                    double bluef = valf * vb;
                    int red = (int)(redf * 255.0);
                    int green = (int)(greenf * 255.0);
                    int blue = (int)(bluef * 255.0);
                    red = red < 255 ? red : 255;
                    green = green < 255 ? green : 255;
                    blue = blue < 255 ? blue : 255;
                    output[pix_position] = pixel = 0xFF000000 | red << 16 | green << 8 | blue;
                }
                ex += rayx_x;
                ey += rayx_y;
                ez += rayx_z;
            }
            row_x += rayy_x;
            row_y += rayy_y;
            row_z += rayy_z;
        }
        return totalrays;
    }

    public static int bingrid_query(byte[] bingrid, int x, int y, int z, int SHIFT_PG, int SHIFT_X) {
        int bx = x;
        int by = y;
        int bz = z;
        int bgrid_offset = (bz << SHIFT_PG) + (by << SHIFT_X) + bx;
        int bgrid_pos = bgrid_offset >> 3;
        int bgrid_mod = bgrid_offset & 7;
        int interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
        return interesting;
    }

    private static double trilineard(int v000, int v100, int v010, int v110, int v001, int v101, int v011, int v111, double fx, double fy, double fz, double _fx, double _fy, double _fz) {
        double px1 = (double)v000 * _fx + (double)v100 * fx;
        double px2 = (double)v010 * _fx + (double)v110 * fx;
        double py1 = px1 * _fy + px2 * fy;
        px1 = (double)v001 * _fx + (double)v101 * fx;
        px2 = (double)v011 * _fx + (double)v111 * fx;
        double py2 = px1 * _fy + px2 * fy;
        return py1 * _fz + py2 * fz;
    }

    private static double trilineard(double v000, double v100, double v010, double v110, double v001, double v101, double v011, double v111, double fx, double fy, double fz, double _fx, double _fy, double _fz) {
        double px1 = v000 * _fx + v100 * fx;
        double px2 = v010 * _fx + v110 * fx;
        double py1 = px1 * _fy + px2 * fy;
        px1 = v001 * _fx + v101 * fx;
        px2 = v011 * _fx + v111 * fx;
        double py2 = px1 * _fy + px2 * fy;
        return py1 * _fz + py2 * fz;
    }

    private static float trilinearf(float v000, float v100, float v010, float v110, float v001, float v101, float v011, float v111, float fx, float fy, float fz, float _fx, float _fy, float _fz) {
        float px1 = v000 * _fx + v100 * fx;
        float px2 = v010 * _fx + v110 * fx;
        float py1 = px1 * _fy + px2 * fy;
        px1 = v001 * _fx + v101 * fx;
        px2 = v011 * _fx + v111 * fx;
        float py2 = px1 * _fy + px2 * fy;
        return py1 * _fz + py2 * fz;
    }

    private static double nneighbord(int v000, int v001, double fz, double _fz) {
        return (double)v000 * _fz + (double)v001 * fz;
    }

    private static int LININTD(int x0, int x1, int dx) {
        return (x0 << 8) + dx * (x1 - x0);
    }

    private static int trilineardi(int v000, int v100, int v010, int v110, int v001, int v101, int v011, int v111, int dx, int dy, int dz) {
        int t1 = vr.LININTD(v000, v100, dx);
        int t2 = vr.LININTD(v010, v110, dx);
        int ty1 = vr.LININTD(t1, t2, dy) >> 8;
        int t3 = vr.LININTD(v001, v101, dx);
        int t4 = vr.LININTD(v011, v111, dx);
        int ty2 = vr.LININTD(t3, t4, dy) >> 8;
        return vr.LININTD(ty1, ty2, dz);
    }

    private static int bilineardi(int v00, int v10, int v01, int v11, int dx, int dy) {
        int t1 = vr.LININTD(v00, v10, dx);
        int t2 = vr.LININTD(v01, v11, dx);
        return vr.LININTD(t1, t2, dy);
    }

    private static int LN_2(int val) {
        for (int i = 0; i < 20; ++i) {
            if (val > 1 << i) continue;
            return i;
        }
        return 0;
    }

    private static float fastInvSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToRawIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    public boolean isVxColorEnhance() {
        return this.vxColorEnhance;
    }

    public void setVxColorEnhance(boolean vxColorEnhance) {
        this.vxColorEnhance = vxColorEnhance;
    }

    static {
        double INV_SCALE = 1.52587890625E-5;
        for (int i = 0; i < 65536; ++i) {
            vr.FRAC[i] = (double)i * 1.52587890625E-5;
        }
        double x = 0.0;
        double dx = 3.0517578125E-5;
        int i = 0;
        while (i < 32768) {
            vr.LIGHT_TABLE[i] = Math.sqrt(x);
            ++i;
            x += dx;
        }
    }

    public static class ByteRayLuminanceMINIP
    extends ByteRayLuminance {
        private static final int INIT_VAL = 131072;
        private short[] mingrid = null;
        private byte[] seggrid = null;

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            short[] mingrid = this.mingrid;
            byte[] seggrid = this.seggrid;
            byte[] volume = this.volume;
            int mdx = this.dx >> 2;
            int mdy = this.dy >> 2;
            int mpgsize = mdx * mdy;
            int totalvoxels = 0;
            int final_val = 131072;
            if (color.filled != 0) {
                final_val = color.luminance_val;
            } else {
                int stepsize;
                int six = (int)(65536.0 * fromX);
                int siy = (int)(65536.0 * fromY);
                int siz = (int)(65536.0 * fromZ);
                color.step_num = (short)8192;
                for (int z = t0; z <= t1; z += stepsize) {
                    int ix = six >> 16;
                    int iy = siy >> 16;
                    int iz = siz >> 16;
                    stepsize = 1;
                    int mz = iz >> 2;
                    int my = iy >> 2;
                    int mx = ix >> 2;
                    int mgrid_pos = mz * mpgsize + my * mdx + mx;
                    short minval = mingrid[mgrid_pos];
                    if (final_val <= minval) {
                        stepsize = 2;
                        totalvoxels += 2;
                    } else {
                        int fz;
                        int fy;
                        int fx;
                        int v7;
                        int v6;
                        int v5;
                        int BASE_PG_1;
                        int v4;
                        int v3;
                        int iy_1;
                        int v2;
                        int v1;
                        int iy_0;
                        int BASE_PG_0;
                        int v0;
                        int val;
                        int ival;
                        int bz = iz;
                        int by = iy;
                        int bx = ix;
                        int bgrid_offset = bz * this.pg_size + by * this.dx + bx;
                        int bgrid_pos = bgrid_offset >> 3;
                        int bgrid_mod = bgrid_offset & 7;
                        int interesting = seggrid[bgrid_pos] & 1 << bgrid_mod;
                        if (interesting != 0 && (ival = (val = vr.trilineardi(v0 = volume[(BASE_PG_0 = this.VOL_OFFSET + iz * this.pg_size) + (iy_0 = iy * this.dx) + ix] & 0xFF, v1 = volume[BASE_PG_0 + iy_0 + ix + 1] & 0xFF, v2 = volume[BASE_PG_0 + (iy_1 = (iy + 1) * this.dx) + ix] & 0xFF, v3 = volume[BASE_PG_0 + iy_1 + ix + 1] & 0xFF, v4 = volume[(BASE_PG_1 = BASE_PG_0 + this.pg_size) + iy_0 + ix] & 0xFF, v5 = volume[BASE_PG_1 + iy_0 + ix + 1] & 0xFF, v6 = volume[BASE_PG_1 + iy_1 + ix] & 0xFF, v7 = volume[BASE_PG_1 + iy_1 + ix + 1] & 0xFF, fx = (six & 0xFFFF) >> 8, fy = (siy & 0xFFFF) >> 8, fz = (siz & 0xFFFF) >> 8)) >> 16) < final_val) {
                            final_val = ival;
                            color.step_num = (short)z;
                        }
                    }
                    six += stepsize * irayX;
                    siy += stepsize * irayY;
                    siz += stepsize * irayZ;
                }
            }
            color.blue = 0.0;
            color.green = 0.0;
            color.red = 0.0;
            if (final_val == 131072) {
                final_val = 0;
            }
            int rgb = this.wlTable[final_val & 0xFFFF];
            int ired = (rgb & 0xFF0000) >> 16;
            int igreen = (rgb & 0xFF00) >> 8;
            int iblue = rgb & 0xFF;
            color.red = (double)ired * 0.00392156862745098;
            color.green = (double)igreen * 0.00392156862745098;
            color.blue = (double)iblue * 0.00392156862745098;
            color.luminance_val = final_val;
            color.light = 0.0;
            return totalvoxels;
        }

        @Override
        public void setVrSession(VrCamera cam) {
            super.setVrSession(cam);
            if (cam == null) {
                this.mingrid = null;
                this.seggrid = null;
            } else {
                this.seggrid = this.ctxt.getSegBingrid();
                this.mingrid = this.ctxt.getMingrid();
            }
        }
    }

    public static class ByteRayLuminanceMIP
    extends ByteRayLuminance {
        private byte[] seggrid = null;
        private short[] maxgrid = null;

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            short[] maxgrid = this.maxgrid;
            byte[] seggrid = this.seggrid;
            byte[] volume = this.volume;
            int mdx = this.dx >> 2;
            int mdy = this.dy >> 2;
            int mpgsize = mdx * mdy;
            int totalvoxels = 0;
            int final_val = this.air;
            if (color.filled != 0) {
                final_val = color.luminance_val;
            } else {
                int stepsize;
                int six = (int)(65536.0 * fromX);
                int siy = (int)(65536.0 * fromY);
                int siz = (int)(65536.0 * fromZ);
                color.step_num = (short)8192;
                for (int z = t0; z <= t1; z += stepsize) {
                    int ix = six >> 16;
                    int iy = siy >> 16;
                    int iz = siz >> 16;
                    stepsize = 1;
                    int mz = iz >> 2;
                    int my = iy >> 2;
                    int mx = ix >> 2;
                    int mgrid_pos = mz * mpgsize + my * mdx + mx;
                    short maxval = maxgrid[mgrid_pos];
                    if (final_val >= maxval) {
                        stepsize = 2;
                        totalvoxels += 2;
                    } else {
                        int fz;
                        int fy;
                        int fx;
                        int v7;
                        int v6;
                        int v5;
                        int BASE_PG_1;
                        int v4;
                        int v3;
                        int iy_1;
                        int v2;
                        int v1;
                        int iy_0;
                        int BASE_PG_0;
                        int v0;
                        int val;
                        int ival;
                        int bz = iz;
                        int by = iy;
                        int bx = ix;
                        int bgrid_offset = bz * this.pg_size + by * this.dx + bx;
                        int bgrid_pos = bgrid_offset >> 3;
                        int bgrid_mod = bgrid_offset & 7;
                        int interesting = seggrid[bgrid_pos] & 1 << bgrid_mod;
                        if (interesting != 0 && (ival = (val = vr.trilineardi(v0 = volume[(BASE_PG_0 = this.VOL_OFFSET + iz * this.pg_size) + (iy_0 = iy * this.dx) + ix] & 0xFF, v1 = volume[BASE_PG_0 + iy_0 + ix + 1] & 0xFF, v2 = volume[BASE_PG_0 + (iy_1 = (iy + 1) * this.dx) + ix] & 0xFF, v3 = volume[BASE_PG_0 + iy_1 + ix + 1] & 0xFF, v4 = volume[(BASE_PG_1 = BASE_PG_0 + this.pg_size) + iy_0 + ix] & 0xFF, v5 = volume[BASE_PG_1 + iy_0 + ix + 1] & 0xFF, v6 = volume[BASE_PG_1 + iy_1 + ix] & 0xFF, v7 = volume[BASE_PG_1 + iy_1 + ix + 1] & 0xFF, fx = (six & 0xFFFF) >> 8, fy = (siy & 0xFFFF) >> 8, fz = (siz & 0xFFFF) >> 8)) >> 16) > final_val) {
                            final_val = ival;
                            color.step_num = (short)z;
                        }
                    }
                    six += stepsize * irayX;
                    siy += stepsize * irayY;
                    siz += stepsize * irayZ;
                }
            }
            color.blue = 0.0;
            color.green = 0.0;
            color.red = 0.0;
            color.luminance_val = -2000;
            int rgb = this.wlTable[final_val & 0xFFFF];
            int ired = (rgb & 0xFF0000) >> 16;
            int igreen = (rgb & 0xFF00) >> 8;
            int iblue = rgb & 0xFF;
            color.red = (double)ired * 0.00392156862745098;
            color.green = (double)igreen * 0.00392156862745098;
            color.blue = (double)iblue * 0.00392156862745098;
            color.luminance_val = final_val;
            color.light = 0.0;
            return totalvoxels;
        }

        @Override
        public void setVrSession(VrCamera cam) {
            super.setVrSession(cam);
            if (cam == null) {
                this.maxgrid = null;
                this.seggrid = null;
            } else {
                this.seggrid = this.ctxt.getSegBingrid();
                this.maxgrid = this.ctxt.getMaxgrid();
            }
        }
    }

    public static class RayLuminanceMINIP
    extends RayLuminance {
        private static final int INIT_VAL = 131072;
        private short[] mingrid = null;
        private byte[] seggrid = null;

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            short[] mingrid = this.mingrid;
            byte[] seggrid = this.seggrid;
            short[] volume = this.volume;
            int mdx = this.dx >> 2;
            int mdy = this.dy >> 2;
            int mpgsize = mdx * mdy;
            int totalvoxels = 0;
            int final_val = 131072;
            if (color.filled != 0) {
                final_val = color.luminance_val;
            } else {
                int stepsize;
                int six = (int)(65536.0 * fromX);
                int siy = (int)(65536.0 * fromY);
                int siz = (int)(65536.0 * fromZ);
                color.step_num = (short)8192;
                for (int z = t0; z <= t1; z += stepsize) {
                    int ix = six >> 16;
                    int iy = siy >> 16;
                    int iz = siz >> 16;
                    stepsize = 1;
                    int mz = iz >> 2;
                    int my = iy >> 2;
                    int mx = ix >> 2;
                    int mgrid_pos = mz * mpgsize + my * mdx + mx;
                    short minval = mingrid[mgrid_pos];
                    if (final_val <= minval) {
                        stepsize = 2;
                        totalvoxels += 2;
                    } else {
                        int fz;
                        int fy;
                        int fx;
                        short v7;
                        short v6;
                        short v5;
                        int BASE_PG_1;
                        short v4;
                        short v3;
                        int iy_1;
                        short v2;
                        short v1;
                        int iy_0;
                        int BASE_PG_0;
                        short v0;
                        int val;
                        int ival;
                        int bz = iz;
                        int by = iy;
                        int bx = ix;
                        int bgrid_offset = bz * this.pg_size + by * this.dx + bx;
                        int bgrid_pos = bgrid_offset >> 3;
                        int bgrid_mod = bgrid_offset & 7;
                        int interesting = seggrid[bgrid_pos] & 1 << bgrid_mod;
                        if (interesting != 0 && (ival = (val = vr.trilineardi(v0 = volume[(BASE_PG_0 = this.VOL_OFFSET + iz * this.pg_size) + (iy_0 = iy * this.dx) + ix], v1 = volume[BASE_PG_0 + iy_0 + ix + 1], v2 = volume[BASE_PG_0 + (iy_1 = (iy + 1) * this.dx) + ix], v3 = volume[BASE_PG_0 + iy_1 + ix + 1], v4 = volume[(BASE_PG_1 = BASE_PG_0 + this.pg_size) + iy_0 + ix], v5 = volume[BASE_PG_1 + iy_0 + ix + 1], v6 = volume[BASE_PG_1 + iy_1 + ix], v7 = volume[BASE_PG_1 + iy_1 + ix + 1], fx = (six & 0xFFFF) >> 8, fy = (siy & 0xFFFF) >> 8, fz = (siz & 0xFFFF) >> 8)) >> 16) < final_val) {
                            final_val = ival;
                            color.step_num = (short)z;
                        }
                    }
                    six += stepsize * irayX;
                    siy += stepsize * irayY;
                    siz += stepsize * irayZ;
                }
            }
            color.blue = 0.0;
            color.green = 0.0;
            color.red = 0.0;
            if (final_val == 131072) {
                final_val = 0;
            }
            int rgb = this.wlTable[final_val & 0xFFFF];
            int ired = (rgb & 0xFF0000) >> 16;
            int igreen = (rgb & 0xFF00) >> 8;
            int iblue = rgb & 0xFF;
            color.red = (double)ired * 0.00392156862745098;
            color.green = (double)igreen * 0.00392156862745098;
            color.blue = (double)iblue * 0.00392156862745098;
            color.luminance_val = final_val;
            color.light = 0.0;
            return totalvoxels;
        }

        @Override
        public void setVrSession(VrCamera cam) {
            super.setVrSession(cam);
            if (cam == null) {
                this.mingrid = null;
                this.seggrid = null;
            } else {
                this.seggrid = this.ctxt.getSegBingrid();
                this.mingrid = this.ctxt.getMingrid();
            }
        }
    }

    public static class RayLuminanceMIP
    extends RayLuminance {
        private short[] maxgrid = null;
        private byte[] seggrid = null;

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            short[] maxgrid = this.maxgrid;
            byte[] seggrid = this.seggrid;
            short[] volume = this.volume;
            int mdx = this.dx >> 2;
            int mdy = this.dy >> 2;
            int mpgsize = mdx * mdy;
            int totalvoxels = 0;
            int final_val = this.air;
            boolean stepsize = true;
            int stepXInc = 1 * irayX;
            int stepYInc = 1 * irayY;
            int stepZInc = 1 * irayZ;
            if (color.filled != 0) {
                final_val = color.luminance_val;
            } else {
                int six = (int)(65536.0 * fromX);
                int siy = (int)(65536.0 * fromY);
                int siz = (int)(65536.0 * fromZ);
                color.step_num = (short)8192;
                int skip_mx = -99;
                int skip_my = -99;
                int skip_mz = -99;
                for (int z = t0; z <= t1; ++z) {
                    int ix = six >> 16;
                    int iy = siy >> 16;
                    int iz = siz >> 16;
                    int mx = ix >> 2;
                    int my = iy >> 2;
                    int mz = iz >> 2;
                    if (mx != skip_mx || my != skip_my || mz != skip_mz) {
                        int mgrid_pos = mz * mpgsize + my * mdx + mx;
                        short maxval = maxgrid[mgrid_pos];
                        skip_mx = -99;
                        skip_my = -99;
                        skip_mz = -99;
                        if (final_val >= maxval) {
                            skip_mx = mx;
                            skip_my = my;
                            skip_mz = mz;
                        } else {
                            int BASE_PG_0 = this.VOL_OFFSET + iz * this.pg_size;
                            int iy_0 = iy * this.dx;
                            int BASE_PG_0_PLUS_IY_0_IX = BASE_PG_0 + iy_0 + ix;
                            short v0 = volume[BASE_PG_0_PLUS_IY_0_IX];
                            short v1 = volume[BASE_PG_0_PLUS_IY_0_IX + 1];
                            int iy_1 = (iy + 1) * this.dx;
                            int BASE_PG_0_PLUS_IY_1_IX = BASE_PG_0 + iy_1 + ix;
                            short v2 = volume[BASE_PG_0_PLUS_IY_1_IX];
                            short v3 = volume[BASE_PG_0_PLUS_IY_1_IX + 1];
                            int BASE_PG_1 = BASE_PG_0 + this.pg_size;
                            int BASE_PG_1_PLUS_IY_0_IX = BASE_PG_1 + iy_0 + ix;
                            short v4 = volume[BASE_PG_1_PLUS_IY_0_IX];
                            short v5 = volume[BASE_PG_1_PLUS_IY_0_IX + 1];
                            int BASE_PG_1_PLUS_IY_1_IX = BASE_PG_1 + iy_1 + ix;
                            short v6 = volume[BASE_PG_1_PLUS_IY_1_IX];
                            short v7 = volume[BASE_PG_1_PLUS_IY_1_IX + 1];
                            int fx = (six & 0xFFFF) >> 8;
                            int fy = (siy & 0xFFFF) >> 8;
                            int fz = (siz & 0xFFFF) >> 8;
                            int val = vr.trilineardi(v0, v1, v2, v3, v4, v5, v6, v7, fx, fy, fz);
                            int ival = val >> 16;
                            if (ival > final_val) {
                                final_val = ival;
                                color.step_num = (short)z;
                            }
                        }
                    }
                    six += stepXInc;
                    siy += stepYInc;
                    siz += stepZInc;
                }
            }
            color.blue = 0.0;
            color.green = 0.0;
            color.red = 0.0;
            color.luminance_val = -2000;
            int rgb = this.wlTable[final_val & 0xFFFF];
            int ired = (rgb & 0xFF0000) >> 16;
            int igreen = (rgb & 0xFF00) >> 8;
            int iblue = rgb & 0xFF;
            color.red = (double)ired * 0.00392156862745098;
            color.green = (double)igreen * 0.00392156862745098;
            color.blue = (double)iblue * 0.00392156862745098;
            color.luminance_val = final_val;
            color.light = 0.0;
            return totalvoxels;
        }

        @Override
        public void setVrSession(VrCamera cam) {
            super.setVrSession(cam);
            if (cam == null) {
                this.seggrid = null;
                this.maxgrid = null;
            } else {
                this.seggrid = this.ctxt.getSegBingrid();
                this.maxgrid = this.ctxt.getMaxgrid();
            }
        }
    }

    public static class RayLuminanceMIP_raw
    extends RayLuminance {
        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            short[] volume = this.volume;
            int totalvoxels = 0;
            int final_val = this.air;
            if (color.filled != 0) {
                final_val = color.luminance_val;
            } else {
                int six = (int)(65536.0 * fromX);
                int siy = (int)(65536.0 * fromY);
                int siz = (int)(65536.0 * fromZ);
                color.step_num = (short)8192;
                for (int z = t0; z <= t1; ++z) {
                    int iz = siz >> 16;
                    int BASE_PG_0 = this.VOL_OFFSET + iz * this.pg_size;
                    int iy = siy >> 16;
                    int iy_0 = iy * this.dx;
                    int ix = six >> 16;
                    short v0 = volume[BASE_PG_0 + iy_0 + ix];
                    short v1 = volume[BASE_PG_0 + iy_0 + ix + 1];
                    int iy_1 = (iy + 1) * this.dx;
                    short v2 = volume[BASE_PG_0 + iy_1 + ix];
                    short v3 = volume[BASE_PG_0 + iy_1 + ix + 1];
                    int BASE_PG_1 = BASE_PG_0 + this.pg_size;
                    short v4 = volume[BASE_PG_1 + iy_0 + ix];
                    short v5 = volume[BASE_PG_1 + iy_0 + ix + 1];
                    short v6 = volume[BASE_PG_1 + iy_1 + ix];
                    short v7 = volume[BASE_PG_1 + iy_1 + ix + 1];
                    int fx = (six & 0xFFFF) >> 8;
                    int fy = (siy & 0xFFFF) >> 8;
                    int fz = (siz & 0xFFFF) >> 8;
                    int val = vr.trilineardi(v0, v1, v2, v3, v4, v5, v6, v7, fx, fy, fz);
                    int ival = val >> 16;
                    if (ival > final_val) {
                        final_val = ival;
                        color.step_num = (short)z;
                    }
                    six += irayX;
                    siy += irayY;
                    siz += irayZ;
                }
            }
            color.blue = 0.0;
            color.green = 0.0;
            color.red = 0.0;
            color.luminance_val = -2000;
            int rgb = this.wlTable[final_val & 0xFFFF];
            int ired = (rgb & 0xFF0000) >> 16;
            int igreen = (rgb & 0xFF00) >> 8;
            int iblue = rgb & 0xFF;
            color.red = (double)ired * 0.00392156862745098;
            color.green = (double)igreen * 0.00392156862745098;
            color.blue = (double)iblue * 0.00392156862745098;
            color.luminance_val = final_val;
            color.light = 0.0;
            return totalvoxels;
        }
    }

    public static abstract class ByteRayLuminance
    implements RayTracer {
        protected static final double INV255 = 0.00392156862745098;
        protected VrCamera cam = null;
        protected VrContext ctxt = null;
        protected JVolume.LinearByte vol = null;
        protected byte[] volume = null;
        protected int VOL_OFFSET = 0;
        protected int[] wlTable = null;
        protected int dx = 0;
        protected int dy = 0;
        protected int dz = 0;
        protected int pg_size = 0;
        protected int MSHIFT_Y = 0;
        protected int MSHIFT_X = 0;
        protected int MSHIFT_PG = 0;
        protected int air = 0;
        protected static final float HALF_VOXEL = 0.5f;

        @Override
        public void setVrSession(VrCamera cam) {
            if (cam == null) {
                this.volume = null;
                this.cam = null;
                this.ctxt = null;
                this.wlTable = null;
                return;
            }
            this.cam = cam;
            this.ctxt = cam.vr_ctxt;
            this.air = cam.getAirValue();
            JVolume.LinearByte vol = (JVolume.LinearByte)this.ctxt.vol;
            this.VOL_OFFSET = vol.PAD;
            this.volume = vol.volume;
            this.wlTable = this.ctxt.wlTable;
            this.dx = vol.dx;
            this.dy = vol.dy;
            this.dz = vol.dz;
            this.pg_size = this.dx * this.dy;
        }
    }

    public static abstract class RayLuminance
    implements RayTracer {
        protected static final double INV255 = 0.00392156862745098;
        protected VrCamera cam = null;
        protected VrContext ctxt = null;
        protected JVolume.LinearShort vol = null;
        protected short[] volume = null;
        protected int VOL_OFFSET = 0;
        protected int[] wlTable = null;
        protected int dx = 0;
        protected int dy = 0;
        protected int dz = 0;
        protected int pg_size = 0;
        protected int MSHIFT_Y = 0;
        protected int MSHIFT_X = 0;
        protected int MSHIFT_PG = 0;
        protected int air = 0;
        protected static final float HALF_VOXEL = 0.5f;

        @Override
        public void setVrSession(VrCamera cam) {
            if (cam == null) {
                this.volume = null;
                this.cam = null;
                this.ctxt = null;
                this.wlTable = null;
                return;
            }
            this.cam = cam;
            this.ctxt = cam.vr_ctxt;
            this.air = cam.getAirValue();
            JVolume.LinearShort vol = (JVolume.LinearShort)this.ctxt.vol;
            this.VOL_OFFSET = vol.PAD;
            this.volume = vol.volume;
            this.wlTable = this.ctxt.wlTable;
            this.dx = vol.dx;
            this.dy = vol.dy;
            this.dz = vol.dz;
            this.pg_size = this.dx * this.dy;
        }
    }

    public static class ByteColorLut_NonPower2_i
    implements RayTracer {
        protected VrCamera cam = null;
        protected VrContext ctxt = null;
        protected JVolume.LinearByte vol = null;
        protected byte[] volume = null;
        protected int VOL_OFFSET = 0;
        protected byte[] bingrid = null;
        protected double[] lightDir = null;
        protected int dx = 0;
        protected int dy = 0;
        protected int dz = 0;
        protected int pg_size = 0;
        protected double[] rgblut = new double[768];
        protected static final float HALF_VOXEL = 0.5f;

        @Override
        public void setVrSession(VrCamera cam) {
            if (cam == null) {
                this.cam = null;
                this.ctxt = null;
                this.vol = null;
                this.volume = null;
                this.bingrid = null;
                return;
            }
            this.cam = cam;
            this.ctxt = cam.vr_ctxt;
            boolean init = false;
            if (this.vol != this.ctxt.vol) {
                init = true;
            }
            this.vol = (JVolume.LinearByte)this.ctxt.vol;
            this.VOL_OFFSET = this.vol.PAD;
            this.volume = this.vol.volume;
            this.bingrid = this.ctxt.getBingrid();
            this.lightDir = cam.light;
            this.dx = this.vol.dx;
            this.dy = this.vol.dy;
            this.dz = this.vol.dz;
            this.pg_size = this.dx * this.dy;
            if (init) {
                int[] cmap = this.vol.cmap;
                for (int i = 0; i < cmap.length; ++i) {
                    int r = (cmap[i] & 0xFF0000) >> 16 & 0xFF;
                    int g = (cmap[i] & 0xFF00) >> 8 & 0xFF;
                    int b = cmap[i] & 0xFF & 0xFF;
                    this.rgblut[i * 3] = (double)r / 255.0;
                    this.rgblut[i * 3 + 1] = (double)g / 255.0;
                    this.rgblut[i * 3 + 2] = (double)b / 255.0;
                }
            }
        }

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            byte[] bingrid = this.bingrid;
            byte[] volume = this.volume;
            boolean first = true;
            int totalvoxels = 0;
            int six = (int)(65536.0 * (fromX - 0.5));
            int siy = (int)(65536.0 * (fromY - 0.5));
            int siz = (int)(65536.0 * (fromZ - 0.5));
            double contrib_max1 = 0.0;
            double light = color.light;
            double vr2 = 0.0;
            double vg = 0.0;
            double vb = 0.0;
            color.step_num = (short)8192;
            for (int z = t0; z <= t1; ++z) {
                int iz = siz >> 16;
                int bz = iz;
                int iy = siy >> 16;
                int by = iy;
                int ix = six >> 16;
                int bx = ix;
                int bgrid_offset = bz * this.pg_size + by * this.dx + bx;
                int bgrid_pos = bgrid_offset >> 3;
                int bgrid_mod = bgrid_offset & 7;
                int interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                if (interesting != 0) {
                    ++totalvoxels;
                    int fx = (six & 0xFFFF) >> 8;
                    int fy = (siy & 0xFFFF) >> 8;
                    int fz = (siz & 0xFFFF) >> 8;
                    if (first) {
                        color.step_num = (short)z;
                        first = false;
                    }
                    int iy_0 = iy * this.dx;
                    int iy_down = (iy + 1) * this.dx;
                    int iy_downdown = (iy + 2) * this.dx;
                    int iy_up = (iy - 1) * this.dx;
                    double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                    int BASE_PG_1 = this.VOL_OFFSET + iz * this.pg_size;
                    int v7 = volume[BASE_PG_1 + iy_0 + ix] & 0xFF;
                    int v8 = volume[BASE_PG_1 + iy_0 + ix + 1] & 0xFF;
                    int v11 = volume[BASE_PG_1 + iy_down + ix] & 0xFF;
                    int v12 = volume[BASE_PG_1 + iy_down + ix + 1] & 0xFF;
                    int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                    int v19 = volume[BASE_PG_2 + iy_0 + ix] & 0xFF;
                    int v20 = volume[BASE_PG_2 + iy_0 + ix + 1] & 0xFF;
                    int v23 = volume[BASE_PG_2 + iy_down + ix] & 0xFF;
                    int v24 = volume[BASE_PG_2 + iy_down + ix + 1] & 0xFF;
                    int val = vr.trilineardi(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz);
                    int ival = val >> 16;
                    double opacity = opacity_table[ival + 8192];
                    if (opacity > 1.0E-4) {
                        int v4 = volume[BASE_PG_1 + iy_up + ix] & 0xFF;
                        int v5 = volume[BASE_PG_1 + iy_up + ix + 1] & 0xFF;
                        int v6 = volume[BASE_PG_1 + iy_0 + ix - 1] & 0xFF;
                        int v9 = volume[BASE_PG_1 + iy_0 + ix + 2] & 0xFF;
                        int v10 = volume[BASE_PG_1 + iy_down + ix - 1] & 0xFF;
                        int v13 = volume[BASE_PG_1 + iy_down + ix + 2] & 0xFF;
                        int v14 = volume[BASE_PG_1 + iy_downdown + ix] & 0xFF;
                        int v15 = volume[BASE_PG_1 + iy_downdown + ix + 1] & 0xFF;
                        int v16 = volume[BASE_PG_2 + iy_up + ix] & 0xFF;
                        int v17 = volume[BASE_PG_2 + iy_up + ix + 1] & 0xFF;
                        int v18 = volume[BASE_PG_2 + iy_0 + ix - 1] & 0xFF;
                        int v21 = volume[BASE_PG_2 + iy_0 + ix + 2] & 0xFF;
                        int v22 = volume[BASE_PG_2 + iy_down + ix - 1] & 0xFF;
                        int v25 = volume[BASE_PG_2 + iy_down + ix + 2] & 0xFF;
                        int v26 = volume[BASE_PG_2 + iy_downdown + ix] & 0xFF;
                        int v27 = volume[BASE_PG_2 + iy_downdown + ix + 1] & 0xFF;
                        int BASE_PG_0 = this.VOL_OFFSET + (iz - 1) * this.pg_size;
                        int v0 = volume[BASE_PG_0 + iy_0 + ix] & 0xFF;
                        int v1 = volume[BASE_PG_0 + iy_0 + ix + 1] & 0xFF;
                        int v2 = volume[BASE_PG_0 + iy_down + ix] & 0xFF;
                        int v3 = volume[BASE_PG_0 + iy_down + ix + 1] & 0xFF;
                        int BASE_PG_3 = BASE_PG_2 + this.pg_size;
                        int v28 = volume[BASE_PG_3 + iy_0 + ix] & 0xFF;
                        int v29 = volume[BASE_PG_3 + iy_0 + ix + 1] & 0xFF;
                        int v30 = volume[BASE_PG_3 + iy_down + ix] & 0xFF;
                        int v31 = volume[BASE_PG_3 + iy_down + ix + 1] & 0xFF;
                        int vx0 = vr.trilineardi(v6, v7, v10, v11, v18, v19, v22, v23, fx, fy, fz);
                        int vx1 = vr.trilineardi(v8, v9, v12, v13, v20, v21, v24, v25, fx, fy, fz);
                        int gr_x = vx1 - vx0 >> 16;
                        int vy0 = vr.trilineardi(v4, v5, v7, v8, v16, v17, v19, v20, fx, fy, fz);
                        int vy1 = vr.trilineardi(v11, v12, v14, v15, v23, v24, v26, v27, fx, fy, fz);
                        int gr_y = vy1 - vy0 >> 16;
                        int vz0 = vr.trilineardi(v0, v1, v2, v3, v7, v8, v11, v12, fx, fy, fz);
                        int vz1 = vr.trilineardi(v19, v20, v23, v24, v28, v29, v30, v31, fx, fy, fz);
                        int gr_z = vz1 - vz0 >> 16;
                        int gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                        if (gnrm > 1) {
                            double contrib = opacity * light;
                            double DOT = (double)gr_x * this.lightDir[0] + (double)gr_y * this.lightDir[1] + (double)gr_z * this.lightDir[2];
                            double gcomponent = Math.abs(DOT) * (double)vr.fastInvSqrt(gnrm);
                            double lightval = contrib * ((double)0.2f + (double)0.8f * gcomponent);
                            double r = this.rgblut[ival * 3];
                            double g = this.rgblut[ival * 3 + 1];
                            double b = this.rgblut[ival * 3 + 2];
                            vr2 += r * lightval;
                            vg += g * lightval;
                            vb += b * lightval;
                            light -= contrib;
                            if (contrib > contrib_max1) {
                                contrib_max1 = contrib;
                                color.step_num = (short)z;
                            }
                            if (light < (double)0.02f) break;
                        }
                    }
                }
                six += irayX;
                siy += irayY;
                siz += irayZ;
            }
            color.red = vr2;
            color.green = vg;
            color.blue = vb;
            color.light = light;
            return totalvoxels;
        }
    }

    public static class ByteRaySplitColorLut_NonPower2_i
    implements RayTracer {
        protected VrCamera cam = null;
        protected VrContext ctxt = null;
        protected JVolume.LinearByte vol = null;
        protected byte[] volume = null;
        protected int VOL_OFFSET = 0;
        protected byte[] bingrid = null;
        protected double[] lightDir = null;
        protected int dx = 0;
        protected int dy = 0;
        protected int dz = 0;
        protected int pg_size = 0;
        protected double[] rgblut = new double[768];
        protected static final float HALF_VOXEL = 0.5f;

        @Override
        public void setVrSession(VrCamera cam) {
            if (cam == null) {
                this.cam = null;
                this.ctxt = null;
                this.vol = null;
                this.volume = null;
                this.bingrid = null;
                return;
            }
            this.cam = cam;
            this.ctxt = cam.vr_ctxt;
            this.vol = (JVolume.LinearByte)this.ctxt.vol;
            this.VOL_OFFSET = this.vol.PAD;
            this.volume = this.vol.volume;
            this.bingrid = this.ctxt.getBingrid();
            this.lightDir = cam.light;
            this.dx = this.vol.dx;
            this.dy = this.vol.dy;
            this.dz = this.vol.dz;
            this.pg_size = this.dx * this.dy;
        }

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            byte[] bingrid = this.bingrid;
            byte[] volume = this.volume;
            if (bingrid == null || volume == null) {
                return 0;
            }
            boolean first = true;
            int totalvoxels = 0;
            int six = (int)(65536.0 * (fromX - 0.5));
            int siy = (int)(65536.0 * (fromY - 0.5));
            int siz = (int)(65536.0 * (fromZ - 0.5));
            double contrib_max1 = 0.0;
            double light = color.light;
            double vr2 = 0.0;
            double vg = 0.0;
            double vb = 0.0;
            color.step_num = (short)8192;
            for (int z = t0; z <= t1; ++z) {
                int iz = siz >> 16;
                int bz = iz;
                int iy = siy >> 16;
                int by = iy;
                int ix = six >> 16;
                int bx = ix;
                int bgrid_offset = bz * this.pg_size + by * this.dx + bx;
                int bgrid_pos = bgrid_offset >> 3;
                int bgrid_mod = bgrid_offset & 7;
                int interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                if (interesting != 0) {
                    ++totalvoxels;
                    int fx = (six & 0xFFFF) >> 8;
                    int fy = (siy & 0xFFFF) >> 8;
                    int fz = (siz & 0xFFFF) >> 8;
                    if (first) {
                        color.step_num = (short)z;
                        first = false;
                    }
                    int iy_0 = iy * this.dx;
                    int iy_down = (iy + 1) * this.dx;
                    int iy_downdown = (iy + 2) * this.dx;
                    int iy_up = (iy - 1) * this.dx;
                    double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                    int BASE_PG_1 = this.VOL_OFFSET + iz * this.pg_size;
                    int v7 = volume[BASE_PG_1 + iy_0 + ix] & 0xFF;
                    int v8 = volume[BASE_PG_1 + iy_0 + ix + 1] & 0xFF;
                    int v11 = volume[BASE_PG_1 + iy_down + ix] & 0xFF;
                    int v12 = volume[BASE_PG_1 + iy_down + ix + 1] & 0xFF;
                    int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                    int v19 = volume[BASE_PG_2 + iy_0 + ix] & 0xFF;
                    int v20 = volume[BASE_PG_2 + iy_0 + ix + 1] & 0xFF;
                    int v23 = volume[BASE_PG_2 + iy_down + ix] & 0xFF;
                    int v24 = volume[BASE_PG_2 + iy_down + ix + 1] & 0xFF;
                    int val = vr.trilineardi(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz);
                    int ival = val >> 16;
                    double opacity = opacity_table[ival + 8192];
                    if (opacity > 1.0E-4) {
                        int v4 = volume[BASE_PG_1 + iy_up + ix] & 0xFF;
                        int v5 = volume[BASE_PG_1 + iy_up + ix + 1] & 0xFF;
                        int v6 = volume[BASE_PG_1 + iy_0 + ix - 1] & 0xFF;
                        int v9 = volume[BASE_PG_1 + iy_0 + ix + 2] & 0xFF;
                        int v10 = volume[BASE_PG_1 + iy_down + ix - 1] & 0xFF;
                        int v13 = volume[BASE_PG_1 + iy_down + ix + 2] & 0xFF;
                        int v14 = volume[BASE_PG_1 + iy_downdown + ix] & 0xFF;
                        int v15 = volume[BASE_PG_1 + iy_downdown + ix + 1] & 0xFF;
                        int v16 = volume[BASE_PG_2 + iy_up + ix] & 0xFF;
                        int v17 = volume[BASE_PG_2 + iy_up + ix + 1] & 0xFF;
                        int v18 = volume[BASE_PG_2 + iy_0 + ix - 1] & 0xFF;
                        int v21 = volume[BASE_PG_2 + iy_0 + ix + 2] & 0xFF;
                        int v22 = volume[BASE_PG_2 + iy_down + ix - 1] & 0xFF;
                        int v25 = volume[BASE_PG_2 + iy_down + ix + 2] & 0xFF;
                        int v26 = volume[BASE_PG_2 + iy_downdown + ix] & 0xFF;
                        int v27 = volume[BASE_PG_2 + iy_downdown + ix + 1] & 0xFF;
                        int BASE_PG_0 = this.VOL_OFFSET + (iz - 1) * this.pg_size;
                        int v0 = volume[BASE_PG_0 + iy_0 + ix] & 0xFF;
                        int v1 = volume[BASE_PG_0 + iy_0 + ix + 1] & 0xFF;
                        int v2 = volume[BASE_PG_0 + iy_down + ix] & 0xFF;
                        int v3 = volume[BASE_PG_0 + iy_down + ix + 1] & 0xFF;
                        int BASE_PG_3 = BASE_PG_2 + this.pg_size;
                        int v28 = volume[BASE_PG_3 + iy_0 + ix] & 0xFF;
                        int v29 = volume[BASE_PG_3 + iy_0 + ix + 1] & 0xFF;
                        int v30 = volume[BASE_PG_3 + iy_down + ix] & 0xFF;
                        int v31 = volume[BASE_PG_3 + iy_down + ix + 1] & 0xFF;
                        int vx0 = vr.trilineardi(v6, v7, v10, v11, v18, v19, v22, v23, fx, fy, fz);
                        int vx1 = vr.trilineardi(v8, v9, v12, v13, v20, v21, v24, v25, fx, fy, fz);
                        int gr_x = vx1 - vx0 >> 16;
                        int vy0 = vr.trilineardi(v4, v5, v7, v8, v16, v17, v19, v20, fx, fy, fz);
                        int vy1 = vr.trilineardi(v11, v12, v14, v15, v23, v24, v26, v27, fx, fy, fz);
                        int gr_y = vy1 - vy0 >> 16;
                        int vz0 = vr.trilineardi(v0, v1, v2, v3, v7, v8, v11, v12, fx, fy, fz);
                        int vz1 = vr.trilineardi(v19, v20, v23, v24, v28, v29, v30, v31, fx, fy, fz);
                        int gr_z = vz1 - vz0 >> 16;
                        int gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                        if (gnrm > 1) {
                            double contrib = opacity * light;
                            double DOT = (double)gr_x * this.lightDir[0] + (double)gr_y * this.lightDir[1] + (double)gr_z * this.lightDir[2];
                            double gcomponent = Math.abs(DOT) * (double)vr.fastInvSqrt(gnrm);
                            double lightval = contrib * ((double)0.2f + (double)0.8f * gcomponent);
                            int rgbidx = 3 * (ival + 8192);
                            double[] lutrgb = this.ctxt.presetCurves.lutrgb;
                            double r = lutrgb[rgbidx];
                            double g = lutrgb[rgbidx + 1];
                            double b = lutrgb[rgbidx + 2];
                            vr2 += r * lightval;
                            vg += g * lightval;
                            vb += b * lightval;
                            light -= contrib;
                            if (contrib > contrib_max1) {
                                contrib_max1 = contrib;
                                color.step_num = (short)z;
                            }
                            if (light < (double)0.02f) break;
                        }
                    }
                }
                six += irayX;
                siy += irayY;
                siz += irayZ;
            }
            color.red = vr2;
            color.green = vg;
            color.blue = vb;
            color.light = light;
            return totalvoxels;
        }
    }

    public static class RaySplitColorLut_NonPower2_i
    extends RaySplitColorLut {
        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            byte[] bingrid = this.bingrid;
            short[] volume = this.volume;
            if (bingrid == null || volume == null) {
                return 0;
            }
            boolean first = true;
            int totalvoxels = 0;
            int six = (int)(65536.0 * (fromX - 0.5));
            int siy = (int)(65536.0 * (fromY - 0.5));
            int siz = (int)(65536.0 * (fromZ - 0.5));
            double contrib_max1 = 0.0;
            double light = color.light;
            double vr2 = 0.0;
            double vg = 0.0;
            double vb = 0.0;
            color.step_num = (short)8192;
            for (int z = t0; z <= t1; ++z) {
                int iz = siz >> 16;
                int bz = iz;
                int iy = siy >> 16;
                int by = iy;
                int ix = six >> 16;
                int bx = ix;
                int bgrid_offset = bz * this.pg_size + by * this.dx + bx;
                int bgrid_pos = bgrid_offset >> 3;
                int bgrid_mod = bgrid_offset & 7;
                int interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                if (interesting != 0) {
                    ++totalvoxels;
                    int fx = (six & 0xFFFF) >> 8;
                    int fy = (siy & 0xFFFF) >> 8;
                    int fz = (siz & 0xFFFF) >> 8;
                    if (first) {
                        color.step_num = (short)z;
                        first = false;
                    }
                    int iy_0 = iy * this.dx;
                    int iy_down = (iy + 1) * this.dx;
                    int iy_downdown = (iy + 2) * this.dx;
                    int iy_up = (iy - 1) * this.dx;
                    double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                    int BASE_PG_1 = this.VOL_OFFSET + iz * this.pg_size;
                    short v7 = volume[BASE_PG_1 + iy_0 + ix];
                    short v8 = volume[BASE_PG_1 + iy_0 + ix + 1];
                    short v11 = volume[BASE_PG_1 + iy_down + ix];
                    short v12 = volume[BASE_PG_1 + iy_down + ix + 1];
                    int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                    short v19 = volume[BASE_PG_2 + iy_0 + ix];
                    short v20 = volume[BASE_PG_2 + iy_0 + ix + 1];
                    short v23 = volume[BASE_PG_2 + iy_down + ix];
                    short v24 = volume[BASE_PG_2 + iy_down + ix + 1];
                    int val = vr.trilineardi(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz);
                    int ival = val >> 16;
                    double opacity = opacity_table[ival + 8192];
                    if (opacity > 1.0E-4) {
                        short v4 = volume[BASE_PG_1 + iy_up + ix];
                        short v5 = volume[BASE_PG_1 + iy_up + ix + 1];
                        short v6 = volume[BASE_PG_1 + iy_0 + ix - 1];
                        short v9 = volume[BASE_PG_1 + iy_0 + ix + 2];
                        short v10 = volume[BASE_PG_1 + iy_down + ix - 1];
                        short v13 = volume[BASE_PG_1 + iy_down + ix + 2];
                        short v14 = volume[BASE_PG_1 + iy_downdown + ix];
                        short v15 = volume[BASE_PG_1 + iy_downdown + ix + 1];
                        short v16 = volume[BASE_PG_2 + iy_up + ix];
                        short v17 = volume[BASE_PG_2 + iy_up + ix + 1];
                        short v18 = volume[BASE_PG_2 + iy_0 + ix - 1];
                        short v21 = volume[BASE_PG_2 + iy_0 + ix + 2];
                        short v22 = volume[BASE_PG_2 + iy_down + ix - 1];
                        short v25 = volume[BASE_PG_2 + iy_down + ix + 2];
                        short v26 = volume[BASE_PG_2 + iy_downdown + ix];
                        short v27 = volume[BASE_PG_2 + iy_downdown + ix + 1];
                        int BASE_PG_0 = this.VOL_OFFSET + (iz - 1) * this.pg_size;
                        short v0 = volume[BASE_PG_0 + iy_0 + ix];
                        short v1 = volume[BASE_PG_0 + iy_0 + ix + 1];
                        short v2 = volume[BASE_PG_0 + iy_down + ix];
                        short v3 = volume[BASE_PG_0 + iy_down + ix + 1];
                        int BASE_PG_3 = BASE_PG_2 + this.pg_size;
                        short v28 = volume[BASE_PG_3 + iy_0 + ix];
                        short v29 = volume[BASE_PG_3 + iy_0 + ix + 1];
                        short v30 = volume[BASE_PG_3 + iy_down + ix];
                        short v31 = volume[BASE_PG_3 + iy_down + ix + 1];
                        int vx0 = vr.trilineardi(v6, v7, v10, v11, v18, v19, v22, v23, fx, fy, fz);
                        int vx1 = vr.trilineardi(v8, v9, v12, v13, v20, v21, v24, v25, fx, fy, fz);
                        int gr_x = vx1 - vx0 >> 16;
                        int vy0 = vr.trilineardi(v4, v5, v7, v8, v16, v17, v19, v20, fx, fy, fz);
                        int vy1 = vr.trilineardi(v11, v12, v14, v15, v23, v24, v26, v27, fx, fy, fz);
                        int gr_y = vy1 - vy0 >> 16;
                        int vz0 = vr.trilineardi(v0, v1, v2, v3, v7, v8, v11, v12, fx, fy, fz);
                        int vz1 = vr.trilineardi(v19, v20, v23, v24, v28, v29, v30, v31, fx, fy, fz);
                        int gr_z = vz1 - vz0 >> 16;
                        int gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                        if (gnrm > 1) {
                            double contrib = opacity * light;
                            double DOT = (double)gr_x * this.lightDir[0] + (double)gr_y * this.lightDir[1] + (double)gr_z * this.lightDir[2];
                            double gcomponent = Math.abs(DOT) * (double)vr.fastInvSqrt(gnrm);
                            double lightval = contrib * ((double)0.2f + (double)0.8f * gcomponent);
                            int rgbidx = 3 * (ival + 8192);
                            double[] lutrgb = this.ctxt.presetCurves.lutrgb;
                            double r = lutrgb[rgbidx];
                            double g = lutrgb[rgbidx + 1];
                            double b = lutrgb[rgbidx + 2];
                            vr2 += r * lightval;
                            vg += g * lightval;
                            vb += b * lightval;
                            light -= contrib;
                            if (contrib > contrib_max1) {
                                contrib_max1 = contrib;
                                color.step_num = (short)z;
                            }
                            if (light < (double)0.02f) break;
                        }
                    }
                }
                six += irayX;
                siy += irayY;
                siz += irayZ;
            }
            color.red = vr2;
            color.green = vg;
            color.blue = vb;
            color.light = light;
            return totalvoxels;
        }
    }

    public static class RaySplitColorLut_CheapGradient_i
    extends RaySplitColorLut {
        private static final int ZSKIP = 1;

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            int interesting;
            int bgrid_mod;
            int bgrid_pos;
            int bgrid_offset;
            int bx;
            int ix;
            int by;
            int iy;
            int bz;
            int iz;
            int z;
            byte[] bingrid = this.bingrid;
            short[] volume = this.volume;
            boolean first = true;
            int totalvoxels = 0;
            int six = (int)(65536.0 * (fromX - 0.5));
            int siy = (int)(65536.0 * (fromY - 0.5));
            int siz = (int)(65536.0 * (fromZ - 0.5));
            double contrib_max1 = 0.0;
            double light = color.light;
            double vr2 = 0.0;
            double vg = 0.0;
            double vb = 0.0;
            boolean everyother = true;
            int gnrm = 1;
            double gcomponent = 1.0;
            color.step_num = (short)8192;
            boolean hit = false;
            for (z = t0; z <= t1; ++z) {
                iz = siz >> 16;
                bz = iz;
                iy = siy >> 16;
                by = iy;
                ix = six >> 16;
                bx = ix;
                bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                bgrid_pos = bgrid_offset >> 3;
                bgrid_mod = bgrid_offset & 7;
                interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                if (interesting != 0) {
                    color.step_num = (short)z;
                    t0 = z;
                    hit = true;
                    break;
                }
                six += irayX;
                siy += irayY;
                siz += irayZ;
            }
            if (hit) {
                for (z = t0; z <= t1; ++z) {
                    iz = siz >> 16;
                    bz = iz;
                    iy = siy >> 16;
                    by = iy;
                    ix = six >> 16;
                    bx = ix;
                    bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                    bgrid_pos = bgrid_offset >> 3;
                    bgrid_mod = bgrid_offset & 7;
                    interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                    if (interesting != 0) {
                        ++totalvoxels;
                        int fx = (six & 0xFFFF) >> 8;
                        int fy = (siy & 0xFFFF) >> 8;
                        int fz = (siz & 0xFFFF) >> 8;
                        if (first) {
                            color.step_num = (short)z;
                            first = false;
                        }
                        int iy_0 = iy << this.SHIFT_X;
                        int iy_down = iy + 1 << this.SHIFT_X;
                        int iy_downdown = iy + 2 << this.SHIFT_X;
                        int iy_up = iy - 1 << this.SHIFT_X;
                        double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                        int BASE_PG_1 = this.VOL_OFFSET + (iz << this.SHIFT_PG);
                        short v7 = volume[BASE_PG_1 + iy_0 + ix];
                        short v8 = volume[BASE_PG_1 + iy_0 + ix + 1];
                        short v11 = volume[BASE_PG_1 + iy_down + ix];
                        short v12 = volume[BASE_PG_1 + iy_down + ix + 1];
                        int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                        short v19 = volume[BASE_PG_2 + iy_0 + ix];
                        short v20 = volume[BASE_PG_2 + iy_0 + ix + 1];
                        short v23 = volume[BASE_PG_2 + iy_down + ix];
                        short v24 = volume[BASE_PG_2 + iy_down + ix + 1];
                        int val = vr.trilineardi(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz);
                        int ival = val >> 16;
                        double opacity = opacity_table[ival + 8192];
                        if (opacity > 1.0E-4) {
                            if (everyother) {
                                short v4 = volume[BASE_PG_1 + iy_up + ix];
                                short v5 = volume[BASE_PG_1 + iy_up + ix + 1];
                                short v6 = volume[BASE_PG_1 + iy_0 + ix - 1];
                                short v9 = volume[BASE_PG_1 + iy_0 + ix + 2];
                                short v10 = volume[BASE_PG_1 + iy_down + ix - 1];
                                short v13 = volume[BASE_PG_1 + iy_down + ix + 2];
                                short v14 = volume[BASE_PG_1 + iy_downdown + ix];
                                short v15 = volume[BASE_PG_1 + iy_downdown + ix + 1];
                                short v16 = volume[BASE_PG_2 + iy_up + ix];
                                short v17 = volume[BASE_PG_2 + iy_up + ix + 1];
                                short v18 = volume[BASE_PG_2 + iy_0 + ix - 1];
                                short v21 = volume[BASE_PG_2 + iy_0 + ix + 2];
                                short v22 = volume[BASE_PG_2 + iy_down + ix - 1];
                                short v25 = volume[BASE_PG_2 + iy_down + ix + 2];
                                short v26 = volume[BASE_PG_2 + iy_downdown + ix];
                                short v27 = volume[BASE_PG_2 + iy_downdown + ix + 1];
                                int BASE_PG_0 = this.VOL_OFFSET + (iz - 1 << this.SHIFT_PG);
                                short v0 = volume[BASE_PG_0 + iy_0 + ix];
                                short v1 = volume[BASE_PG_0 + iy_0 + ix + 1];
                                short v2 = volume[BASE_PG_0 + iy_down + ix];
                                short v3 = volume[BASE_PG_0 + iy_down + ix + 1];
                                int BASE_PG_3 = BASE_PG_2 + this.pg_size;
                                short v28 = volume[BASE_PG_3 + iy_0 + ix];
                                short v29 = volume[BASE_PG_3 + iy_0 + ix + 1];
                                short v30 = volume[BASE_PG_3 + iy_down + ix];
                                short v31 = volume[BASE_PG_3 + iy_down + ix + 1];
                                int vx0 = vr.trilineardi(v6, v7, v10, v11, v18, v19, v22, v23, fx, fy, fz);
                                int vx1 = vr.trilineardi(v8, v9, v12, v13, v20, v21, v24, v25, fx, fy, fz);
                                int gr_x = vx1 - vx0 >> 16;
                                int vy0 = vr.trilineardi(v4, v5, v7, v8, v16, v17, v19, v20, fx, fy, fz);
                                int vy1 = vr.trilineardi(v11, v12, v14, v15, v23, v24, v26, v27, fx, fy, fz);
                                int gr_y = vy1 - vy0 >> 16;
                                int vz0 = vr.trilineardi(v0, v1, v2, v3, v7, v8, v11, v12, fx, fy, fz);
                                int vz1 = vr.trilineardi(v19, v20, v23, v24, v28, v29, v30, v31, fx, fy, fz);
                                int gr_z = vz1 - vz0 >> 16;
                                gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                                double DOT = (double)gr_x * this.lightDir[0] + (double)gr_y * this.lightDir[1] + (double)gr_z * this.lightDir[2];
                                gcomponent = Math.abs(DOT) * (double)vr.fastInvSqrt(gnrm);
                            }
                            if (gnrm > 1) {
                                everyother = !everyother;
                                double contrib = opacity * light;
                                double lightval = contrib * ((double)0.2f + (double)0.8f * gcomponent);
                                int rgbidx = 3 * (ival + 8192);
                                double[] lutrgb = this.ctxt.presetCurves.lutrgb;
                                double r = lutrgb[rgbidx];
                                double g = lutrgb[rgbidx + 1];
                                double b = lutrgb[rgbidx + 2];
                                vr2 += r * lightval;
                                vg += g * lightval;
                                vb += b * lightval;
                                light -= contrib;
                                if (contrib > contrib_max1) {
                                    contrib_max1 = contrib;
                                    color.step_num = (short)z;
                                }
                                if (light < (double)0.02f) break;
                            }
                        }
                    }
                    six += irayX;
                    siy += irayY;
                    siz += irayZ;
                }
            }
            color.red = vr2;
            color.green = vg;
            color.blue = vb;
            color.light = light;
            return totalvoxels;
        }
    }

    public static class RaySplitColorLutNoGrad_i
    extends RaySplitColorLut {
        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            int interesting;
            int bgrid_mod;
            int bgrid_pos;
            int bgrid_offset;
            int bx;
            int ix;
            int by;
            int iy;
            int bz;
            int iz;
            int z;
            byte[] bingrid = this.bingrid;
            short[] volume = this.volume;
            boolean first = true;
            int totalvoxels = 0;
            int six = (int)(65536.0 * (fromX - 0.5));
            int siy = (int)(65536.0 * (fromY - 0.5));
            int siz = (int)(65536.0 * (fromZ - 0.5));
            double contrib_max1 = 0.0;
            double light = color.light;
            double vr2 = 0.0;
            double vg = 0.0;
            double vb = 0.0;
            color.step_num = (short)8192;
            boolean hit = false;
            for (z = t0; z <= t1; ++z) {
                iz = siz >> 16;
                bz = iz;
                iy = siy >> 16;
                by = iy;
                ix = six >> 16;
                bx = ix;
                bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                bgrid_pos = bgrid_offset >> 3;
                bgrid_mod = bgrid_offset & 7;
                interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                if (interesting != 0) {
                    color.step_num = (short)z;
                    t0 = z;
                    hit = true;
                    break;
                }
                six += irayX;
                siy += irayY;
                siz += irayZ;
            }
            if (hit) {
                for (z = t0; z <= t1; ++z) {
                    iz = siz >> 16;
                    bz = iz;
                    iy = siy >> 16;
                    by = iy;
                    ix = six >> 16;
                    bx = ix;
                    bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                    bgrid_pos = bgrid_offset >> 3;
                    bgrid_mod = bgrid_offset & 7;
                    interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                    if (interesting != 0) {
                        ++totalvoxels;
                        int fx = (six & 0xFFFF) >> 8;
                        int fy = (siy & 0xFFFF) >> 8;
                        int fz = (siz & 0xFFFF) >> 8;
                        if (first) {
                            color.step_num = (short)z;
                            first = false;
                        }
                        int iy_0 = iy << this.SHIFT_X;
                        int iy_down = iy + 1 << this.SHIFT_X;
                        int iy_downdown = iy + 2 << this.SHIFT_X;
                        int iy_up = iy - 1 << this.SHIFT_X;
                        double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                        int BASE_PG_1 = this.VOL_OFFSET + (iz << this.SHIFT_PG);
                        short v7 = volume[BASE_PG_1 + iy_0 + ix];
                        short v8 = volume[BASE_PG_1 + iy_0 + ix + 1];
                        short v11 = volume[BASE_PG_1 + iy_down + ix];
                        short v12 = volume[BASE_PG_1 + iy_down + ix + 1];
                        int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                        short v19 = volume[BASE_PG_2 + iy_0 + ix];
                        short v20 = volume[BASE_PG_2 + iy_0 + ix + 1];
                        short v23 = volume[BASE_PG_2 + iy_down + ix];
                        short v24 = volume[BASE_PG_2 + iy_down + ix + 1];
                        int val = vr.trilineardi(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz);
                        int ival = val >> 16;
                        double opacity = opacity_table[ival + 8192];
                        if (opacity > 1.0E-4) {
                            double contrib = opacity * light;
                            double lightval = contrib * 0.9;
                            int rgbidx = 3 * (ival + 8192);
                            double[] lutrgb = this.ctxt.presetCurves.lutrgb;
                            double r = lutrgb[rgbidx];
                            double g = lutrgb[rgbidx + 1];
                            double b = lutrgb[rgbidx + 2];
                            vr2 += r * lightval;
                            vg += g * lightval;
                            vb += b * lightval;
                            light -= contrib;
                            if (contrib > contrib_max1) {
                                contrib_max1 = contrib;
                                color.step_num = (short)z;
                            }
                            if (light < (double)0.02f) break;
                        }
                    }
                    six += irayX;
                    siy += irayY;
                    siz += irayZ;
                }
            }
            color.red = vr2;
            color.green = vg;
            color.blue = vb;
            color.light = light;
            return totalvoxels;
        }
    }

    public static class RaySplitColorLut_i
    extends RaySplitColorLut {
        private static final int ZSKIP = 1;

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            int interesting;
            int bgrid_mod;
            int bgrid_pos;
            int bgrid_offset;
            int bx;
            int ix;
            int by;
            int iy;
            int bz;
            int iz;
            int z;
            byte[] bingrid = this.bingrid;
            short[] volume = this.volume;
            boolean first = true;
            int totalvoxels = 0;
            int six = (int)(65536.0 * (fromX - 0.5));
            int siy = (int)(65536.0 * (fromY - 0.5));
            int siz = (int)(65536.0 * (fromZ - 0.5));
            double contrib_max1 = 0.0;
            double light = color.light;
            double vr2 = 0.0;
            double vg = 0.0;
            double vb = 0.0;
            irayX *= 1;
            irayY *= 1;
            irayZ *= 1;
            color.step_num = (short)8192;
            boolean hit = false;
            for (z = t0; z <= t1; ++z) {
                iz = siz >> 16;
                bz = iz;
                iy = siy >> 16;
                by = iy;
                ix = six >> 16;
                bx = ix;
                bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                bgrid_pos = bgrid_offset >> 3;
                bgrid_mod = bgrid_offset & 7;
                interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                if (interesting != 0) {
                    color.step_num = (short)z;
                    t0 = z;
                    hit = true;
                    break;
                }
                six += irayX;
                siy += irayY;
                siz += irayZ;
            }
            if (hit) {
                for (z = t0; z <= t1; ++z) {
                    iz = siz >> 16;
                    bz = iz;
                    iy = siy >> 16;
                    by = iy;
                    ix = six >> 16;
                    bx = ix;
                    bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                    bgrid_pos = bgrid_offset >> 3;
                    bgrid_mod = bgrid_offset & 7;
                    interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                    if (interesting != 0) {
                        ++totalvoxels;
                        int fx = (six & 0xFFFF) >> 8;
                        int fy = (siy & 0xFFFF) >> 8;
                        int fz = (siz & 0xFFFF) >> 8;
                        if (first) {
                            color.step_num = (short)z;
                            first = false;
                        }
                        int iy_0 = iy << this.SHIFT_X;
                        int iy_down = iy + 1 << this.SHIFT_X;
                        int iy_downdown = iy + 2 << this.SHIFT_X;
                        int iy_up = iy - 1 << this.SHIFT_X;
                        double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                        int BASE_PG_1 = this.VOL_OFFSET + (iz << this.SHIFT_PG);
                        short v7 = volume[BASE_PG_1 + iy_0 + ix];
                        short v8 = volume[BASE_PG_1 + iy_0 + ix + 1];
                        short v11 = volume[BASE_PG_1 + iy_down + ix];
                        short v12 = volume[BASE_PG_1 + iy_down + ix + 1];
                        int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                        short v19 = volume[BASE_PG_2 + iy_0 + ix];
                        short v20 = volume[BASE_PG_2 + iy_0 + ix + 1];
                        short v23 = volume[BASE_PG_2 + iy_down + ix];
                        short v24 = volume[BASE_PG_2 + iy_down + ix + 1];
                        int val = vr.trilineardi(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz);
                        int ival = val >> 16;
                        double opacity = opacity_table[ival + 8192];
                        if (opacity > 1.0E-4) {
                            short v4 = volume[BASE_PG_1 + iy_up + ix];
                            short v5 = volume[BASE_PG_1 + iy_up + ix + 1];
                            short v6 = volume[BASE_PG_1 + iy_0 + ix - 1];
                            short v9 = volume[BASE_PG_1 + iy_0 + ix + 2];
                            short v10 = volume[BASE_PG_1 + iy_down + ix - 1];
                            short v13 = volume[BASE_PG_1 + iy_down + ix + 2];
                            short v14 = volume[BASE_PG_1 + iy_downdown + ix];
                            short v15 = volume[BASE_PG_1 + iy_downdown + ix + 1];
                            short v16 = volume[BASE_PG_2 + iy_up + ix];
                            short v17 = volume[BASE_PG_2 + iy_up + ix + 1];
                            short v18 = volume[BASE_PG_2 + iy_0 + ix - 1];
                            short v21 = volume[BASE_PG_2 + iy_0 + ix + 2];
                            short v22 = volume[BASE_PG_2 + iy_down + ix - 1];
                            short v25 = volume[BASE_PG_2 + iy_down + ix + 2];
                            short v26 = volume[BASE_PG_2 + iy_downdown + ix];
                            short v27 = volume[BASE_PG_2 + iy_downdown + ix + 1];
                            int BASE_PG_0 = this.VOL_OFFSET + (iz - 1 << this.SHIFT_PG);
                            short v0 = volume[BASE_PG_0 + iy_0 + ix];
                            short v1 = volume[BASE_PG_0 + iy_0 + ix + 1];
                            short v2 = volume[BASE_PG_0 + iy_down + ix];
                            short v3 = volume[BASE_PG_0 + iy_down + ix + 1];
                            int BASE_PG_3 = BASE_PG_2 + this.pg_size;
                            short v28 = volume[BASE_PG_3 + iy_0 + ix];
                            short v29 = volume[BASE_PG_3 + iy_0 + ix + 1];
                            short v30 = volume[BASE_PG_3 + iy_down + ix];
                            short v31 = volume[BASE_PG_3 + iy_down + ix + 1];
                            int vx0 = vr.trilineardi(v6, v7, v10, v11, v18, v19, v22, v23, fx, fy, fz);
                            int vx1 = vr.trilineardi(v8, v9, v12, v13, v20, v21, v24, v25, fx, fy, fz);
                            int gr_x = vx1 - vx0 >> 16;
                            int vy0 = vr.trilineardi(v4, v5, v7, v8, v16, v17, v19, v20, fx, fy, fz);
                            int vy1 = vr.trilineardi(v11, v12, v14, v15, v23, v24, v26, v27, fx, fy, fz);
                            int gr_y = vy1 - vy0 >> 16;
                            int vz0 = vr.trilineardi(v0, v1, v2, v3, v7, v8, v11, v12, fx, fy, fz);
                            int vz1 = vr.trilineardi(v19, v20, v23, v24, v28, v29, v30, v31, fx, fy, fz);
                            int gr_z = vz1 - vz0 >> 16;
                            int gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                            if (gnrm > 1) {
                                double contrib = opacity * light;
                                double DOT = (double)gr_x * this.lightDir[0] + (double)gr_y * this.lightDir[1] + (double)gr_z * this.lightDir[2];
                                double gcomponent = Math.abs(DOT) * (double)vr.fastInvSqrt(gnrm);
                                double lightval = contrib * ((double)0.2f + (double)0.8f * gcomponent);
                                int rgbidx = 3 * (ival + 8192);
                                double[] lutrgb = this.ctxt.presetCurves.lutrgb;
                                double r = lutrgb[rgbidx];
                                double g = lutrgb[rgbidx + 1];
                                double b = lutrgb[rgbidx + 2];
                                vr2 += r * lightval;
                                vg += g * lightval;
                                vb += b * lightval;
                                light -= contrib;
                                if (contrib > contrib_max1) {
                                    contrib_max1 = contrib;
                                    color.step_num = (short)z;
                                }
                                if (light < (double)0.02f) break;
                            }
                        }
                    }
                    six += irayX;
                    siy += irayY;
                    siz += irayZ;
                }
            }
            color.red = vr2;
            color.green = vg;
            color.blue = vb;
            color.light = light;
            return totalvoxels;
        }
    }

    public static class RaySplitColorLut_f
    extends RaySplitColorLut {
        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            int interesting;
            int bgrid_mod;
            int bgrid_pos;
            int bgrid_offset;
            int bx;
            int ix;
            int by;
            int iy;
            int bz;
            int iz;
            int z;
            byte[] bingrid = this.bingrid;
            short[] volume = this.volume;
            int totalvoxels = 0;
            int six = (int)(65536.0 * (fromX - 0.5));
            int siy = (int)(65536.0 * (fromY - 0.5));
            int siz = (int)(65536.0 * (fromZ - 0.5));
            float light = (float)color.light;
            float vr2 = 0.0f;
            float vg = 0.0f;
            float vb = 0.0f;
            float contrib_max1 = 0.0f;
            color.step_num = (short)8192;
            boolean hit = false;
            for (z = t0; z <= t1; ++z) {
                iz = siz >> 16;
                bz = iz;
                iy = siy >> 16;
                by = iy;
                ix = six >> 16;
                bx = ix;
                bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                bgrid_pos = bgrid_offset >> 3;
                bgrid_mod = bgrid_offset & 7;
                interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                if (interesting != 0) {
                    color.step_num = (short)z;
                    t0 = z;
                    hit = true;
                    break;
                }
                six += irayX;
                siy += irayY;
                siz += irayZ;
            }
            if (hit) {
                for (z = t0; z <= t1; ++z) {
                    iz = siz >> 16;
                    bz = iz;
                    iy = siy >> 16;
                    by = iy;
                    ix = six >> 16;
                    bx = ix;
                    bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                    bgrid_pos = bgrid_offset >> 3;
                    bgrid_mod = bgrid_offset & 7;
                    interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                    if (interesting != 0) {
                        ++totalvoxels;
                        int fracx = six & 0xFFFF;
                        int fracy = siy & 0xFFFF;
                        int fracz = siz & 0xFFFF;
                        float fx = (float)FRAC[fracx];
                        float fy = (float)FRAC[fracy];
                        float fz = (float)FRAC[fracz];
                        float _fx = 1.0f - fx;
                        float _fy = 1.0f - fy;
                        float _fz = 1.0f - fz;
                        int iy_0 = iy << this.SHIFT_X;
                        int iy_down = iy + 1 << this.SHIFT_X;
                        int iy_downdown = iy + 2 << this.SHIFT_X;
                        int iy_up = iy - 1 << this.SHIFT_X;
                        int BASE_PG_1 = this.VOL_OFFSET + (iz << this.SHIFT_PG);
                        float v4 = volume[BASE_PG_1 + iy_up + ix];
                        float v5 = volume[BASE_PG_1 + iy_up + ix + 1];
                        float v6 = volume[BASE_PG_1 + iy_0 + ix - 1];
                        float v7 = volume[BASE_PG_1 + iy_0 + ix];
                        float v8 = volume[BASE_PG_1 + iy_0 + ix + 1];
                        float v9 = volume[BASE_PG_1 + iy_0 + ix + 2];
                        float v10 = volume[BASE_PG_1 + iy_down + ix - 1];
                        float v11 = volume[BASE_PG_1 + iy_down + ix];
                        float v12 = volume[BASE_PG_1 + iy_down + ix + 1];
                        float v13 = volume[BASE_PG_1 + iy_down + ix + 2];
                        float v14 = volume[BASE_PG_1 + iy_downdown + ix];
                        float v15 = volume[BASE_PG_1 + iy_downdown + ix + 1];
                        int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                        float v16 = volume[BASE_PG_2 + iy_up + ix];
                        float v17 = volume[BASE_PG_2 + iy_up + ix + 1];
                        float v18 = volume[BASE_PG_2 + iy_0 + ix - 1];
                        float v19 = volume[BASE_PG_2 + iy_0 + ix];
                        float v20 = volume[BASE_PG_2 + iy_0 + ix + 1];
                        float v21 = volume[BASE_PG_2 + iy_0 + ix + 2];
                        float v22 = volume[BASE_PG_2 + iy_down + ix - 1];
                        double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                        float v23 = volume[BASE_PG_2 + iy_down + ix];
                        float v24 = volume[BASE_PG_2 + iy_down + ix + 1];
                        float val = vr.trilinearf(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz, _fx, _fy, _fz);
                        int ival = (int)val;
                        float opacity = (float)opacity_table[ival + 8192];
                        if ((double)opacity > 1.0E-4) {
                            float v25 = volume[BASE_PG_2 + iy_down + ix + 2];
                            float v26 = volume[BASE_PG_2 + iy_downdown + ix];
                            float v27 = volume[BASE_PG_2 + iy_downdown + ix + 1];
                            int BASE_PG_0 = this.VOL_OFFSET + (iz - 1 << this.SHIFT_PG);
                            float v0 = volume[BASE_PG_0 + iy_0 + ix];
                            float v1 = volume[BASE_PG_0 + iy_0 + ix + 1];
                            float v2 = volume[BASE_PG_0 + iy_down + ix];
                            float v3 = volume[BASE_PG_0 + iy_down + ix + 1];
                            int BASE_PG_3 = BASE_PG_2 + this.pg_size;
                            float v28 = volume[BASE_PG_3 + iy_0 + ix];
                            float v29 = volume[BASE_PG_3 + iy_0 + ix + 1];
                            float v30 = volume[BASE_PG_3 + iy_down + ix];
                            float v31 = volume[BASE_PG_3 + iy_down + ix + 1];
                            float vx0 = vr.trilinearf(v6, v7, v10, v11, v18, v19, v22, v23, fx, fy, fz, _fx, _fy, _fz);
                            float vx1 = vr.trilinearf(v8, v9, v12, v13, v20, v21, v24, v25, fx, fy, fz, _fx, _fy, _fz);
                            float gr_x = vx1 - vx0;
                            float vy0 = vr.trilinearf(v4, v5, v7, v8, v16, v17, v19, v20, fx, fy, fz, _fx, _fy, _fz);
                            float vy1 = vr.trilinearf(v11, v12, v14, v15, v23, v24, v26, v27, fx, fy, fz, _fx, _fy, _fz);
                            float gr_y = vy1 - vy0;
                            float vz0 = vr.trilinearf(v0, v1, v2, v3, v7, v8, v11, v12, fx, fy, fz, _fx, _fy, _fz);
                            float vz1 = vr.trilinearf(v19, v20, v23, v24, v28, v29, v30, v31, fx, fy, fz, _fx, _fy, _fz);
                            float gr_z = vz1 - vz0;
                            float gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                            if (gnrm > 1.0f) {
                                float contrib = opacity * light;
                                float gcomponent = (float)(Math.abs((double)gr_x * this.lightDir[0] + (double)gr_y * this.lightDir[1] + (double)gr_z * this.lightDir[2]) / Math.sqrt(gnrm));
                                float lightval = contrib * (0.2f + 0.8f * gcomponent);
                                int rgbidx = 3 * (ival + 8192);
                                double[] lutrgb = this.ctxt.presetCurves.lutrgb;
                                float r = (float)lutrgb[rgbidx];
                                float g = (float)lutrgb[rgbidx + 1];
                                float b = (float)lutrgb[rgbidx + 2];
                                vr2 += r * lightval;
                                vg += g * lightval;
                                vb += b * lightval;
                                light -= contrib;
                                if (contrib > contrib_max1) {
                                    contrib_max1 = contrib;
                                    color.step_num = (short)z;
                                }
                                if (light < 0.02f) break;
                            }
                        }
                    }
                    six += irayX;
                    siy += irayY;
                    siz += irayZ;
                }
            }
            color.red = vr2;
            color.green = vg;
            color.blue = vb;
            color.light = light;
            return totalvoxels;
        }
    }

    public static class RaySplitColorLut
    implements RayTracer {
        protected VrCamera cam = null;
        protected double[] vrbg = new double[3];
        protected VrContext ctxt = null;
        protected JVolume.LinearShort vol = null;
        protected short[] volume = null;
        protected int VOL_OFFSET = 0;
        protected byte[] bingrid = null;
        protected double[] lightDir = null;
        protected int dx = 0;
        protected int dy = 0;
        protected int dz = 0;
        protected int pg_size = 0;
        protected int SHIFT_Y = 0;
        protected int SHIFT_X = 0;
        protected int SHIFT_PG = 0;
        protected static final float HALF_VOXEL = 0.5f;

        @Override
        public int traceRay(double fromX, double fromY, double fromZ, double rayX, double rayY, double rayZ, int irayX, int irayY, int irayZ, int t0, int t1, VrColor color) {
            int interesting;
            int bgrid_mod;
            int bgrid_pos;
            int bgrid_offset;
            int bx;
            int ix;
            int by;
            int iy;
            int bz;
            int iz;
            int z;
            byte[] bingrid = this.bingrid;
            short[] volume = this.volume;
            int totalvoxels = 0;
            int six = (int)(65536.0 * (fromX - 0.5));
            int siy = (int)(65536.0 * (fromY - 0.5));
            int siz = (int)(65536.0 * (fromZ - 0.5));
            double light = color.light;
            double vr2 = 0.0;
            double vg = 0.0;
            double vb = 0.0;
            double contrib_max1 = 0.0;
            color.step_num = (short)8192;
            boolean hit = false;
            for (z = t0; z <= t1; ++z) {
                iz = siz >> 16;
                bz = iz;
                iy = siy >> 16;
                by = iy;
                ix = six >> 16;
                bx = ix;
                bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                bgrid_pos = bgrid_offset >> 3;
                bgrid_mod = bgrid_offset & 7;
                interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                if (interesting != 0) {
                    color.step_num = (short)z;
                    t0 = z;
                    hit = true;
                    break;
                }
                six += irayX;
                siy += irayY;
                siz += irayZ;
            }
            if (hit) {
                for (z = t0; z <= t1; ++z) {
                    iz = siz >> 16;
                    bz = iz;
                    iy = siy >> 16;
                    by = iy;
                    ix = six >> 16;
                    bx = ix;
                    bgrid_offset = (bz << this.SHIFT_PG) + (by << this.SHIFT_X) + bx;
                    bgrid_pos = bgrid_offset >> 3;
                    bgrid_mod = bgrid_offset & 7;
                    interesting = bingrid[bgrid_pos] & 1 << bgrid_mod;
                    if (interesting != 0) {
                        ++totalvoxels;
                        int fracx = six & 0xFFFF;
                        int fracy = siy & 0xFFFF;
                        int fracz = siz & 0xFFFF;
                        double fx = FRAC[fracx];
                        double fy = FRAC[fracy];
                        double fz = FRAC[fracz];
                        double _fx = 1.0 - fx;
                        double _fy = 1.0 - fy;
                        double _fz = 1.0 - fz;
                        int iy_0 = iy << this.SHIFT_X;
                        int iy_down = iy + 1 << this.SHIFT_X;
                        int iy_downdown = iy + 2 << this.SHIFT_X;
                        int iy_up = iy - 1 << this.SHIFT_X;
                        int BASE_PG_1 = this.VOL_OFFSET + (iz << this.SHIFT_PG);
                        double v4 = volume[BASE_PG_1 + iy_up + ix];
                        double v5 = volume[BASE_PG_1 + iy_up + ix + 1];
                        double v6 = volume[BASE_PG_1 + iy_0 + ix - 1];
                        double v7 = volume[BASE_PG_1 + iy_0 + ix];
                        double v8 = volume[BASE_PG_1 + iy_0 + ix + 1];
                        double v9 = volume[BASE_PG_1 + iy_0 + ix + 2];
                        double v10 = volume[BASE_PG_1 + iy_down + ix - 1];
                        double v11 = volume[BASE_PG_1 + iy_down + ix];
                        double v12 = volume[BASE_PG_1 + iy_down + ix + 1];
                        double v13 = volume[BASE_PG_1 + iy_down + ix + 2];
                        double v14 = volume[BASE_PG_1 + iy_downdown + ix];
                        double v15 = volume[BASE_PG_1 + iy_downdown + ix + 1];
                        int BASE_PG_2 = BASE_PG_1 + this.pg_size;
                        double v16 = volume[BASE_PG_2 + iy_up + ix];
                        double v17 = volume[BASE_PG_2 + iy_up + ix + 1];
                        double v18 = volume[BASE_PG_2 + iy_0 + ix - 1];
                        double v19 = volume[BASE_PG_2 + iy_0 + ix];
                        double v20 = volume[BASE_PG_2 + iy_0 + ix + 1];
                        double v21 = volume[BASE_PG_2 + iy_0 + ix + 2];
                        double v22 = volume[BASE_PG_2 + iy_down + ix - 1];
                        double[] opacity_table = this.ctxt.presetCurves.opacity_table;
                        double v23 = volume[BASE_PG_2 + iy_down + ix];
                        double v24 = volume[BASE_PG_2 + iy_down + ix + 1];
                        double val = vr.trilineard(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz, _fx, _fy, _fz);
                        int ival = (int)val;
                        double opacity = opacity_table[ival + 8192];
                        if (opacity > 1.0E-4) {
                            double v25 = volume[BASE_PG_2 + iy_down + ix + 2];
                            double v26 = volume[BASE_PG_2 + iy_downdown + ix];
                            double v27 = volume[BASE_PG_2 + iy_downdown + ix + 1];
                            int BASE_PG_0 = this.VOL_OFFSET + (iz - 1 << this.SHIFT_PG);
                            double v0 = volume[BASE_PG_0 + iy_0 + ix];
                            double v1 = volume[BASE_PG_0 + iy_0 + ix + 1];
                            double v2 = volume[BASE_PG_0 + iy_down + ix];
                            double v3 = volume[BASE_PG_0 + iy_down + ix + 1];
                            int BASE_PG_3 = BASE_PG_2 + this.pg_size;
                            double v28 = volume[BASE_PG_3 + iy_0 + ix];
                            double v29 = volume[BASE_PG_3 + iy_0 + ix + 1];
                            double v30 = volume[BASE_PG_3 + iy_down + ix];
                            double v31 = volume[BASE_PG_3 + iy_down + ix + 1];
                            double vx0 = vr.trilineard(v6, v7, v10, v11, v18, v19, v22, v23, fx, fy, fz, _fx, _fy, _fz);
                            double vx1 = vr.trilineard(v8, v9, v12, v13, v20, v21, v24, v25, fx, fy, fz, _fx, _fy, _fz);
                            double gr_x = vx1 - vx0;
                            double vy0 = vr.trilineard(v4, v5, v7, v8, v16, v17, v19, v20, fx, fy, fz, _fx, _fy, _fz);
                            double vy1 = vr.trilineard(v11, v12, v14, v15, v23, v24, v26, v27, fx, fy, fz, _fx, _fy, _fz);
                            double gr_y = vy1 - vy0;
                            double vz0 = vr.trilineard(v0, v1, v2, v3, v7, v8, v11, v12, fx, fy, fz, _fx, _fy, _fz);
                            double vz1 = vr.trilineard(v19, v20, v23, v24, v28, v29, v30, v31, fx, fy, fz, _fx, _fy, _fz);
                            double gr_z = vz1 - vz0;
                            double gnrm = gr_x * gr_x + gr_y * gr_y + gr_z * gr_z;
                            if (gnrm > 1.0) {
                                double contrib = opacity * light;
                                double gcomponent = Math.abs(gr_x * this.lightDir[0] + gr_y * this.lightDir[1] + gr_z * this.lightDir[2]) / Math.sqrt(gnrm);
                                double lightval = contrib * ((double)0.2f + (double)0.8f * gcomponent);
                                int rgbidx = 3 * (ival + 8192);
                                double[] lutrgb = this.ctxt.presetCurves.lutrgb;
                                double r = lutrgb[rgbidx];
                                double g = lutrgb[rgbidx + 1];
                                double b = lutrgb[rgbidx + 2];
                                vr2 += r * lightval;
                                vg += g * lightval;
                                vb += b * lightval;
                                light -= contrib;
                                if (contrib > contrib_max1) {
                                    contrib_max1 = contrib;
                                    color.step_num = (short)z;
                                }
                                if (light < (double)0.02f) break;
                            }
                        }
                    }
                    six += irayX;
                    siy += irayY;
                    siz += irayZ;
                }
            }
            color.red = vr2;
            color.green = vg;
            color.blue = vb;
            color.light = light;
            return totalvoxels;
        }

        public void clear() {
            this.cam = null;
            this.ctxt = null;
            this.vol = null;
            this.volume = null;
            this.bingrid = null;
            this.dz = 0;
            this.dy = 0;
            this.dx = 0;
            this.pg_size = 0;
        }

        @Override
        public void setVrSession(VrCamera cam) {
            if (cam == null) {
                this.clear();
                return;
            }
            this.cam = cam;
            this.ctxt = cam.vr_ctxt;
            this.vol = (JVolume.LinearShort)this.ctxt.vol;
            this.VOL_OFFSET = this.vol.PAD;
            this.volume = this.vol.volume;
            this.bingrid = this.ctxt.getBingrid();
            double[] bg = cam.getBackgroundf();
            if (bg != null) {
                this.vrbg[0] = bg[0];
                this.vrbg[1] = bg[1];
                this.vrbg[2] = bg[2];
            }
            this.lightDir = cam.light;
            this.dx = this.vol.dx;
            this.dy = this.vol.dy;
            this.dz = this.vol.dz;
            this.pg_size = this.dx * this.dy;
            this.SHIFT_Y = vr.LN_2(this.dy);
            this.SHIFT_X = vr.LN_2(this.dx);
            this.SHIFT_PG = this.SHIFT_Y + this.SHIFT_X;
        }
    }
}

