/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.marker;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.marker.XpSliceControlledMarker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class XpCrossMarker
extends XpSliceControlledMarker {
    private SliceControlledCapable scc1 = null;
    private SliceControlledCapable scc2 = null;
    private double focusCenterSize = 0.05;
    private int bullsDim = 19;
    private Ellipse2D bullsEye = new Ellipse2D.Double(0.0, 0.0, this.bullsDim, this.bullsDim);
    private int sliceIdx1 = -1;
    private int sliceIdx2 = -1;
    private Point2D p1_1 = new Point2D.Double();
    private Point2D p2_1 = new Point2D.Double();
    private Point2D p1_2 = new Point2D.Double();
    private Point2D p2_2 = new Point2D.Double();
    private CPoint imgPt = new CPoint(0);
    private CPoint dispPt = new CPoint(1);
    private Point2D dp1_1 = new Point2D.Double();
    private Point2D dp2_1 = new Point2D.Double();
    private Point2D dp1_2 = new Point2D.Double();
    private Point2D dp2_2 = new Point2D.Double();
    private XpGeomUtils gu = new XpGeomUtils();
    private Line2D l1 = new Line2D.Double();
    private Line2D l2 = new Line2D.Double();
    private boolean focusOn = false;
    private Point2D int0 = new Point2D.Double();
    private Point2D int1 = new Point2D.Double();
    private int radiusSq = 0;
    private int containsType = -1;
    private boolean pressed = false;

    public XpCrossMarker() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setForeground(Color.green);
        this.setMarkerStroke(new BasicStroke(1.5f));
    }

    public double updateDisplayCoordinates(Point2D dp1, Point2D dp2, Point2D p1, Point2D p2) {
        CTransform ctc = this.getTransform((byte)0, (byte)1);
        this.imgPt.setPoint(p1.getX(), p1.getY(), 0.0, (byte)0);
        ctc.transform(this.imgPt, this.dispPt);
        dp1.setLocation(this.dispPt.x, this.dispPt.y);
        this.imgPt.setPoint(p2.getX(), p2.getY(), 0.0, (byte)0);
        ctc.transform(this.imgPt, this.dispPt);
        dp2.setLocation(this.dispPt.x, this.dispPt.y);
        double dx = dp2.getX() - dp1.getX();
        double dy = dp2.getY() - dp1.getY();
        double len = Math.sqrt(dx * dx + dy * dy);
        return len;
    }

    public final int getTargetDim() {
        return this.bullsDim;
    }

    public final void setTargetDim(int bDim) {
        this.bullsDim = bDim;
    }

    @Override
    public boolean contains(int x, int y) {
        int dy;
        int dx;
        int distSq;
        int x1 = x - 6;
        int x2 = x + 6;
        int y1 = y - 6;
        int y2 = y + 6;
        if (!this.pressed) {
            this.containsType = -1;
        }
        if (this.focusOn && (distSq = (dx = (int)(this.int0.getX() - (double)x)) * dx + (dy = (int)(this.int0.getY() - (double)y)) * dy) < this.radiusSq) {
            if (!this.pressed) {
                this.containsType = 3;
            }
            return true;
        }
        if (XpCrossMarker.intersects(x1, y1, x2, y2, (int)this.dp1_1.getX(), (int)this.dp1_1.getY(), (int)this.dp2_1.getX(), (int)this.dp2_1.getY())) {
            if (!this.pressed) {
                this.containsType = 1;
            }
            return true;
        }
        if (XpCrossMarker.intersects(x1, y1, x2, y2, (int)this.dp1_2.getX(), (int)this.dp1_2.getY(), (int)this.dp2_2.getX(), (int)this.dp2_2.getY())) {
            if (!this.pressed) {
                this.containsType = 2;
            }
            return true;
        }
        return false;
    }

    private void computeIntersection() {
        Point2D[] pts1 = this.getImageIntersectionPoints(this.scc1, this.sliceIdx1);
        this.p1_1.setLocation(pts1[0]);
        this.p2_1.setLocation(pts1[1]);
        Point2D[] pts2 = this.getImageIntersectionPoints(this.scc2, this.sliceIdx2);
        this.p1_2.setLocation(pts2[0]);
        this.p2_2.setLocation(pts2[1]);
    }

    @Override
    public void setActiveSlice(Object source, XpSlice slice) {
        this.sliceIdx1 = this.scc1.getActiveSliceIndex();
        this.sliceIdx2 = this.scc2.getActiveSliceIndex();
        this.computeIntersection();
        this.repaint();
    }

    public void setSliceControlledCapable(SliceControlledCapable scc1, SliceControlledCapable scc2) {
        if (this.scc1 != null) {
            this.scc1.removeSliceListener(this);
        }
        if (this.scc2 != null) {
            this.scc2.removeSliceListener(this);
        }
        this.resetSliceControlledCapable(this.scc1);
        this.resetSliceControlledCapable(this.scc2);
        this.scc1 = scc1;
        scc1.addSliceListener(this);
        this.scc2 = scc2;
        scc2.addSliceListener(this);
        this.sliceIdx1 = scc1.getActiveSliceIndex();
        this.sliceIdx2 = scc2.getActiveSliceIndex();
        this.computeIntersection();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.pressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.pressed = false;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int idx;
        int csliceIdx;
        Point p = me.getPoint();
        if (this.containsType == 3 || this.containsType == 1) {
            csliceIdx = this.scc1.getActiveSliceIndex();
            idx = this.getNearestSliceIndex(this.scc1, p);
            if (idx != -1 && idx != csliceIdx) {
                this.scc1.setActiveSliceIndex(idx);
            }
        }
        if (this.containsType == 3 || this.containsType == 2) {
            csliceIdx = this.scc2.getActiveSliceIndex();
            idx = this.getNearestSliceIndex(this.scc2, p);
            if (idx != -1 && idx != csliceIdx) {
                this.scc2.setActiveSliceIndex(idx);
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.focusOn = false;
        Graphics2D g = (Graphics2D)graphics;
        Stroke st = g.getStroke();
        double len1 = this.updateDisplayCoordinates(this.dp1_1, this.dp2_1, this.p1_1, this.p2_1);
        double len2 = this.updateDisplayCoordinates(this.dp1_2, this.dp2_2, this.p1_2, this.p2_2);
        this.l1.setLine(this.dp1_1, this.dp2_1);
        this.l2.setLine(this.dp1_2, this.dp2_2);
        int status = this.gu.intersect2DSegments(this.l1, this.l2, this.int0, this.int1);
        if (status == 1) {
            this.focusOn = true;
        }
        Stroke str = this.getMarkerStroke();
        g.setStroke(str);
        Color c = this.getForeground();
        g.setColor(c);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.focusOn) {
            this.radiusSq = this.bullsDim * this.bullsDim;
            double w = this.bullsEye.getWidth();
            double h = this.bullsEye.getHeight();
            double x = this.int0.getX() - w / 2.0;
            double y = this.int0.getY() - h / 2.0;
            this.bullsEye.setFrame(x, y, w, h);
            g.draw(this.bullsEye);
        }
        g.drawLine((int)this.dp1_1.getX(), (int)this.dp1_1.getY(), (int)this.dp2_1.getX(), (int)this.dp2_1.getY());
        g.drawLine((int)this.dp1_2.getX(), (int)this.dp1_2.getY(), (int)this.dp2_2.getX(), (int)this.dp2_2.getY());
        g.setStroke(st);
    }
}

