/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.platform.dm.DmImageCreator;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.Dimension;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JFrame;

public class DmSingleFrameCreator
extends DmImageCreator {
    private DicomComposite dcmComp = new DicomComposite();
    private String fileName = "";
    private int[] dims = null;
    private int pixelDataLen = 0;
    private byte[] cacheFrame = null;
    private ByteBuffer bbuff = null;
    private FileOutputStream appendStream = null;

    public DmSingleFrameCreator(XjImage vol, XjTagValue[] tags, String fileName) {
        this(vol, tags, false, fileName);
    }

    public DmSingleFrameCreator(XjImage img, XjTagValue[] tags, boolean newStudy, String fileName) {
        super(img, tags);
        this.init(this.getTags(), tags, img, newStudy, fileName);
    }

    private void init(XjTagValue[] tagsToFill, XjTagValue[] userTags, XjImage img, boolean newStudy, String fileName) {
        this.setValues(this.dcmComp, tagsToFill);
        this.fileName = fileName;
        this.dcmComp.setValue(8, 24, UidGenerator.newInstanceUID());
        if (newStudy) {
            this.dcmComp.setValue(32, 13, UidGenerator.newInstanceUID());
        }
        this.dcmComp.setValue(32, 14, UidGenerator.newInstanceUID());
        this.dcmComp.setValue(8, 4158, "GEHC Multiframe volume");
        this.dcmComp.setValue(32, 17, DmSingleFrameCreator.getSeriesNo(img));
        this.dcmComp.setDateValue(8, 18, this.getCreationDate());
        this.dcmComp.setTimeValue(8, 19, this.getCreationDate());
        this.dcmComp.setValue(2, 16, "1.2.840.10008.1.2.1");
        this.dcmComp.setValue(40, 8, new Integer(1));
        int bpp = Integer.parseInt("" + img.getValue(40, 257));
        int bytesPerVoxel = bpp / 8;
        if (userTags != null) {
            for (int i = 0; i < userTags.length; ++i) {
                XjTagValue t = userTags[i];
                try {
                    System.err.println(">> " + t.value);
                    this.dcmComp.setValue(t.group, t.element, t.value);
                    continue;
                }
                catch (DMException e) {
                    System.err.println("ERROR: Setting user tag (" + Integer.toHexString(t.group) + "," + Integer.toHexString(t.element) + ") : " + t.value);
                    System.err.println("       " + e.getMessage());
                }
            }
        }
        int w = Integer.parseInt("" + this.dcmComp.getValue(40, 17));
        int h = Integer.parseInt("" + this.dcmComp.getValue(40, 16));
        this.dims = new int[]{w, h};
        this.pixelDataLen = this.dims[0] * this.dims[1] * bytesPerVoxel;
        this.dcmComp.setValue(32736, 0, new Long(this.pixelDataLen));
    }

    public void setFrame(Object data, int offset) throws IOException {
        int len = this.dims[0] * this.dims[1];
        if (data instanceof short[]) {
            this.dcmComp.setVR(32736, 16, 20311);
            this.cacheFrame = new byte[len * 2];
            this.bbuff = ByteBuffer.wrap(this.cacheFrame);
            this.bbuff.order(ByteOrder.LITTLE_ENDIAN);
            this.bbuff.asShortBuffer().put((short[])data, offset, len);
        } else if (data instanceof byte[]) {
            this.dcmComp.setVR(32736, 16, 20290);
            this.cacheFrame = new byte[len];
            this.bbuff = ByteBuffer.wrap(this.cacheFrame);
            this.bbuff.put((byte[])data, offset, len);
        }
        this.dcmComp.setValue(32736, 16, this.cacheFrame);
        FileOutputStream fos = new FileOutputStream(this.fileName);
        this.dcmComp.write(fos, true);
        fos.close();
        dicomParser dp = new dicomParser(this.fileName);
        tagValue tv = new tagValue(32736, 16);
        tv.fillValue = false;
        dp.fill(new tagValue[]{tv});
        dp.clearFile();
        RandomAccessFile raf = new RandomAccessFile(this.fileName, "rw");
        raf.seek(tv.fileOffset + 8L);
        byte[] buff = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(buff);
        bb.order(tv.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        bb.putInt(this.pixelDataLen);
        raf.write(buff);
        raf.close();
    }

    public void close() throws IOException {
        if (this.appendStream != null) {
            this.appendStream.close();
        }
    }

    public static void main(String[] args) {
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        DMImage[] imgs = dmo[0].getImages(null);
        String mfpath = args[1];
        int nw = 1024;
        int nh = 128;
        XjTagValue rows = new XjTagValue(40, 16);
        rows.value = new Short(128);
        XjTagValue cols = new XjTagValue(40, 17);
        cols.value = new Short(1024);
        XjTagValue sp = new XjTagValue(40, 48);
        sp.value = "8.0\\1.0";
        XjTagValue defwl = new XjTagValue(40, 4176);
        defwl.value = "2048";
        XjTagValue defww = new XjTagValue(40, 4177);
        defww.value = "4096";
        XjTagValue inter = new XjTagValue(40, 4178);
        inter.value = "0";
        XjTagValue[] tags = new XjTagValue[]{rows, cols, sp, defwl, defww, inter};
        DmSingleFrameCreator dmf = new DmSingleFrameCreator(imgs[0], tags, true, mfpath);
        short[] data = new short[131072];
        double pct = 0.5;
        int hw = 256;
        int hh = 32;
        try {
            for (int y = 32; y < 96; ++y) {
                int yoffset = y * 1024;
                for (int x = 256; x < 768; ++x) {
                    data[yoffset + x] = 4096;
                }
            }
            dmf.setFrame(data, 0);
            dmf.close();
            System.err.println("%%% Wrote multiframe: " + mfpath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DMSession dms_mf = new DMSession(new String[]{"file", mfpath});
        DMObject[] dmo_mf = dms_mf.getRelated("series");
        XjImage[] imgs_mf = dmo_mf[0].getImages(null);
        JFrame jf = new JFrame("Single-Image");
        XpImageViewport iv = new XpImageViewport();
        iv.setImages(imgs_mf);
        jf.setContentPane(iv);
        iv.setPreferredSize(new Dimension(512, 512));
        jf.pack();
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }
}

