/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class XpDMDicomSave {
    private XpDMDicomSave() {
    }

    public static InputStream replacePixels(String dcmName, BufferedImage bi) {
        InputStream is = null;
        dcmName = "/gspnet/images/dicom97/dicom/gems/ct/im100";
        System.out.println("Reading: " + dcmName);
        try {
            DicomComposite dmc = new DicomComposite();
            FileInputStream fis = new FileInputStream(dcmName);
            dmc.read(fis);
            fis.close();
            Object orows = dmc.getValue(40, 16);
            Object ocols = dmc.getValue(40, 17);
            int iw = Integer.parseInt("" + ocols);
            int ih = Integer.parseInt("" + orows);
            int bw = bi.getWidth();
            int bh = bi.getHeight();
            if (iw != bw || ih != bh) {
                return null;
            }
            String dcmUID = UidGenerator.newInstanceUID();
            dmc.setValue(8, 24, dcmUID);
            dmc.setValue(8, 4158, "JAMI PATTERN IMAGE");
            dmc.setValue(16, 16, "JAMI Patient");
            dmc.setValue(8, 112, "GEMS JAMI");
            dmc.setValue(8, 128, "Fake Hospital");
            DataBuffer db = bi.getRaster().getDataBuffer();
            if (db instanceof DataBufferUShort) {
                short[] data = ((DataBufferUShort)db).getData();
                byte[] bdata = new byte[2 * data.length];
                for (int i = 0; i < data.length; ++i) {
                    short d = data[i];
                    int hi = (0xFF00 & d) >> 8;
                    int lo = 0xFF & d;
                    bdata[2 * i + 1] = (byte)lo;
                    bdata[2 * i] = (byte)hi;
                }
                dmc.setValue(32736, 16, bdata);
            } else if (db instanceof DataBufferShort) {
                short[] data = ((DataBufferShort)db).getData();
                byte[] bdata = new byte[2 * data.length];
                for (int i = 0; i < data.length; ++i) {
                    short d = data[i];
                    int hi = (0xFF00 & d) >> 8;
                    int lo = 0xFF & d;
                    bdata[2 * i + 1] = (byte)lo;
                    bdata[2 * i] = (byte)hi;
                }
                dmc.setValue(32736, 16, bdata);
            } else if (db instanceof DataBufferByte) {
                byte[] data = ((DataBufferByte)db).getData();
                dmc.setValue(32736, 16, data);
            }
            System.out.println("r=" + orows + "  c=" + ocols);
            is = dmc.getInputStream();
        }
        catch (IOException ex) {
            System.err.println("IOException: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (DMException ex) {
            System.err.println("DMException: " + ex.getMessage());
            ex.printStackTrace();
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInputStream(InputStream is, String outputName) {
        FileOutputStream fos = null;
        try {
            byte[] buff = new byte[256];
            fos = new FileOutputStream(outputName);
            int nread = -1;
            do {
                if ((nread = is.read(buff)) <= 0) continue;
                fos.write(buff, 0, nread);
            } while (nread != -1);
        }
        catch (IOException ex) {
            System.err.println("IOEXCEPTION: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("USAGE: XpDMDicomSave <dcmName>");
            return;
        }
        String fileName = args[0];
        BufferedImage bi = new BufferedImage(512, 512, 11);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setColor(Color.yellow);
        Rectangle2D.Double r = new Rectangle2D.Double(50.0, 50.0, 100.0, 100.0);
        g2.fill(r);
        InputStream is = XpDMDicomSave.replacePixels(fileName, bi);
        XpDMDicomSave.saveInputStream(is, "/gspnet/developer/espinal/DUMP/pattern.dcm");
    }
}

