/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.image.XjMedicalImage;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ServerImageSet
implements XjDicomObject {
    private XjImage[] imgs = null;
    private XpMedicalImage[] medimgs = null;
    private int width = -1;
    private int height = -1;

    public ServerImageSet(XjImage[] imgs) {
        this.imgs = imgs;
    }

    public XjImage getImage(int sliceIdx) {
        return this.imgs[sliceIdx];
    }

    public XpMedicalImage[] getMedicalImages() {
        if (this.medimgs == null) {
            this.medimgs = new XpMedicalImage[this.imgs.length];
            for (int i = 0; i < this.medimgs.length; ++i) {
                this.medimgs[i] = new XjMedicalImage(this.imgs[i]);
            }
        }
        return this.medimgs;
    }

    public int getNumImages() {
        return this.imgs.length;
    }

    public int getWidth() {
        if (this.width < 0) {
            this.width = Integer.parseInt("" + this.imgs[0].getValue(40, 17));
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height < 0) {
            this.height = Integer.parseInt("" + this.imgs[0].getValue(40, 16));
        }
        return this.height;
    }

    public double[] getPixelSpacing(int idx) {
        double[] spacing = this.getDoubleArrayValue(idx, 40, 48);
        return spacing;
    }

    public double[] getULHC(int idx) {
        double[] ulhc = this.getDoubleArrayValue(idx, 32, 50);
        ulhc[0] = -ulhc[0];
        ulhc[1] = -ulhc[1];
        return ulhc;
    }

    public double[] getXDir(int idx) {
        double[] vals = this.getDoubleArrayValue(idx, 32, 55);
        double[] xdir = new double[]{-vals[0], -vals[1], vals[2]};
        double[] spacing = this.getPixelSpacing(idx);
        JnVector3d.normalize(xdir);
        JnVector3d.scale(xdir, spacing[0]);
        return xdir;
    }

    public double[] getYDir(int idx) {
        double[] vals = this.getDoubleArrayValue(idx, 32, 55);
        double[] ydir = new double[]{-vals[3], -vals[4], vals[5]};
        double[] spacing = this.getPixelSpacing(idx);
        JnVector3d.normalize(ydir);
        JnVector3d.scale(ydir, spacing[1]);
        return ydir;
    }

    public int getBitsPerPixel() {
        int bpp = Integer.parseInt("" + this.imgs[0].getValue(40, 257));
        return bpp;
    }

    public int getPixelRepresentation() {
        int pixelRep = Integer.parseInt("" + this.imgs[0].getValue(40, 259));
        return pixelRep;
    }

    @Override
    public Object getValue(int group, int element) {
        return this.getValue(0, group, element);
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        return this.getValues(0, tv);
    }

    public Object getValue(int sliceIdx, int group, int element) {
        return this.imgs[sliceIdx].getValue(group, element);
    }

    public int getValues(int sliceIdx, XjTagValue[] tv) {
        return this.imgs[sliceIdx].getValues(tv);
    }

    private double[] getDoubleArrayValue(int idx, int group, int element) {
        String s = this.imgs[idx].getValue(group, element).toString();
        if (s != null) {
            ArrayList<String> l = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s, " ,\\\t\n");
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
            double[] result = new double[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                try {
                    result[i] = Double.parseDouble((String)l.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return result;
        }
        return null;
    }
}

