/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.codec;

import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.tap.util.clientServer.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class FastCompressionCodec
implements RmPixelBufferCodec {
    private RmPixelBuffer return_rpb = new RmPixelBuffer();
    private byte[] compress_buff = null;
    private byte[] buffer = new byte[1024];
    private short[] spixbuff = null;
    private int[] ipixbuff = null;

    @Override
    public String getName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public int encode(RmPixelBuffer pb, byte[] pbstream, int pboffset) {
        int newOffset = this.encodePixelBuffer(pb, pbstream, pboffset);
        return newOffset - pboffset;
    }

    @Override
    public RmPixelBuffer decode(byte[] pbstream, int pboffset, int pblength) {
        int newOffset = this.decodePixelBuffer(pbstream, pboffset, this.return_rpb);
        return this.return_rpb;
    }

    private int decodePixelBuffer(byte[] in, int offset, RmPixelBuffer rpb) {
        rpb.x0 = Utils.getInt(in, offset);
        rpb.y0 = Utils.getInt(in, offset += 4);
        rpb.pixBufferWidth = Utils.getInt(in, offset += 4);
        rpb.pixBufferHeight = Utils.getInt(in, offset += 4);
        rpb.xstep = Utils.getInt(in, offset += 4);
        rpb.ystep = Utils.getInt(in, offset += 4);
        rpb.nchannels = Utils.getInt(in, offset += 4);
        rpb.remainingPasses = Utils.getInt(in, offset += 4);
        rpb.mpAlgorithmId = Utils.getInt(in, offset += 4);
        byte type = in[offset += 4];
        int full_size = Utils.getInt(in, ++offset);
        int compressed_size = Utils.getInt(in, offset += 4);
        int len = rpb.pixBufferWidth * rpb.pixBufferHeight;
        Inflater decompressor = new Inflater();
        decompressor.setInput(in, offset += 4, compressed_size);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(full_size);
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(this.buffer);
                bos.write(this.buffer, 0, count);
            }
            catch (Exception count) {}
        }
        try {
            bos.close();
        }
        catch (IOException count) {
            // empty catch block
        }
        byte[] decompressedData = bos.toByteArray();
        switch (type) {
            case 0: 
            case 2: {
                if (this.spixbuff == null || this.spixbuff.length < len) {
                    this.spixbuff = new short[len];
                }
                int i = 0;
                while (i < len) {
                    short val;
                    this.spixbuff[i] = val = (short)(((decompressedData[i * 2 + 1] & 0xFF) << 0) + ((decompressedData[i * 2 + 0] & 0xFF) << 8));
                    ++i;
                    offset += 2;
                }
                rpb.pixBuffer = this.spixbuff;
                break;
            }
            case 1: {
                if (this.ipixbuff == null || this.ipixbuff.length < len) {
                    this.ipixbuff = new int[len];
                }
                int i = 0;
                while (i < len) {
                    int val;
                    this.ipixbuff[i] = val = ((decompressedData[i * 3 + 2] & 0xFF) << 0) + ((decompressedData[i * 3 + 1] & 0xFF) << 8) + ((decompressedData[i * 3 + 0] & 0xFF) << 16) + -16777216;
                    ++i;
                    offset += 3;
                }
                rpb.pixBuffer = this.ipixbuff;
            }
        }
        return offset;
    }

    private int encodePixelBuffer(RmPixelBuffer rpb, byte[] out, int offset) {
        int val;
        int i;
        Utils.putInt(out, offset, rpb.x0);
        Utils.putInt(out, offset += 4, rpb.y0);
        Utils.putInt(out, offset += 4, rpb.pixBufferWidth);
        Utils.putInt(out, offset += 4, rpb.pixBufferHeight);
        Utils.putInt(out, offset += 4, rpb.xstep);
        Utils.putInt(out, offset += 4, rpb.ystep);
        Utils.putInt(out, offset += 4, rpb.nchannels);
        Utils.putInt(out, offset += 4, rpb.remainingPasses);
        Utils.putInt(out, offset += 4, rpb.mpAlgorithmId);
        offset += 4;
        Object pixbuff = rpb.pixBuffer;
        int len = rpb.pixBufferWidth * rpb.pixBufferHeight;
        int pixbuffOffset = rpb.pixBufferOffset;
        int full_size = 0;
        if (pixbuff instanceof short[]) {
            full_size = len * 2;
            switch (rpb.bpp) {
                case 12: {
                    out[offset] = 2;
                    break;
                }
                case 16: {
                    out[offset] = 0;
                }
            }
            Utils.putInt(out, ++offset, full_size);
            offset += 4;
            if (this.compress_buff == null || this.compress_buff.length != len * 2) {
                this.compress_buff = new byte[len * 2];
            }
            short[] spixbuff = (short[])pixbuff;
            for (i = 0; i < len; ++i) {
                val = spixbuff[pixbuffOffset + i];
                this.compress_buff[i * 2 + 1] = (byte)(val >>> 0);
                this.compress_buff[i * 2 + 0] = (byte)(val >>> 8);
            }
        } else {
            full_size = len * 3;
            out[offset] = 1;
            Utils.putInt(out, ++offset, full_size);
            offset += 4;
            if (this.compress_buff == null || this.compress_buff.length != len * 3) {
                this.compress_buff = new byte[len * 3];
            }
            int[] ipixbuff = (int[])pixbuff;
            for (i = 0; i < len; ++i) {
                val = ipixbuff[pixbuffOffset + i];
                this.compress_buff[i * 3 + 2] = (byte)(val >>> 0);
                this.compress_buff[i * 3 + 1] = (byte)(val >>> 8);
                this.compress_buff[i * 3 + 0] = (byte)(val >>> 16);
            }
        }
        Deflater compressor = new Deflater();
        compressor.setLevel(1);
        compressor.setInput(this.compress_buff);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.compress_buff.length);
        while (!compressor.finished()) {
            int count = compressor.deflate(this.buffer);
            bos.write(this.buffer, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] compressed_data = bos.toByteArray();
        int compressed_size = compressed_data.length;
        int ratio = (int)((1.0 - (double)compressed_size / (double)full_size) * 100.0);
        Utils.putInt(out, offset, compressed_size);
        offset += 4;
        int i2 = 0;
        while (i2 < compressed_size) {
            out[offset] = compressed_data[i2];
            ++i2;
            ++offset;
        }
        return offset;
    }
}

