/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.codec;

import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.tap.util.clientServer.Utils;

public class SimpleLossyPBCodec
implements RmPixelBufferCodec {
    private RmPixelBuffer return_rpb = new RmPixelBuffer();
    private short[] spixbuff = null;
    private int[] ipixbuff = null;

    @Override
    public String getName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public int encode(RmPixelBuffer pb, byte[] pbstream, int pboffset) {
        int newOffset = this.encodePixelBuffer(pb, pbstream, pboffset);
        return newOffset - pboffset;
    }

    @Override
    public RmPixelBuffer decode(byte[] pbstream, int pboffset, int pblength) {
        int newOffset = this.decodePixelBuffer(pbstream, pboffset, this.return_rpb);
        return this.return_rpb;
    }

    private int decodePixelBuffer(byte[] in, int buff_offset, RmPixelBuffer rpb) {
        int offset = buff_offset;
        rpb.x0 = Utils.getInt(in, offset);
        rpb.y0 = Utils.getInt(in, offset += 4);
        rpb.pixBufferWidth = Utils.getInt(in, offset += 4);
        rpb.pixBufferHeight = Utils.getInt(in, offset += 4);
        rpb.xstep = Utils.getInt(in, offset += 4);
        rpb.ystep = Utils.getInt(in, offset += 4);
        rpb.nchannels = Utils.getInt(in, offset += 4);
        rpb.remainingPasses = Utils.getInt(in, offset += 4);
        rpb.mpAlgorithmId = Utils.getInt(in, offset += 4);
        byte type = in[offset += 4];
        ++offset;
        int len = rpb.pixBufferWidth * rpb.pixBufferHeight;
        switch (type) {
            case 2: {
                if (this.spixbuff == null || this.spixbuff.length < len) {
                    this.spixbuff = new short[len];
                }
                int spix_len = len - len % 2;
                int i = 0;
                while (i < spix_len) {
                    int A2 = in[offset + 0] & 0xFF;
                    int val0 = A2 << 4;
                    this.spixbuff[i] = (short)val0;
                    ++i;
                    ++offset;
                }
                rpb.pixBuffer = this.spixbuff;
                break;
            }
            case 0: {
                if (this.spixbuff == null || this.spixbuff.length < len) {
                    this.spixbuff = new short[len];
                }
                int i = 0;
                while (i < len) {
                    short val;
                    this.spixbuff[i] = val = (short)((in[offset + 0] & 0xFF) << 8);
                    ++i;
                    ++offset;
                }
                rpb.pixBuffer = this.spixbuff;
                break;
            }
            case 1: {
                if (this.ipixbuff == null || this.ipixbuff.length < len) {
                    this.ipixbuff = new int[len];
                }
                int[] rgb = new int[3];
                int i = 0;
                while (i < len) {
                    int val;
                    int y = in[offset + 0] & 0xFF;
                    int uv = in[offset + 1] & 0xFF;
                    int u = uv & 0xF0;
                    int v = (uv & 0xF) << 4;
                    SimpleLossyPBCodec.yuv2rgb_int(y, u, v, rgb);
                    this.ipixbuff[i] = val = (rgb[2] << 0) + (rgb[1] << 8) + (rgb[0] << 16) + -16777216;
                    ++i;
                    offset += 2;
                }
                rpb.pixBuffer = this.ipixbuff;
            }
        }
        return offset;
    }

    private int encodePixelBuffer(RmPixelBuffer rpb, byte[] out, int buff_offset) {
        int offset;
        block8: {
            int pixbuffOffset;
            int len;
            Object pixbuff;
            block7: {
                offset = buff_offset;
                Utils.putInt(out, offset, rpb.x0);
                Utils.putInt(out, offset += 4, rpb.y0);
                Utils.putInt(out, offset += 4, rpb.pixBufferWidth);
                Utils.putInt(out, offset += 4, rpb.pixBufferHeight);
                Utils.putInt(out, offset += 4, rpb.xstep);
                Utils.putInt(out, offset += 4, rpb.ystep);
                Utils.putInt(out, offset += 4, rpb.nchannels);
                Utils.putInt(out, offset += 4, rpb.remainingPasses);
                Utils.putInt(out, offset += 4, rpb.mpAlgorithmId);
                offset += 4;
                pixbuff = rpb.pixBuffer;
                len = rpb.pixBufferWidth * rpb.pixBufferHeight;
                pixbuffOffset = rpb.pixBufferOffset;
                if (!(pixbuff instanceof short[])) break block7;
                short[] spixbuff = (short[])pixbuff;
                switch (rpb.bpp) {
                    case 12: {
                        out[offset++] = 2;
                        int i = pixbuffOffset;
                        while (i < pixbuffOffset + len) {
                            short v0 = spixbuff[i];
                            short val0 = v0 < 0 ? (short)0 : v0;
                            out[offset + 0] = (byte)(val0 >> 4);
                            ++i;
                            ++offset;
                        }
                        break block8;
                    }
                    case 16: {
                        out[offset++] = 0;
                        int i = pixbuffOffset;
                        while (i < pixbuffOffset + len) {
                            short val = spixbuff[i];
                            out[offset + 0] = (byte)(val >> 8);
                            ++i;
                            ++offset;
                        }
                        break;
                    }
                }
                break block8;
            }
            out[offset] = 1;
            ++offset;
            int[] ipixbuff = (int[])pixbuff;
            int[] yuv = new int[3];
            int i = pixbuffOffset;
            while (i < pixbuffOffset + len) {
                int val = ipixbuff[i];
                SimpleLossyPBCodec.rgb2yuv_int(val, yuv);
                out[offset + 1] = (byte)(yuv[1] & 0xF0 | (yuv[2] & 0xF0) >> 4);
                out[offset + 0] = (byte)yuv[0];
                ++i;
                offset += 2;
            }
        }
        return offset;
    }

    private static void yuv2rgb(float y, float u, float v, float[] rgb) {
        float r = y + v * 1.13983f;
        float g = y + -0.39465f * u + -0.5806f * v;
        float b = y + 2.03211f * u;
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
    }

    private static void rgb2yuv(float r, float g, float b, float[] yuv) {
        float Y = 0.299f * r + 0.587f * g + 0.114f * b;
        float U = -0.14713f * r + -0.28886f * g + 0.436f * b;
        float V = (float)((double)(0.615f * r + -0.51499f * g) + -0.10001 * (double)b);
        System.err.println("yuv: " + Y + " " + U + " " + V);
        yuv[0] = Y;
        yuv[1] = U;
        yuv[2] = V;
    }

    private static void yuv2rgb_int(int y, int u, int v, int[] rgb) {
        int r = Math.min(9535 * (y - 16) + 13074 * (v - 128) >> 13, 255);
        int g = Math.min(9535 * (y - 16) - 6660 * (v - 128) - 3203 * (u - 128) >> 13, 255);
        int b = Math.min(9535 * (y - 16) + 16531 * (u - 128) >> 13, 255);
        rgb[0] = r < 0 ? 0 : r;
        rgb[1] = g < 0 ? 0 : g;
        rgb[2] = b < 0 ? 0 : b;
    }

    private static void rgb2yuv_int(int rgb, int[] yuv) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int Y = Math.min(Math.abs(r * 2104 + g * 4130 + b * 802 + 4096 + 131072) >> 13, 235);
        int U = Math.min(Math.abs(r * -1214 + g * -2384 + b * 3598 + 4096 + 0x100000) >> 13, 240);
        int V = Math.min(Math.abs(r * 3598 + g * -3013 + b * -585 + 4096 + 0x100000) >> 13, 240);
        yuv[0] = Y;
        yuv[1] = U;
        yuv[2] = V;
    }

    public static void main(String[] args) {
        int[] colors = new int[]{-65536, -16711936, -16776961, -65281};
        int[] iyuv = new int[3];
        int[] irgb = new int[3];
        float[] yuv = new float[3];
        float[] rgb = new float[3];
        for (int i = 0; i < colors.length; ++i) {
            int rgbval = colors[i];
            int r = rgbval >> 16 & 0xFF;
            int g = rgbval >> 8 & 0xFF;
            int b = rgbval & 0xFF;
            SimpleLossyPBCodec.rgb2yuv_int(rgbval, iyuv);
            iyuv[1] = iyuv[1] & 0xF0;
            iyuv[2] = iyuv[2] & 0xF0;
            SimpleLossyPBCodec.yuv2rgb_int(iyuv[0], iyuv[1], iyuv[2], irgb);
            SimpleLossyPBCodec.rgb2yuv((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, yuv);
            SimpleLossyPBCodec.yuv2rgb(yuv[0], yuv[1], yuv[2], rgb);
            float fr = rgb[0] * 255.0f;
            float fg = rgb[1] * 255.0f;
            float fb = rgb[2] * 255.0f;
            System.err.println(">>>>> float: " + r + " " + g + " " + b + " | " + fr + " " + fg + " " + fb);
            System.err.println("----------------------------");
        }
    }
}

