/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.session;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.terra.jami.j3d.remote.Rm3DClientServerIF;
import com.ge.med.terra.jami.j3d.remote.Rm3DDispatcher;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.jami.remote.RmRenderConnection;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.remote.RmServerDataManager;
import com.ge.med.terra.jami.remote.ServerImageSet;
import com.ge.med.terra.jami.remote.codec.PassThruPBCodec;
import com.ge.med.terra.jami.remote.session.WSCaller;
import com.ge.med.terra.jami.remote.session.WSImageSet;
import com.ge.med.terra.jami.remote.session.WSVolume;
import com.ge.med.terra.jami.render.remote.Rm2DClientDispatcher;
import com.ge.med.terra.jami.render.remote.Rm2DClientServerIF;
import com.ge.med.terra.jami.render.remote.Rm2DServerDispatcher;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class WSRenderSession
implements RmRenderSession {
    private String hostname = "localhost";
    private int portno = -1;
    private WSCaller caller = null;
    private static int connectionIdCnt = 0;
    private Map<Integer, XjDicomObject> serverData = new HashMap<Integer, XjDicomObject>();
    private Map<Integer, WSConnection> connectionMap = new HashMap<Integer, WSConnection>();

    public WSRenderSession(String hostname, int port) {
        this.hostname = hostname;
        this.portno = port;
    }

    protected WSRenderSession() {
    }

    protected abstract WSCaller createConnector(String var1, int var2);

    private WSCaller getCaller() {
        if (this.caller == null) {
            this.caller = this.createConnector(this.hostname, this.portno);
        }
        return this.caller;
    }

    @Override
    public RmRenderConnection createConnection(String connectionType, String[] args) {
        WSConnection crc = null;
        if (connectionType.equalsIgnoreCase("3D")) {
            crc = new WS3DRenderConnection(this.getCaller(), args[0]);
        } else if (connectionType.equalsIgnoreCase("2D")) {
            crc = new WS2DRenderConnection(this.getCaller(), args[0]);
        }
        return crc;
    }

    public int __createRemoteRendering(String connectType, String engineName) {
        int newConnectionId = connectionIdCnt++;
        if (connectType.equals("2D")) {
            WS2DRenderConnection rc = new WS2DRenderConnection(newConnectionId);
            int engineId = rc.__createRemoteEngine(engineName);
            this.connectionMap.put(newConnectionId, rc);
        } else if (connectType.equals("3D")) {
            WS3DRenderConnection rc = new WS3DRenderConnection(newConnectionId);
            int engineId = rc.__createRemoteEngine(engineName);
            this.connectionMap.put(newConnectionId, rc);
        }
        System.err.println(">>> Created remote connection: [" + newConnectionId + "] -- " + this.connectionMap.get(newConnectionId));
        return newConnectionId;
    }

    protected WSConnection getConnection(int connectionId) {
        return this.connectionMap.get(connectionId);
    }

    private static void printVolumeInfo(XjVolumeInfo vol) {
        int[] dims = vol.getVolumeDimensions(null);
        System.err.println(Arrays.toString(dims));
        System.err.println(vol.getBitsPerVoxel());
        System.err.println(Arrays.toString(vol.getXDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getYDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getZDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getRASOfOrigin(null)));
        System.err.println(vol.getRelatedComposite());
        System.err.println(vol.getValue(40, 16));
        System.err.println(vol.getValue(16, 16));
        System.err.println(vol.getVSliceValue(2, 16, 16));
        System.err.println("============================================");
    }

    @Override
    public Object getRemoteData(String[] args) {
        if (args[0].equalsIgnoreCase("volume")) {
            WSVolume vol = new WSVolume(this.getCaller(), args[1]);
            WSRenderSession.printVolumeInfo(vol);
            return vol;
        }
        if (args[0].equalsIgnoreCase("images")) {
            WSImageSet imgSet = new WSImageSet(this.getCaller(), args[1]);
            XjImage[] imgs = imgSet.getImages();
            return imgs;
        }
        return null;
    }

    @Override
    public void close() {
    }

    protected int __newVolume(String volumePath) {
        DMSession dms = new DMSession(new String[]{"file", volumePath});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
        int id = RmServerDataManager.instance().addDataObject(vol);
        this.serverData.put(id, vol);
        return id;
    }

    protected int __newImageSet(String imgPath) {
        DMSession dms = new DMSession(new String[]{"file", imgPath});
        DMObject[] dmo = dms.getRelated("series");
        XjImage[] imgs = dmo[0].getImages(null);
        ServerImageSet sis = new ServerImageSet(imgs);
        int id = RmServerDataManager.instance().addDataObject(sis.getMedicalImages());
        this.serverData.put(id, sis);
        return id;
    }

    protected XjDicomObject getData(int id) {
        return this.serverData.get(id);
    }

    public String getRemoteHost() {
        return this.hostname;
    }

    public int getRemotePortNo() {
        return this.portno;
    }

    protected static class WSVolumeInfo
    implements XjVolumeInfo {
        private int[] dims = null;
        private double[] ulhc = null;
        private double[] xdir = null;
        private double[] ydir = null;
        private double[] zdir = null;
        private WSCaller caller = null;
        private int bpp = 0;
        private int pixelType = 1;
        private String fpath = null;

        public WSVolumeInfo(int bpp, int pixType, int[] dims, double[] ulhc, double[] xdir, double[] ydir, double[] zdir, String fpath) {
            this.dims = dims;
            this.ulhc = ulhc;
            this.xdir = xdir;
            this.ydir = ydir;
            this.zdir = zdir;
            this.bpp = bpp;
            this.pixelType = pixType;
            this.fpath = fpath;
        }

        @Override
        public int getBitsPerVoxel() {
            return this.bpp;
        }

        @Override
        public int getPixelType() {
            return this.pixelType;
        }

        @Override
        public Object getVSliceValue(int sliceNo, int group, int element) {
            return null;
        }

        @Override
        public Object getValue(int group, int element) {
            return this.getVSliceValue(0, group, element);
        }

        @Override
        public int getValues(XjTagValue[] tv) {
            return 0;
        }

        @Override
        public String getRelatedComposite() {
            return this.fpath;
        }

        @Override
        public int[] getVolumeDimensions(int[] dims) {
            if (dims == null) {
                dims = new int[3];
            }
            System.arraycopy(this.dims, 0, dims, 0, 3);
            return dims;
        }

        @Override
        public double[] getRASOfOrigin(double[] ras_ulc) {
            double[] v = ras_ulc;
            if (v == null) {
                v = new double[3];
            }
            System.arraycopy(this.ulhc, 0, v, 0, 3);
            return v;
        }

        @Override
        public double[] getXDirectionRAS(double[] ras_dx) {
            double[] v = ras_dx;
            if (v == null) {
                v = new double[3];
            }
            System.arraycopy(this.xdir, 0, v, 0, 3);
            return v;
        }

        @Override
        public double[] getYDirectionRAS(double[] ras_dy) {
            double[] v = ras_dy;
            if (v == null) {
                v = new double[3];
            }
            System.arraycopy(this.ydir, 0, v, 0, 3);
            return v;
        }

        @Override
        public double[] getZDirectionRAS(double[] ras_dz) {
            double[] v = ras_dz;
            if (v == null) {
                v = new double[3];
            }
            System.arraycopy(this.zdir, 0, v, 0, 3);
            return v;
        }
    }

    protected static class WS3DRenderConnection
    extends WSConnection
    implements RmRenderConnection,
    Rm3DClientServerIF,
    Rm3DDispatcher.RemoteCaller {
        private Rm3DDispatcher dispatcher = new Rm3DDispatcher(this);
        private byte[] cache_buff = null;
        private ByteBuffer cache_bb = null;

        public WS3DRenderConnection(WSCaller caller, String rengineClass) {
            super(caller);
            int id = this.createRemoteEngine(rengineClass);
            this.setId(id);
        }

        public WS3DRenderConnection(int id) {
            super(id);
        }

        public int createRemoteEngine(String rengineClass) {
            return this.openConnection("3D", rengineClass);
        }

        public int __createRemoteEngine(String rengine) {
            int rengineId = this.dispatcher.createEngine(rengine);
            return rengineId;
        }

        public Object rmcommand(RmCommand rmc) {
            return this.dispatcher.remoteCommand(rmc);
        }

        @Override
        public ByteBuffer __rmcommand(byte[] in) {
            int offset;
            ByteBuffer bb = this.dispatcher.processCommand(in);
            if (bb != null && (offset = bb.position()) > 0) {
                int len = bb.remaining();
                if (this.cache_buff == null || this.cache_buff.length < len) {
                    this.cache_buff = new byte[len];
                    this.cache_bb = ByteBuffer.wrap(this.cache_buff, 0, len);
                }
                byte[] data = bb.array();
                System.arraycopy(data, offset, this.cache_buff, 0, len);
                bb = this.cache_bb;
            }
            return bb;
        }

        @Override
        public byte[] call(byte[] data, int offset, int length) {
            return this.rmcommand(data, offset, length);
        }

        @Override
        public Object execute(RmCommand cmd) {
            return this.rmcommand(cmd);
        }

        @Override
        public void close() {
        }

        @Override
        public String[] getSupportedCodecs() {
            return (String[])this.rmcommand(new RmCommand(35, null));
        }

        @Override
        public RmPixelBuffer render(int renderOutputLayer, int passno, byte renderType) {
            byte[] pbstream = (byte[])this.rmcommand(new RmCommand(5, new Object[]{new Integer(renderOutputLayer), new Integer(passno), new Byte(renderType)}, true));
            return this.getPBCodec().decode(pbstream, 0, pbstream.length);
        }

        @Override
        public boolean setCodec(String codecName) {
            Class<?> codecClass = null;
            String currCodec = this.getCodec();
            try {
                codecClass = Class.forName(codecName);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            String[] supportedCodecs = this.getSupportedCodecs();
            boolean found = false;
            for (int i = 0; i < supportedCodecs.length; ++i) {
                if (!supportedCodecs[i].equals(codecName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            boolean success = (Boolean)this.rmcommand(new RmCommand(36, new Object[]{codecName}));
            if (success) {
                try {
                    Constructor<?> con = codecClass.getConstructor(null);
                    this.setPBCodec((RmPixelBufferCodec)con.newInstance(null));
                }
                catch (Exception e) {
                    success = false;
                    this.rmcommand(new RmCommand(36, new Object[]{currCodec}));
                }
            }
            return success;
        }
    }

    protected static class WS2DRenderConnection
    extends WSConnection
    implements RmRenderConnection,
    Rm2DClientServerIF,
    Rm2DClientDispatcher.RemoteCaller {
        private Rm2DClientDispatcher clientDispatcher = new Rm2DClientDispatcher(this);
        private Rm2DServerDispatcher serverDispatcher = new Rm2DServerDispatcher();

        public WS2DRenderConnection(WSCaller caller, String rengineClass) {
            super(caller);
            int id = this.createRemoteEngine(rengineClass);
            this.setId(id);
        }

        public WS2DRenderConnection(int id) {
            super(id);
        }

        public int createRemoteEngine(String rengineClass) {
            return this.openConnection("2D", rengineClass);
        }

        public int __createRemoteEngine(String rengine) {
            int rengineId = this.serverDispatcher.createEngine(rengine);
            return rengineId;
        }

        public Object rmcommand(RmCommand rmc) {
            return this.clientDispatcher.remoteCommand(rmc);
        }

        @Override
        public ByteBuffer __rmcommand(byte[] in) {
            return this.serverDispatcher.processCommand(in);
        }

        @Override
        public byte[] call(byte[] data, int offset, int length) {
            return this.rmcommand(data, offset, length);
        }

        @Override
        public Object execute(RmCommand cmd) {
            return this.rmcommand(cmd);
        }

        @Override
        public String[] getSupportedCodecs() {
            return (String[])this.rmcommand(new RmCommand(13, null));
        }

        @Override
        public RmPixelBuffer render(int renderOutputLayer, int passno, byte renderType) {
            byte[] pbstream = (byte[])this.rmcommand(new RmCommand(1, new Object[]{new Integer(renderOutputLayer), new Integer(passno), new Byte(renderType)}, true));
            return this.getPBCodec().decode(pbstream, 0, pbstream.length);
        }

        @Override
        public boolean setCodec(String codecName) {
            Class<?> codecClass = null;
            String currCodec = this.getCodec();
            try {
                codecClass = Class.forName(codecName);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            String[] supportedCodecs = this.getSupportedCodecs();
            boolean found = false;
            for (int i = 0; i < supportedCodecs.length; ++i) {
                if (!supportedCodecs[i].equals(codecName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            boolean success = (Boolean)this.rmcommand(new RmCommand(14, new Object[]{codecName}));
            if (success) {
                try {
                    Constructor<?> con = codecClass.getConstructor(null);
                    this.setPBCodec((RmPixelBufferCodec)con.newInstance(null));
                }
                catch (Exception e) {
                    success = false;
                    this.rmcommand(new RmCommand(14, new Object[]{currCodec}));
                }
            }
            return success;
        }
    }

    protected static abstract class WSConnection
    implements RmRenderConnection {
        public static final byte CREATE_RENDERENGINE = 0;
        public static final byte RMCOMMAND = 1;
        private List tmonitors = new ArrayList();
        private int id = -1;
        private RmPixelBufferCodec codec = new PassThruPBCodec();
        private WSCaller caller = null;

        public WSConnection(WSCaller caller) {
            this.caller = caller;
        }

        public WSConnection(int id) {
            this.setId(id);
        }

        @Override
        public void addTaskMonitor(TaskMonitor tm) {
            this.tmonitors.add(tm);
        }

        @Override
        public void removeTaskMonitor(TaskMonitor tm) {
            this.tmonitors.remove(tm);
        }

        @Override
        public int getId() {
            return this.id;
        }

        protected void setId(int id) {
            this.id = id;
        }

        @Override
        public void close() {
            this.caller.closeConnection();
        }

        @Override
        public String getCodec() {
            if (this.codec != null) {
                return this.codec.getName();
            }
            return null;
        }

        public RmPixelBufferCodec getPBCodec() {
            return this.codec;
        }

        public void setPBCodec(RmPixelBufferCodec codec) {
            this.codec = codec;
        }

        public byte[] rmcommand(byte[] args, int offset, int length) {
            return this.caller.remoteCommand(this.getId(), args, offset, length);
        }

        public int openConnection(String connectionType, String remoteEngine) {
            return this.caller.openConnection(connectionType, remoteEngine);
        }

        public abstract ByteBuffer __rmcommand(byte[] var1);
    }
}

