/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmRenderConnection;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.remote.Base2DRenderEngine;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public class RmClient2DEngine
extends Base2DRenderEngine
implements IterativeRenderer {
    private RmRenderConnection rconnection = null;
    private ClientMultiPassAlgorithm client_mp = new ClientMultiPassAlgorithm(this);
    private short[] zbuffer = null;
    private ParallelTaskManager tp = null;
    private boolean fitToViewport = true;
    private AffineTransform transform = new AffineTransform();
    private CTransform img2display = new CTransform();
    private CTransform display2img = new CTransform();
    private long renderTimeStamp = 0L;
    private XpImage image = null;
    private boolean transformDirty = true;
    private Rectangle lastViewport = new Rectangle();
    private int imgWidth = 0;
    private int imgHeight = 0;
    private XpGeomUtils gu = new XpGeomUtils();

    public RmClient2DEngine(RmRenderSession serverSession, String remoteRenderer) {
        this.rconnection = serverSession.createConnection("2D", new String[]{remoteRenderer});
        if (this.rconnection == null) {
            throw new RuntimeException("Invalid 2D-remote renderer: " + remoteRenderer + ", cannot create connection.");
        }
        this.transform.setToIdentity();
        this.img2display.loadIdentity();
        this.display2img.loadIdentity();
        this.tp = new ParallelTaskManager();
        Class[] mpalg = (Class[])this.rconnection.execute(new RmCommand(10, null, true));
        this.client_mp.setFillAlgorithmTable(mpalg);
    }

    public void dispose() {
        this.rconnection.close();
    }

    @Override
    public void shutdown() {
        this.dispose();
        this.tp.destroy();
    }

    private void computeTransform(Rectangle viewport) {
        try {
            if (this.transformDirty || !viewport.equals(this.lastViewport)) {
                int w = this.imgWidth;
                int h = this.imgHeight;
                double azimuth = this.image.getAzimuth();
                double px = this.image.getPixelDimensionX();
                double py = this.image.getPixelDimensionY();
                this.gu.calcAffineTransform(viewport, this.getImageRenderAttributes(), w, h, azimuth, this.fitToViewport, px, py, this.transform);
                this.img2display.load(this.transform);
                this.img2display.inverse(this.display2img);
                this.transformDirty = false;
                this.lastViewport.setBounds(viewport);
            }
        }
        catch (Exception e) {
            System.err.println(">>>> BAD Matrix: " + this.transform + "  w=" + this.imgWidth + " imgHeight=" + this.imgHeight);
        }
    }

    public AffineTransform getAffineTransform() {
        int owidth = this.getBufferWidth();
        int oheight = this.getBufferHeight();
        this.computeTransform(new Rectangle(0, 0, owidth, oheight));
        return this.transform;
    }

    public final XpImageOrientation getDisplayOrientation() {
        return this.getImageRenderAttributes().getImageOrientation();
    }

    public final void setFitToViewport(boolean fToViewport) {
        this.rconnection.execute(new RmCommand(2, new Object[]{new Boolean(fToViewport)}));
        this.fitToViewport = fToViewport;
    }

    public final boolean getFitToViewport() {
        Boolean val = (Boolean)this.rconnection.execute(new RmCommand(3, null));
        return val;
    }

    public CTransform getTransform(byte in, byte out) {
        int owidth = this.getBufferWidth();
        int oheight = this.getBufferHeight();
        this.computeTransform(new Rectangle(0, 0, owidth, oheight));
        if (in == out) {
            return CTransform.Identity;
        }
        if (in == 0 && out == 1) {
            return this.img2display;
        }
        if (in == 1 && out == 0) {
            return this.display2img;
        }
        return null;
    }

    public final XpImage getFrame() {
        return this.image;
    }

    public final void setImage(XpImage image) {
        this.image = image;
        if (image != null) {
            this.imgWidth = image.getSlice().width;
            this.imgHeight = image.getSlice().height;
            this.rconnection.execute(new RmCommand(4, new Object[]{image}));
        } else {
            this.imgWidth = 0;
            this.imgHeight = 0;
        }
    }

    public void setImageLayers(List imgLayers) {
        if (imgLayers != null) {
            throw new UnsupportedOperationException();
        }
    }

    public int getImageLayer() {
        Integer val = (Integer)this.rconnection.execute(new RmCommand(5, null));
        return val;
    }

    public void selectImageLayer(int layer) {
        this.rconnection.execute(new RmCommand(12, new Object[]{new Integer(layer)}));
    }

    public XpImagePixelAttributes getImagePixelAttributes(int layer) {
        return this.getImageRenderAttributes().getImagePixelAttributes();
    }

    public final Object getInterpolationHint() {
        return RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    }

    public final void setInterpolationHint(Object interpolationHint) {
    }

    public int getNumImageLayers() {
        Integer val = (Integer)this.rconnection.execute(new RmCommand(6, null));
        return val;
    }

    public long getRenderTimeStamp() {
        return this.renderTimeStamp;
    }

    public boolean isFusionCapable() {
        return false;
    }

    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        throw new UnsupportedOperationException();
    }

    public XjFusionPixelCombiner getPixelCombiner() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        super.setImageRenderAttributes(attr);
        this.transformDirty = true;
        this.rconnection.execute(new RmCommand(7, new Object[]{attr}));
    }

    public Shape getClipShape() {
        return this.getImageRenderAttributes().getClipShape();
    }

    public void setClipShape(Shape clipShape) {
        this.getImageRenderAttributes().setClipShape(clipShape);
    }

    public final void setImageClip(Shape s) {
        this.getImageRenderAttributes().setImageClip(s);
    }

    public final Shape getImageClip() {
        return this.getImageRenderAttributes().getImageClip();
    }

    public final void setClipGraphics(boolean clipGraphics) {
        this.rconnection.execute(new RmCommand(8, new Object[]{new Boolean(clipGraphics)}));
    }

    @Override
    public void setOutput(int[] rgbBuff, int width, int height) {
        super.setOutput(rgbBuff, width, height);
        this.rconnection.execute(new RmCommand(9, new Object[]{new Integer(width), new Integer(height)}));
        this.zbuffer = new short[width * height];
    }

    @Override
    public XpMedicalImage getMedicalImage() {
        if (this.image instanceof XpMedicalImage) {
            return (XpMedicalImage)this.image;
        }
        return null;
    }

    @Override
    public short[] getZBuffer() {
        return this.zbuffer;
    }

    @Override
    public void clearBuffers() {
        super.clearBuffers();
        Arrays.fill(this.zbuffer, (short)0);
        this.rconnection.execute(new RmCommand(11, null));
    }

    @Override
    public Object createThreadData() {
        return null;
    }

    @Override
    public void renderPixels(int thread_id, int renderOutputLayer, int x0, int y0, int width, int height, int stepx, int stepy, Object thread_data) {
    }

    @Override
    public int renderPixel(int thread_id, int renderOutputLayer, int x, int y, Object thread_data) {
        return 0;
    }

    @Override
    public int getNumOutputLayers() {
        return 0;
    }

    @Override
    public boolean isRenderChange() {
        return false;
    }

    @Override
    public MultipassAlgorithm[] getSupportedMultipassAlgorithms() {
        return new MultipassAlgorithm[]{this.client_mp};
    }

    @Override
    public MultipassAlgorithm getMultipassAlgorithm(int renderOutputLayer) {
        return this.client_mp;
    }

    public ParallelTaskManager getParallelTaskManager() {
        return this.tp;
    }

    public int renderPass(int layer, int passno) {
        RmPixelBuffer rpb = this.rconnection.render(layer, passno, (byte)55);
        this.client_mp.setFillAlgorithm(rpb.mpAlgorithmId);
        rpb.decodeMultipass(this);
        return rpb.remainingPasses;
    }

    @Override
    public void render(int renderOutputLayer) {
        RmPixelBuffer rpb = this.rconnection.render(renderOutputLayer, 0, (byte)56);
        rpb.decodeMultipass(this);
    }

    private static class ClientMultiPassAlgorithm
    implements MultipassAlgorithm {
        private IterativeRenderer renderer = null;
        private RmClient2DEngine c2d = null;
        private MultipassAlgorithm[] filler = null;
        private int fillerIdx = -1;

        public ClientMultiPassAlgorithm(RmClient2DEngine c2d) {
            this.c2d = c2d;
        }

        @Override
        public void shutdown() {
            this.renderer = null;
            this.c2d = null;
            for (MultipassAlgorithm multipassAlgorithm : this.filler) {
                multipassAlgorithm.shutdown();
            }
            this.filler = null;
        }

        public void setFillAlgorithm(int fillIdx) {
            this.fillerIdx = fillIdx;
        }

        public void setFillAlgorithmTable(Class[] mpalg) {
            this.filler = new MultipassAlgorithm[mpalg.length];
            for (int i = 0; i < mpalg.length; ++i) {
                this.filler[i] = this.createFillAlgorithm(mpalg[i]);
            }
        }

        private MultipassAlgorithm createFillAlgorithm(Class fillerClass) {
            Constructor c = null;
            MultipassAlgorithm filler_alg = null;
            try {
                c = fillerClass.getConstructor(ParallelTaskManager.class);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (c != null) {
                try {
                    filler_alg = (MultipassAlgorithm)c.newInstance(this.c2d.getParallelTaskManager());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    c = fillerClass.getConstructor(null);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                try {
                    if (c != null) {
                        filler_alg = (MultipassAlgorithm)c.newInstance(null);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (filler_alg != null) {
                filler_alg.setT3DIRenderer(this.c2d);
            }
            return filler_alg;
        }

        @Override
        public int render(int x, int y, int w, int h, int renderOutputLayer, int passno) {
            return this.c2d.renderPass(renderOutputLayer, passno);
        }

        @Override
        public void fill(int x, int y, int w, int h, int renderOutputLayer, int passno) {
            this.filler[this.fillerIdx].fill(x, y, w, h, renderOutputLayer, passno);
        }

        @Override
        public void setT3DIRenderer(IterativeRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public IterativeRenderer getT3DIRenderer() {
            return this.renderer;
        }

        @Override
        public String getDescriptor() {
            return this.getClass().getCanonicalName();
        }
    }
}

