/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;

public class XpRectangularRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    protected static boolean badscreendual;
    private static int INNER_TOLERANCE;
    private static int OUTER_TOLERANCE;
    private static boolean DO_ROTATE;
    private transient XpHandle[] handles = null;
    private transient JComponent[] r = null;
    private transient RectangularShape rs = null;
    private transient RectangularShape drawRs = null;
    private transient RectangularShape outerShape = null;
    private transient RectangularShape innerShape = null;
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient Point2D tmpPoint2 = new Point2D.Double();
    private transient Point2D tmpPoint3 = new Point2D.Double();
    private transient Point2D tmpPoint4 = new Point2D.Double();
    private AffineTransform at = new AffineTransform();
    private CPoint cpDisp = new CPoint(1);
    private CPoint cpImg = new CPoint(0);
    private ContainmentCache ccache = new ContainmentCache();
    private boolean dirtyContains = true;
    private transient XpGeomUtils gu = new XpGeomUtils();
    private AffineTransform invT = new AffineTransform();
    protected transient RectangularShape accumRS = null;
    private boolean idealStatistics = false;
    private boolean squareConstraints = false;
    private transient Point2D cnt = new Point2D.Double();

    public XpRectangularRoi(RectangularShape rs) {
        super(rs);
        this.init(rs);
    }

    public XpRectangularRoi(RoiShapeModel ss) {
        super(ss);
        this.init((RectangularShape)ss.getShape());
    }

    private void init(RectangularShape rs) {
        this.rs = rs;
        this.drawRs = (RectangularShape)rs.clone();
        this.outerShape = (RectangularShape)rs.clone();
        this.innerShape = (RectangularShape)rs.clone();
        this.createHandles();
    }

    @Override
    protected void copyObject(Object o) {
        XpRectangularRoi rr = (XpRectangularRoi)o;
        super.copyObject(rr);
        rr.idealStatistics = this.idealStatistics;
        rr.squareConstraints = this.squareConstraints;
    }

    public double getIdealLength() {
        return 0.0;
    }

    public double getIdealArea() {
        return 0.0;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.rs.getBounds2D();
    }

    public final XpHandle getHandle(int idx) {
        if (this.handles != null && idx >= 0 && idx < this.handles.length) {
            return this.handles[idx];
        }
        return null;
    }

    protected final void setSquareConstraints(boolean squareConstraints) {
        this.squareConstraints = squareConstraints;
    }

    protected final boolean getSquareConstraints() {
        return this.squareConstraints;
    }

    public final void getFrame(Rectangle2D r) {
        double x = this.rs.getX();
        double y = this.rs.getY();
        double w = this.rs.getWidth();
        double h = this.rs.getHeight();
        r.setFrame(x, y, w, h);
    }

    public final Rectangle2D getFrame() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        this.getFrame(r);
        return r;
    }

    public void setFrame(double x, double y, double w, double h) {
        XpSlice sl = this.getImage().getSlice();
        double X1 = 0.0;
        double Y1 = 0.0;
        double X2 = sl.width;
        double Y2 = sl.height;
        Rectangle2D domain = this.getDomain();
        if (domain != null) {
            X1 = domain.getX();
            Y1 = domain.getY();
            X2 = X1 + domain.getWidth();
            Y2 = Y1 + domain.getHeight();
        }
        double x2 = x + w;
        double y2 = y + h;
        if (x < X1 || x >= X2 || x2 < X1 || x2 >= X2) {
            x = this.rs.getX();
            w = this.rs.getWidth();
        }
        if (y < Y1 || y >= Y2 || y2 < Y1 || y2 >= Y2) {
            y = this.rs.getY();
            h = this.rs.getHeight();
        }
        this.rs.setFrame(x, y, w, h);
        this.syncModel();
    }

    @Override
    public final void getCenter(Point2D center) {
        double x = this.rs.getX();
        double y = this.rs.getY();
        double w = this.rs.getWidth();
        double h = this.rs.getHeight();
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        center.setLocation(cx, cy);
    }

    @Override
    public Shape getDrawShape() {
        return this.drawRs;
    }

    @Override
    protected void updateHandles() {
        super.updateHandles();
        double x = this.rs.getX();
        double y = this.rs.getY();
        double w = this.rs.getWidth();
        double h = this.rs.getHeight();
        this.getRotatedPoint(x, y, this.handles[0]);
        this.getRotatedPoint(x + w, y, this.handles[1]);
        this.getRotatedPoint(x + w, y + h, this.handles[2]);
        this.getRotatedPoint(x, y + h, this.handles[3]);
        if (DO_ROTATE) {
            this.getRotatedPoint(x + w / 2.0, y, this.handles[4]);
            this.getRotatedPoint(x + w / 2.0, y + h, this.handles[5]);
            this.getRotatedPoint(x, y + h / 2.0, this.handles[6]);
            this.getRotatedPoint(x + w, y + h / 2.0, this.handles[7]);
        }
    }

    private void createHandles() {
        if (this.r == null) {
            int nHandles = 8;
            if (!DO_ROTATE) {
                nHandles = 4;
            }
            this.handles = new XpHandle[nHandles];
            int len = this.handles.length;
            for (int i = 0; i < len; ++i) {
                this.handles[i] = new XpHandle((XpAnchorable)this, i, 16);
                this.add(this.handles[i]);
                this.handles[i].setFilled(false);
            }
            if (DO_ROTATE) {
                this.handles[4].setShape(XpHandle.HANDLE_CROSSHAIR, XpHandle.HANDLE_BOX);
                this.handles[5].setShape(XpHandle.HANDLE_CROSSHAIR, XpHandle.HANDLE_BOX);
                this.handles[6].setShape(XpHandle.HANDLE_CROSSHAIR, XpHandle.HANDLE_BOX);
                this.handles[7].setShape(XpHandle.HANDLE_CROSSHAIR, XpHandle.HANDLE_BOX);
            }
            this.updateHandles();
        }
    }

    @Override
    public String createRoiStatLabel(XpPixelStatistics ps) {
        String roiStat = "";
        if (ps != null) {
            double mean = ps.getMean();
            double var = ps.getVariance();
            double stddev = Math.sqrt(var);
            double area = this.isIdealStatistics() ? this.getIdealArea() : this.getArea();
            roiStat = this.getRoiLabel() + ": m " + this.statFormat(mean) + ", sd " + this.statFormat(stddev) + ", a " + this.statFormat(area) + " mm2";
        }
        return roiStat;
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int xx, int yy) {
        Rectangle2D bounds;
        if (this.dirtyContains) {
            if (vc == null) {
                return false;
            }
            RectangularShape rs = (RectangularShape)this.getModelShape();
            double x1 = rs.getX();
            double y1 = rs.getY();
            double iw = rs.getWidth();
            double ih = rs.getHeight();
            double x2 = x1 + iw;
            double y2 = y1;
            double x3 = x1;
            double y3 = y1 + ih;
            double x4 = x1 + iw;
            double y4 = y1 + ih;
            this.cpImg.x = x1;
            this.cpImg.y = y1;
            vc.transform(this.cpImg, this.cpDisp, (byte)1);
            this.cpImg.x = x2;
            this.cpImg.y = y2;
            vc.transform(this.cpImg, this.cpDisp, (byte)1);
            this.cpImg.x = x3;
            this.cpImg.y = y3;
            vc.transform(this.cpImg, this.cpDisp, (byte)1);
            this.cpImg.x = x4;
            this.cpImg.y = y4;
            vc.transform(this.cpImg, this.cpDisp, (byte)1);
            double x = this.drawRs.getX();
            double y = this.drawRs.getY();
            double w = this.drawRs.getWidth();
            double h = this.drawRs.getHeight();
            int hIT = INNER_TOLERANCE / 2;
            int hOT = OUTER_TOLERANCE / 2;
            this.outerShape.setFrame(x - (double)hOT, y - (double)hOT, w + (double)OUTER_TOLERANCE, h + (double)OUTER_TOLERANCE);
            this.innerShape.setFrame(x + (double)hIT, y + (double)hIT, w - (double)INNER_TOLERANCE, h - (double)INNER_TOLERANCE);
            this.dirtyContains = false;
        }
        double w = this.ccache.w;
        double h = this.ccache.h;
        this.getRotatedPoint(xx, yy, -this.ccache.angle, this.ccache.cx, this.ccache.cy, this.tmpPoint1);
        boolean contained = this.outerShape.contains(this.tmpPoint1);
        if (contained && w > 6.0 && h > 6.0) {
            boolean bl = contained = !this.innerShape.contains(this.tmpPoint1);
        }
        if (this.isDragByRoiLabel() && !contained && (bounds = this.getRoiLabelBounds()) != null && bounds.contains(xx, yy)) {
            contained = true;
        }
        return contained;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g) {
        double tcy;
        double tcx;
        this.dirtyContains = true;
        double x1 = this.rs.getX();
        double y1 = this.rs.getY();
        double x2 = x1 + this.rs.getWidth();
        double y2 = y1;
        double x3 = x1;
        double y3 = y1 + this.rs.getHeight();
        double x4 = x1 + this.rs.getWidth();
        double y4 = y1 + this.rs.getHeight();
        this.getDisplayPoint(x1, y1, this.tmpPoint1);
        this.getDisplayPoint(x2, y2, this.tmpPoint2);
        this.getDisplayPoint(x3, y3, this.tmpPoint3);
        this.getDisplayPoint(x4, y4, this.tmpPoint4);
        double tx1 = this.tmpPoint1.getX();
        double ty1 = this.tmpPoint1.getY();
        double tx2 = this.tmpPoint2.getX();
        double ty2 = this.tmpPoint2.getY();
        double tx3 = this.tmpPoint3.getX();
        double ty3 = this.tmpPoint3.getY();
        double tx4 = this.tmpPoint4.getX();
        double ty4 = this.tmpPoint4.getY();
        this.ccache.cx = tcx = (tx1 + tx2 + tx3 + tx4) / 4.0;
        this.ccache.cy = tcy = (ty1 + ty2 + ty3 + ty4) / 4.0;
        double dxw = tx2 - tx1;
        double dyw = ty2 - ty1;
        double w = Math.sqrt(dxw * dxw + dyw * dyw);
        double dxh = tx3 - tx1;
        double dyh = ty3 - ty1;
        double h = Math.sqrt(dxh * dxh + dyh * dyh);
        double x = tcx - w / 2.0;
        double y = tcy - h / 2.0;
        double angle = Math.atan(dyw / dxw);
        if (dyw < 0.0 && dxw < 0.0) {
            angle += Math.PI;
        } else if (dxw < 0.0 && dyw > 0.0) {
            angle += Math.PI;
        }
        this.ccache.w = w;
        this.ccache.h = h;
        this.ccache.angle = angle;
        this.at.setToIdentity();
        this.drawRs.setFrame(x, y, w, h);
        this.at.setToRotation(angle, tcx, tcy);
        this.gu.calcInverse(this.at, this.invT);
        g.transform(this.at);
        super.render(vc, g);
        g.transform(this.invT);
        int hidx = 6;
        if (!DO_ROTATE) {
            hidx = 0;
        }
        this.drawRoiId(vc, g, this.handles[hidx]);
    }

    @Override
    protected void dragMouse(CPoint dragV) {
        double x = this.rs.getX() + dragV.x;
        double y = this.rs.getY() + dragV.y;
        double w = this.rs.getWidth();
        double h = this.rs.getHeight();
        this.setFrame(x, y, w, h);
    }

    protected void processAngle(int rotIdx, Point p) {
        this.getCenter(this.cnt);
        double cx = this.cnt.getX();
        double cy = this.cnt.getY();
        this.cpDisp.setLocation(p.getX(), p.getY(), 0.0);
        this.displayToImage(this.cpDisp, this.cpImg);
        double x = this.cpImg.x;
        double y = this.cpImg.y;
        double cAngle = this.getAngle();
        double dx = x - cx;
        double dy = y - cy;
        if (rotIdx == 7 || rotIdx == 6) {
            cAngle = -Math.atan(dy / dx);
        } else if (rotIdx == 4 || rotIdx == 5) {
            cAngle = Math.atan(dx / dy);
        }
        this.setAngle(cAngle);
    }

    @Override
    public void anchorPressed(MouseEvent e, Object jc) {
        XpHandle xph = (XpHandle)jc;
        RectangularShape rs = (RectangularShape)this.getModelShape();
        if (this.accumRS == null) {
            this.accumRS = (RectangularShape)rs.clone();
        } else {
            this.accumRS.setFrame(rs.getX(), rs.getY(), rs.getWidth(), rs.getHeight());
        }
        super.anchorPressed(e, jc);
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object jc) {
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        Point p = e.getPoint();
        double x = this.accumRS.getX();
        double y = this.accumRS.getY();
        double w = this.accumRS.getWidth();
        double h = this.accumRS.getHeight();
        if (handleIdx >= 0 && handleIdx <= 3) {
            double dx = drag.x;
            double dy = drag.y;
            this.getRotatedPoint(dx, dy, this.getAngle(), 0.0, 0.0, this.tmpPoint1);
            dx = this.tmpPoint1.getX();
            dy = this.tmpPoint1.getY();
            if (this.squareConstraints) {
                double dlt = dy;
                switch (handleIdx) {
                    case 0: {
                        x += dlt;
                        y += dlt;
                        w -= 2.0 * dlt;
                        h -= 2.0 * dlt;
                        break;
                    }
                    case 1: {
                        y += dlt;
                        h -= 2.0 * dlt;
                        w -= 2.0 * dlt;
                        x += dlt;
                        break;
                    }
                    case 2: {
                        w += 2.0 * dlt;
                        h += 2.0 * dlt;
                        x -= dlt;
                        y -= dlt;
                        break;
                    }
                    case 3: {
                        x -= dlt;
                        w += 2.0 * dlt;
                        h += 2.0 * dlt;
                        y -= dlt;
                    }
                }
            } else {
                switch (handleIdx) {
                    case 0: {
                        x += dx;
                        y += dy;
                        w -= 2.0 * dx;
                        h -= 2.0 * dy;
                        break;
                    }
                    case 1: {
                        y += dy;
                        h -= 2.0 * dy;
                        w += 2.0 * dx;
                        x -= dx;
                        break;
                    }
                    case 2: {
                        w += 2.0 * dx;
                        h += 2.0 * dy;
                        x -= dx;
                        y -= dy;
                        break;
                    }
                    case 3: {
                        x += dx;
                        w -= 2.0 * dx;
                        h += 2.0 * dy;
                        y -= dy;
                    }
                }
            }
        } else {
            if (badscreendual) {
                int xx = p.x;
                int yy = p.y;
                java.awt.Rectangle bounds = this.getComponentBounds();
                if (bounds.width > 0 && bounds.height > 0) {
                    int width = bounds.width;
                    int height = bounds.height;
                    if (xx < 0) {
                        xx = 0;
                    }
                    if (xx >= width) {
                        xx = width - 1;
                    }
                    if (yy < 0) {
                        yy = 0;
                    }
                    if (yy >= height) {
                        yy = height - 1;
                    }
                    if (xx != p.x || p.y != yy) {
                        super.anchorDragged(e, drag, jc);
                        return;
                    }
                }
            }
            switch (handleIdx) {
                case 4: {
                    this.processAngle(4, p);
                    break;
                }
                case 5: {
                    this.processAngle(5, p);
                    break;
                }
                case 6: {
                    this.processAngle(6, p);
                    break;
                }
                case 7: {
                    this.processAngle(7, p);
                }
            }
        }
        this.accumRS.setFrame(x, y, w, h);
        if (w >= 0.5 && h >= 0.5) {
            this.setFrame(this.accumRS.getX(), this.accumRS.getY(), this.accumRS.getWidth(), this.accumRS.getHeight());
        }
        super.anchorDragged(e, drag, jc);
    }

    @Override
    public GSPSGraphic gspsDescription() {
        return null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        try {
            s.defaultWriteObject();
            if (this.rs instanceof Rectangle2D.Double) {
                s.writeObject(new String("Rectangle2D.Double"));
                s.writeDouble(this.rs.getX());
                s.writeDouble(this.rs.getY());
                s.writeDouble(this.rs.getWidth());
                s.writeDouble(this.rs.getHeight());
            } else if (this.rs instanceof Ellipse2D.Double) {
                s.writeObject(new String("Ellipse2D.Double"));
                s.writeDouble(this.rs.getX());
                s.writeDouble(this.rs.getY());
                s.writeDouble(this.rs.getWidth());
                s.writeDouble(this.rs.getHeight());
            } else if (this.rs instanceof RoundRectangle2D.Double) {
                s.writeObject(new String("RoundRectangle2D.Double"));
                RoundRectangle2D.Double rect = (RoundRectangle2D.Double)this.rs;
                s.writeDouble(rect.getX());
                s.writeDouble(rect.getY());
                s.writeDouble(rect.getWidth());
                s.writeDouble(rect.getHeight());
                s.writeDouble(rect.getArcHeight());
                s.writeDouble(rect.getArcWidth());
            }
            s.writeBoolean(this.isVisible());
            s.writeObject(this.getRoiLabel());
            s.writeObject(this.getColor());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
            String shape = (String)s.readObject();
            RoiShapeModel rsm = null;
            RectangularShape rshape = null;
            if (shape.compareTo("Rectangle2D.Double") == 0) {
                Rectangle2D.Double rect = null;
                rect = new Rectangle2D.Double(s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble());
                rsm = new RoiShapeModel(rect);
                rshape = rect;
            } else if (shape.compareTo("Ellipse2D.Double") == 0) {
                Ellipse2D.Double ellipse = null;
                ellipse = new Ellipse2D.Double(s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble());
                rsm = new RoiShapeModel(ellipse);
                rshape = ellipse;
            } else if (shape.compareTo("RoundRectangle2D.Double") == 0) {
                RoundRectangle2D.Double rrect = null;
                rrect = new RoundRectangle2D.Double(s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble());
                rsm = new RoiShapeModel(rrect);
                rshape = rrect;
            }
            boolean visibility = s.readBoolean();
            String roiLabel = (String)s.readObject();
            Color color = (Color)s.readObject();
            rsm.setVisible(visibility);
            rsm.setRoiLabel(roiLabel);
            rsm.setColor(color);
            this.setRoiShapeModel(rsm);
            this.init(rshape);
            this.tmpPoint1 = new Point2D.Double();
            this.tmpPoint2 = new Point2D.Double();
            this.tmpPoint3 = new Point2D.Double();
            this.tmpPoint4 = new Point2D.Double();
            this.gu = new XpGeomUtils();
            this.cnt = new Point2D.Double();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void setRoiShapeModel(RoiShapeModel shapemodel) {
        super.setRoiShapeModel(shapemodel);
    }

    public boolean isIdealStatistics() {
        return this.idealStatistics;
    }

    public void setIdealStatistics(boolean idealStatistics) {
        this.idealStatistics = idealStatistics;
    }

    static {
        String rotate;
        int[] idims;
        String dims;
        badscreendual = false;
        INNER_TOLERANCE = 12;
        OUTER_TOLERANCE = 10;
        DO_ROTATE = true;
        String dsb = XpPropertiesManager.getProperty("jami.dualscreenbad", "false");
        if (dsb.toLowerCase().equals("true")) {
            badscreendual = true;
        }
        if ((dims = XpPropertiesManager.getProperty("jami.roi.rectangular.tolerance")) != null && (idims = XpPropertiesManager.parseIntList(dims, ", ")) != null && idims.length >= 2) {
            INNER_TOLERANCE = idims[0];
            OUTER_TOLERANCE = idims[1];
        }
        if ((rotate = XpPropertiesManager.getProperty("jami.roi.rectangular.rotate")) != null && rotate.toUpperCase().equals("FALSE")) {
            DO_ROTATE = false;
        }
    }

    private static abstract class RectComponentCreator
    extends XpRoiComponentCreator {
        private int resizeSE = 2;
        private int resizeNW = 0;
        int prevy;

        private RectComponentCreator() {
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            int y = me.getY();
            int handleIdx = this.resizeSE;
            if (y < this.prevy) {
                handleIdx = this.resizeNW;
            }
            if (rrm != null) {
                XpHandle resize = rrm.getHandle(handleIdx);
                resize.handleDragged(me);
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            super.mousePressed(me);
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            this.prevy = me.getY();
            if (rrm != null) {
                XpImageOrientation orientation = this.getImageOrientation();
                int state = orientation.getState();
                boolean flip = orientation.getFlip();
                double radAngle = orientation.getAngle();
                if (flip) {
                    this.resizeSE = 3;
                    this.resizeNW = 1;
                    rrm.setAngle(-radAngle);
                } else {
                    this.resizeSE = 2;
                    this.resizeNW = 0;
                    rrm.setAngle(radAngle);
                }
                XpHandle resize = rrm.getHandle(this.resizeSE);
                resize.handlePressed(me);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            if (rrm != null) {
                XpHandle resize = rrm.getHandle(this.resizeSE);
                resize.handleReleased(me);
                super.mouseReleased(me);
            }
        }
    }

    public static class Circle
    extends Ellipse
    implements Cloneable,
    Serializable {
        public Circle(double cx, double cy, double radius) {
            super(new Ellipse2D.Double(cx - radius, cy - radius, 2.0 * radius, 2.0 * radius));
            this.setSquareConstraints(true);
        }

        public Circle(RoiShapeModel statshape) {
            super(statshape);
        }

        public static ComponentCreator getComponentCreator(int ccid) {
            if (ccid == 0) {
                return new CircleCreator();
            }
            return null;
        }

        @Override
        public double getIdealArea() {
            XpImage img = this.getImage();
            double area = 0.0;
            if (img != null) {
                double pdx = img.getPixelDimensionX();
                RectangularShape rs = (RectangularShape)this.getModelShape();
                double radius = rs.getWidth() * pdx * 0.5;
                area = Math.PI * radius * radius;
            }
            return area;
        }

        @Override
        public double getIdealLength() {
            XpImage img = this.getImage();
            double length = 0.0;
            if (img != null) {
                double pdx = img.getPixelDimensionX();
                RectangularShape rs = (RectangularShape)this.getModelShape();
                double radius = rs.getWidth() * pdx * 0.5;
                length = Math.PI * 2 * radius;
            }
            return length;
        }

        @Override
        public Object clone() {
            Ellipse2D m = (Ellipse2D)this.getModelShape();
            Circle circ = new Circle(m.getX(), m.getY(), m.getWidth());
            this.copyObject(circ);
            return circ;
        }

        private static class CircleCreator
        extends RectComponentCreator {
            private CircleCreator() {
            }

            @Override
            public RoiActor getRoiActor(double x, double y) {
                return new Circle(x, y, 5.0);
            }
        }
    }

    public static class Ellipse
    extends XpRectangularRoi
    implements Cloneable,
    Serializable {
        private transient Point2D gspsTemp = new Point2D.Double();

        public Ellipse(Ellipse2D e) {
            super(e);
        }

        public Ellipse(RoiShapeModel statshape) {
            super(statshape);
        }

        public static ComponentCreator getComponentCreator(int ccid) {
            if (ccid == 0) {
                return new EllipseCreator();
            }
            return null;
        }

        @Override
        public double getIdealArea() {
            XpImage img = this.getImage();
            double area = 0.0;
            if (img != null) {
                double pdx = img.getPixelDimensionX();
                double pdy = img.getPixelDimensionY();
                RectangularShape rs = (RectangularShape)this.getModelShape();
                double pw = rs.getWidth() * pdx;
                double ph = rs.getHeight() * pdy;
                area = Math.PI * pw * ph / 4.0;
            }
            return area;
        }

        @Override
        public double getIdealLength() {
            double len = 0.0;
            XpImage img = this.getImage();
            if (img != null) {
                double b;
                double ph;
                double pdx = img.getPixelDimensionX();
                double pdy = img.getPixelDimensionY();
                RectangularShape rs = (RectangularShape)this.getModelShape();
                double pw = rs.getWidth() / 2.0 * pdx;
                double a = Math.max(pw, ph = rs.getHeight() / 2.0 * pdy);
                if (a == (b = Math.min(pw, ph))) {
                    return Math.PI * 2 * a;
                }
                double ab1 = a - b;
                double ab2 = a + b;
                double h = ab1 * ab1 / (ab2 * ab2);
                double ecc = Math.sqrt(1.0 - b * b / (a * a));
                if (ecc < 0.999) {
                    len = 0.7853981633974483 * (a + b) * (3.0 * (1.0 + h / 4.0) + 1.0 / (1.0 - h / 4.0));
                } else {
                    double s = 0.825056;
                    double s1 = 4.0 * (a + b);
                    double d1 = 1.7168146928204138 * a * b;
                    double sq = Math.pow(a, s) / 2.0 + Math.pow(b, s) / 2.0;
                    double d2 = Math.pow(sq, 1.0 / s);
                    len = s1 - d1 / d2;
                }
            }
            return len;
        }

        @Override
        public Object clone() {
            Ellipse2D m = (Ellipse2D)this.getModelShape();
            Ellipse2D r = (Ellipse2D)m.clone();
            Ellipse ell = new Ellipse(r);
            this.copyObject(ell);
            return ell;
        }

        @Override
        public final GSPSGraphic gspsDescription() {
            double h;
            XpRoiHandleContainer.GraphicDescriptor description = null;
            RectangularShape rs = (RectangularShape)this.getModelShape();
            double x = rs.getX();
            double y = rs.getY();
            double w = rs.getWidth();
            if (w == (h = rs.getHeight())) {
                double cx = x + w / 2.0;
                double cy = y + h / 2.0;
                double circ_ptX = cx;
                double circ_ptY = cy + h / 2.0;
                Point2D[] pts = new Point2D[]{new Point2D.Double(cx, cy), new Point2D.Double(circ_ptX, circ_ptY)};
                description = new XpRoiHandleContainer.GraphicDescriptor("CIRCLE", pts);
            } else if (w > h) {
                double majorP1X = x;
                double majorP1Y = y + h / 2.0;
                double majorP2X = x + w;
                double majorP2Y = majorP1Y;
                double minorP1X = x + w / 2.0;
                double minorP1Y = y;
                double minorP2X = minorP1X;
                double minorP2Y = y + h;
                this.getRotatedPoint(majorP1X, majorP1Y, this.gspsTemp);
                majorP1X = this.gspsTemp.getX();
                majorP1Y = this.gspsTemp.getY();
                this.getRotatedPoint(majorP2X, majorP2Y, this.gspsTemp);
                majorP2X = this.gspsTemp.getX();
                majorP2Y = this.gspsTemp.getY();
                this.getRotatedPoint(minorP1X, minorP1Y, this.gspsTemp);
                minorP1X = this.gspsTemp.getX();
                minorP1Y = this.gspsTemp.getY();
                this.getRotatedPoint(minorP2X, minorP2Y, this.gspsTemp);
                minorP2X = this.gspsTemp.getX();
                minorP2Y = this.gspsTemp.getY();
                Point2D[] pts = new Point2D[]{new Point2D.Double(majorP1X, majorP1Y), new Point2D.Double(majorP2X, majorP2Y), new Point2D.Double(minorP1X, minorP1Y), new Point2D.Double(minorP2X, minorP2Y)};
                description = new XpRoiHandleContainer.GraphicDescriptor("ELLIPSE", pts);
            } else {
                double majorP1X = x + w / 2.0;
                double majorP1Y = y;
                double majorP2X = majorP1X;
                double majorP2Y = y + h;
                double minorP1X = x;
                double minorP1Y = y + h / 2.0;
                double minorP2X = x + w;
                double minorP2Y = minorP1Y;
                this.getRotatedPoint(majorP1X, majorP1Y, this.gspsTemp);
                majorP1X = this.gspsTemp.getX();
                majorP1Y = this.gspsTemp.getY();
                this.getRotatedPoint(majorP2X, majorP2Y, this.gspsTemp);
                majorP2X = this.gspsTemp.getX();
                majorP2Y = this.gspsTemp.getY();
                this.getRotatedPoint(minorP1X, minorP1Y, this.gspsTemp);
                minorP1X = this.gspsTemp.getX();
                minorP1Y = this.gspsTemp.getY();
                this.getRotatedPoint(minorP2X, minorP2Y, this.gspsTemp);
                minorP2X = this.gspsTemp.getX();
                minorP2Y = this.gspsTemp.getY();
                Point2D[] pts = new Point2D[]{new Point2D.Double(majorP1X, majorP1Y), new Point2D.Double(majorP2X, majorP2Y), new Point2D.Double(minorP1X, minorP1Y), new Point2D.Double(minorP2X, minorP2Y)};
                description = new XpRoiHandleContainer.GraphicDescriptor("ELLIPSE", pts);
            }
            return description;
        }

        private static class EllipseCreator
        extends RectComponentCreator {
            private EllipseCreator() {
            }

            @Override
            public RoiActor getRoiActor(double x, double y) {
                return new Ellipse(new Ellipse2D.Double(x - 5.0, y - 3.0, 5.0, 3.0));
            }
        }
    }

    public static class RoundRectangle
    extends XpRectangularRoi
    implements Serializable {
        public RoundRectangle(RoundRectangle2D r) {
            super(r);
        }

        public RoundRectangle(RoiShapeModel statshape) {
            super(statshape);
        }

        public static ComponentCreator getComponentCreator(int ccid) {
            if (ccid == 0) {
                return new RoundRectangleCreator();
            }
            return null;
        }

        @Override
        public Object clone() {
            RoundRectangle2D m = (RoundRectangle2D)this.getModelShape();
            RoundRectangle2D r = (RoundRectangle2D)m.clone();
            RoundRectangle rect = new RoundRectangle(r);
            this.copyObject(rect);
            return rect;
        }

        private static class RoundRectangleCreator
        extends RectComponentCreator {
            private RoundRectangleCreator() {
            }

            @Override
            public RoiActor getRoiActor(double x, double y) {
                return new RoundRectangle(new RoundRectangle2D.Double(x - 5.0, y - 2.0, 5.0, 2.0, 5.0, 5.0));
            }
        }
    }

    public static class Square
    extends Rectangle
    implements Cloneable,
    Serializable {
        public Square(double x, double y, double dim) {
            super(new Rectangle2D.Double(x, y, dim, dim));
            this.setSquareConstraints(true);
        }

        public Square(RoiShapeModel statshape) {
            super(statshape);
        }

        public static ComponentCreator getComponentCreator(int ccid) {
            if (ccid == 0) {
                return new SquareCreator();
            }
            return null;
        }

        @Override
        public Object clone() {
            Rectangle2D m = (Rectangle2D)this.getModelShape();
            Square sq = new Square(m.getX(), m.getY(), m.getWidth());
            this.copyObject(sq);
            return sq;
        }

        private static class SquareCreator
        extends RectComponentCreator {
            private SquareCreator() {
            }

            @Override
            public RoiActor getRoiActor(double x, double y) {
                return new Square(x, y, 5.0);
            }
        }
    }

    public static class Rectangle
    extends XpRectangularRoi
    implements Cloneable,
    Serializable {
        private transient Point2D gspsTemp = new Point2D.Double();

        public Rectangle(Rectangle2D r) {
            super(r);
        }

        public Rectangle(RoiShapeModel statshape) {
            super(statshape);
        }

        @Override
        public double getIdealArea() {
            XpImage img = this.getImage();
            double area = 0.0;
            if (img != null) {
                double pdx = img.getPixelDimensionX();
                double pdy = img.getPixelDimensionY();
                RectangularShape rs = (RectangularShape)this.getModelShape();
                double pw = rs.getWidth() * pdx;
                double ph = rs.getHeight() * pdy;
                area = pw * ph;
            }
            return area;
        }

        @Override
        public double getIdealLength() {
            XpImage img = this.getImage();
            double len = 0.0;
            if (img != null) {
                double pdx = img.getPixelDimensionX();
                double pdy = img.getPixelDimensionY();
                RectangularShape rs = (RectangularShape)this.getModelShape();
                double pw = rs.getWidth() * pdx;
                double ph = rs.getHeight() * pdy;
                len = 2.0 * pw + 2.0 * ph;
            }
            return len;
        }

        @Override
        public final GSPSGraphic gspsDescription() {
            Point2D[] pts = new Point2D[5];
            RectangularShape rs = (RectangularShape)this.getModelShape();
            double x = rs.getX();
            double y = rs.getY();
            double w = rs.getWidth();
            double h = rs.getHeight();
            this.getRotatedPoint(x, y, this.gspsTemp);
            pts[0] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            this.getRotatedPoint(x += w, y, this.gspsTemp);
            pts[1] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            this.getRotatedPoint(x, y += h, this.gspsTemp);
            pts[2] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            this.getRotatedPoint(x -= w, y, this.gspsTemp);
            pts[3] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            this.getRotatedPoint(x, y -= h, this.gspsTemp);
            pts[4] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
            return description;
        }

        public static ComponentCreator getComponentCreator(int ccid) {
            if (ccid == 0) {
                return new RectangleCreator();
            }
            return null;
        }

        @Override
        public Object clone() {
            Rectangle2D m = (Rectangle2D)this.getModelShape();
            Rectangle2D r = (Rectangle2D)m.clone();
            Rectangle rect = new Rectangle(r);
            this.copyObject(rect);
            return rect;
        }

        private static class RectangleCreator
        extends RectComponentCreator {
            private RectangleCreator() {
            }

            @Override
            public RoiActor getRoiActor(double x, double y) {
                return new Rectangle(new Rectangle2D.Double(x - 5.0, y - 3.0, 5.0, 3.0));
            }
        }
    }

    private static class ContainmentCache
    implements Serializable {
        public double angle;
        public double cx;
        public double cy;
        public double w;
        public double h;

        private ContainmentCache() {
        }
    }
}

