/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.aw;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class XpAwRectangle
extends XpRectangularRoi.Rectangle {
    private int centerHandleId = this.getNumHandles();
    private XpHandle centerHandle = new XpHandle((XpAnchorable)this, this.centerHandleId, 16);

    public XpAwRectangle(Rectangle2D r) {
        super(r);
        this.add(this.centerHandle);
        double hx = r.getX() + r.getWidth() * 0.5;
        double hy = r.getY() + r.getHeight() * 0.5;
        this.centerHandle.setLocation(hx, hy);
    }

    @Override
    public void anchorPressed(MouseEvent e, Object jc) {
        int noHandles = this.getNumHandles();
        for (int i = 0; i < noHandles; ++i) {
            this.get(i).setVisible(false);
        }
        super.anchorPressed(e, jc);
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (handleIdx == this.centerHandleId) {
            super.roiPressed(e);
        }
    }

    @Override
    public void anchorReleased(MouseEvent e, Object jc) {
        int noHandles = this.getNumHandles();
        for (int i = 0; i < noHandles; ++i) {
            this.get(i).setVisible(true);
        }
        this.sync();
        super.anchorReleased(e, jc);
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object jc) {
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (handleIdx == this.centerHandleId) {
            super.roiDragged(e);
            RectangularShape r = (RectangularShape)this.getModelShape();
            double hx = r.getX() + r.getWidth() * 0.5;
            double hy = r.getY() + r.getHeight() * 0.5;
            this.centerHandle.setLocation(hx, hy);
            this.syncModel();
        } else {
            super.anchorDragged(e, drag, jc);
        }
    }

    @Override
    public void roiDragged(MouseEvent e) {
        super.roiDragged(e);
        RectangularShape r = (RectangularShape)this.getModelShape();
        double hx = r.getX() + r.getWidth() * 0.5;
        double hy = r.getY() + r.getHeight() * 0.5;
        this.centerHandle.setLocation(hx, hy);
        this.syncModel();
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new AwRectangleCreator();
        }
        return null;
    }

    public static abstract class RectComponentCreator
    extends XpRoiComponentCreator {
        private final int resizeIdx = 2;

        @Override
        public void mouseDragged(MouseEvent me) {
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            XpHandle resize = rrm.getHandle(2);
            resize.handleDragged(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            super.mousePressed(me);
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            XpHandle resize = rrm.getHandle(2);
            resize.handlePressed(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            XpHandle resize = rrm.getHandle(2);
            resize.handleReleased(me);
            super.mouseReleased(me);
        }
    }

    private static class AwRectangleCreator
    extends RectComponentCreator {
        private AwRectangleCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x, double y) {
            return new XpAwRectangle(new Rectangle2D.Double(x - 5.0, y - 3.0, 5.0, 3.0));
        }
    }
}

