/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.j3d;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.roi.XpPolygonRoi;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Roi3DInvestigator
extends JPanel {
    private T3DViewport vp1 = new T3DViewport();

    public Roi3DInvestigator(String volumePath) {
        this.setLayout(new BorderLayout());
        DMSession dms = new DMSession(new String[]{"file", volumePath});
        DMObject[] dmo = dms.getRelated("series");
        DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
        int width = 800;
        int height = 800;
        this.vp1.setVolume(vol);
        this.vp1.setRenderStyle("REFORMAT");
        this.add((Component)this.vp1, "Center");
        this.vp1.setPreferredSize(new Dimension(800, 800));
        JPanel uipanel = new JPanel();
        uipanel.setPreferredSize(new Dimension(800, 64));
        this.add((Component)uipanel, "South");
        uipanel.add(new JLabel("Scroll: "));
        int MAX = 1000;
        final JSlider scroller = new JSlider(0, 0, 1000, 500);
        uipanel.add(scroller);
        this.add((Component)uipanel, "South");
        scroller.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                J3DVolumeModel jvm = (J3DVolumeModel)Roi3DInvestigator.this.vp1.getVolumeModel();
                double thickness = Math.min(jvm.j_vol.ras_dx, jvm.j_vol.ras_dy);
                thickness = Math.min(jvm.j_vol.ras_dz, thickness);
                double delta = thickness / 1000.0;
                double[] lp = Roi3DInvestigator.this.vp1.getLookPoint(null);
                double[] ep = Roi3DInvestigator.this.vp1.getEyePoint(null);
                double[] view = new double[3];
                JnVector3d.sub(lp, ep, view);
                JnVector3d.normalize(view);
                JnVector3d.scale(view, delta);
                int sign = (double)scroller.getValue() - 500.0 > 0.0 ? 1 : -1;
                JnVector3d.scaleAdd(lp, view, sign, lp);
                JnVector3d.scaleAdd(ep, view, sign, ep);
                Roi3DInvestigator.this.vp1.setCamera(ep, lp, Roi3DInvestigator.this.vp1.getUp(null));
                Roi3DInvestigator.this.vp1.repaint();
            }
        });
        Ellipse2D.Double ellipse = new Ellipse2D.Double(200.0, 200.0, 128.0, 64.0);
        XpRectangularRoi.Ellipse sr_ell = new XpRectangularRoi.Ellipse(ellipse);
        Rectangle2D.Double rect = new Rectangle2D.Double(200.0, 340.0, 128.0, 64.0);
        XpRectangularRoi.Rectangle sr_rect = new XpRectangularRoi.Rectangle(rect);
        Point2D[] pts = new Point2D[]{new Point2D.Double(160.0, 80.0), new Point2D.Double(480.0, 480.0)};
        XpPolygonRoi sr_line = new XpPolygonRoi(pts);
        this.vp1.add(sr_ell);
        this.vp1.add(sr_rect);
        this.vp1.add(sr_line);
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("ROI 3D");
        Roi3DInvestigator vs3d = new Roi3DInvestigator(args[0]);
        jf.setContentPane(vs3d);
        jf.pack();
        jf.setDefaultCloseOperation(3);
        jf.setVisible(true);
    }
}

