/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class DMUtils {
    public static String PROPERTY_SESSION_NAME = "SessionName";
    public static String PROPERTY_SESSION_TYPE = "session type";
    public static String PROPERTY_SESSION_REP = "session rep";
    public static String PROPERTY_SESSION_ARGS = "session args";
    public static String MSG_REUSE_NETWORK_ASSOCIATION = "reuse association";
    public static String MSG_CLOSE_NETWORK_ASSOCIATION = "close association";
    public static String MSG_NETWORK_ASSOCIATION_TYPE = "get association type";
    public static String MSG_MAKE_NETWORK_ASSOCIATION = "make association";
    public static String MSG_CSTORE_DIR = "scp_db";
    public static String MSG_SCP_PORT = "scp_port";
    public static String MSG_PING_REMOTE_SCP = "ping remote scp";
    public static String MSG_NETWORK_STOP_SERVER = "stop_server";
    public static String MSG_RESERVE_SPACE = "reserve";
    public static String MSG_RELEASE_SPACE = "release";
    public static String NW_INIT_CALLED_AE = "calledAE";
    public static String NW_INIT_CALLED_HOST = "calledHost";
    public static String NW_INIT_CALLED_PORT = "calledPort";
    public static String NW_INIT_CALLING_AE = "callingAE";
    public static String NW_INIT_IMPL_CLASS_UID = "implClassUID";
    public static String NW_INIT_SECURE = "Secure";
    public static String TS_EBE = "1.2.840.10008.1.2.2";
    public static String TS_ELE = "1.2.840.10008.1.2.1";
    public static String TS_ILE = "1.2.840.10008.1.2";
    public static String TS_GEBE = "1.2.840.113619.5.2";
    public static String TS_JPEGLossless = "1.2.840.10008.1.2.4.70";
    public static String TS_RLELossless = "1.2.840.10008.1.2.5";
    public static String TS_JPEGBaseline = "1.2.840.10008.1.2.4.50";
    public static String TS_UNKOWN = "";
    public static Comparator patSort = new Comparator(){

        public int compare(Object object, Object object1) {
            DMObject dmo1 = (DMObject)object;
            DMObject dmo2 = (DMObject)object1;
            Object obj = dmo1.getValue(16, 16);
            String str1 = obj == null ? "" : (String)obj;
            obj = dmo2.getValue(16, 16);
            String str2 = obj == null ? "" : (String)obj;
            return str1.compareTo(str2);
        }
    };
    public static Comparator stuSort = new Comparator(){

        public int compare(Object object, Object object1) {
            DMObject dmo1 = (DMObject)object;
            DMObject dmo2 = (DMObject)object1;
            Object obj = dmo1.getValue(32, 16);
            String str1 = obj == null ? "" : (String)obj;
            obj = dmo2.getValue(32, 16);
            String str2 = obj == null ? "" : (String)obj;
            return str1.compareTo(str2);
        }
    };
    public static Comparator serSort = new Comparator(){

        public int compare(Object object, Object object1) {
            DMObject dmo1 = (DMObject)object;
            DMObject dmo2 = (DMObject)object1;
            Object obj = dmo1.getValue(32, 17);
            String str1 = obj == null ? "" : (String)obj;
            obj = dmo2.getValue(32, 17);
            String str2 = obj == null ? "" : (String)obj;
            return str1.compareTo(str2);
        }
    };
    public static Comparator imgSort = new Comparator(){

        public int compare(Object object, Object object1) {
            DMObject dmo1 = (DMObject)object;
            DMObject dmo2 = (DMObject)object1;
            Object obj = dmo1.getValue(32, 19);
            String str1 = obj == null ? "" : (String)obj;
            obj = dmo2.getValue(32, 19);
            String str2 = obj == null ? "" : (String)obj;
            return str1.compareTo(str2);
        }
    };

    public static DMObject[] filter(DMObject[] objs, DMQuery q) {
        ArrayList<DMObject> list = new ArrayList<DMObject>();
        for (int i = 0; i < objs.length; ++i) {
            if (!q.valid(objs[i])) continue;
            list.add(objs[i]);
        }
        DMObject[] filteredObjs = new DMObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            filteredObjs[i] = (DMObject)list.get(i);
        }
        return filteredObjs;
    }

    public static void displaySequence(DMSequence seq) {
        DMUtils.displaySequence(seq, 0);
    }

    private static void displaySequence(DMSequence seq, int level) {
        int x;
        int numItems = seq.getNumberOfItems();
        for (x = 0; x < level; ++x) {
            System.out.print("\t");
        }
        System.out.println("BEGIN_SEQUENCE");
        for (int i = 0; i < seq.getNumberOfItems(); ++i) {
            int x2;
            for (x2 = 0; x2 < level; ++x2) {
                System.out.print("\t");
            }
            System.out.println("BEGIN_ITEM");
            for (int j = 0; j < seq.getItem(i).getNumberOfTags(); ++j) {
                if (seq.getItem(i).getValue(seq.getItem(i).getTags()[j]) instanceof DMSequence) {
                    DMUtils.displaySequence((DMSequence)seq.getItem(i).getValue(seq.getItem(i).getTags()[j]), level + 1);
                    continue;
                }
                for (int x3 = 0; x3 < level + 1; ++x3) {
                    System.out.print("\t");
                }
                System.out.println(seq.getItem(i).getTags()[j] + "= " + seq.getItem(i).getValue(seq.getItem(i).getTags()[j]));
            }
            for (x2 = 0; x2 < level; ++x2) {
                System.out.print("\t");
            }
            System.out.println("END_ITEM");
        }
        for (x = 0; x < level; ++x) {
            System.out.print("\t");
        }
        System.out.println("END_SEQUENCE");
    }

    public static void printChildren(DMSession dms) {
        DMUtils.printChildren(dms, System.out);
    }

    public static void printChildren(DMSession dms, PrintStream fout) {
        DMObject[] pats = dms.getChildren();
        System.out.println("# of patients= " + pats.length);
        Arrays.sort(pats, patSort);
        for (int i = 0; i < pats.length; ++i) {
            DMUtils.printChildren(pats[i], fout);
        }
    }

    public static void printChildren(DMObject obj) {
        DMUtils.printChildren(obj, System.out);
    }

    public static void printChildren(DMObject obj, PrintStream out) {
        if (obj.getType().equalsIgnoreCase("patient")) {
            DMObject[] kids = obj.getRelated("study");
            Arrays.sort(kids, stuSort);
            out.println("");
            out.println("-Patient: " + obj.getValue(16, 16));
            for (int i = 0; i < kids.length; ++i) {
                DMUtils.printChildren(kids[i], out);
            }
        } else if (obj.getType().equalsIgnoreCase("study")) {
            DMObject[] kids = obj.getRelated("series");
            Arrays.sort(kids, serSort);
            out.println("\t-Study: " + obj.getValue(32, 13));
            for (int i = 0; i < kids.length; ++i) {
                DMUtils.printChildren(kids[i], out);
            }
        } else if (obj.getType().equalsIgnoreCase("series")) {
            DMObject[] kids = obj.getRelated("image");
            Arrays.sort(kids, imgSort);
            out.println("\t\t-Series: " + obj.getValue(32, 14));
            for (int i = 0; i < kids.length; ++i) {
                DMUtils.printChildren(kids[i], out);
            }
        } else if (obj.getType().equalsIgnoreCase("image")) {
            out.println("\t\t\t+Image: " + obj.getValue(8, 24));
        }
    }

    public static tagValue findtag(tagValue[] t, int g, int e) {
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].is(g, e)) continue;
            return t[i];
        }
        return null;
    }

    public static XjVolume buildVolume(DMObject series, DMTag[] neededtags) {
        return new DMVolume(series, neededtags);
    }

    public static void main(String[] args) {
        DMSession dms = new DMSession("file", "D:\\dev\\dicom\\direct3d", null);
        DMVolume xjv = new DMVolume(dms.getRelated("series")[0], null);
        System.out.println("xjv.getBitsPerVoxel()=" + xjv.getBitsPerVoxel());
        System.out.println("xjv.getPixelType()=" + xjv.getPixelType());
        System.out.println("=" + xjv.isVolumeLittleEndian());
        int[] dim = xjv.getVolumeDimensions(null);
        System.out.println("dim=" + dim[0] + "," + dim[1] + "," + dim[2]);
        double[] v = xjv.getRASOfOrigin(null);
        System.out.println("xjv.getRASOfOrigin()=" + v[0] + "," + v[1] + "," + v[2]);
        v = xjv.getXDirectionRAS(null);
        System.out.println("xjv.getXDirectionRAS()=" + v[0] + "," + v[1] + "," + v[2]);
        v = xjv.getYDirectionRAS(null);
        System.out.println("xjv.getYDirectionRAS()=" + v[0] + "," + v[1] + "," + v[2]);
        v = xjv.getZDirectionRAS(null);
        System.out.println("xjv.getZDirectionRAS()=" + v[0] + "," + v[1] + "," + v[2]);
        System.out.println("=" + xjv);
    }

    public static class DMVolume
    implements XjVolume {
        IImage[] slices;
        int width;
        int height;
        boolean littleEndian;
        int bitsPerPix = -1;
        int pixType = 0;
        DMObject series;
        double[] ras_xdir = new double[3];
        double[] ras_ydir = new double[3];

        private void filldoubles(String str, double[] dv) {
            String[] s = str.split("\\\\");
            for (int i = 0; i < s.length; ++i) {
                dv[i] = Double.parseDouble(s[i]);
            }
        }

        public DMVolume(DMObject series, DMTag[] neededtags) {
            this.series = series;
            double[] ras_xy = new double[6];
            double[] pixSpac = new double[2];
            DMComposite[] comp = series.getComposites();
            ArrayList<IImage> al = new ArrayList<IImage>(comp.length);
            double[] topLeft = new double[3];
            for (int i = 0; i < comp.length; ++i) {
                tagValue tv;
                int frames;
                String path = comp[i].getFilePath();
                tagValue[] tget = fileImage.getImageTags(comp[i].peer, neededtags);
                String imgType = ((String)dicomImageGen.get(tget, 40, 4)).trim();
                int dimy = (Integer)dicomImageGen.get(tget, 40, 16);
                int dimx = (Integer)dicomImageGen.get(tget, 40, 17);
                int n = frames = dicomImageGen.get(tget, 40, 8) != null ? Integer.parseInt((String)dicomImageGen.get(tget, 40, 8)) : 1;
                if (i == 0) {
                    Object str = dicomImageGen.get(tget, 32, 55);
                    if (str != null) {
                        this.filldoubles(str.toString(), ras_xy);
                    } else {
                        ras_xy = null;
                    }
                    str = dicomImageGen.get(tget, 40, 48);
                    if (str != null) {
                        this.filldoubles(str.toString(), pixSpac);
                    } else {
                        pixSpac = null;
                    }
                    this.bitsPerPix = fileImage.getBitsPerPix((DMElement[])tget);
                    if ("MONOCHROME2".equalsIgnoreCase(imgType)) {
                        this.pixType = 1;
                    } else if ("RGB".equalsIgnoreCase(imgType)) {
                        this.pixType = 2;
                    }
                    for (int tags = 0; tags < tget.length; ++tags) {
                        if (!tget[tags].is(32736, 16)) continue;
                        this.littleEndian = tget[tags].isLittleEndian();
                    }
                }
                if ((tv = DMUtils.findtag(tget, 32, 50)) != null) {
                    String str = (String)tv.value;
                    this.filldoubles(str, topLeft);
                }
                this.width = dimx;
                this.height = dimy;
                int k = 0;
                while (k < frames) {
                    IImage img = new IImage();
                    img.filename = path;
                    System.arraycopy(topLeft, 0, img.topLeft, 0, 3);
                    img.topLeft[0] = -img.topLeft[0];
                    img.topLeft[1] = -img.topLeft[1];
                    img.offset = tget[tget.length - 1].getOffset();
                    img.dmc = comp[i];
                    img.imgNo = k++;
                    al.add(img);
                }
            }
            this.slices = al.toArray(new IImage[al.size()]);
            if (ras_xy != null) {
                this.ras_xdir[0] = -ras_xy[0] * pixSpac[0];
                this.ras_xdir[1] = -ras_xy[1] * pixSpac[0];
                this.ras_xdir[2] = ras_xy[2] * pixSpac[0];
                this.ras_ydir[0] = -ras_xy[3] * pixSpac[1];
                this.ras_ydir[1] = -ras_xy[4] * pixSpac[1];
                this.ras_ydir[2] = ras_xy[5] * pixSpac[1];
            }
            final double[] v = new double[]{this.slices[0].topLeft[0] - this.slices[1].topLeft[0], this.slices[0].topLeft[1] - this.slices[1].topLeft[1], this.slices[0].topLeft[2] - this.slices[1].topLeft[2]};
            final double[] p = new double[]{this.slices[0].topLeft[0], this.slices[0].topLeft[1], this.slices[0].topLeft[2]};
            Arrays.sort(this.slices, new Comparator(){
                double[] tmp = new double[3];

                public int compare(Object o1, Object o2) {
                    IImage i1 = (IImage)o1;
                    IImage i2 = (IImage)o2;
                    this.sub(i1.topLeft, p, this.tmp);
                    double t1 = this.dot(this.tmp, v);
                    this.sub(i2.topLeft, p, this.tmp);
                    double t2 = this.dot(this.tmp, v);
                    return Double.compare(t2, t1);
                }
            });
        }

        private void sub(double[] a, double[] b, double[] out) {
            out[0] = a[0] - b[0];
            out[1] = a[1] - b[1];
            out[2] = a[2] - b[2];
        }

        private double dot(double[] a, double[] b) {
            return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
        }

        @Override
        public int[] getVolumeDimensions(int[] dims) {
            if (dims == null) {
                dims = new int[]{this.width, this.height, this.slices.length};
            }
            return dims;
        }

        @Override
        public double[] getRASOfOrigin(double[] doubleArray) {
            if (doubleArray == null) {
                doubleArray = this.slices[0].topLeft;
            } else {
                System.arraycopy(this.slices[0].topLeft, 0, doubleArray, 0, 3);
            }
            return doubleArray;
        }

        @Override
        public double[] getXDirectionRAS(double[] ras_dx) {
            if (ras_dx == null) {
                ras_dx = this.ras_xdir;
            } else {
                System.arraycopy(this.ras_xdir, 0, ras_dx, 0, 3);
            }
            return ras_dx;
        }

        @Override
        public double[] getYDirectionRAS(double[] ras_dy) {
            if (ras_dy == null) {
                ras_dy = this.ras_ydir;
            } else {
                System.arraycopy(this.ras_ydir, 0, ras_dy, 0, 3);
            }
            return ras_dy;
        }

        @Override
        public double[] getZDirectionRAS(double[] ras_dz) {
            if (ras_dz == null) {
                ras_dz = new double[]{this.slices[1].topLeft[0] - this.slices[0].topLeft[0], this.slices[1].topLeft[1] - this.slices[0].topLeft[1], this.slices[1].topLeft[2] - this.slices[0].topLeft[2]};
            }
            return ras_dz;
        }

        @Override
        public int getValues(XjTagValue[] xjTagValueArray) {
            DMElement[] data = DMElement.genDMelements(xjTagValueArray);
            this.series.getValues(data);
            return DMElement.getXjTagValue(data, xjTagValueArray);
        }

        @Override
        public long getVSliceOffset(int slice) {
            return this.slices[slice].offset;
        }

        @Override
        public String getVSlicePath(int slice) {
            return this.slices[slice].filename;
        }

        @Override
        public int getBitsPerVoxel() {
            return this.bitsPerPix;
        }

        @Override
        public int getPixelType() {
            return this.pixType;
        }

        @Override
        public boolean isVolumeLittleEndian() {
            return this.littleEndian;
        }

        @Override
        public Object getVSliceValue(int sliceNo, int group, int element) {
            return this.slices[sliceNo].dmc.getValue(group, element);
        }

        @Override
        public Object getValue(int group, int element) {
            return this.slices[0].dmc.getValue(group, element);
        }

        @Override
        public String getRelatedComposite() {
            return "";
        }

        public XjImage getImage(int slice) {
            return this.slices[slice].dmc.getImages(null)[0];
        }

        class IImage {
            double[] topLeft = new double[3];
            DMComposite dmc;
            int imgNo;
            String filename;
            long offset;

            IImage() {
            }
        }
    }
}

