/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjDicomObjectFrame;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.MultiFrameSupportIF;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiSeqItem;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.dm.peerutils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class MultiFrameSupport
implements MultiFrameSupportIF {
    private static final DMTag SOP_CLASS_UID_TAG = new DMTag(8, 22);
    private static final DMTag NUMBER_OF_FRAMES_TAG = new DMTag(40, 8);
    private static final DMTag SHARED_FUNCTIONAL_GROUPS_TAG = new DMTag(20992, 37417);
    private static final DMTag PER_FRAME_FUNCTIONAL_GROUPS_TAG = new DMTag(20992, 37424);
    private static final String SHARED_FUNCTIONAL_GROUPS_PREFIX = MultiFrameSupport.tagToString(SHARED_FUNCTIONAL_GROUPS_TAG);
    private static final String PER_FRAME_FUNCTIONAL_GROUPS_PREFIX = MultiFrameSupport.tagToString(PER_FRAME_FUNCTIONAL_GROUPS_TAG);
    private final Map<DMTag, String> sharedFunctionalGroupsMap = new HashMap<DMTag, String>();
    private final Map<DMTag, String> perFrameFunctionalGroupsMap = new HashMap<DMTag, String>();

    @Override
    public int getNumberOfFrames(DMiImage peer) {
        int numberOfFrames = -1;
        Object val = peer.getValue(NUMBER_OF_FRAMES_TAG);
        numberOfFrames = null == val ? 1 : Integer.parseInt((String)val);
        return numberOfFrames;
    }

    @Override
    public XjDicomObjectFrame.MultiFrameType getMultiFrameType(DMiImage peer) {
        if (ENH_MF_SOP_CLASS_UIDS.contains(peer.getValue(SOP_CLASS_UID_TAG))) {
            return MultiFrameSupport.checkForFunctionalGroups(peer, true);
        }
        if (OPT_ENH_MF_SOP_CLASS_UIDS.contains(peer.getValue(SOP_CLASS_UID_TAG))) {
            return MultiFrameSupport.checkForFunctionalGroups(peer, false);
        }
        if (MF_SOP_CLASS_UIDS.contains(peer.getValue(SOP_CLASS_UID_TAG))) {
            return XjDicomObjectFrame.MultiFrameType.MULTI_FRAME;
        }
        return XjDicomObjectFrame.MultiFrameType.SINGLE_FRAME;
    }

    private static XjDicomObjectFrame.MultiFrameType checkForFunctionalGroups(DMiImage peer, boolean enhancedDicomCase) {
        if (null != peer.getValue(SHARED_FUNCTIONAL_GROUPS_TAG) || null != peer.getValue(PER_FRAME_FUNCTIONAL_GROUPS_TAG)) {
            return XjDicomObjectFrame.MultiFrameType.MULTI_FRAME_ENHANCED;
        }
        if (enhancedDicomCase) {
            String msg = "Enhanced DICOM Multi-Frame SOP Class UID (" + peer.getValue(SOP_CLASS_UID_TAG) + ") has missing functional groups tags. Treating as non-enhanced multi-frame.";
            Tap.log.log(Level.WARNING, msg);
        }
        return XjDicomObjectFrame.MultiFrameType.MULTI_FRAME;
    }

    @Override
    public Object getValue(DMiImage peer, int frameNumber, DMTag tag2) {
        int numberOfFrames = this.getNumberOfFrames(peer);
        if (frameNumber < 0 && frameNumber >= numberOfFrames) {
            throw new IndexOutOfBoundsException("Invalid frame number. It should be between 0 and " + (numberOfFrames - 1));
        }
        Object value = peer.getValue(tag2);
        if (value instanceof DMiSequence) {
            return new DMSequence((DMiSequence)value);
        }
        if (null == value && this.getMultiFrameType(peer).equals((Object)XjDicomObjectFrame.MultiFrameType.MULTI_FRAME_ENHANCED) && null == (value = this.getValueFromSharedFunctionalGroupSQ(peer, tag2))) {
            value = this.getValueFromPerFrameFunctionalGroupSQ(peer, frameNumber, tag2);
        }
        return value;
    }

    @Override
    public XjTagValue[] getFrameTags(DMiImage peer, int frameNumber) {
        DMiSequence seq = (DMiSequence)peer.getValue(PER_FRAME_FUNCTIONAL_GROUPS_TAG);
        if (null == seq) {
            return new XjTagValue[0];
        }
        DMSequence valuePerFrameSQ = new DMSequence(seq);
        return valuePerFrameSQ.getItem(frameNumber).getItemTags();
    }

    public synchronized Set<DMTag> getSharedGroupCachedTags() {
        return this.sharedFunctionalGroupsMap.keySet();
    }

    public synchronized Set<DMTag> getPerFrameCachedTags() {
        return this.perFrameFunctionalGroupsMap.keySet();
    }

    private Object getValue(DMiImage peer, String tag2) {
        return Util.getValue(peer, tag2);
    }

    private synchronized Object getValueFromSharedFunctionalGroupSQ(DMiImage peer, DMTag tag2) {
        if (this.sharedFunctionalGroupsMap.containsKey(tag2)) {
            return this.getValue(peer, this.sharedFunctionalGroupsMap.get(tag2));
        }
        DMiSequence valueSharedSQ = (DMiSequence)peer.getValue(SHARED_FUNCTIONAL_GROUPS_TAG);
        Object value = MultiFrameSupport.getValueFromSequence(valueSharedSQ, tag2, SHARED_FUNCTIONAL_GROUPS_PREFIX, this.sharedFunctionalGroupsMap);
        return value;
    }

    private synchronized Object getValueFromPerFrameFunctionalGroupSQ(DMiImage peer, int frameNumber, DMTag tag2) {
        if (this.perFrameFunctionalGroupsMap.containsKey(tag2)) {
            String path = PER_FRAME_FUNCTIONAL_GROUPS_PREFIX + "[" + frameNumber + "]" + this.perFrameFunctionalGroupsMap.get(tag2);
            return this.getValue(peer, path);
        }
        DMiSequence valuePerFrameSQ = (DMiSequence)peer.getValue(PER_FRAME_FUNCTIONAL_GROUPS_TAG);
        Object value = MultiFrameSupport.getValueFromItem(valuePerFrameSQ, frameNumber, tag2, PER_FRAME_FUNCTIONAL_GROUPS_PREFIX, this.perFrameFunctionalGroupsMap);
        String path = this.perFrameFunctionalGroupsMap.get(tag2);
        if (null != path) {
            String myFramePrefix = PER_FRAME_FUNCTIONAL_GROUPS_PREFIX + "[" + frameNumber + "]";
            path = path.replace(myFramePrefix, "");
            this.perFrameFunctionalGroupsMap.put(tag2, path);
        }
        return value;
    }

    private static Object getValueFromSequence(DMiSequence seq, DMTag tag2, String path, Map<DMTag, String> map) {
        Object value = null;
        int nItems = seq.getNumberOfItems();
        for (int i = 0; i < nItems && null == value; ++i) {
            value = MultiFrameSupport.getValueFromItem(seq, i, tag2, path, map);
        }
        return value;
    }

    private static Object getValueFromItem(DMiSequence seq, int itemNumber, DMTag tagToFind, String path, Map<DMTag, String> map) {
        String tempPath;
        DMiSequence seqToSearch;
        Object val;
        DMTag tag22;
        DMTag[] tags;
        Object value = null;
        StringBuilder pathToTag = new StringBuilder(path);
        DMiSeqItem item = seq.getItem(itemNumber);
        for (DMTag tag22 : tags = item.getTags()) {
            if (!tag22.equals(tagToFind)) continue;
            pathToTag.append("[");
            pathToTag.append(itemNumber);
            pathToTag.append("]");
            pathToTag.append(MultiFrameSupport.tagToString(tagToFind));
            map.put(new DMTag(tagToFind.getGroup(), tagToFind.getElement()), pathToTag.toString());
            return item.getValue(tag22);
        }
        DMTag[] dMTagArray = tags;
        int n = dMTagArray.length;
        for (int i = 0; !(i >= n || (val = item.getValue(tag22 = dMTagArray[i])) instanceof DMiSequence && null != (value = MultiFrameSupport.getValueFromSequence(seqToSearch = (DMiSequence)val, tagToFind, tempPath = pathToTag + "[" + itemNumber + "]" + MultiFrameSupport.tagToString(tag22), map))); ++i) {
        }
        return value;
    }

    private static String tagToString(DMTag tag2) {
        int group = tag2.getGroup();
        int element = tag2.getElement();
        String sg = Integer.toHexString(group);
        sg = "0x" + "0000".substring(sg.length()) + sg;
        String se = Integer.toHexString(element);
        se = "0x" + "0000".substring(se.length()) + se;
        return "(" + sg + "," + se + ")";
    }
}

