/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.util.Set;
import java.util.TreeSet;

public class HL7StrucDocDirectoryRecordType
extends DirectoryRecordType {
    private static final DicomdirTagValue charSetTag = new DicomdirTagValue(8, 5, 1, true);
    private static final DicomdirTagValue identifierTag = new DicomdirTagValue(64, 57345, 1, false);
    private static final DicomdirTagValue docEffecTimeTag = new DicomdirTagValue(64, 3584, 1, false);
    private static final DicomdirTagValue docCodeQTag = new DicomdirTagValue(64, 57350, 1, true);
    private static final DicomdirTagValue titleTag = new DicomdirTagValue(66, 16, 1, true);

    public HL7StrucDocDirectoryRecordType() {
        super("HL7 STRUC DOC");
    }

    @Override
    protected Set<tagValue> createDefaultTagList() {
        TreeSet<tagValue> tagSet = new TreeSet<tagValue>();
        tagSet.add(charSetTag);
        tagSet.add(identifierTag);
        tagSet.add(docEffecTimeTag);
        tagSet.add(docCodeQTag);
        tagSet.add(titleTag);
        return tagSet;
    }

    @Override
    protected Object getDefaultValue(DicomdirTagValue atv) {
        if (atv.getType() == 2) {
            return null;
        }
        if (atv.compareTo(identifierTag) == 0) {
            return "UNDEFINED";
        }
        if (atv.compareTo(docEffecTimeTag) == 0) {
            return "000000.000";
        }
        throw new IllegalArgumentException("Unable to provide default value for " + atv);
    }
}

