/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.util.Set;
import java.util.TreeSet;

public class RTPlanDirectoryRecordType
extends DirectoryRecordType {
    private static final DicomdirTagValue charSetTag = new DicomdirTagValue(8, 5, 1, true);
    private static final DicomdirTagValue instanceNumberTag = new DicomdirTagValue(32, 19, 1, false);
    private static final DicomdirTagValue planLabelTag = new DicomdirTagValue(12298, 2, 1, false);
    private static final DicomdirTagValue planDateTag = new DicomdirTagValue(12298, 6, 2, false);
    private static final DicomdirTagValue planTimeTag = new DicomdirTagValue(12298, 7, 2, false);
    private static int dummyInstNumber = 9998;

    public RTPlanDirectoryRecordType() {
        super("RT PLAN");
    }

    @Override
    protected Set<tagValue> createDefaultTagList() {
        TreeSet<tagValue> tagSet = new TreeSet<tagValue>();
        tagSet.add(charSetTag);
        tagSet.add(instanceNumberTag);
        tagSet.add(planLabelTag);
        tagSet.add(planDateTag);
        tagSet.add(planTimeTag);
        return tagSet;
    }

    @Override
    protected Object getDefaultValue(DicomdirTagValue atv) {
        if (atv.getType() == 2) {
            return null;
        }
        if (atv.compareTo(instanceNumberTag) == 0) {
            return Integer.toString(++dummyInstNumber);
        }
        if (atv.compareTo(planLabelTag) == 0) {
            return "UNDEFINED";
        }
        throw new IllegalArgumentException("Unable to provide default value for " + atv);
    }
}

