/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.TreeSet;

public class StudyDirectoryRecordType
extends DirectoryRecordType {
    public static final SimpleDateFormat DA_FORMAT_PARSE = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat TM_FORMAT_PARSE = new SimpleDateFormat("HHmmss.SSS");
    private static final DicomdirTagValue charSetTag = new DicomdirTagValue(8, 5, 1, true);
    private static final DicomdirTagValue studyIDTag = new DicomdirTagValue(32, 16, 1, false);
    private static final DicomdirTagValue studyDateTag = new DicomdirTagValue(8, 32, 1, false);
    private static final DicomdirTagValue studyTimeTag = new DicomdirTagValue(8, 48, 1, false);
    private static final DicomdirTagValue studyInstUIDTag = new DicomdirTagValue(32, 13, 1, true);
    private static final DicomdirTagValue studyDescTag = new DicomdirTagValue(8, 4144, 2, false);
    private static final DicomdirTagValue accessNumberTag = new DicomdirTagValue(8, 80, 2, false);
    private static final tagValue seriesDate = new tagValue(8, 33);
    private static final tagValue acqDate = new tagValue(8, 34);
    private static final tagValue acqDateTime = new tagValue(8, 42);
    private static final tagValue contentDate = new tagValue(8, 35);
    private static final tagValue instCreationDate = new tagValue(8, 18);
    private static final tagValue seriesTime = new tagValue(8, 49);
    private static final tagValue acqTime = new tagValue(8, 50);
    private static final tagValue contentTime = new tagValue(8, 51);
    private static final tagValue instCreationTime = new tagValue(8, 19);
    protected static tagValue[] tagList = new tagValue[]{seriesDate, acqDate, acqDateTime, contentDate, instCreationDate, seriesTime, acqDateTime, contentTime, instCreationTime};

    public StudyDirectoryRecordType() {
        super("STUDY");
    }

    @Override
    protected Set<tagValue> createDefaultTagList() {
        TreeSet<tagValue> tagSet = new TreeSet<tagValue>();
        tagSet.add(charSetTag);
        tagSet.add(studyIDTag);
        tagSet.add(studyDateTag);
        tagSet.add(studyTimeTag);
        tagSet.add(studyInstUIDTag);
        tagSet.add(studyDescTag);
        tagSet.add(accessNumberTag);
        return tagSet;
    }

    @Override
    protected Object getDefaultValue(DicomdirTagValue dtv) {
        if (dtv.getType() == 2) {
            return null;
        }
        if (dtv.compareTo(studyIDTag) == 0) {
            return "UNDEFINED";
        }
        if (dtv.compareTo(studyDateTag) == 0) {
            Object tmpDate = null;
            if (null != StudyDirectoryRecordType.seriesDate.value) {
                tmpDate = StudyDirectoryRecordType.seriesDate.value;
            } else if (null != StudyDirectoryRecordType.acqDate.value) {
                tmpDate = StudyDirectoryRecordType.acqDate.value;
            } else if (null != StudyDirectoryRecordType.acqDateTime.value) {
                String date = ((String)StudyDirectoryRecordType.acqDateTime.value).substring(0, 8);
                tmpDate = date;
            } else if (null != StudyDirectoryRecordType.contentDate.value) {
                tmpDate = StudyDirectoryRecordType.contentDate.value;
            } else if (null != StudyDirectoryRecordType.instCreationDate.value) {
                tmpDate = StudyDirectoryRecordType.instCreationDate.value;
            }
            return StudyDirectoryRecordType.validateDate(tmpDate);
        }
        if (dtv.compareTo(studyTimeTag) == 0) {
            Object tmpTime = null;
            if (null != StudyDirectoryRecordType.seriesTime.value) {
                tmpTime = StudyDirectoryRecordType.seriesTime.value;
            } else if (null != StudyDirectoryRecordType.acqTime.value) {
                tmpTime = StudyDirectoryRecordType.acqTime.value;
            } else if (null != StudyDirectoryRecordType.acqDateTime.value) {
                String time = ((String)StudyDirectoryRecordType.acqDateTime.value).substring(8);
                tmpTime = time;
            } else if (null != StudyDirectoryRecordType.contentTime.value) {
                tmpTime = StudyDirectoryRecordType.contentTime.value;
            } else if (null != StudyDirectoryRecordType.instCreationTime.value) {
                tmpTime = StudyDirectoryRecordType.instCreationTime.value;
            }
            return StudyDirectoryRecordType.validateTime(tmpTime);
        }
        throw new IllegalArgumentException("Unable to provide default value for " + dtv);
    }

    public static Object validateDate(Object date) {
        if (null == date) {
            return "18880808";
        }
        String dateStr = date.toString().replaceAll("\\.", "");
        int spIndex = dateStr.indexOf(32);
        if (dateStr.length() != 8 || -1 != spIndex) {
            return "18880808";
        }
        try {
            DA_FORMAT_PARSE.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            return "18880808";
        }
    }

    public static Object validateTime(Object time) {
        int len;
        if (null == time) {
            return "000000.000";
        }
        String timeStr = time.toString();
        int st = 0;
        for (len = timeStr.length(); st < len && timeStr.charAt(len - 1) <= ' '; --len) {
        }
        timeStr = st > 0 || len < timeStr.length() ? timeStr.substring(st, len) : timeStr;
        timeStr = timeStr.replaceAll("\\:", "");
        int dotIndex = timeStr.indexOf(46);
        if (timeStr.length() < 2 || timeStr.length() > 13 || -1 != dotIndex && 6 != dotIndex || ' ' == timeStr.charAt(0)) {
            return "000000.000";
        }
        if (timeStr.length() == 2) {
            timeStr = timeStr + "0000.0";
        } else if (timeStr.length() == 4) {
            timeStr = timeStr + "00.0";
        } else if (-1 == dotIndex && timeStr.length() == 6) {
            timeStr = timeStr + ".0";
        }
        if (0 < dotIndex) {
            String frac = StudyDirectoryRecordType.fracInMS(timeStr.substring(dotIndex + 1));
            timeStr = timeStr.substring(0, dotIndex) + "." + frac;
        }
        try {
            TM_FORMAT_PARSE.parse(timeStr);
            return time;
        }
        catch (ParseException pex) {
            return "000000.000";
        }
    }

    protected static String fracInMS(String frac) {
        String padded = frac.length() > 3 ? frac.substring(0, 3) : (frac.length() == 0 ? "000" : frac);
        return padded;
    }
}

