/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dmtest;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.ImageCreator;

public class CacheCheck {
    ImageCreator ic = null;
    DMSession session = new DMSession(new String[]{"terra", "terradb", "localhost"});

    public static void fail(String msg) {
        System.err.println("ERROR: " + msg);
        System.exit(1);
    }

    public CacheCheck() {
        try {
            this.ic = new ImageCreator();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session.addDMEventListener(1, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent event) {
                CacheCheck.this.installHandler();
            }
        });
        this.session.addDMEventListener(2, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent event) {
                CacheCheck.this.generalHandler();
            }
        });
    }

    public void installHandler() {
        int size = this.session.getChildren().length;
        System.out.println(">>Install Event, size= " + size);
        if (size != 1) {
            CacheCheck.fail("in install event");
        }
    }

    public void generalHandler() {
        int size = this.session.getChildren().length;
        System.out.println(">>General Event, size= " + size);
        if (size != 0 && ((String)this.session.getChildren()[0].getValue(16, 16)).startsWith("Patient")) {
            CacheCheck.fail("in general event");
        }
    }

    public void doInstall() throws Exception {
        this.ic.install(1, 1, 1, 1, this.session);
    }

    public void doDelete() {
        DMObject[] pats = this.session.getChildren();
        for (int i = 0; i < pats.length; ++i) {
            pats[i].delete();
        }
    }

    public static void main(String[] args) {
        try {
            CacheCheck ct = new CacheCheck();
            ct.doDelete();
            while (true) {
                ct.doInstall();
                int numPatients = ct.session.getChildren().length;
                System.out.println("# of patients= " + numPatients);
                if (numPatients != 1) {
                    CacheCheck.fail("in item query");
                }
                DMElement elem = new DMElement();
                elem.group = 16;
                elem.element = 16;
                elem.vrep = 20558;
                elem.value = "" + System.currentTimeMillis();
                ct.session.getChildren()[0].setValues(new DMElement[]{elem});
                String pName = (String)ct.session.getChildren()[0].getValue(16, 16);
                System.out.println("pName= " + pName);
                SimpleUtilities.sleep(1000L);
                ct.doDelete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
            return;
        }
    }
}

