/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dmtest;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.ImageCreator;

public class MemoryCheck {
    ImageCreator ic = null;
    DMSession session = new DMSession(new String[]{"terra", "terradb", "localhost"});
    DMTag[] ptTags = new DMTag[]{new DMTag(16, 32), new DMTag(8, 32), new DMTag(16, 16), new DMTag(9, 4123), new DMTag(9, 4115), new DMTag(9, 4116)};

    public MemoryCheck() {
        try {
            this.ic = new ImageCreator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.session.addDMEventListener(1, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent event) {
                MemoryCheck.this.installHandler();
            }
        });
        this.session.addDMEventListener(2, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent event) {
                MemoryCheck.this.generalHandler();
            }
        });
    }

    public void installHandler() {
        this.doPatientTableQuery();
    }

    public void generalHandler() {
    }

    public void collect() {
        System.gc();
        SimpleUtilities.sleep(1000L);
        System.gc();
        SimpleUtilities.sleep(1000L);
        System.out.println("Hopefully forced garbage collection!");
        SimpleUtilities.sleep(5000L);
    }

    public void installTest() throws Exception {
        for (int i = 1; i <= 100; ++i) {
            this.ic.install(1, 4, 1, 2, this.session);
            SimpleUtilities.sleep(50L);
            if (i % 10 != 0) continue;
            System.out.println("# of patients installed= " + i);
            this.collect();
        }
    }

    public void doPatientTableQuery() {
        DMObject[] studies = this.session.getRelated("study");
        int i = 0;
        for (i = 0; i < studies.length && i < 20; ++i) {
            for (int j = 0; j < this.ptTags.length; ++j) {
                Object object = studies[i].getValue(this.ptTags[j]);
            }
        }
        System.out.println("read " + this.ptTags.length + " tags from " + i + " studies");
    }

    public void deleteAll() {
        DMObject[] pats = this.session.getChildren();
        for (int i = 0; i < pats.length; ++i) {
            pats[i].delete();
        }
    }

    public static void main(String[] args) {
        try {
            MemoryCheck mt = new MemoryCheck();
            mt.deleteAll();
            mt.installTest();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

