/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.list;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import java.util.logging.Level;

public class ListObjectInfo {
    protected String id;
    protected String originalId;
    protected String type;
    protected String[] sessionArgs;
    protected boolean persisted;

    public ListObjectInfo(String id, String originalId, String type, String[] sessionArgs) {
        this.id = id;
        this.originalId = originalId;
        this.type = type.toLowerCase();
        this.sessionArgs = sessionArgs;
    }

    public ListObjectInfo(String id, DMiObject dmo, String[] sessionArgs) {
        this(id, dmo.getID(), dmo.getType(), sessionArgs);
    }

    public String[] getSessionArgs() {
        return this.sessionArgs;
    }

    public void setSessionArgs(String[] sessionArgs) {
        this.sessionArgs = sessionArgs;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    private boolean compareSessionArgs(String[] sessionArgs) {
        boolean same = false;
        if (null == sessionArgs) {
            if (null == this.sessionArgs) {
                same = true;
            }
        } else if (null != this.sessionArgs && this.sessionArgs.length == sessionArgs.length) {
            same = true;
            for (int i = 0; same && i < sessionArgs.length; ++i) {
                String args = this.sessionArgs[i];
                same = null != args && args.equalsIgnoreCase(sessionArgs[i]);
            }
        }
        return same;
    }

    public boolean equals(Object obj) {
        boolean same = false;
        if (obj instanceof ListObjectInfo) {
            ListObjectInfo info = (ListObjectInfo)obj;
            Tap.log.log(Level.INFO, "Comparing [{0}] and [{1}]", new Object[]{this, info});
            same = this.getOriginalId().equalsIgnoreCase(info.getOriginalId()) && this.getType().equalsIgnoreCase(info.getType()) && this.compareSessionArgs(info.sessionArgs);
        }
        return same;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.id);
        buffer.append(";");
        buffer.append(this.originalId);
        buffer.append(";");
        buffer.append(this.type);
        buffer.append(";");
        for (int i = 0; i < this.sessionArgs.length; ++i) {
            buffer.append(i > 0 ? "," : "");
            buffer.append(this.sessionArgs[i]);
        }
        return buffer.toString();
    }
}

