/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.list;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.list.ListComposite;
import com.ge.med.terra.tap.dm.list.ListDB;
import com.ge.med.terra.tap.dm.list.ListObject;
import com.ge.med.terra.tap.dm.list.ListObjectInfo;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class ListSession
implements DMiSession {
    public static final int PATIENT = 0;
    public static final int STUDY = 1;
    public static final int SERIES = 2;
    public static final int IMAGE = 3;
    public static final String[] LEVELS = new String[]{"patient", "study", "series", "image"};
    protected ListDB dbData;
    final int MAX_SIZE = 200000;
    protected Map cache = new LinkedHashMap(200000){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 200000;
        }
    };

    @Override
    public void ClearCache() {
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
    }

    @Override
    public DMiJob asynSend(String str) {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        return this.getRelated(LEVELS[0], q);
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        this.getRelated(LEVELS[0], q, cb);
    }

    @Override
    public DMiComposite getComposite(String id) {
        return this.createListComposite(id);
    }

    @Override
    public DMiComposite[] getComposites() {
        String[] ids = this.dbData.getIds();
        HashSet<DMiComposite> result = new HashSet<DMiComposite>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            ListObject dmo = this.createListObject(ids[i]);
            DMiComposite[] comps = dmo.getComposites(null);
            for (int j = 0; j < comps.length; ++j) {
                result.add(comps[j]);
            }
        }
        return result.toArray(new DMiComposite[result.size()]);
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        return this.createListObject(id);
    }

    @Override
    public DMiJob[] getJobs() {
        throw new UnsupportedOperationException("Method ListSession:getJobs() not implemented.");
    }

    @Override
    public int getNumberOfComposites() {
        String[] ids = this.dbData.getIds();
        HashSet<DMiComposite> result = new HashSet<DMiComposite>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            ListObject dmo = this.createListObject(ids[i]);
            DMiComposite[] comps = dmo.getComposites(null);
            for (int j = 0; j < comps.length; ++j) {
                result.add(comps[j]);
            }
        }
        return result.size();
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q, rcvr);
        return list.toArray(new DMiObject[list.size()]);
    }

    @Override
    public void getRelated(String type, DMQuery q, DMiObjectReceiver cb) {
        String[] ids = this.dbData.getIds();
        HashSet<DMiObject> result = new HashSet<DMiObject>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            ListObject listObject = this.createListObject(ids[i]);
            if (listObject.getType().equals(type)) {
                result.add(listObject);
                continue;
            }
            DMiObject[] objs = listObject.getRelated(type, q);
            for (int j = 0; j < objs.length; ++j) {
                result.add(objs[j]);
            }
        }
        for (ListObject listObject : result) {
            if (q != null && !q.valid(listObject) || cb.gotOne(listObject)) continue;
            return;
        }
    }

    @Override
    public void init(String session, String[] args) {
        this.dbData = new ListDB(session);
        ListObjectInfo[] data = this.dbData.getAll();
        for (int i = 0; i < data.length; ++i) {
            ListObjectInfo info = data[i];
            this.cache.put(info.getId(), info);
        }
    }

    @Override
    public void install(InputStream is) throws IOException {
        throw new UnsupportedOperationException("Method ListSession:install() not supported.");
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        throw new UnsupportedOperationException("Method ListSession:installFiles() not supported.");
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
    }

    @Override
    public void save(DMiObject dmo, Hashtable prop) {
        DMiObject[] dmoArray = new DMiObject[]{dmo};
        this.save(dmoArray, prop);
    }

    @Override
    public void save(DMiObject[] dmo, Hashtable prop) {
        DMSession dms = (DMSession)prop.get("From");
        String[] args = dms.getSessionArgs();
        for (int i = 0; i < dmo.length; ++i) {
            ListObjectInfo info = new ListObjectInfo(ListSession.getId(dmo[i]), dmo[i], args);
            this.dbData.add(info);
            this.cache.put(info.getId(), info);
        }
    }

    @Override
    public void save(DMiComposite dmc, Hashtable prop) {
        DMSession dms = (DMSession)prop.get("From");
        String[] args = dms.getSessionArgs();
        ListObjectInfo info = new ListObjectInfo(ListSession.getId(dmc), dmc.getID(), LEVELS[3], args);
        this.dbData.add(info);
        this.cache.put(info.getId(), info);
    }

    @Override
    public String[] send(String str) {
        DMSession[] sessions = this.dbData.getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            sessions[i].send(str);
        }
        return null;
    }

    protected ListObject createListObject(String id) {
        ListObjectInfo info = (ListObjectInfo)this.cache.get(id);
        DMSession session = DMSession.getSession(info.getSessionArgs());
        DMObject dmo = session.getDMObject(info.getType(), info.getOriginalId());
        return new ListObject(id, dmo.getPeer(), this);
    }

    protected ListObject createListObject(String parentId, DMiObject dmo) {
        String[] args = ((ListObjectInfo)this.cache.get(parentId)).getSessionArgs();
        ListObjectInfo info = new ListObjectInfo(ListSession.getId(dmo), dmo, args);
        this.cache.put(info.getId(), info);
        return new ListObject(info.getId(), dmo, this);
    }

    protected ListComposite createListComposite(String id) {
        int index;
        ListComposite composite = null;
        if (id != null && (index = id.indexOf(124)) > 0) {
            String objId = id.substring(0, index);
            String compId = id.substring(index + 1);
            ListObject dmo = this.createListObject(objId);
            ListComposite[] dmc = (ListComposite[])dmo.getComposites(null);
            for (int i = 0; i < dmc.length; ++i) {
                if (!dmc[i].getOriginalId().equals(compId)) continue;
                composite = dmc[i];
                break;
            }
        }
        return composite;
    }

    protected static String getId(DMiObject dmo) {
        String prefix = dmo.getType().substring(0, 2).toUpperCase();
        String id = prefix + dmo.getID();
        Tap.log.log(Level.FINE, "Object ID={0}", id);
        return id;
    }

    protected static String getId(DMiComposite dmc) {
        String prefix = "CO";
        String id = prefix + dmc.getID();
        Tap.log.log(Level.FINE, "Object ID={0}", id);
        return id;
    }
}

