/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mem;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.mem.Mem;
import com.ge.med.terra.tap.dm.mem.MemComposite;
import com.ge.med.terra.tap.dm.mem.MemSession;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.util.dicom.TagValueList;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class MemObject
extends Mem
implements DMiObject,
DMTagValueInterface {
    MemSession ses;
    int level;
    Vector compVec = new Vector();
    Hashtable childTable = new Hashtable();
    MemComposite refComp;

    public MemObject(MemSession ses, int level, MemComposite comp, tagValue[] keyTags) {
        this.ses = ses;
        this.level = level;
        this.compVec.add(comp);
        if (level < 3) {
            this.addComposite(comp, keyTags);
        }
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    public void addComposite(MemComposite comp, tagValue[] keyTags) {
        TagValueList tvl = MemObject.buildTVList(MemObject.extractTagsGivenLevel(this.level + 1, keyTags));
        MemObject o = (MemObject)this.childTable.get(tvl);
        if (o == null) {
            this.childTable.put(tvl, new MemObject(this.ses, this.level + 1, comp, keyTags));
        } else {
            o.addComposite(comp, keyTags);
        }
    }

    private DMiObject[] getChildren(DMQuery q) {
        Iterator iter = this.childTable.values().iterator();
        ArrayList<MemObject> a = new ArrayList<MemObject>();
        while (iter.hasNext()) {
            MemObject item = (MemObject)iter.next();
            if (q != null && !q.valid(item)) continue;
            a.add(item);
        }
        return a.toArray(new DMiObject[a.size()]);
    }

    @Override
    public String getType() {
        return ieorder[this.level];
    }

    @Override
    public Object getValue(DMTag t) {
        return ((MemComposite)this.compVec.get(0)).getValue(t);
    }

    @Override
    public void getValues(DMElement[] elements) {
        ((MemComposite)this.compVec.get(0)).getValues(elements);
    }

    @Override
    public void setValues(DMElement[] elements) {
        for (MemComposite item : this.compVec) {
            item.setValues(elements);
        }
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q) {
        ArrayList<MemComposite> a = new ArrayList<MemComposite>();
        for (MemComposite item : this.compVec) {
            if (q != null && !q.valid(item)) continue;
            a.add(item);
        }
        return a.toArray(new DMiComposite[a.size()]);
    }

    @Override
    public int getNumberOfComposites(DMQuery q) {
        return this.compVec.size();
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        int ieLevel = MemObject.getLevel(ieType);
        if (ieLevel == this.level) {
            return this.getChildren(q);
        }
        Iterator iter = this.childTable.values().iterator();
        ArrayList<DMiObject> list = new ArrayList<DMiObject>();
        while (iter.hasNext()) {
            MemObject child = (MemObject)iter.next();
            DMiObject[] tmp = child.getRelated(ieType, null);
            for (int i = 0; i < tmp.length; ++i) {
                if (q != null && !q.valid((MemObject)tmp[i])) continue;
                list.add(tmp[i]);
            }
        }
        return list.toArray(new DMiObject[list.size()]);
    }

    @Override
    public void getRelated(String ieType, DMQuery q, DMiObjectReceiver cb) {
        int ieLevel = MemObject.getLevel(ieType);
        if (ieLevel == this.level) {
            if (q == null || q.valid(this)) {
                cb.gotOne(this);
            }
        } else if (ieLevel == this.level + 1) {
            for (MemObject child : this.childTable.values()) {
                if (q != null && !q.valid(child)) continue;
                cb.gotOne(child);
            }
            return;
        }
        for (MemObject child : this.childTable.values()) {
            DMiObject[] tmp = child.getRelated(ieType, null);
            for (int i = 0; i < tmp.length; ++i) {
                if (q != null && !q.valid((MemObject)tmp[i])) continue;
                cb.gotOne(tmp[i]);
            }
        }
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q) {
        return this.getRelated(ieType, q).length;
    }

    @Override
    public void delete() {
        System.err.println("in delete");
        this.destroy();
        System.err.println("destroy done");
        if (this.level == 0) {
            return;
        }
        try {
            ((MemObject[])this.getRelated("patient", null))[0].removeComposites(this.compVec, this.level);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        System.err.println("remove composites done");
    }

    void removeComposites(Vector vec, int blevel) {
        if (this.level == blevel) {
            return;
        }
        System.err.println("removecomposites " + this.level);
        if (this.compVec == null) {
            return;
        }
        Iterator iter = vec.iterator();
        while (iter.hasNext()) {
            this.compVec.remove(iter.next());
        }
        Enumeration child = this.childTable.keys();
        Vector v = new Vector();
        while (child.hasMoreElements()) {
            Object key = null;
            Object k = child.nextElement();
            key = k;
            MemObject item = (MemObject)this.childTable.get(k);
            if (item.compVec != null) continue;
            v.add(key);
        }
        Iterator keyiter = v.iterator();
        while (keyiter.hasNext()) {
            this.childTable.remove(keyiter.next());
        }
        for (MemObject item : this.childTable.values()) {
            item.removeComposites(vec, blevel);
        }
    }

    void destroy() {
        for (MemObject item : this.childTable.values()) {
            item.destroy();
            this.compVec = null;
        }
        this.childTable = null;
        this.refComp = null;
    }

    @Override
    public DMTag[] getTags() {
        return null;
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        ArrayList<BufferedImage> al = new ArrayList<BufferedImage>(this.compVec.size());
        for (MemComposite item : this.compVec) {
            BufferedImage[] tmp = item.getPixelData(tags);
            for (int i = 0; i < tmp.length; ++i) {
                al.add(tmp[i]);
            }
        }
        return al.toArray(new BufferedImage[al.size()]);
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public String getID() {
        return this.toString();
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        try {
            DMiComposite[] comp = this.getComposites(null);
            ArrayList<DMiImage> al = new ArrayList<DMiImage>(comp.length);
            for (int i = 0; i < comp.length; ++i) {
                DMiImage[] dmi = comp[i].getImages(tags);
                for (int j = 0; j < dmi.length; ++j) {
                    al.add(dmi[j]);
                }
            }
            return al.toArray(new DMiImage[al.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

