/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mem;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.mem.Mem;
import com.ge.med.terra.tap.dm.mem.MemComposite;
import com.ge.med.terra.tap.dm.mem.MemObject;
import com.ge.med.terra.tap.dm.mem.memBuffer;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.util.dicom.TagValueList;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class MemSession
extends Mem
implements DMiSession {
    Hashtable compHash = new Hashtable();
    dicomParser oparser = new dicomParser();
    Hashtable childTable = new Hashtable();
    int imgsize = 0;
    int no_of_img = 0;
    boolean fixmem = false;
    private final String[] level = new String[]{"patient", "study", "series", "image"};
    Vector eventList = new Vector();
    byte[] inputBuffer = null;

    @Override
    public DMiComposite getComposite(String id) {
        return (DMiComposite)this.compHash.get(id);
    }

    @Override
    public DMiComposite[] getComposites() {
        return this.compHash.values().toArray(new DMiComposite[0]);
    }

    @Override
    public int getNumberOfComposites() {
        return this.compHash.size();
    }

    @Override
    public void init(String session, String[] args) {
        String IMGSIZESTR = "IMAGESIZE=";
        String NOIMG = "NOIMG=";
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            String upper = args[i].toUpperCase();
            if (upper.startsWith("IMAGESIZE=")) {
                this.imgsize = Integer.parseInt(args[i].substring("IMAGESIZE=".length()));
            }
            if (!upper.startsWith("NOIMG=")) continue;
            this.no_of_img = Integer.parseInt(args[i].substring("NOIMG=".length()));
        }
        boolean bl = this.fixmem = this.imgsize != 0 && this.no_of_img != 0;
        if (this.fixmem) {
            // empty if block
        }
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        final ArrayList a = new ArrayList();
        this.getChildren(q, new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject o) {
                a.add(o);
                return true;
            }
        });
        return a.toArray(new DMiObject[a.size()]);
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        for (MemObject item : this.childTable.values()) {
            boolean ret;
            if (q != null && !q.valid(item) || (ret = cb.gotOne(item))) continue;
            break;
        }
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        this.getRelated(ieType, q, new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject o) {
                list.add(o);
                return true;
            }
        });
        return list.toArray(new DMiObject[list.size()]);
    }

    @Override
    public void getRelated(String type, DMQuery q, DMiObjectReceiver cb) {
        final String ieType = type;
        final DMQuery query = q;
        final DMiObjectReceiver fcb = cb;
        final DMiObjectReceiver callback = new DMiObjectReceiver(){
            boolean ret = true;

            @Override
            public boolean gotOne(DMiObject o) {
                if (o != null) {
                    this.ret = fcb.gotOne(o);
                }
                return this.ret;
            }
        };
        if (this.level[0].equalsIgnoreCase(type)) {
            this.getChildren(q, cb);
        } else {
            this.getChildren(q, new DMiObjectReceiver(){

                @Override
                public boolean gotOne(DMiObject o) {
                    o.getRelated(ieType, query, callback);
                    return callback.gotOne(null);
                }
            });
        }
    }

    @Override
    public void save(DMiObject o, Hashtable prop) {
        DMiComposite[] c = o.getComposites(null);
        for (int i = 0; i < c.length; ++i) {
            this.save(c[i], prop);
        }
    }

    @Override
    public void save(DMiObject[] o, Hashtable prop) {
        for (int i = 0; i < o.length; ++i) {
            this.save(o[i], prop);
        }
    }

    @Override
    public void save(DMiComposite o, Hashtable prop) {
        try {
            InputStream is = o.getInputStream();
            this.install(is);
            is.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        this.eventList.add(new EventContainer(eventType, listener));
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
        Iterator iter = this.eventList.iterator();
        EventContainer cont = null;
        while (iter.hasNext()) {
            EventContainer item = (EventContainer)iter.next();
            if (!item.listener.equals(listener)) continue;
            cont = item;
        }
        this.eventList.remove(cont);
    }

    private void fireEvent(int type, String msg) {
        Iterator iter = this.eventList.iterator();
        DMEvent e = new DMEvent(type, msg);
        while (iter.hasNext()) {
            EventContainer item = (EventContainer)iter.next();
            if (item.eventType != type) continue;
            item.listener.actionPerformed(e);
        }
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        for (int i = 0; i < files.length; ++i) {
            FileInputStream is = new FileInputStream(files[i]);
            this.install(is);
            ((InputStream)is).close();
            if (!destroy) continue;
            files[i].delete();
        }
    }

    @Override
    public void install(InputStream is) throws IOException {
        try {
            int in;
            if (this.inputBuffer == null) {
                this.inputBuffer = new byte[0x100000];
            }
            int buflen = this.inputBuffer.length;
            int off = 0;
            int len = buflen;
            while ((in = is.read(this.inputBuffer, off, len)) >= 0) {
                if (buflen == (off += in)) {
                    byte[] tmp = new byte[buflen * 2];
                    System.arraycopy(this.inputBuffer, 0, tmp, 0, this.inputBuffer.length);
                    this.inputBuffer = tmp;
                    buflen = this.inputBuffer.length;
                }
                len = buflen - off;
            }
            byte[] compdata = new byte[off];
            System.arraycopy(this.inputBuffer, 0, compdata, 0, off);
            MemComposite mc = new MemComposite(this, new memBuffer(compdata));
            mc.getValues(Mem.keyTags);
            TagValueList tvl = Mem.buildTVList(Mem.extractTagsGivenLevel(1, Mem.keyTags));
            if (this.childTable.containsKey(tvl)) {
                ((MemObject)this.childTable.get(tvl)).addComposite(mc, Mem.keyTags);
            } else {
                MemObject patent = new MemObject(this, 0, mc, Mem.keyTags);
                this.childTable.put(tvl, patent);
            }
            String id = mc.getID();
            if (id == null) {
                throw new RuntimeException("no SOP instance UID for composite");
            }
            this.compHash.put(id, mc);
            this.fireEvent(1, id);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void addComposite(MemComposite comp) {
        comp.getValues(keyTags);
        TagValueList l = MemSession.buildTVList(MemSession.tvget(patNum, keyTags));
        MemObject o = (MemObject)this.childTable.get(l);
        if (o == null) {
            this.childTable.put(l, new MemObject(this, 0, comp, keyTags));
        } else {
            o.addComposite(comp, keyTags);
        }
        String id = comp.getID();
        if (id == null) {
            throw new RuntimeException("no SOP instance UID for composite");
        }
        this.compHash.put(id, comp);
        this.fireEvent(1, id);
    }

    @Override
    public String[] send(String str) {
        return null;
    }

    @Override
    public DMiJob asynSend(String str) {
        return null;
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        if ("patient".equalsIgnoreCase(type)) {
            for (MemObject item : this.childTable.values()) {
                if (!item.getID().equals(id)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public void ClearCache() {
    }

    @Override
    public DMiJob[] getJobs() {
        return null;
    }

    @Override
    public void close() {
    }

    class EventContainer {
        int eventType;
        DMEventListener listener;

        public EventContainer(int type, DMEventListener l) {
            this.eventType = type;
            this.listener = l;
        }
    }
}

