/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mwl;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ResponsePolicy;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.mwl.DicomObjectReceiver;
import com.ge.med.terra.tap.dm.mwl.MwlSession;
import com.ge.med.terra.tap.dm.mwl.MwlUtils;
import com.ge.med.terra.tap.util.dicom.SOPClassUtil;
import com.ge.med.terra.tap.util.socket.SocketUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;

public class CFind {
    public static final int OK = 0;
    public static final int NOT_OK = 1;
    public static final int C_FIND_COMPLETED = 0;
    public static final int C_FIND_PENDING_OK = 65280;
    public static final int C_FIND_PENDING_WARNING = 65281;
    private String calledAE;
    private String callingAE;
    private String calledHost;
    private int calledPort;
    private int[] tsids = new int[]{8193, 8195};
    private int socketTmo = Integer.parseInt(Tap.getProperty("tap.dm.nw.socketTmo", "0"));
    private Socket socket;
    private Association as;
    private int maxPduSize = Integer.parseInt(Tap.getProperty("tap.dm.scu.cfindMaxPduSize", "16352"));
    private int pContext = 4141;
    private Random rand = new Random();
    private int range = 100;
    private Vector<DicomObject> vect = new Vector();
    private boolean debug = false;
    private boolean isSecureNode;

    CFind(String calledAE, String calledHost, int calledPort, String callingAE) {
        this(calledAE, calledHost, calledPort, callingAE, null);
    }

    CFind(String calledAE, String calledHost, int calledPort, String callingAE, Properties props) {
        int[] arr;
        this.calledAE = calledAE;
        this.callingAE = callingAE;
        this.calledHost = calledHost;
        this.calledPort = calledPort;
        String tp = null;
        if (props != null) {
            String tmo;
            tp = props.getProperty("TransferParams");
            if (tp != null) {
                this.tsids = MwlSession.parseTransferParams(tp);
            }
            if ((tmo = props.getProperty("socketTmo")) != null) {
                this.socketTmo = Integer.parseInt(tmo);
            }
        }
        if ((props == null || tp == null) && (arr = SOPClassUtil.parseSOPClasses(Tap.getProperty("tap.dm.scu.cfindTS"))) != null) {
            this.tsids = arr;
        }
        this.debug = MwlSession.debug();
    }

    public CFind(String calledAE, String calledHost, int calledPort, String callingAE, boolean isSecureNode, Properties props) throws Exception {
        this(calledAE, calledHost, calledPort, callingAE, props);
        this.isSecureNode = isSecureNode;
    }

    public int getQueryRetrieveInfoModel() {
        return this.pContext;
    }

    public int makeAssociation() throws Exception {
        if (this.socket != null && this.as != null) {
            return 0;
        }
        SocketUtil sockUtil = new SocketUtil();
        this.socket = this.isSecureNode ? sockUtil.getSSLSocket(this.calledHost, this.calledPort, this.socketTmo) : sockUtil.getSocket(this.calledHost, this.calledPort, this.socketTmo);
        this.as = MwlUtils.createAssociation(this.socket);
        Request request = new Request();
        request.setCalledTitle(this.calledAE);
        request.setCallingTitle(this.callingAE);
        request.setMaxPduSize(this.maxPduSize);
        request.addPresentationContext(this.pContext, this.tsids);
        if (this.debug) {
            System.out.println("C-FIND: Request Packet is \n" + request.toString());
        }
        this.as.sendAssociateRequest(request);
        Response response = this.as.receiveAssociateResponse();
        if (this.debug) {
            System.out.println("C-FIND: Response Packet is \n" + response.toString());
        }
        if (response instanceof Acknowledge) {
            Acknowledge ack = (Acknowledge)response;
            int result = ResponsePolicy.getResultForAbstractSyntax(request, ack, this.pContext);
            switch (result) {
                case 0: {
                    if (this.debug) {
                        System.out.println("C-FIND: Association accepted");
                    }
                    return 0;
                }
                case 3: {
                    Tap.log.log(Level.WARNING, "C-FIND: abstract syntax not supported");
                    return 1;
                }
                case 4: {
                    Tap.log.log(Level.WARNING, "C-FIND: transfer syntaxes not supported");
                    return 1;
                }
                case 1: {
                    Tap.log.log(Level.WARNING, "C-FIND: user rejection of presentation context");
                    return 1;
                }
                case 2: {
                    Tap.log.log(Level.WARNING, "C-FIND: presentation context refused, no reason given");
                    return 1;
                }
            }
            Tap.log.log(Level.WARNING, "C-FIND: Unknown Result for Abstract Syntax");
            return 1;
        }
        if (response instanceof Reject) {
            Tap.log.log(Level.WARNING, "C-FIND: association rejected: " + response);
            return 1;
        }
        if (response instanceof Abort) {
            Tap.log.log(Level.WARNING, "C-FIND: association aborted: " + response);
            return 1;
        }
        Tap.log.log(Level.WARNING, "C-FIND: unknown error");
        return 1;
    }

    public void releaseAssociation() throws IOException, IllegalValueException {
        if (this.socket != null && this.as != null) {
            this.as.sendReleaseRequest();
            this.as.receiveReleaseResponse();
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public void abortAssociation() throws IOException {
        if (this.socket != null && this.as != null) {
            this.as.sendAbort(0, 0);
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public int doFind(DicomObject dataSet) {
        return this.doFind(dataSet, null);
    }

    public int doFind(DicomObject dataSet, DicomObjectReceiver dor) {
        this.vect.clear();
        try {
            String sopclass;
            DicomObject req = DimseUtil.createFindRequest(new Integer(this.rand.nextInt(this.range)), new Integer(this.pContext), new Integer(0));
            if (this.debug) {
                System.out.println("C-FIND: request:");
                req.dumpVRs(System.out);
                System.out.println("C-FIND: data:");
                dataSet.dumpVRs(System.out);
            }
            this.as.send(this.pContext, req, dataSet);
            DicomObject res = this.as.receiveCommand();
            int commandfield = res.getI(256);
            if (commandfield != 32800) {
                Tap.log.log(Level.WARNING, "No C-FIND RESPONSE command field : " + Integer.toHexString(commandfield));
                this.abortAssociation();
            }
            if ((sopclass = res.getS(2)) != null && UID.getUIDEntry(sopclass).getConstant() != this.pContext) {
                Tap.log.log(Level.WARNING, "Affected Study Class UID in C-FIND RESPONSE wrong: " + sopclass);
                this.abortAssociation();
            }
            int status = res.getI(2304);
            while ((status == 65280 || status == 65281) && res != null) {
                res = this.as.receiveData();
                if (res == null) continue;
                if (this.debug) {
                    System.out.println("C-FIND: got one:");
                    res.dumpVRs(System.out);
                }
                this.vect.add(res);
                if (null != dor && !dor.gotOne(res)) break;
                res = this.as.receiveCommand();
                status = res.getI(2304);
            }
            if (this.debug) {
                System.out.println("C-FIND: got " + this.vect.size() + " objects");
            }
            if (status == 0) {
                return 0;
            }
            return 1;
        }
        catch (Exception ex) {
            Tap.log.log(Level.SEVERE, "Error during C-FIND: ", ex);
            throw new DMException(ex);
        }
    }

    public DicomObject[] getObjects() {
        DicomObject[] obj = this.vect.toArray(new DicomObject[this.vect.size()]);
        return obj;
    }

    public String[] getStudyInstanceUIDs() {
        String[] str = new String[this.vect.size()];
        for (int i = 0; i < str.length; ++i) {
            str[i] = (String)this.vect.get(i).get(0x20000D);
        }
        return str;
    }

    public void dumpVRs() {
        for (int i = 0; i < this.vect.size(); ++i) {
            System.out.println("");
            try {
                this.vect.get(i).dumpVRs(System.out);
                continue;
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Error when dumping VRs: ", ex);
            }
        }
    }

    public void dumpStudyInstances() {
        for (int i = 0; i < this.vect.size(); ++i) {
            try {
                System.out.println(this.vect.get(i).get(0x20000D));
                continue;
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Error when dumping Study Instance UIDs: ", ex);
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Usage: " + CFind.class.getName() + " calledAE calledHost calledPort callingAE");
                return;
            }
            String calledAE = args[0];
            String calledHost = args[1];
            String calledPort = args[2];
            String callingAE = args[3];
            System.out.println("CFind( calledAE=\"" + calledAE + "\", calledHost=\"" + calledHost + "\", calledPort=" + calledPort + ", callingAE=\"" + callingAE + "\" )");
            CFind cf = new CFind(calledAE, calledHost, Integer.parseInt(calledPort), callingAE);
            if (0 == cf.makeAssociation()) {
                System.out.println("Querying for all studies on " + calledAE);
                DicomObject dataSet = MwlSession.tapToDicomMwlQuery(null);
                System.out.println("DICOM data set to use for the query:");
                dataSet.dumpVRs(System.out);
                if (0 == cf.doFind(dataSet)) {
                    System.out.println("C-FIND Successful");
                    System.out.println("Received Study Instance UIDs:");
                    cf.dumpStudyInstances();
                    cf.releaseAssociation();
                } else {
                    System.out.println("C-FIND Failed");
                    cf.abortAssociation();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

