/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mwl;

import com.archimed.dicom.DDate;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Person;
import com.archimed.dicom.TagValue;
import com.archimed.dicom.charset.DicomCharset;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.mwl.MwlComposite;
import com.ge.med.terra.tap.dm.mwl.MwlSequence;
import com.ge.med.terra.tap.dm.mwl.MwlSession;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class MwlObject
implements DMiObject,
DMTagValueInterface {
    protected Set<MwlObject> ref = new HashSet<MwlObject>();
    protected MwlComposite[] composites;
    private static final String[] LEVELS = new String[]{"patient", "study", "series", "image"};
    private String id;
    private String type;
    private MwlSession session;
    private DicomObject dicomObject;
    private int refCount = 0;
    private boolean debug = false;

    public MwlObject(String type, MwlSession session, DicomObject dicomObject) {
        if (type.equalsIgnoreCase("patient")) {
            this.init(type, session, dicomObject);
            this.id = MwlObject.getPatientID(dicomObject);
        } else if (type.equalsIgnoreCase("study") || type.equalsIgnoreCase("exam")) {
            this.init("study", session, dicomObject);
            this.id = MwlObject.getStudyID(dicomObject);
        } else {
            this.id = "UNKNOWN";
            throw new IllegalArgumentException("Invalid IE type: " + type);
        }
    }

    private void init(String type, MwlSession session, DicomObject dicomObject) {
        this.type = type.toUpperCase();
        this.session = session;
        this.dicomObject = dicomObject;
        this.debug = MwlSession.debug();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Object getValue(DMTag tag2) {
        return MwlObject.getValueFromDicomObject(this.dicomObject, tag2);
    }

    @Override
    public void getValues(DMElement[] elements) {
        MwlObject.getValuesFromDicomObject(this.dicomObject, elements);
    }

    @Override
    public void setValues(DMElement[] elements) {
        if (elements == null) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            try {
                this.dicomObject.set_ge(elements[i].group, elements[i].element, elements[i].value);
                continue;
            }
            catch (DicomException dex) {
                Tap.log.log(Level.WARNING, "Error when setting value for element " + elements[i], dex);
            }
        }
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q) {
        if (null == this.composites) {
            ArrayList<MwlComposite> compList = new ArrayList<MwlComposite>();
            if (this.type.equalsIgnoreCase("patient")) {
                for (MwlObject mwlobj : this.ref) {
                    if (null != q && !q.valid(mwlobj)) continue;
                    compList.add(new MwlComposite(mwlobj.dicomObject, this.session));
                }
            } else if (null == q || q.valid(this)) {
                compList.add(new MwlComposite(this.dicomObject, this.session));
            }
            this.composites = compList.toArray(new MwlComposite[compList.size()]);
        }
        return this.composites;
    }

    @Override
    public int getNumberOfComposites(DMQuery q) {
        return this.getComposites(q).length;
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        DMiObject[] mwlobjs = null;
        ArrayList<MwlObject> mwlList = new ArrayList<MwlObject>();
        if (ieType.equalsIgnoreCase("patient") || ieType.equalsIgnoreCase("study") || ieType.equalsIgnoreCase("exam")) {
            if (this.type.equalsIgnoreCase(ieType)) {
                if (null == q || q.valid(this)) {
                    mwlList.add(this);
                }
            } else {
                for (MwlObject mwlobj : this.ref) {
                    if (null != q && !q.valid(mwlobj)) continue;
                    mwlList.add(mwlobj);
                }
            }
        } else {
            throw new DMException("Invalid IE type: " + ieType);
        }
        mwlobjs = mwlList.toArray(new MwlObject[mwlList.size()]);
        return mwlobjs;
    }

    @Override
    public void getRelated(String ieType, DMQuery q, DMiObjectReceiver callback) {
        DMiObject[] objs = this.getRelated(ieType, q);
        for (int i = 0; i < objs.length && callback.gotOne(objs[i]); ++i) {
        }
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q) {
        return this.getRelated(ieType, q).length;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Method delete() not supported by MWL objects.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not supported by MWL objects.");
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method setLock() not supported by MWL objects.");
    }

    @Override
    public DMTag[] getTags() {
        return MwlObject.getTagsFromDicomObject(this.dicomObject);
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        throw new UnsupportedOperationException("Method getPixelData() not supported by MWL objects.");
    }

    @Override
    public void attach() {
        ++this.refCount;
    }

    @Override
    public void detach() {
        --this.refCount;
    }

    public static String getPatientID(DicomObject dicomObject) {
        return "P|" + dicomObject.get(0x100020);
    }

    public static String getStudyID(DicomObject dicomObject) {
        return "ST|" + dicomObject.get(0x20000D);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        throw new UnsupportedOperationException("Method getImages() not supported by MWL objects.");
    }

    public MwlSession getSession() {
        return this.session;
    }

    public void dump() {
        try {
            this.dicomObject.dumpVRs(System.out);
        }
        catch (IOException ex) {
            Tap.log.log(Level.WARNING, "Error when dumping object contents: ", ex);
        }
    }

    static Object getValueFromDicomObject(DicomObject dicomObject, DMTag tag2) {
        return MwlObject.getValueFromDicomObject(dicomObject, tag2.getGroup(), tag2.getElement());
    }

    static Object getValueFromDicomObject(DicomObject dicomObject, int group, int element) {
        Object obj = dicomObject.get_ge(group, element);
        if (obj instanceof DicomObject) {
            return new MwlSequence(dicomObject, group, element);
        }
        if (obj instanceof Person) {
            return ((Person)obj).toDICOMString();
        }
        if (obj instanceof DDate) {
            return ((DDate)obj).toDICOMString();
        }
        return obj;
    }

    static void getValuesFromDicomObject(DicomObject dicomObject, DMElement[] elements) {
        DicomCharset[] s = dicomObject.dicomCharsets();
        if (s.length > 0 && s[0] == null) {
            try {
                s[0] = DicomCharset.DEFAULT;
                String charsetName = dicomObject.getString(524293, 0, true);
                if ("ISO_IR100".equals(charsetName)) {
                    Tap.log.log(Level.INFO, "Fixing invalid DICOM defined term ISO_IR100");
                    dicomObject.setString(524293, "ISO_IR 100", 0);
                } else {
                    Tap.log.log(Level.INFO, "Fixing odd DICOM defined term " + charsetName);
                    dicomObject.setString(524293, "US-ASCII", 0);
                }
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Error fixing default character set: ", ex);
            }
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i].value = MwlObject.getValueFromDicomObject(dicomObject, elements[i].group, elements[i].element);
        }
    }

    static DMTag[] getTagsFromDicomObject(DicomObject dicomObject) {
        ArrayList<DMTag> al = new ArrayList<DMTag>();
        Enumeration vrs = dicomObject.enumerateVRs(false);
        int i = 0;
        while (vrs.hasMoreElements()) {
            TagValue tv = (TagValue)vrs.nextElement();
            al.add(new DMTag(tv.getGroup(), tv.getElement()));
            ++i;
        }
        return al.toArray(new DMTag[al.size()]);
    }

    private boolean isBelowMe(String ieType) {
        boolean found = false;
        for (int i = 0; i < LEVELS.length; ++i) {
            if (LEVELS[i].equalsIgnoreCase(this.type)) {
                found = true;
            }
            if (!LEVELS[i].equalsIgnoreCase(ieType) || !found) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String ret = this.type + "|";
        ret = this.type.equalsIgnoreCase("patient") ? ret + this.dicomObject.get(0x100010) + "|" + this.dicomObject.get(0x100020) + "|" + this.dicomObject.get(0x100030) : (this.type.equalsIgnoreCase("study") ? ret + this.dicomObject.get(0x20000D) : "UNKNOWN");
        return ret;
    }

    public static void main(String[] args) {
        try {
            MwlSession session = new MwlSession();
            DicomObject dicomObject = new DicomObject();
            dicomObject.set_ge(8, 5, "ISO_IR 100");
            dicomObject.set_ge(16, 16, "Fern\u00e1ndez");
            dicomObject.set_ge(16, 32, "987346890");
            dicomObject.set_ge(16, 48, "19711022");
            dicomObject.set_ge(32, 13, "1.2.3.4.3.23.4.5.2.432.1212.23232");
            MwlObject obj = new MwlObject("study", session, dicomObject);
            System.out.println(obj);
            for (String level : LEVELS) {
                System.out.println(level + " is below me " + obj.isBelowMe(level));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

