/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.TagValue;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.cfind;
import com.ge.med.terra.tap.dm.network.scp;
import com.ge.med.terra.tap.util.dicom.DicomData;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ScpFind
implements ScpService {
    boolean init = false;
    int port = -1;
    Properties props = null;
    boolean debug = false;
    int[] cmds = new int[]{32};
    int[] sops = new int[]{4135, 4132, 4138};

    @Override
    public void init(scp scp2, Properties props) {
        this.debug = Tap.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");
        this.props = props;
        this.init = true;
    }

    @Override
    public int[] getSupportedSOPClass() {
        return this.sops;
    }

    @Override
    public int[] getSupportedCommands() {
        return this.cmds;
    }

    @Override
    public boolean doCommand(int command2, Association as, DicomObject dcm, Request request, Response response) {
        if (command2 == 32) {
            return this.doFind(as, dcm, request);
        }
        return false;
    }

    public boolean doFind(Association as, DicomObject dcm, Request request) {
        DicomObject rdcm = new DicomObject();
        String caller = request.getCallingTitle();
        try {
            String sopclass = dcm.getS(2);
            int supportedSOPClass = -1;
            for (int i = 0; i < this.sops.length; ++i) {
                if (!sopclass.equals(UID.getUIDEntry(this.sops[i]).getValue())) continue;
                supportedSOPClass = i;
                break;
            }
            if (supportedSOPClass == -1) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("wrong sop class in C-FIND REQUEST: " + sopclass + " , aborting");
                }
                as.sendAbort(0, 0);
                return false;
            }
            Integer messageid = (Integer)dcm.get(272);
            if (messageid == null) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("message ID missing from C-ECHO REQUEST, aborting");
                }
                as.sendAbort(0, 0);
                return false;
            }
            DicomObject qdcm = as.receiveData();
            if (this.debug) {
                qdcm.dumpVRs(System.out);
            }
            String level = (String)qdcm.get(524370);
            qdcm.set(524370, null);
            rdcm.set(524370, level);
            Enumeration elements = qdcm.enumerateVRs(true);
            Vector<DMElement> tags = new Vector<DMElement>();
            while (elements.hasMoreElements()) {
                TagValue vr2 = (TagValue)elements.nextElement();
                if (vr2.getElement() == 0 || vr2.getGroup() == 8 && vr2.getElement() == 82) {
                    if (!elements.hasMoreElements()) break;
                    vr2 = (TagValue)elements.nextElement();
                }
                DMElement de = new DMElement(vr2.getGroup(), vr2.getElement());
                tags.add(de);
            }
            DMElement[] dataElements = tags.toArray(new DMElement[tags.size()]);
            DicomObject cmd = DimseUtil.createFindResponse(messageid, new Integer(this.sops[supportedSOPClass]), true, new Integer(65280));
            DMSession ses = scp.getSession();
            if (ses == null) {
                ses = (DMSession)scp.sessionTable.get(caller);
            }
            if (ses == null) {
                new File(scp.cstoreDir + File.separatorChar + caller).mkdir();
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("Making new DMSession: " + scp.cstoreDir + File.separatorChar + caller);
                }
                ses = new DMSession("file", scp.cstoreDir + File.separatorChar + caller, null);
                scp.sessionTable.put(caller, ses);
            }
            DMQuery q = new DMQuery(new DicomData(qdcm));
            if (this.debug) {
                System.out.println("DMQuery: " + q);
            }
            String pid = (String)qdcm.get(0x100020);
            DMObject[] objs = null;
            if (pid != null) {
                objs = ses.getRelated("patient", new DMQuery("(0x0010, 0x0020) = " + pid));
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("patient level PRE getRelated(): " + objs.length);
                }
            }
            for (int l = 0; l < scp.QLEVELS.length; ++l) {
                if (!level.equalsIgnoreCase(scp.QLEVELS[l])) continue;
                DMObject[] dMObjectArray = objs = objs == null || objs.length == 0 ? ses.getRelated(level, q) : objs[0].getRelated(level, q);
                if (Tap.logLevel < Tap.LEVEL_FINE) break;
                Tap.log.fine(level + " level getRelated(): " + objs.length);
                break;
            }
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    objs[i].getValues(dataElements);
                    for (DMElement de : dataElements) {
                        Object value;
                        if (this.debug) {
                            System.out.println("Adding [" + de + "] (" + de.valueAsBytes + ") to C-FIND RESPONSE");
                        }
                        if (null == (value = de.valueAsBytes)) {
                            value = de.value;
                        }
                        rdcm.set_ge(de.group, de.element, value);
                    }
                    rdcm.set(524370, level);
                    if (this.debug) {
                        System.out.println("sending C-FIND RESPONSE: " + (i + 1));
                        rdcm.dumpVRs(System.out);
                    }
                    as.send(this.sops[supportedSOPClass], cmd, rdcm);
                }
            }
            cmd.set(2304, new Integer(0));
            cmd.set(2048, cfind.NO_DATA);
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("sending C-FIND RESPONSE: COMPLETED");
            }
            as.send(this.sops[supportedSOPClass], cmd, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

