/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.scp;
import com.ge.med.terra.tap.util.dicom.SOPClassUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public class ScpStore
implements ScpService {
    ClientServices services;
    Properties props = null;
    scp myscp;
    boolean init = false;
    static Vector clients = new Vector();
    static HashMap waitingOn = new HashMap();
    int[] cmds = new int[]{1};
    int[] sops = new int[]{4119, 4121, 4118, 4131, 4158, 4151, 4153, 4120, 4130, 4128, 4129, 4194, 4195, 4123, 4149, 4148, 4165};
    int localFileTS = 8194;
    boolean debug = Tap.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");
    private static HashMap instances = new HashMap();

    @Override
    public void init(scp newscp, Properties props) {
        int[] arr;
        String sops;
        this.init = true;
        this.myscp = newscp;
        this.services = ScpStore.getClientServices(4921);
        if (props != null && (sops = props.getProperty("tap.dm.scp.localFileTS")) != null && (arr = SOPClassUtil.parseSOPClasses(sops)) != null) {
            this.localFileTS = arr[0];
        }
    }

    @Override
    public int[] getSupportedSOPClass() {
        return this.sops;
    }

    @Override
    public int[] getSupportedCommands() {
        return this.cmds;
    }

    @Override
    public boolean doCommand(int command2, Association as, DicomObject dcm, Request request, Response response) {
        if (command2 == 1) {
            return this.doStore(as, dcm, request.getCallingTitle());
        }
        return false;
    }

    public boolean doStore(Association as, DicomObject dcm, String caller) {
        try {
            DicomObject data;
            String sopclass = dcm.getS(2);
            int supportedSOPClass = -1;
            for (int i = 0; i < this.sops.length; ++i) {
                if (!sopclass.equals(UID.getUIDEntry(this.sops[i]).getValue())) continue;
                supportedSOPClass = i;
                break;
            }
            if (supportedSOPClass == -1) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("wrong sop class in C-STORE REQUEST: " + sopclass + " , aborting");
                }
                as.sendAbort(0, 0);
                return false;
            }
            Integer messageid = (Integer)dcm.get(272);
            if (messageid == null) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("message ID missing from C-STORE REQUEST, aborting");
                }
                as.sendAbort(0, 0);
                return false;
            }
            int priority = dcm.getI(1792);
            int dataSetType = dcm.getI(2048);
            if (dataSetType == 257) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("No Data Set present as per Data Set Type tag, Aborting C-Store");
                }
                as.sendAbort(0, 6);
                return false;
            }
            if (this.debug) {
                Tap.log.info("C-MOVE originator= " + dcm.get(4144));
                Tap.log.info("C-MOVE originator message-ID= " + dcm.get(4145));
                Tap.log.info("received C-STORE REQUEST ... getting data .. ");
            }
            if ((data = as.receiveData()) == null) {
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("Got NULL data");
                }
            } else {
                File dfile;
                String SOPInstanceUID = (String)data.get(524312);
                if (SOPInstanceUID == null) {
                    SOPInstanceUID = (String)data.getFileMetaInformation().get(131075);
                }
                if (this.saveDicom(data, dfile = File.createTempFile(SOPInstanceUID + "-", ".dcm", new File(scp.cstoreDir)))) {
                    if (this.debug) {
                        Tap.log.info(dfile.getAbsolutePath() + " - Saved OK");
                    }
                    if (this.hasListener(SOPInstanceUID)) {
                        if (this.debug) {
                            Tap.log.info("Notifying listeners ..");
                        }
                        this.notifyListener(SOPInstanceUID, dfile.getAbsolutePath());
                    } else {
                        DMSession ses = this.getSessions(caller);
                        if (this.debug) {
                            Tap.log.info("Installing file in " + ses + " ..");
                        }
                        try {
                            ses.installFiles(new File[]{dfile}, true);
                        }
                        catch (Exception e) {
                            if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                                Tap.log.warning("Failed to install- " + dfile.getAbsolutePath());
                            }
                            e.printStackTrace();
                        }
                    }
                }
                data = null;
            }
            DicomObject responsedcm = new DicomObject();
            responsedcm.set(2, UID.getUIDEntry(this.sops[supportedSOPClass]).getValue());
            responsedcm.set(256, new Integer(32769));
            responsedcm.set(288, messageid);
            responsedcm.set(2048, new Integer(257));
            responsedcm.set(2304, new Integer(0));
            responsedcm.set(4096, dcm.get(4096));
            if (this.debug) {
                Tap.log.info("Will send C-STORE response");
                responsedcm.dumpVRs(System.err);
            }
            as.send(this.sops[supportedSOPClass], responsedcm, null);
            Tap.log.fine("sent C-STORE response");
            return true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            try {
                as.sendAbort(0, 0);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return false;
        }
    }

    private boolean saveDicom(DicomObject data, File dfile) throws Exception {
        boolean ret = false;
        FileOutputStream fout = null;
        try {
            if (this.debug) {
                Tap.log.info("About to save file " + dfile.getAbsolutePath());
            }
            fout = new FileOutputStream(dfile);
            if (System.getProperty("MVDI_MODE", "0").equals("1")) {
                data.set(0x100010, "Anonymous");
            }
            if (this.debug) {
                Tap.log.info(">> localFileTS:" + this.localFileTS);
            }
            data.write(fout, true, this.localFileTS, false);
            fout.close();
            ret = true;
        }
        catch (Exception e) {
            if (fout != null) {
                fout.close();
            }
            if (dfile != null) {
                dfile.delete();
            }
            e.printStackTrace();
        }
        return ret;
    }

    private DMSession getSessions(String caller) {
        DMSession ses = scp.getSession();
        if (ses == null) {
            ses = (DMSession)scp.sessionTable.get(caller);
        }
        if (ses == null) {
            Tap.log.info("Making new DMSession");
            if (System.getProperty("MVDI_MODE", "0").equals("1")) {
                Tap.log.info("Found MVDI_MODE");
                String sysId = caller;
                new File(scp.cstoreDir + File.separatorChar + sysId + File.separatorChar + "images").mkdir();
                ses = new DMSession("file", scp.cstoreDir + File.separatorChar + sysId + File.separatorChar + "images", null);
            } else {
                new File(scp.cstoreDir + File.separatorChar + caller).mkdir();
                ses = new DMSession("file", scp.cstoreDir + File.separatorChar + caller, null);
            }
            scp.sessionTable.put(caller, ses);
        }
        return ses;
    }

    public synchronized boolean hasListener(String sopid) {
        return waitingOn.containsKey(sopid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListener(String sopid, String file) {
        ClientProxy p = null;
        HashMap hashMap = waitingOn;
        synchronized (hashMap) {
            Object o = waitingOn.get(sopid);
            if (o instanceof ClientProxy) {
                p = (ClientProxy)o;
                waitingOn.remove(sopid);
            } else if (o instanceof ClientProxy[]) {
                ClientProxy[] pa = (ClientProxy[])o;
                if (pa.length == 2) {
                    p = pa[1];
                    waitingOn.put(sopid, pa[0]);
                } else {
                    ClientProxy[] npa = new ClientProxy[pa.length - 1];
                    System.arraycopy(pa, 0, npa, 0, pa.length - 1);
                    p = pa[pa.length - 1];
                    waitingOn.put(sopid, npa);
                }
            }
        }
        if (null != p) {
            p.notifyOfFile(file);
        } else if (Tap.logLevel >= Tap.LEVEL_WARNING) {
            Tap.log.warning("Unable to find a valid ClientProxy to notify for SOP ID: " + sopid);
        }
    }

    public static void addSopListener(String sopid, ClientProxy prox) {
        HashMap hashMap = waitingOn;
        synchronized (hashMap) {
            Object o = waitingOn.get(sopid);
            if (o == null) {
                waitingOn.put(sopid, prox);
                return;
            }
            if (o instanceof ClientProxy) {
                waitingOn.put(sopid, new ClientProxy[]{(ClientProxy)o, prox});
                return;
            }
            if (o instanceof ClientProxy[]) {
                ClientProxy[] cp = new ClientProxy[((ClientProxy[])o).length + 1];
                System.arraycopy(o, 0, cp, 0, cp.length - 1);
                cp[cp.length - 1] = prox;
                waitingOn.put(sopid, cp);
                return;
            }
            throw new RuntimeException("hash make contains =" + o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpSopListeners() {
        HashMap hashMap = waitingOn;
        synchronized (hashMap) {
            Set list = waitingOn.entrySet();
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("***** Num SopListeners: " + list.size());
            }
        }
    }

    static ClientServices getClientServices(int port) {
        Integer iport = new Integer(port);
        ClientServices inst = (ClientServices)instances.get(iport);
        if (inst == null) {
            inst = new ClientServices(port);
            instances.put(iport, inst);
        }
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            Tap.log.fine("ClientServices.getInstance() ..");
        }
        ScpStore.dumpSopListeners();
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        ScpStore store = new ScpStore();
        Socket s = null;
        try {
            store.init(null, new Properties());
            s = new Socket("localhost", 4921);
            ObjectInputStream is = new ObjectInputStream(s.getInputStream());
            ObjectOutputStream os = new ObjectOutputStream(s.getOutputStream());
            for (int i = 0; i < 5; ++i) {
                os.writeObject("SOP-" + i);
                String res = (String)is.readObject();
                Tap.log.info("Got result: " + res);
            }
            s.close();
        }
        catch (Exception ex) {
            if (null != s) {
                try {
                    s.close();
                }
                catch (IOException os) {
                    // empty catch block
                }
            }
            ex.printStackTrace();
        }
        ScpStore scpStore = store;
        synchronized (scpStore) {
            try {
                store.wait();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static class ClientProxy {
        ObjectOutputStream oos;
        ObjectInputStream ois;
        String clientName = "NONAME";
        boolean debug = Tap.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");

        public ClientProxy(Socket s) throws IOException {
            if (Tap.logLevel <= Tap.LEVEL_FINE) {
                Tap.log.fine("new ClientProxy created ..");
            }
            this.oos = new ObjectOutputStream(s.getOutputStream());
            this.ois = new ObjectInputStream(s.getInputStream());
            try {
                this.clientName = (String)this.ois.readObject();
                if (Tap.logLevel <= Tap.LEVEL_FINE) {
                    Tap.log.fine("Got client name: " + this.clientName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Thread t = new Thread(){

                @Override
                public void run() {
                    Tap.log.fine("Start listening for client commands...");
                    this.listenForSops();
                }
            };
            t.setDaemon(true);
            t.setName("serviceClients");
            t.start();
        }

        public void listenForSops() {
            while (true) {
                try {
                    while (true) {
                        String sop = (String)this.ois.readObject();
                        if (this.debug) {
                            Tap.log.info("Got client <" + this.clientName + "> object: " + sop);
                        }
                        ScpStore.addSopListener(sop, this);
                        this.oos.writeObject("OK");
                    }
                }
                catch (SocketException ex) {
                    ex.printStackTrace();
                }
                catch (EOFException ex) {
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("Exiting listenForSops()..");
            }
            ScpStore.dumpSopListeners();
        }

        public void notifyOfFile(String file) {
            try {
                if (this.debug) {
                    Tap.log.info("Notifying client <" + this.clientName + "> about file: " + file);
                }
                this.oos.writeObject(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    static class ClientServices {
        ServerSocket sock;

        private ClientServices(int port) {
            try {
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("Creating ServerSocket on " + port);
                }
                this.sock = new ServerSocket(port);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        if (Tap.logLevel >= Tap.LEVEL_FINE) {
                            Tap.log.fine("start listening on " + sock);
                        }
                        this.listen();
                    }
                };
                t.setDaemon(true);
                t.setName("serviceClients");
                t.start();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        void listen() {
            while (true) {
                try {
                    while (true) {
                        if (Tap.logLevel >= Tap.LEVEL_FINE) {
                            Tap.log.fine("waiting on sock.accept() ..");
                        }
                        ClientProxy cp = new ClientProxy(this.sock.accept());
                        clients.add(cp);
                    }
                }
                catch (IOException ex) {
                    Tap.log.log(Level.WARNING, "listen() exception: ", ex);
                    ScpStore.dumpSopListeners();
                    continue;
                }
                break;
            }
        }
    }
}

