/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.pesi;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.dmtest.FindDuplicateId;
import com.ge.med.terra.tap.util.tport.TPort;
import java.io.File;
import java.util.ArrayList;

public class CheckPesi {
    public static void printEverything(String root) {
        FindDuplicateId fdi = new FindDuplicateId(new String[]{"pesi", root});
        long start = System.currentTimeMillis();
        fdi.reportContent();
        System.out.println("time taken= " + (System.currentTimeMillis() - start) + " ms");
    }

    public static void printPatients(String root) {
        DMSession ses = new DMSession(new String[]{"pesi", root});
        long start = System.currentTimeMillis();
        DMObject[] pats = ses.getChildren();
        System.out.println("Found " + pats.length + " patients");
        System.out.println("time taken= " + (System.currentTimeMillis() - start) + " ms");
        start = System.currentTimeMillis();
        for (int i = 0; i < pats.length; ++i) {
            System.out.println("patient[" + i + "]= " + pats[i]);
        }
        System.out.println("time taken= " + (System.currentTimeMillis() - start) + " ms");
    }

    public static void showImages(String root) {
        DMSession dms = new DMSession(new String[]{"pesi", root});
        DMObject[] dmo = dms.getRelated("patient");
        TPort.simpleDisplayFrame(dmo[0].getImages(null));
        TPort.simpleDisplayFrame(dmo[1].getImages(null));
    }

    static void buildCompositeList(ArrayList a, File dir) {
        File[] fd = dir.listFiles();
        for (int i = 0; i < fd.length; ++i) {
            if (!fd[i].isDirectory()) {
                a.add(fd[i]);
                continue;
            }
            CheckPesi.buildCompositeList(a, fd[i]);
        }
    }

    public static void TestSOPQuery(String root, String imagePath) {
        DMObject[] patients;
        DMSession dms = new DMSession(new String[]{"pesi", root});
        if (imagePath != null) {
            File dir = new File(imagePath);
            File[] fd = dir.listFiles();
            ArrayList<File> a = new ArrayList<File>();
            for (int i = 0; i < fd.length; ++i) {
                if (!fd[i].isDirectory()) {
                    a.add(fd[i]);
                    continue;
                }
                CheckPesi.buildCompositeList(a, fd[i]);
            }
            File[] images = a.toArray(new File[a.size()]);
            try {
                for (int i = 0; i < images.length; ++i) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((patients = dms.getChildren()).length > 0) {
            DMObject[] series = patients[0].getRelated("series");
            Object sop = series[0].getValue(8, 24);
            System.err.println("sop===" + (String)sop);
            DMObject[] sopImages = dms.getRelated("image", new DMQuery("(0x0008, 0x0018) = " + (String)sop));
            System.err.println("sopImages.length===" + sopImages.length);
        }
    }

    public static void main(String[] args) {
        String root;
        String string = root = System.getProperty("os.name").startsWith("Windows") ? "d:/dev/images/pesi" : "/export/home1/sdc_image_pool/images";
        if (args.length > 0) {
            root = args[0];
        }
        Object imagePath = null;
        if (args.length > 1) {
            CheckPesi.TestSOPQuery(root, args[1]);
        }
    }
}

