/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.pesi;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.pesi.PesiCompositeBase;
import com.ge.med.terra.tap.dm.pesi.PesiSession;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.dm.sessionFile.fileSequence;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PesiComposite
extends PesiCompositeBase
implements DMiComposite,
DMTagValueInterface {
    protected File path;
    private PesiSession session = null;
    private HashMap<DMTag, tagValue> elemCache = new HashMap();

    public PesiComposite(File path, PesiSession ses) {
        this.path = path;
        this.session = ses;
    }

    public PesiComposite(File path) {
        this.path = path;
        this.session = null;
    }

    @Override
    public Object getValue(DMTag tag2) {
        if (this.elemCache.containsKey(tag2)) {
            return this.elemCache.get((Object)tag2).value;
        }
        try {
            parser.setFile(this.getFilePath());
            tagValue tv = new tagValue(tag2.getGroup(), tag2.getElement());
            parser.fill(new tagValue[]{tv});
            if (tv.vrep == 21329) {
                tv.value = new fileSequence(tv);
            }
            if (tag2.getGroup() < 200) {
                this.elemCache.put(new DMTag(tag2.getGroup(), tag2.getElement()), tv);
            }
            Object output = tv.value;
            if (this.session != null && output != null && tag2.getGroup() == 8 && tag2.getElement() == 24) {
                this.session.SOPcache.put(new Integer(output.hashCode()), this.getFilePath().substring(this.session.rootDir.getAbsolutePath().length() + 1));
            }
            Object object = output;
            return object;
        }
        catch (Exception ex) {
            throw new DMException("Error parsing: " + this.getFilePath(), ex);
        }
        finally {
            parser.clearFile();
        }
    }

    @Override
    public void getValues(DMElement[] elements) {
        int i;
        int size = elements.length;
        boolean[] isFilled = new boolean[size];
        ArrayList<DMElement> tagsToFill = new ArrayList<DMElement>();
        for (i = 0; i < elements.length; ++i) {
            DMTag tag2 = new DMTag(elements[i].group, elements[i].element);
            if (this.elemCache.containsKey(tag2)) {
                tagValue tv = this.elemCache.get(tag2);
                tagValue.copyFillData(tv, elements[i]);
                isFilled[i] = true;
                continue;
            }
            isFilled[i] = false;
            tagsToFill.add(elements[i]);
        }
        if (!tagsToFill.isEmpty()) {
            try {
                parser.setFile(this.getFilePath());
                Object[] tgs = tagsToFill.toArray(new DMElement[tagsToFill.size()]);
                Arrays.sort(tgs);
                parser.fill((tagValue[])tgs);
                int oldg = -1;
                int olde = -1;
                for (int i2 = 0; i2 < tgs.length; ++i2) {
                    if (((DMElement)tgs[i2]).vrep == 21329) {
                        ((DMElement)tgs[i2]).value = new fileSequence((tagValue)tgs[i2]);
                    }
                    if (oldg != ((DMElement)tgs[i2]).group || olde != ((DMElement)tgs[i2]).element) {
                        DMTag tag3 = new DMTag(((DMElement)tgs[i2]).group, ((DMElement)tgs[i2]).element);
                        this.elemCache.put(tag3, new tagValue((tagValue)tgs[i2]));
                    }
                    oldg = ((DMElement)tgs[i2]).group;
                    olde = ((DMElement)tgs[i2]).element;
                }
            }
            catch (FileNotFoundException ex) {
                throw new DMException("Error parsing: " + this.getFilePath(), ex);
            }
            finally {
                parser.clearFile();
            }
        }
        if (this.session != null) {
            for (i = 0; i < elements.length; ++i) {
                DMElement ele = elements[i];
                if (ele.group != 8 || ele.element != 24 || ele.value == null) continue;
                this.session.SOPcache.put(new Integer(ele.value.hashCode()), this.getFilePath());
                return;
            }
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        throw new UnsupportedOperationException("Method setValues() not yet implemented.");
    }

    @Override
    public String getType() {
        return "composite";
    }

    @Override
    public DMTag[] getTags() {
        try {
            parser.setFile(this.getFilePath());
        }
        catch (Exception ex) {
            throw new DMException("Error parsing: " + this.getFilePath(), ex);
        }
        tagValue[] tv = parser.getTags();
        parser.clearFile();
        DMTag[] dt = new DMTag[tv.length];
        for (int i = 0; i < tv.length; ++i) {
            dt[i] = new DMTag(tv[i].group, tv[i].element, tv[i].vrString());
        }
        return dt;
    }

    @Override
    public void delete() {
        this.path.delete();
    }

    @Override
    public String getID() {
        return this.path.getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.path);
        }
        catch (IOException ex) {
            throw new DMException("Error getting input stream: " + this.getFilePath(), ex);
        }
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        fileImageManager.getInstance().setPause(true);
        DMiImage[] imgs = fileImage.getImages(this, tags);
        fileImageManager.getInstance().setPause(false);
        return imgs;
    }

    public DMiImage getImage(DMTag[] tags, int frame) {
        fileImageManager.getInstance().setPause(true);
        fileImage[] imgs = fileImage.getImages(this, tags, frame);
        fileImageManager.getInstance().setPause(false);
        return imgs[0];
    }

    @Override
    public String getFilePath() {
        return this.path.getAbsolutePath();
    }

    void clearCache() {
        this.elemCache.clear();
    }

    void removeTagFromCache(DMTag tag2) {
        this.elemCache.remove(tag2);
    }

    public void printCacheForDebugging() {
        RuntimeException e = new RuntimeException();
        StackTraceElement[] ste = e.getStackTrace();
        System.out.println(ste[2]);
        Set<DMTag> keys = this.elemCache.keySet();
        Iterator<DMTag> it = keys.iterator();
        System.out.println("=========================");
        System.out.println("this.hashCode= " + this.hashCode());
        while (it.hasNext()) {
            System.out.println(this.elemCache.get(it.next()));
        }
        System.out.println("=========================");
    }
}

