/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.pesi;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dm.pesi.PesiComposite;
import com.ge.med.terra.tap.dm.pesi.PesiObject;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.ImageCreator;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.er.EREvent;
import com.ge.med.terra.tap.util.er.EREventListener;
import com.ge.med.terra.tap.util.er.EventRouter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class PesiSession
implements DMiSession {
    public static final String FILE_FILTER_CMD = "FileFilter=";
    public static final String RESTRICT_IMAGES_CMD = "RestrictImages=";
    public static final String PRINT_COMP_CACHE_CMD = "PrintCompCache=";
    public static final String REMOVE_TAG_FROM_COMP_CACHE_CMD = "RemoveTagFromCompCache=";
    public static final String CLEAR_COMP_CACHE_CMD = "ClearCompCache=";
    public File rootDir;
    public String countFile;
    public String configFile;
    public String stageDir;
    boolean imageStartWithI = true;
    public FileFilter ffilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.getName().startsWith("v");
        }
    };
    protected HashMap compcache = new HashMap();
    protected HashMap auxCache = new HashMap();
    protected static EventRouter er;
    protected static String sep;
    protected Map patientCache = new Hashtable();
    protected tagValue[] patientTags;
    protected tagValue[] examTags;
    protected tagValue[] seriesTags;
    protected tagValue[] imageTags;
    protected tagValue[] otherTags = new tagValue[]{new tagValue(8, 96), new tagValue(32, 19)};
    protected tagValue[] tagsToGet = null;
    final int MAX_ENTRIES = 200000;
    public Map SOPcache = Collections.synchronizedMap(new LinkedHashMap(200000){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 200000;
        }
    });
    private LastInstalled lastInstalled = new LastInstalled();
    private dicomParser parser = new dicomParser();
    boolean useER = Tap.getProperty("tap.dm.pesi.useEventRouter", "false").trim().equalsIgnoreCase("true");
    ArrayList[] listeners = new ArrayList[]{new ArrayList(10), new ArrayList(10)};
    private static int unique;

    protected PesiComposite makeNewPesiComposite(File path) {
        WeakReference r = (WeakReference)this.compcache.get(path);
        PesiComposite pc = null;
        if (r != null) {
            pc = (PesiComposite)r.get();
        }
        if (pc != null) {
            return pc;
        }
        pc = new PesiComposite(path, this);
        this.compcache.put(path, new WeakReference<PesiComposite>(pc));
        return pc;
    }

    @Override
    public DMiComposite getComposite(String id) {
        File f = new File(id);
        if (f.exists() && !f.isDirectory()) {
            return this.makeNewPesiComposite(f);
        }
        return null;
    }

    protected void recursivelyFindComposites(File root, ArrayList comps) {
        String[] c = root.list();
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            File child = new File(root, c[i]);
            if (child.isDirectory()) {
                this.recursivelyFindComposites(child, comps);
                continue;
            }
            if (this.imageStartWithI && !child.getName().startsWith("i") && !child.getName().startsWith("I")) continue;
            comps.add(this.makeNewPesiComposite(child));
        }
    }

    public PesiComposite findAComposite(File root) {
        while (root.isDirectory()) {
            boolean isFileAccepted = false;
            String[] list = root.list();
            if (list.length == 0) {
                return null;
            }
            if (this.ffilter == null) {
                root = new File(root.getPath(), list[0]);
                continue;
            }
            for (int imgIndex = 0; imgIndex < list.length; ++imgIndex) {
                File tmp = new File(root.getPath(), list[imgIndex]);
                if (!this.ffilter.accept(tmp)) continue;
                isFileAccepted = true;
                root = tmp;
                break;
            }
            if (isFileAccepted) continue;
            return null;
        }
        return this.makeNewPesiComposite(root);
    }

    @Override
    public DMiComposite[] getComposites() {
        ArrayList list = new ArrayList(100);
        this.recursivelyFindComposites(this.rootDir, list);
        return list.toArray(new PesiComposite[0]);
    }

    @Override
    public int getNumberOfComposites() {
        return this.getComposites().length;
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        return this.getRelated("patient", q);
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q, rcvr);
        return list.toArray(new DMiObject[0]);
    }

    public boolean checkSOPQuery(String type, DMQuery q, DMiObjectReceiver cb) {
        Object path;
        if (q != null && q.group == 8 && q.element == 24 && (path = this.SOPcache.get(new Integer(q.sval.hashCode()))) != null) {
            cb.gotOne(this.makePesiObject(type, new File(this.rootDir + sep + (String)path)));
            return true;
        }
        return false;
    }

    @Override
    public void getRelated(String type, DMQuery q, DMiObjectReceiver cb) {
        if (this.checkSOPQuery(type, q, cb)) {
            return;
        }
        ArrayList<Object> patList = new ArrayList<Object>(10);
        File[] patDirs = this.rootDir.listFiles();
        for (int i = 0; patDirs != null && i < patDirs.length; ++i) {
            if (this.patientCache.containsKey(patDirs[i])) {
                patList.add(this.patientCache.get(patDirs[i]));
                continue;
            }
            if (!patDirs[i].isDirectory() || patDirs[i].listFiles() == null || patDirs[i].listFiles().length <= 0) continue;
            PesiObject pobj = this.makePesiObject("patient", patDirs[i]);
            this.patientCache.put(patDirs[i], pobj);
            patList.add(pobj);
        }
        PesiObject[] pats = patList.toArray(new PesiObject[0]);
        for (int i = 0; i < pats.length; ++i) {
            int j;
            if (type.equalsIgnoreCase("patient")) {
                if (q != null && !q.valid(pats[i]) || cb.gotOne(pats[i])) continue;
                return;
            }
            DMiObject[] stds = pats[i].getRelated("study", null);
            if (type.equalsIgnoreCase("study")) {
                for (j = 0; j < stds.length; ++j) {
                    if (q != null && !q.valid((PesiObject)stds[j]) || cb.gotOne(stds[j])) continue;
                    return;
                }
                continue;
            }
            for (j = 0; j < stds.length; ++j) {
                int k;
                DMiObject[] sers = stds[j].getRelated("series", null);
                if (type.equalsIgnoreCase("series")) {
                    for (k = 0; k < sers.length; ++k) {
                        if (q != null && !q.valid((PesiObject)sers[k]) || cb.gotOne(sers[k])) continue;
                        return;
                    }
                    continue;
                }
                for (k = 0; k < sers.length; ++k) {
                    DMiObject[] imgs = sers[k].getRelated("image", null);
                    if (!type.equalsIgnoreCase("image")) continue;
                    for (int l = 0; l < imgs.length; ++l) {
                        if (q != null && !q.valid((PesiObject)imgs[l]) || cb.gotOne(imgs[l])) continue;
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        this.getRelated("patient", q, cb);
    }

    @Override
    public void init(String session, String[] args) {
        this.setRestrictImages(System.getProperty("tap.pesi.RestrictImages"));
        this.rootDir = new File(session);
        this.countFile = this.rootDir.getParent() + sep + "pdb" + sep + "count";
        this.configFile = this.rootDir.getParent() + sep + "pdb" + sep + "config";
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            Tap.log.fine(">>>>>>>>>>>useER:" + this.useER);
        }
        if (this.useER) {
            this.setupEvents();
        }
    }

    protected void setupEvents() {
        try {
            EventRouter.startServer(5879);
        }
        catch (Exception exception) {
            // empty catch block
        }
        er = EventRouter.createClient();
        er.connect("127.0.0.1", 5879);
        EREventListener cl = new EREventListener(){

            @Override
            public void event(EREvent[] e) {
                for (int i = 0; i < e.length; ++i) {
                    DMEvent ev = null;
                    if (e[i].getType().equals("DMEvent.COMPOSITE_ADDED")) {
                        ev = new DMEvent(1, e[i].getMessageAsString());
                        ev.setSource(ev.getMessage().substring("install: ".length()));
                    } else if (e[i].getType().equals("DMEvent.GENERAL_EVENT")) {
                        ev = new DMEvent(1, e[i].getMessageAsString());
                    }
                    PesiSession.this.doNotify(ev);
                }
            }
        };
        er.addEREventListener("DMEvent.COMPOSITE_ADDED", 0, cl);
        er.addEREventListener("DMEvent.GENERAL_EVENT", 0, cl);
    }

    @Override
    public void save(DMiObject o, Hashtable prop) {
        DMiComposite[] comps = o.getComposites(null);
        for (int i = 0; i < comps.length; ++i) {
            this.save(comps[i], prop);
        }
    }

    @Override
    public void save(DMiObject[] o, Hashtable prop) {
        for (int i = 0; i < o.length; ++i) {
            this.save(o[i], prop);
        }
    }

    @Override
    public void save(DMiComposite o, Hashtable prop) {
        try {
            InputStream in = o.getInputStream();
            this.install(in);
            in.close();
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (eventType == 1) {
            this.listeners[0].add(listener);
        } else if (eventType == 2) {
            this.listeners[1].add(listener);
        } else {
            System.out.println("Event type: " + eventType + " not supported!");
        }
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
        this.listeners[0].remove(listener);
        this.listeners[1].remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getNewPES(int[] ret, int incr) {
        FileOutputStream fos = null;
        RandomAccessFile raf = null;
        FileLock lock = null;
        try {
            File f = new File(this.countFile);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            if (!f.exists()) {
                fos = new FileOutputStream(f);
                byte[] buff = new byte[12];
                fos.write(buff);
                fos.close();
            }
            raf = new RandomAccessFile(f, "rw");
            FileChannel fc = raf.getChannel();
            do {
                if ((lock = fc.tryLock()) != null) continue;
                Thread.sleep(10L);
            } while (lock == null);
            int p = raf.readInt();
            int e = raf.readInt();
            int s = raf.readInt();
            raf.seek(0L);
            switch (incr) {
                case 0: {
                    ++p;
                }
                case 1: {
                    ++e;
                }
                case 2: {
                    ++s;
                }
            }
            raf.writeInt(p);
            raf.writeInt(e);
            raf.writeInt(s);
            if (ret == null) {
                ret = new int[]{p, e, s};
            }
            int[] nArray = ret;
            return nArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (null != lock) {
                try {
                    lock.release();
                }
                catch (IOException iOException) {}
            }
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void initTags() throws IOException {
        int i;
        Properties config = new Properties();
        config.load(PesiSession.class.getResourceAsStream("config"));
        if (new File(this.configFile).exists()) {
            FileInputStream in = new FileInputStream(this.configFile);
            config.load(in);
            in.close();
        }
        String[] tags = new String[]{config.getProperty("PATIENT"), config.getProperty("STUDY"), config.getProperty("SERIES"), config.getProperty("IMAGE")};
        tagValue[][] tv = new tagValue[4][];
        ArrayList<tagValue> toget = new ArrayList<tagValue>(10);
        for (i = 0; i < tags.length; ++i) {
            StringTokenizer toks = new StringTokenizer(tags[i], ";");
            tv[i] = new tagValue[toks.countTokens()];
            for (int j = 0; j < tv[i].length; ++j) {
                String str = toks.nextToken();
                String[] ge = str.split(",");
                tv[i][j] = new tagValue(Integer.parseInt(ge[0].substring(2), 16), Integer.parseInt(ge[1].substring(2), 16));
                toget.add(tv[i][j]);
            }
        }
        for (i = 0; i < this.otherTags.length; ++i) {
            toget.add(this.otherTags[i]);
        }
        this.patientTags = tv[0];
        this.examTags = tv[1];
        this.seriesTags = tv[2];
        this.imageTags = tv[3];
        this.tagsToGet = toget.toArray(new tagValue[toget.size()]);
        Arrays.sort(this.tagsToGet);
    }

    private String getDicomId(String level, tagValue[] tags) {
        tagValue[] matchTags = null;
        String dicomId = "";
        if (level.equals("patient")) {
            matchTags = this.patientTags;
        } else if (level.equals("study")) {
            matchTags = this.examTags;
        } else if (level.equals("series")) {
            matchTags = this.seriesTags;
        } else if (level.equals("image")) {
            matchTags = this.imageTags;
        }
        int matched = 0;
        for (int i = 0; i < tags.length; ++i) {
            for (int j = 0; j < matchTags.length; ++j) {
                if (tags[i].group != matchTags[j].group || tags[i].element != matchTags[j].element) continue;
                dicomId = dicomId + tags[i].value;
                if (++matched != matchTags.length) continue;
                return dicomId;
            }
        }
        return dicomId;
    }

    private String getDicomId(DMiObject obj) {
        int i;
        tagValue[] matchTags = null;
        String dicomId = "";
        if (obj.getType().equals("patient")) {
            matchTags = this.patientTags;
        } else if (obj.getType().equals("study")) {
            matchTags = this.examTags;
        } else if (obj.getType().equals("series")) {
            matchTags = this.seriesTags;
        } else if (obj.getType().equals("images")) {
            matchTags = this.imageTags;
        }
        DMElement[] elem = new DMElement[matchTags.length];
        for (i = 0; i < elem.length; ++i) {
            elem[i] = new DMElement(matchTags[i].group, matchTags[i].element);
        }
        obj.getValues(elem);
        for (i = 0; i < elem.length; ++i) {
            dicomId = dicomId + elem[i].value;
        }
        return dicomId;
    }

    protected String getPath(InputStream is) {
        int[] count = new int[3];
        String fileName = null;
        try {
            if (this.tagsToGet == null) {
                this.initTags();
            }
            this.parser.setFile(is);
            this.parser.fill(this.tagsToGet);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.parser.clearFile();
        }
        String patientID = this.getDicomId("patient", this.tagsToGet);
        String examID = this.getDicomId("study", this.tagsToGet);
        String seriesID = this.getDicomId("series", this.tagsToGet);
        String imageID = this.getDicomId("image", this.tagsToGet);
        String modality = "" + Util.get(this.tagsToGet, 8, 96);
        String imNum = "" + Util.get(this.tagsToGet, 32, 19);
        PesiObject p_dmo = null;
        PesiObject e_dmo = null;
        PesiObject s_dmo = null;
        String baseDir = null;
        if (patientID.equals(this.lastInstalled.pid) && examID.equals(this.lastInstalled.eid) && seriesID.equals(this.lastInstalled.sid)) {
            baseDir = this.lastInstalled.dir;
        } else {
            p_dmo = this.getMatiching(null, patientID);
            if (p_dmo != null) {
                e_dmo = this.getMatiching(p_dmo, examID);
                if (e_dmo != null) {
                    s_dmo = this.getMatiching(e_dmo, seriesID);
                    if (s_dmo != null) {
                        baseDir = s_dmo.path.getPath() + File.separator;
                    } else {
                        this.getNewPES(count, 2);
                        baseDir = e_dmo.path.getPath() + File.separator;
                        baseDir = baseDir + "s" + count[2] + File.separator;
                    }
                } else {
                    this.getNewPES(count, 1);
                    baseDir = p_dmo.path.getPath() + File.separator;
                    baseDir = baseDir + "e" + count[1] + File.separator;
                    baseDir = baseDir + "s" + count[2] + File.separator;
                }
            } else {
                this.getNewPES(count, 0);
                baseDir = this.rootDir.getPath() + File.separator;
                baseDir = baseDir + "p" + count[0] + File.separator;
                baseDir = baseDir + "e" + count[1] + File.separator;
                baseDir = baseDir + "s" + count[2] + File.separator;
            }
        }
        this.lastInstalled.pid = patientID;
        this.lastInstalled.eid = examID;
        this.lastInstalled.sid = seriesID;
        this.lastInstalled.dir = baseDir;
        fileName = baseDir + "i" + Math.abs(imageID.hashCode()) + "." + modality + "DC." + imNum;
        return fileName;
    }

    public PesiObject getMatiching(PesiObject parent, final String id) {
        final PesiObject[] child = new PesiObject[1];
        DMiObjectReceiver or = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject o) {
                if (id.equals(PesiSession.this.getDicomId(o))) {
                    child[0] = (PesiObject)o;
                    return false;
                }
                return true;
            }
        };
        if (parent == null) {
            this.getChildren(null, or);
        } else {
            parent.getRelated(PesiObject.levels[parent.level - 1], null, or);
        }
        return child[0];
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < files.length; ++i) {
            FileInputStream fis = new FileInputStream(files[i]);
            String path = this.getPath(fis);
            fis.close();
            if (path == null) {
                throw new DMException("Install failed: " + files[i].getAbsolutePath());
            }
            if (new File(path).exists()) {
                throw new DMException("Install failed: " + files[i].getAbsolutePath() + " already exists");
            }
            if (destroy) {
                if (!new File(path).getParentFile().exists()) {
                    new File(path).getParentFile().mkdirs();
                }
                if (!files[i].renameTo(new File(path))) {
                    System.err.println("failed to move. file will be copied: " + files[i].getAbsolutePath());
                    SimpleUtilities.copyFile(files[i].getAbsolutePath(), path);
                    files[i].delete();
                }
                this.fireEvent(new DMEvent(1, "install: " + path, path));
            } else {
                if (!new File(path).getParentFile().exists()) {
                    new File(path).getParentFile().mkdirs();
                }
                SimpleUtilities.copyFile(files[i].getAbsolutePath(), path);
                this.fireEvent(new DMEvent(1, "install: " + path, path));
            }
            if ((i + 1) % 100 != 0) continue;
            System.out.println("Series " + (i + 1) / 100 + " installed in " + (System.currentTimeMillis() - start) + " ms");
            start = System.currentTimeMillis();
        }
    }

    @Override
    public void install(InputStream is) throws IOException {
        String path = this.rootDir.getParent() + sep + "pdb" + sep + "stage";
        if (!new File(path).exists()) {
            new File(path).mkdirs();
        }
        File toinstall = new File(path + sep + ((long)Math.abs(this.hashCode()) + System.currentTimeMillis() + (long)(++unique)));
        SimpleUtilities.copyFile(is, toinstall.getAbsolutePath());
        this.installFiles(new File[]{toinstall}, true);
    }

    @Override
    public String[] send(String str) {
        String[] ret = new String[]{};
        try {
            if (str.startsWith(FILE_FILTER_CMD)) {
                String fc = str.substring(FILE_FILTER_CMD.length(), str.length());
                System.out.println("fc=" + fc);
                Class<?> c = Class.forName(fc);
                this.ffilter = (FileFilter)c.newInstance();
            } else if (str.startsWith(RESTRICT_IMAGES_CMD)) {
                this.setRestrictImages(str.substring(RESTRICT_IMAGES_CMD.length()));
            } else if (str.startsWith(PRINT_COMP_CACHE_CMD)) {
                String rid = str.substring(PRINT_COMP_CACHE_CMD.length(), str.length());
                PesiComposite comp = (PesiComposite)this.getComposite(rid);
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    comp.printCacheForDebugging();
                }
            } else if (str.startsWith(REMOVE_TAG_FROM_COMP_CACHE_CMD)) {
                String idAndTag = str.substring(REMOVE_TAG_FROM_COMP_CACHE_CMD.length(), str.length());
                String[] tokens = idAndTag.split(",");
                PesiComposite comp = null;
                if (tokens.length == 3) {
                    comp = (PesiComposite)this.getComposite(tokens[0]);
                }
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    int group = Integer.decode(tokens[1]);
                    int element = Integer.decode(tokens[2]);
                    comp.removeTagFromCache(new DMTag(group, element));
                }
            } else if (str.startsWith(CLEAR_COMP_CACHE_CMD)) {
                String rid = str.substring(CLEAR_COMP_CACHE_CMD.length(), str.length());
                PesiComposite comp = (PesiComposite)this.getComposite(rid);
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    comp.clearCache();
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return ret;
    }

    private void setRestrictImages(String bool) {
        if (bool != null) {
            this.imageStartWithI = Boolean.parseBoolean(bool);
        }
    }

    @Override
    public DMiJob asynSend(String str) {
        throw new UnsupportedOperationException("Method asynSend() not yet implemented.");
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        return this.makePesiObject(type, new File(id));
    }

    @Override
    public void ClearCache() {
        Set keys = this.patientCache.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            PesiComposite[] comps = (PesiComposite[])((PesiObject)this.patientCache.get(it.next())).getComposites(null);
            if (comps == null || comps.length <= 0) continue;
            for (int i = 0; i < comps.length; ++i) {
                comps[i].clearCache();
            }
        }
        this.patientCache.clear();
        this.compcache.clear();
        this.auxCache.clear();
    }

    @Override
    public DMiJob[] getJobs() {
        throw new UnsupportedOperationException("Method getJobs() not yet implemented.");
    }

    void doNotify(DMEvent e) {
        Iterator iter = null;
        if (e.getID() == 1) {
            iter = this.listeners[0].iterator();
        } else if (e.getID() == 2) {
            iter = this.listeners[1].iterator();
        }
        while (iter != null && iter.hasNext()) {
            try {
                ((DMEventListener)iter.next()).actionPerformed(e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void fireEvent(DMEvent e) {
        this.doNotify(e);
        if (this.useER) {
            if (e.getID() == 1) {
                er.sendEvent("DMEvent.COMPOSITE_ADDED", e.getMessage());
            } else if (e.getID() == 2) {
                er.sendEvent("DMEvent.GENERAL_EVENT", e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        DMSession s = new DMSession("pesi", "c:/dev/images/test", null);
        s.addDMEventListener(1, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent e) {
                System.out.println("Got event: " + e);
            }
        });
        try {
            ImageCreator c = new ImageCreator();
            c.install(1, 1, 1, 1, s);
            Thread.sleep(5000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("done");
    }

    @Override
    public void close() {
    }

    protected PesiObject makePesiObject(String type, File path) {
        return new PesiObject(type, path, this);
    }

    static {
        sep = File.separator;
        unique = 0;
    }

    class LastInstalled {
        String pid;
        String eid;
        String sid;
        String dir;

        LastInstalled() {
        }
    }
}

