/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.pesi;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.peer.DMAuxObject;
import com.ge.med.terra.tap.dm.pesi.Vheaders;
import com.ge.med.terra.tap.dm.pesi.Vindex;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VheadersAuxObject
implements DMAuxObject {
    public static final String HEADERNAME = "v_headers";
    public static final String INDEXNAME = "v_headers.index";
    public static final String TYPE = "vheader";
    protected Vheaders vho;
    protected String vHeadersName;
    protected String vIndexName;
    protected Vindex index;

    public VheadersAuxObject(File path) throws FileNotFoundException {
        String pathStr;
        this.vHeadersName = pathStr = path.getAbsolutePath();
        this.vIndexName = pathStr;
        if (pathStr.endsWith(HEADERNAME)) {
            this.vIndexName = this.vIndexName.substring(0, HEADERNAME.length()) + INDEXNAME;
        } else {
            if (path.isDirectory()) {
                this.vIndexName = this.vIndexName + File.separator;
                this.vHeadersName = this.vHeadersName + File.separator;
            }
            this.vIndexName = this.vIndexName + INDEXNAME;
            this.vHeadersName = this.vHeadersName + HEADERNAME;
        }
        System.err.println(this.vIndexName);
        System.err.println(this.vHeadersName);
        this.setup();
    }

    public VheadersAuxObject(String index, String headers) throws FileNotFoundException {
        this.vIndexName = index;
        this.vHeadersName = headers;
        this.setup();
    }

    public VheadersAuxObject(InputStream is) throws IOException {
        int len;
        int rlen;
        int len2;
        byte[] buff = new byte[32768];
        VheadersAuxObject.readFully(is, buff, 0, 8);
        int indexlen = VheadersAuxObject.getInt(buff, 0);
        int hdrlen = VheadersAuxObject.getInt(buff, 8);
        File outdir = File.createTempFile("hdr", "dir");
        boolean ret = outdir.mkdir();
        if (!ret) {
            throw new IOException("could not make dir " + outdir);
        }
        File indexfd = new File(outdir, INDEXNAME);
        FileOutputStream fos = new FileOutputStream(indexfd);
        for (rlen = 0; rlen < indexlen; rlen += len2) {
            len2 = is.read(buff, 0, buff.length > indexlen - rlen ? indexlen - rlen : buff.length);
            if (len2 < 0) {
                throw new IOException();
            }
            fos.write(buff, 0, len2);
        }
        fos.close();
        File headerfd = new File(outdir, HEADERNAME);
        fos = new FileOutputStream(headerfd);
        for (rlen = 0; rlen < hdrlen; rlen += len) {
            len = is.read(buff, 0, buff.length > indexlen - rlen ? indexlen - rlen : buff.length);
            if (len < 0) {
                throw new IOException();
            }
            fos.write(buff, 0, len);
        }
        fos.close();
        this.vIndexName = indexfd.getAbsolutePath();
        this.vHeadersName = headerfd.getAbsolutePath();
        this.setup();
    }

    protected void setup() throws FileNotFoundException {
        this.index = new Vindex(this.vIndexName);
        this.vho = new Vheaders(this.vHeadersName, this.index);
    }

    public void getImageTags(int imageNumber, DMElement[] dmtags) {
        try {
            this.vho.getImageTags(imageNumber, dmtags);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Properties getProperties() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws DMException {
        File index = new File(this.vIndexName);
        File path = new File(this.vHeadersName);
        int ilen = (int)index.length();
        int plen = (int)path.length();
        byte[] buff = new byte[ilen + plen + 8];
        try {
            VheadersAuxObject.putInt(buff, 0, ilen);
            VheadersAuxObject.putInt(buff, 4, plen);
            FileInputStream fis = new FileInputStream(index);
            VheadersAuxObject.readFully(fis, buff, 8, ilen);
            fis.close();
            fis = new FileInputStream(index);
            VheadersAuxObject.readFully(fis, buff, 8 + ilen, plen);
            fis.close();
        }
        catch (Exception e) {
            throw new DMException(e);
        }
        ByteArrayInputStream bas = new ByteArrayInputStream(buff);
        return bas;
    }

    @Override
    public String getFileName() {
        throw new UnsupportedOperationException();
    }

    public static boolean viable(int level, File path) {
        return level == 1 && new File(path, HEADERNAME).exists() && new File(path, INDEXNAME).exists();
    }

    @Override
    public void putFile(String path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class getConverterClass() {
        return VheadersConverter.class;
    }

    public int getNumberOfImage() {
        return this.index.count;
    }

    public String getFilePath(int i) {
        return this.index.filepath[i];
    }

    public int getOffset(int i) {
        return this.index.pxloffset[i];
    }

    private static void putInt(byte[] b, int off, int val) {
        b[off + 3] = (byte)(val >>> 0);
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off + 0] = (byte)(val >>> 24);
    }

    private static void readFully(InputStream is, byte[] buff, int off, int len) throws IOException {
        int n;
        int rlen = 0;
        do {
            if ((n = is.read(buff, off + rlen, len - rlen)) >= 0) continue;
            throw new IOException("end of stream");
        } while ((rlen += n) < len);
    }

    private static int readInt(InputStream is, byte[] buff) throws IOException {
        VheadersAuxObject.readFully(is, buff, 0, 4);
        return VheadersAuxObject.getInt(buff, 0);
    }

    private static int getInt(byte[] b, int off) {
        return ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static class VheadersConverter
    implements DMAuxObject.Converter {
        @Override
        public Object getObjectFromStream(InputStream str) {
            try {
                return new VheadersAuxObject(str);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to parse stream", e);
            }
        }

        @Override
        public InputStream getStreamFromObject(Object obj) {
            VheadersAuxObject v = (VheadersAuxObject)obj;
            return v.getInputStream();
        }

        @Override
        public void writeFileFromObject(Object obj, String path) throws IOException {
            VheadersAuxObject v = (VheadersAuxObject)obj;
            this.writeFileFromStream(v.getInputStream(), path);
        }

        @Override
        public void writeFileFromStream(InputStream str, String path) throws IOException {
            int len;
            byte[] buff = new byte[32768];
            FileOutputStream fos = new FileOutputStream(path);
            while ((len = str.read(buff)) >= 0) {
                fos.write(buff, 0, len);
            }
            fos.close();
        }
    }
}

