/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.remote;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.remote.command;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Server {
    Vector sessions = new Vector();
    HashMap dms = new HashMap();
    ObjectInputStream in;
    ObjectOutputStream out;

    public Server(String[] args) {
        try {
            ServerSocket ss = new ServerSocket(Integer.parseInt(args[0]));
            while (true) {
                Socket s = ss.accept();
                Session sess = new Session(s, this);
                this.sessions.add(sess);
                sess.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    public DMSession getSession(int key) {
        return (DMSession)this.dms.get(new Integer(key));
    }

    public void putSession(int key, DMSession s) {
        this.dms.put(new Integer(key), s);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            new Server(args);
        } else {
            new Server(new String[]{"2034"});
        }
    }

    class Session
    extends Thread
    implements command {
        Socket sock;
        Server server;
        DMSession session = null;
        HashMap dmoHash = new HashMap();

        public Session(Socket s, Server svr) {
            this.sock = s;
            this.server = svr;
        }

        @Override
        public void run() {
            try {
                Server.this.in = new ObjectInputStream(this.sock.getInputStream());
                Server.this.out = new ObjectOutputStream(this.sock.getOutputStream());
                while (true) {
                    Message m = new Message();
                    m.type = Server.this.in.readInt();
                    m.size = Server.this.in.readInt();
                    for (int i = 0; i < m.size; ++i) {
                        m.v.add(Server.this.in.readObject());
                    }
                    this.RequestDispatch(Server.this.out, m);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                return;
            }
        }

        public void RequestDispatch(ObjectOutputStream out, Message m) {
            try {
                switch (m.type) {
                    case 1: {
                        Iterator i = m.v.iterator();
                        String[] config = new String[m.v.size()];
                        int key = 0;
                        int k = 0;
                        while (i.hasNext()) {
                            config[k] = (String)i.next();
                            key += config[k].hashCode();
                            ++k;
                        }
                        DMSession s = this.server.getSession(key);
                        if (s == null) {
                            s = new DMSession(config);
                        }
                        this.session = s;
                        out.writeObject(null);
                        break;
                    }
                    case 2: {
                        System.out.println("getChildren");
                        DMQuery q = (DMQuery)m.v.get(0);
                        DMObject[] o = this.session.getChildren(q);
                        int[] keys = new int[o.length];
                        for (int i = 0; i < o.length; ++i) {
                            keys[i] = o[i].getPeer().hashCode();
                            this.dmoHash.put(new Integer(keys[i]), o[i]);
                        }
                        out.writeObject(keys);
                        out.writeObject(null);
                        break;
                    }
                    case 3: {
                        String type = (String)m.v.get(0);
                        DMQuery q = (DMQuery)m.v.get(1);
                        DMObject[] o = this.session.getRelated(type, q);
                        int[] keys = new int[o.length];
                        for (int i = 0; i < o.length; ++i) {
                            keys[i] = o[i].getPeer().hashCode();
                            this.dmoHash.put(new Integer(keys[i]), o[i]);
                        }
                        out.writeObject(keys);
                        out.writeObject(null);
                        break;
                    }
                    case 5: {
                        String[] result = this.session.send((String)m.v.get(1));
                        out.writeObject(result);
                        out.writeObject(null);
                        break;
                    }
                    case 4: {
                        this.session.ClearCache();
                        out.writeObject(null);
                        break;
                    }
                    case 101: {
                        Integer key = (Integer)m.v.get(0);
                        DMObject o = (DMObject)this.dmoHash.get(key);
                        out.writeObject(o.getType());
                        out.writeObject(null);
                        break;
                    }
                    case 102: {
                        Integer key = (Integer)m.v.get(0);
                        DMTag tag2 = (DMTag)m.v.get(1);
                        DMObject o = (DMObject)this.dmoHash.get(key);
                        Object obj = o.getValue(tag2);
                        if (obj instanceof DMSequence) {
                            out.writeObject(null);
                        } else {
                            out.writeObject(obj);
                        }
                        out.writeObject(null);
                        break;
                    }
                    case 103: {
                        Integer key = (Integer)m.v.get(0);
                        String type = (String)m.v.get(1);
                        DMQuery q = (DMQuery)m.v.get(2);
                        DMObject obj = (DMObject)this.dmoHash.get(key);
                        DMObject[] o = obj.getRelated(type, q);
                        int[] keys = new int[o.length];
                        for (int i = 0; i < o.length; ++i) {
                            keys[i] = o[i].getPeer().hashCode();
                            this.dmoHash.put(new Integer(keys[i]), o[i]);
                        }
                        out.writeObject(keys);
                        out.writeObject(null);
                        break;
                    }
                    case 104: {
                        Integer key = (Integer)m.v.get(0);
                        String type = (String)m.v.get(1);
                        DMQuery q = (DMQuery)m.v.get(2);
                        DMObject obj = (DMObject)this.dmoHash.get(key);
                        int no = obj.getPeer().getNumberOfRelated(type, q);
                        out.writeObject(new Integer(no));
                        out.writeObject(null);
                        break;
                    }
                    case 105: {
                        Integer key = (Integer)m.v.get(0);
                        DMObject obj = (DMObject)this.dmoHash.get(key);
                        obj.delete();
                        out.writeObject(null);
                        break;
                    }
                    case 106: {
                        Integer key = (Integer)m.v.get(0);
                        DMObject obj = (DMObject)this.dmoHash.get(key);
                        out.writeObject(obj.getPeer().getTags());
                        out.writeObject(null);
                        break;
                    }
                    case 107: {
                        Integer key = (Integer)m.v.get(0);
                        DMObject obj = (DMObject)this.dmoHash.get(key);
                        out.writeObject(obj.getPixelData((DMTag[])m.v.get(1)));
                        out.writeObject(null);
                        break;
                    }
                    case 108: {
                        Integer key = (Integer)m.v.get(0);
                        DMObject obj = (DMObject)this.dmoHash.get(key);
                        obj.setValues((DMElement[])m.v.get(1));
                        out.writeObject(null);
                        break;
                    }
                    case 109: {
                        Integer key = (Integer)m.v.get(0);
                        DMObject obj = (DMObject)this.dmoHash.get(key);
                        System.out.println("remote attach");
                        out.writeObject(null);
                        break;
                    }
                    case 110: {
                        Integer key = (Integer)m.v.get(0);
                        DMObject obj = (DMObject)this.dmoHash.get(key);
                        System.out.println("remote detach?");
                        out.writeObject(null);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                try {
                    out.writeObject(ex);
                }
                catch (Exception ex2) {
                    ex2.printStackTrace(System.err);
                }
            }
        }
    }

    class Message {
        public final int CONNECT = 1;
        int type;
        int size;
        Vector v = new Vector();

        Message() {
        }

        public String toString() {
            String s = "Message(" + this.type + ")[" + this.size + "]=";
            for (int i = 0; i < this.size; ++i) {
                s = s + "" + this.v.get(i) + ",";
            }
            return s;
        }
    }
}

