/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.pesi.PesiComposite;
import com.ge.med.terra.tap.dm.rm.RmCompositeBase;
import com.ge.med.terra.tap.dm.rm.RmImage;
import com.ge.med.terra.tap.dm.rm.RmQueryPacket;
import com.ge.med.terra.tap.dm.rm.RmService;
import com.ge.med.terra.tap.dm.rm.RmSession;
import com.ge.med.terra.tap.dm.rm.RmState;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public class RmComposite
extends RmCompositeBase
implements DMiComposite,
DMTagValueInterface {
    public static final String IMAGE_NAME = "rmimage.";
    public static final String COMP_EXT = ".comp";
    public static final String UNCOMP_EXT = ".uncomp";
    final HashMap cache = new HashMap();
    String id;
    RmSession session;
    DMiImage[] images;
    Object lock = new Object();
    PesiComposite composite;
    RuntimeException compositeException;
    int access;
    int state;
    static long[] waitTimes = new long[100];
    static int waitCount = 0;

    public RmComposite(RmSession session, String id) {
        this.session = session;
        this.id = id;
        session.getCmpMgr().addComposite(this);
    }

    @Override
    public Object getValue(DMTag tag2) {
        Object value;
        if (this.cache.containsKey(tag2)) {
            value = this.cache.get(tag2);
        } else {
            if (this.composite == null) {
                try {
                    this.waitForComposite();
                }
                catch (InterruptedException iex) {
                    Tap.log.log(Level.INFO, "Call to getValue() interrupted");
                    return null;
                }
            }
            value = this.composite.getValue(tag2);
            if (tag2.getGroup() < 200) {
                this.cache.put(tag2, value);
            }
        }
        return value;
    }

    @Override
    public void getValues(DMElement[] elements) {
        ArrayList<DMElement> uncached = new ArrayList<DMElement>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            DMTag tag2 = new DMTag(elements[i].group, elements[i].element);
            if (this.cache.containsKey(tag2)) {
                elements[i].value = this.cache.get(tag2);
                continue;
            }
            uncached.add(elements[i]);
        }
        if (uncached.isEmpty()) {
            return;
        }
        if (this.composite != null) {
            DMElement[] dme = uncached.toArray(new DMElement[uncached.size()]);
            this.composite.getValues(dme);
            for (int i = 0; i < dme.length; ++i) {
                if (dme[i].group >= 200) continue;
                this.cache.put(new DMTag(dme[i].group, dme[i].element), dme[i].value);
            }
            return;
        }
        DMElement[] tags = uncached.toArray(new DMElement[uncached.size()]);
        RmQueryPacket qp = new RmQueryPacket(-1, this.id, -1, tags, null);
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)62, tid, qp);
        Object o = this.session.com.waitForResponse(-62, tid);
        Object[] values = (Object[])o;
        for (int i = 0; i < tags.length; ++i) {
            DMTag tag3 = new DMTag(tags[i].group, tags[i].element);
            tags[i].value = values[i];
            this.cache.put(tag3, values[i]);
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
    }

    @Override
    public String getType() {
        return "composite";
    }

    @Override
    public DMTag[] getTags() {
        return this.getComposite().getTags();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("RmComposite:delete() is not supported");
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public InputStream getInputStream() {
        return this.getComposite().getInputStream();
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        if (this.images == null) {
            RmQueryPacket qp = new RmQueryPacket(-1, this.id, 3, tags, null);
            int tid = RmService.newTid();
            this.session.com.sendMsg((byte)40, tid, qp);
            Object o = this.session.com.waitForResponse(-40, tid);
            RmImage.Info[] info = (RmImage.Info[])o;
            DMiImage[] dmi = new DMiImage[info.length];
            for (int i = 0; i < info.length; ++i) {
                dmi[i] = new RmImage(this, info[i].frameNumber);
            }
            this.images = dmi;
        }
        return this.images;
    }

    @Override
    public String getFilePath() {
        return this.getComposite().getFilePath();
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public int getAccess() {
        return this.access;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadComposite(String path) {
        this.buildComposite(path);
        Object object = this.lock;
        synchronized (object) {
            this.session.addThread();
            while (this.composite == null && this.compositeException == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException iex) {
                    if (this.session.broken) {
                        throw new DMException("connection lost");
                    }
                    Tap.log.log(Level.INFO, "Call to loadComposite() interrupted");
                }
            }
            this.session.removeThread();
        }
        if (this.compositeException != null) {
            this.session.fireError(8, "failure during load", this.compositeException);
            throw this.compositeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildComposite(String path) {
        block10: {
            String strResponse = "nocompress";
            try {
                File file;
                if (path == null) {
                    file = File.createTempFile(IMAGE_NAME, "", this.session.DIR);
                    file.deleteOnExit();
                    String filename = file.getAbsolutePath();
                    Tap.log.fine(filename);
                    RmQueryPacket qp = new RmQueryPacket(-1, this.id, -1, filename, null);
                    int tid = RmService.newTid();
                    this.session.com.sendMsg((byte)63, tid, qp);
                    strResponse = (String)this.session.com.waitForResponse(-63, tid, 0L);
                } else {
                    file = new File(path);
                }
                if ("compress".equals(strResponse)) {
                    try {
                        file = this.decompressFile(file);
                    }
                    catch (Exception e) {
                        Tap.log.log(Level.WARNING, "Unable to decompress file: ", e);
                    }
                    break block10;
                }
                this.composite = new PesiComposite(file);
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (IOException ioex) {
                this.session.fireError(8, "buildComposite failure", this.compositeException);
                Tap.log.log(Level.WARNING, "Unable to build composite: ", ioex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildUnCompressedComposite(boolean bShouldCompress, String strLocalFile) {
        if (bShouldCompress) {
            this.buildComposite(strLocalFile);
            return;
        }
        String strResponse = "nocompress";
        File file = new File(strLocalFile);
        file.deleteOnExit();
        String filename = file.getAbsolutePath();
        Tap.log.fine(filename);
        RmQueryPacket qp = new RmQueryPacket(-1, this.id, -1, filename + UNCOMP_EXT, null);
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)63, tid, qp);
        strResponse = (String)this.session.com.waitForResponse(-63, tid, 0L);
        this.composite = new PesiComposite(file);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    private File decompressFile(File compressedFile) {
        String strDestFile = compressedFile.getAbsolutePath();
        String strSrcFile = strDestFile + COMP_EXT;
        this.session.addCompositeTask(this, strDestFile);
        this.session.iDicomComp.decompress(strSrcFile, strDestFile);
        return new File(strDestFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void taskDone(String taskName) {
        File decompressedFile;
        File compressedFile = new File(taskName + COMP_EXT);
        compressedFile.deleteOnExit();
        boolean worked = compressedFile.delete();
        if (!worked) {
            Tap.log.log(Level.FINE, "Unable to delete compressed file {0}", compressedFile.getAbsolutePath());
        }
        if (!(decompressedFile = new File(taskName)).exists()) {
            Tap.log.severe("file \"" + decompressedFile.getAbsolutePath() + "\" not found");
            this.session.fireError(8, "compression did not write file", null);
        }
        decompressedFile.deleteOnExit();
        this.composite = new PesiComposite(decompressedFile);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.session.removeCompositeTask(taskName);
    }

    void taskFailed(String taskName, String reason, Exception e) {
        this.buildUnCompressedComposite(false, taskName);
        this.session.removeCompositeTask(taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForComposite() throws InterruptedException {
        if (this.composite != null) {
            return;
        }
        try {
            RmState.setMustLoad(this);
            this.session.getCmpMgr().startLoading();
            Object object = this.lock;
            synchronized (object) {
                this.session.addThread();
                while (this.composite == null && this.compositeException == null) {
                    this.lock.wait();
                }
                this.session.removeThread();
            }
        }
        catch (InterruptedException ie) {
            if (this.session.broken) {
                throw new DMException("connection lost");
            }
            throw ie;
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Unable to waitForComposite: ", e);
        }
        if (this.compositeException != null) {
            RuntimeException e = this.compositeException;
            this.compositeException = null;
            throw new RuntimeException(e);
        }
    }

    void unloadComposite() {
        if (this.composite != null) {
            this.composite.delete();
            this.composite = null;
        }
    }

    @Override
    protected PesiComposite getComposite() {
        PesiComposite pesiComp = this.composite;
        if (this.composite == null) {
            try {
                this.waitForComposite();
            }
            catch (InterruptedException iex) {
                Tap.log.log(Level.INFO, "Call to getComposite() interrupted");
                throw new RuntimeException(iex);
            }
            pesiComp = this.composite;
        }
        this.session.getCmpMgr().access(this);
        return pesiComp;
    }

    void setImages(DMiImage[] images) {
        if (this.images == null) {
            this.images = images;
        }
    }

    public void refresh() {
        this.composite = null;
        this.loadComposite(null);
    }

    public void preLoad() {
        if (this.access > 0) {
            this.session.getCmpMgr().reloadComposite(this);
        } else {
            this.session.getCmpMgr().setPreLoad(this);
        }
    }

    public void preUnload() {
        this.session.getCmpMgr().setPreUnload(this);
    }

    static {
        SimpleUtilities.addDebugInfoNotify(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

