/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.rm.RmComposite;
import com.ge.med.terra.tap.dm.rm.RmImageBase;
import com.ge.med.terra.tap.dm.rm.RmObject;
import java.io.Serializable;

class RmImage
extends RmImageBase
implements DMiImage {
    RmComposite composite;
    DMiImage image;
    RmObject dmoImage;
    int frameNumber;

    public RmImage(RmComposite composite, int frameNumber) {
        this.composite = composite;
        this.frameNumber = frameNumber;
    }

    public RmImage(RmObject dmoImage, int frameNumber) {
        this.dmoImage = dmoImage;
        this.frameNumber = frameNumber;
    }

    @Override
    public int getIconHeight() {
        return this.getImage().getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.getImage().getIconWidth();
    }

    @Override
    public Object getProperty(Object key) {
        this.makeComposite();
        if ("waitForImage".equals(key)) {
            try {
                this.composite.waitForComposite();
            }
            catch (InterruptedException e) {
                throw new DMException(e);
            }
            return null;
        }
        return this.getImage().getProperty(key);
    }

    @Override
    public void preLoad() {
        this.makeComposite();
        this.composite.preLoad();
    }

    @Override
    public void preUnload() {
        if (this.composite != null) {
            this.composite.preUnload();
        }
    }

    @Override
    public void refresh() {
        this.makeComposite();
        this.composite.refresh();
    }

    private void makeComposite() {
        if (this.composite != null) {
            return;
        }
        this.composite = (RmComposite)this.dmoImage.getComposites(null)[0];
    }

    @Override
    public Object getValue(DMTag tag2) {
        if (this.dmoImage != null && this.dmoImage.cacheContains(tag2)) {
            return this.dmoImage.getValue(tag2);
        }
        this.makeComposite();
        return this.composite.getValue(tag2);
    }

    @Override
    public DMiComposite getComposite() {
        this.makeComposite();
        return this.composite;
    }

    @Override
    public void setState(int state) {
    }

    @Override
    public int getState() {
        this.makeComposite();
        return this.composite.getState();
    }

    @Override
    public void setAccess(int access) {
    }

    @Override
    public int getAccess() {
        return 0;
    }

    @Override
    public int memorySize() {
        return 0;
    }

    @Override
    public void unloadImage() {
        this.makeComposite();
        this.composite.unloadComposite();
    }

    @Override
    public void loadImage() {
        this.makeComposite();
        this.composite.loadComposite(null);
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    protected DMiImage getImage() {
        if (this.image == null) {
            this.makeComposite();
            this.image = this.composite.getComposite().getImages(null)[this.frameNumber];
        }
        return this.image;
    }

    static class Info
    implements Serializable {
        public String cid;
        public int frameNumber;

        public Info(String cid, int frameNumber) {
            this.cid = cid;
            this.frameNumber = frameNumber;
        }
    }
}

