/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.rm.Msg;
import com.ge.med.terra.tap.dm.rm.RmServer;
import com.ge.med.terra.tap.dm.rm.RmSession;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class RmService
implements XmService {
    public static long TIMEOUT = 60000L;
    XmSession client;
    private static int tcount = 1;
    private static final boolean debug = false;
    private final byte[] len = new byte[4];
    private final Long EVENT_KEY = new Long(-1L);
    private XmServiceStatus status;
    private short channel;
    private byte[] packet;
    private Vector msgQue = new Vector();
    private RmServer ss;
    private Hashtable responseMap = new Hashtable();
    private RmSession rms = null;

    public RmService() {
        this.setupMsgQue();
    }

    public RmService(RmSession rms) {
        this.setupMsgQue();
        this.rms = rms;
    }

    public RmService(short channel, byte[] packet) {
        this.status = new XmServiceStatus();
        this.channel = channel;
        this.packet = packet;
        Utils.putInt(this.len, 0, packet.length);
    }

    public RmService createPacket(byte sid, int tid, Object data) {
        return this.createPacket(new Msg(sid, tid, data));
    }

    public RmService createPacket(Msg message) {
        return new RmService(this.channel, message.toByteArray());
    }

    @Override
    public void setParent(XmSession client) {
        this.client = client;
        if (!client.isClient()) {
            this.ss = new RmServer(this);
        }
    }

    public Object waitForResponse(int type, int tid) {
        return this.waitForResponse(type, tid, TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForResponse(int type, int tid, long timeout) {
        Long key = new Long((long)type << 32 | (long)tid);
        long start = System.currentTimeMillis();
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            while (!this.responseMap.containsKey(key)) {
                block9: {
                    try {
                        if (this.rms != null) {
                            this.rms.addThread();
                        }
                        this.responseMap.wait(timeout);
                        if (this.rms != null) {
                            this.rms.removeThread();
                        }
                    }
                    catch (InterruptedException ex) {
                        if (this.rms == null || !this.rms.broken) break block9;
                        throw new DMException("connection lost");
                    }
                }
                if (timeout == 0L || System.currentTimeMillis() - start <= timeout) continue;
                throw new RuntimeException("response timeout");
            }
            Object response = this.responseMap.remove(key);
            if (response instanceof Exception) {
                throw new RuntimeException((Exception)response);
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMEvent[] waitForEvent() throws InterruptedException {
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            while (!this.responseMap.containsKey(this.EVENT_KEY)) {
                if (this.rms != null) {
                    this.rms.addThread();
                }
                this.responseMap.wait();
                if (this.rms == null) continue;
                this.rms.removeThread();
            }
            Vector response = (Vector)this.responseMap.remove(this.EVENT_KEY);
            return response.toArray(new DMEvent[response.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResponse(int type, int tid) {
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            this.responseMap.remove(new Long((long)type << 32 | (long)tid));
        }
    }

    @Override
    public int readMessage(InputStream is) throws IOException {
        int length = Utils.readInt(is, this.len);
        this.packet = new byte[length];
        Utils.readFully(is, this.packet);
        this.queueMessage(this.packet);
        return this.len.length + this.packet.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueMessage(byte[] buff) {
        this.msgQue.add(buff);
        Vector vector = this.msgQue;
        synchronized (vector) {
            this.msgQue.notify();
        }
    }

    protected void processMessageBuffer(byte[] buff) {
        this.processMessage(new Msg(buff));
    }

    public void sendMsg(byte sid, int tid, Object data) {
        this.client.writeMessage(this.createPacket(sid, tid, data));
    }

    public void sendMsg(Msg message) {
        if (message == null) {
            return;
        }
        this.client.writeMessage(this.createPacket(message));
    }

    public static synchronized int newTid() {
        return ++tcount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToMessages(Msg message) {
        Hashtable hashtable = this.responseMap;
        synchronized (hashtable) {
            if (this.responseMap.contains(this.EVENT_KEY)) {
                Vector v = (Vector)this.responseMap.get(this.EVENT_KEY);
                v.add(message.data);
            } else {
                Vector<Object> v = new Vector<Object>();
                v.add(message.data);
                this.responseMap.put(this.EVENT_KEY, v);
            }
            this.responseMap.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processMessage(Msg message) {
        if (this.client.isClient()) {
            if (message.sid == 72) {
                this.addEventToMessages(message);
                return;
            }
            Hashtable hashtable = this.responseMap;
            synchronized (hashtable) {
                Long msgT = new Long((long)message.sid << 32 | (long)message.tid);
                if (message.data instanceof Vector) {
                    Vector v = (Vector)this.responseMap.get(msgT);
                    if (v != null) {
                        v.addAll((Vector)message.data);
                    } else {
                        this.responseMap.put(msgT, message.data);
                    }
                } else {
                    try {
                        this.responseMap.put(msgT, message.data);
                    }
                    catch (Exception ex) {
                        Msg.printMessageType(message);
                        System.out.flush();
                        ex.printStackTrace();
                    }
                }
                this.responseMap.notifyAll();
                return;
            }
        }
        this.sendMsg(this.ss.processMessage(message));
    }

    protected void setupMsgQue() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Vector vector = RmService.this.msgQue;
                    synchronized (vector) {
                        while (RmService.this.msgQue.isEmpty()) {
                            try {
                                RmService.this.msgQue.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        RmService.this.processMessageBuffer((byte[])RmService.this.msgQue.remove(0));
                    }
                }
            }
        };
        t.setName("messageQue");
        t.setDaemon(true);
        t.start();
    }

    @Override
    public int writeMessage(OutputStream os, short mid) throws IOException {
        os.write(this.len);
        os.write(this.packet);
        return this.len.length + this.packet.length;
    }

    @Override
    public short getID() {
        return this.channel;
    }

    @Override
    public void setID(short type) {
        this.channel = type;
    }

    @Override
    public void connectionLost() {
        if (null != this.client && !this.client.isClient() && null != this.ss.dms) {
            this.ss.dms.ClearCache();
        }
        if (null != this.rms) {
            this.rms.connectionLost();
        }
    }

    @Override
    public XmServiceStatus getStatus() {
        return this.status;
    }
}

