/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjCompressor;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.rm.RmComposite;
import com.ge.med.terra.tap.dm.rm.RmCompositeManager;
import com.ge.med.terra.tap.dm.rm.RmMFComposite;
import com.ge.med.terra.tap.dm.rm.RmObject;
import com.ge.med.terra.tap.dm.rm.RmQueryPacket;
import com.ge.med.terra.tap.dm.rm.RmService;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.DicomTransfer;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class RmSession
implements DMiSession {
    public static final String IMAGES_DIR = "rmimages";
    public static final int PATIENT = 0;
    public static final int STUDY = 1;
    public static final int SERIES = 2;
    public static final int IMAGE = 3;
    public static final String[] LEVEL = new String[]{"patient", "study", "series", "image"};
    private static int sessionNumber = 0;
    private HashSet threads = new HashSet();
    protected XmSession xmc;
    protected RmService com;
    protected int id;
    protected int[][][] prefetch = new int[4][][];
    private Vector listeners = new Vector();
    private Vector errorListeners = new Vector();
    XjCompressor iDicomComp = null;
    String compressorName = null;
    HashMap comprssMap = new HashMap();
    HashMap mfCompCache = new HashMap();
    boolean broken = false;
    PreferenceChangeListener pchangeListener;
    private DicomTransfer mfTransfer = null;
    RmCompositeManager cmpMgr;
    File DIR;
    protected String rep;
    final int MAX_SIZE = 200000;
    protected Map compcache = new LinkedHashMap(200000){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 200000;
        }
    };
    TaskMonitor tel = new TaskMonitor(){

        @Override
        public void taskBegin(String taskName, int totalWork) {
        }

        @Override
        public void taskDone(String taskName) {
            ((RmComposite)RmSession.this.comprssMap.get(taskName)).taskDone(taskName);
        }

        @Override
        public void taskFailed(String taskName, String reason, Exception e) {
            ((RmComposite)RmSession.this.comprssMap.get(taskName)).taskFailed(taskName, reason, e);
        }

        @Override
        public void taskProgress(String taskName, int units) {
        }
    };
    private Thread eventSupport;

    void putMfComposite(String src, RmMFComposite comp) {
        this.mfCompCache.put(src, comp);
    }

    boolean containsMfComposite(String src) {
        return this.mfCompCache.containsKey(src);
    }

    RmMFComposite getMfComposite(String src) {
        return (RmMFComposite)this.mfCompCache.get(src);
    }

    RmCompositeManager getCmpMgr() {
        if (this.cmpMgr != null) {
            return this.cmpMgr;
        }
        this.cmpMgr = new RmCompositeManager(this);
        return this.cmpMgr;
    }

    DicomTransfer getTransfer() {
        if (this.mfTransfer == null) {
            this.mfTransfer = new DicomTransfer();
            this.mfTransfer.installInto(this.xmc);
        }
        return this.mfTransfer;
    }

    public static int getLevel(String l) {
        for (int i = 0; i < LEVEL.length; ++i) {
            if (!LEVEL[i].equalsIgnoreCase(l)) continue;
            return i;
        }
        return -1;
    }

    RmComposite makeNewComposite(String id) {
        WeakReference r = (WeakReference)this.compcache.get(id);
        RmComposite rc = null;
        if (r != null) {
            rc = (RmComposite)r.get();
        }
        if (rc == null) {
            rc = new RmComposite(this, id);
            this.compcache.put(id, new WeakReference<RmComposite>(rc));
        } else {
            rc.preLoad();
        }
        return rc;
    }

    private void createTempDir() {
        boolean ok;
        File tmp = new File(SimpleUtilities.getTempDir());
        if (!tmp.isDirectory()) {
            throw new DMException(tmp.getAbsolutePath() + " is not a directory.");
        }
        if (!tmp.canRead()) {
            throw new DMException("Cannot Read from temp directory " + tmp.getAbsolutePath());
        }
        if (!tmp.canWrite()) {
            throw new DMException("Cannot Write to temp directory " + tmp.getAbsolutePath());
        }
        String pid = Integer.toString(SimpleUtilities.getProcessID());
        this.DIR = new File(tmp, IMAGES_DIR + File.separator + pid + File.separator + "rmsession" + ++sessionNumber);
        if (!this.DIR.exists() && !(ok = this.DIR.mkdirs())) {
            throw new DMException("Cound not make temp directory " + this.DIR.getAbsolutePath());
        }
    }

    void connectionLost() {
        this.broken = true;
        Preferences p = Preferences.userNodeForPackage(this.getClass());
        p.removePreferenceChangeListener(this.pchangeListener);
        DMSession.removeSession(this);
        this.com = null;
        this.eventSupport.interrupt();
        HashSet set = this.threads;
        this.threads = null;
        Thread[] t = set.toArray(new Thread[set.size()]);
        for (int i = 0; i < t.length; ++i) {
            t[i].interrupt();
        }
    }

    void addThread() {
        this.threads.add(Thread.currentThread());
    }

    void removeThread() {
        this.threads.remove(Thread.currentThread());
    }

    @Override
    public void init(String session, String[] args) {
        this.createTempDir();
        this.xmc = XmSession.factory(session);
        this.com = new RmService(this);
        this.xmc.installHandle(this.com);
        int tid = RmService.newTid();
        this.com.sendMsg((byte)1, tid, args);
        this.com.waitForResponse(-1, tid);
        this.rep = session;
        this.compressorName = System.getProperty("tap.remote.ICOMPRESS");
        if (this.compressorName != null) {
            if ("null".equalsIgnoreCase(this.compressorName)) {
                this.compressorName = null;
            } else {
                this.compressorName = this.compressorName.trim();
                if (this.compressorName.length() == 0) {
                    this.compressorName = null;
                }
            }
            this.sendCompress("ICOMPRESS=" + this.compressorName);
        }
        final Preferences p = Preferences.userNodeForPackage(this.getClass());
        boolean useCompression = p.getBoolean("useCompression", true);
        this.sendCompress("ICOMPRESS=" + (useCompression ? this.compressorName : null));
        this.pchangeListener = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                boolean useCompression = p.getBoolean("useCompression", true);
                RmSession.this.sendCompress("ICOMPRESS=" + (useCompression ? RmSession.this.compressorName : null));
            }
        };
        p.addPreferenceChangeListener(this.pchangeListener);
        this.eventSupport = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        block3: while (true) {
                            DMEvent[] dme = RmSession.this.com.waitForEvent();
                            int i = 0;
                            while (true) {
                                if (i >= dme.length) continue block3;
                                RmSession.this.fireEvent(dme[i]);
                                ++i;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        if (RmSession.this.com != null) continue;
                        return;
                    }
                    break;
                }
            }
        };
        this.eventSupport.setName("RmSession:eventSupport");
        this.eventSupport.setDaemon(true);
        this.eventSupport.start();
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        return this.getRelated("patient", q);
    }

    private String qtoString(DMQuery q) {
        if (q == null) {
            return null;
        }
        return q.toString();
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        int[][] tags = null;
        int retLevel = RmSession.getLevel(ieType);
        tags = q != null ? q.getTags() : this.prefetch[retLevel];
        RmQueryPacket p = new RmQueryPacket(retLevel, null, -1, tags, this.qtoString(q));
        int tid = RmService.newTid();
        this.com.sendMsg((byte)2, tid, p);
        Object o = this.com.waitForResponse(-2, tid);
        if (o == null) {
            return new DMiObject[0];
        }
        Object[][] pack = (Object[][])o;
        DMiObject[] dmo = new DMiObject[pack.length];
        for (int i = 0; i < dmo.length; ++i) {
            String id = (String)pack[i][0];
            RmObject rmo = new RmObject(this, retLevel, id);
            dmo[i] = rmo;
            for (int k = 1; k < pack[i].length; ++k) {
                rmo.addToCache(new DMTag(tags[k - 1][0], tags[k - 1][1]), pack[i][k]);
            }
        }
        return dmo;
    }

    @Override
    public void getRelated(String type, DMQuery q, DMiObjectReceiver cb) {
        int[][] tags = null;
        int retLevel = RmSession.getLevel(type);
        tags = this.prefetch[retLevel];
        RmQueryPacket p = new RmQueryPacket(retLevel, null, -1, tags, this.qtoString(q));
        int tid = RmService.newTid();
        this.com.sendMsg((byte)3, tid, p);
        Object[] lastOarray = null;
        boolean cont = true;
        do {
            Object o = this.com.waitForResponse(-3, tid);
            Vector v = (Vector)o;
            Iterator iter = v.iterator();
            while (iter.hasNext() && cont) {
                lastOarray = (Object[])iter.next();
                if (lastOarray == null) continue;
                String id = (String)lastOarray[0];
                RmObject obj = new RmObject(this, retLevel, id);
                int off = 1;
                if (tags != null) {
                    if (tags.length == lastOarray.length + 2 && retLevel == 3) {
                        obj.filePath = (String)lastOarray[1];
                        off = 2;
                    }
                    for (int k = 0; k < tags.length; ++k) {
                        obj.addToCache(new DMTag(tags[k][0], tags[k][1]), lastOarray[k + off]);
                    }
                }
                cont = cb.gotOne(obj);
            }
        } while (lastOarray != null && cont);
        if (!cont) {
            this.com.sendMsg((byte)4, tid, "");
            this.com.waitForResponse(-4, tid);
            this.com.clearResponse(-3, tid);
        }
    }

    @Override
    public DMiComposite getComposite(String id) {
        return this.makeNewComposite(id);
    }

    @Override
    public DMiComposite[] getComposites() {
        int tid = RmService.newTid();
        this.com.sendMsg((byte)5, tid, "");
        Object o = this.com.waitForResponse(-5, tid);
        if (o == null) {
            return new RmComposite[0];
        }
        String[] ids = (String[])o;
        DMiComposite[] dmo = new RmComposite[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            dmo[i] = this.makeNewComposite(ids[i]);
        }
        return dmo;
    }

    @Override
    public int getNumberOfComposites() {
        int tid = RmService.newTid();
        this.com.sendMsg((byte)6, tid, "");
        return (Integer)this.com.waitForResponse(-6, tid);
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        this.getRelated("patient", q, cb);
    }

    @Override
    public DMiObject getDMiObject(String ieType, String id) {
        return new RmObject(this, RmSession.getLevel(ieType), id);
    }

    @Override
    public void save(DMiComposite dmc, Hashtable prop) {
        this.transferFile(dmc.getFilePath());
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (eventType == 1) {
            this.listeners.add(listener);
        } else if (eventType == 8) {
            this.errorListeners.add(listener);
        }
        this.com.sendMsg((byte)12, RmService.newTid(), new int[]{eventType, freq});
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws IOException, FileNotFoundException {
        int i;
        String[] paths = new String[files.length];
        for (i = 0; i < files.length; ++i) {
            paths[i] = files[i].getAbsolutePath();
        }
        this.transferFiles(paths);
        if (destroy) {
            for (i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    @Override
    public void install(InputStream is) throws IOException {
        File tmpFile = File.createTempFile("image", null);
        SimpleUtilities.copyFile(is, tmpFile.getAbsolutePath());
        this.transferFile(tmpFile.getAbsolutePath());
        tmpFile.delete();
    }

    protected int[][] loadCache(String name, String str) {
        if (str.startsWith(name)) {
            int[][] t = new DMQuery(str.substring(name.length())).getTags();
            Arrays.sort(t, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int[] i1 = (int[])o1;
                    int[] i2 = (int[])o2;
                    if (i1 != i2) {
                        return i1[0] - i2[0];
                    }
                    return i1[1] - i2[1];
                }
            });
            int k = 0;
            int i = 1;
            while (i < t.length) {
                if (t[i][0] == t[k][0] && t[i][1] == t[k][1]) {
                    t[k] = t[i];
                }
                ++i;
                ++k;
            }
            HashSet set = new HashSet(Arrays.asList(t));
            t = (int[][])set.toArray((T[])new int[set.size()][]);
            Arrays.sort(t, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int[] i1 = (int[])o1;
                    int[] i2 = (int[])o2;
                    if (i1 != i2) {
                        return i1[0] - i2[0];
                    }
                    return i1[1] - i2[1];
                }
            });
            return t;
        }
        return null;
    }

    @Override
    public String[] send(String str) {
        if (str.startsWith("IMGDIR")) {
            return new String[]{this.DIR.getAbsolutePath()};
        }
        if (str.startsWith("TIMEOUT=")) {
            RmService.TIMEOUT = Long.decode(str.substring("TIMEOUT=".length()));
            return null;
        }
        if (str.startsWith("ICOMPRESS=")) {
            this.sendCompress(str);
            return null;
        }
        String[] cache = new String[]{"PCACHE=", "ECACHE=", "SCACHE=", "ICACHE="};
        for (int i = 0; i < cache.length; ++i) {
            int[][] tmp = this.loadCache(cache[i], str);
            if (tmp == null) continue;
            this.prefetch[i] = tmp;
            break;
        }
        int tid = RmService.newTid();
        this.com.sendMsg((byte)8, tid, str);
        this.com.waitForResponse(-8, tid);
        return null;
    }

    private void sendCompress(String str) {
        String className = str.substring("ICOMPRESS=".length());
        try {
            if ("null".equalsIgnoreCase(className)) {
                this.iDicomComp = null;
            } else {
                this.iDicomComp = (XjCompressor)Class.forName(className).newInstance();
                this.iDicomComp.addTaskEventListener(this.tel);
            }
            int tid = RmService.newTid();
            this.com.sendMsg((byte)8, tid, str);
            this.com.waitForResponse(-8, tid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void addCompositeTask(RmComposite comp, String task) {
        this.comprssMap.put(task, comp);
    }

    void removeCompositeTask(String task) {
        this.comprssMap.remove(task);
    }

    @Override
    public DMiJob asynSend(String str) {
        throw new UnsupportedOperationException("Method RmSession:asynSend() not implemented.");
    }

    @Override
    public void ClearCache() {
        int tid = RmService.newTid();
        this.com.sendMsg((byte)10, tid, "");
        this.com.waitForResponse(-10, tid);
    }

    @Override
    public DMiJob[] getJobs() {
        throw new UnsupportedOperationException("Method RmSession:getJobs() not implemented.");
    }

    @Override
    public void close() {
        int tid = RmService.newTid();
        this.com.sendMsg((byte)9, tid, "");
        this.com.waitForResponse(-9, tid);
    }

    @Override
    public void save(DMiObject dmo, Hashtable prop) {
        DMSession dms = (DMSession)prop.get("From");
        String sessionRep = (String)dms.getProperty(DMUtils.PROPERTY_SESSION_REP);
        if (dms.getPeer() instanceof RmSession && sessionRep.equals(this.rep)) {
            String[] args = (String[])dms.getProperty(DMUtils.PROPERTY_SESSION_ARGS);
            int tid = RmService.newTid();
            RmQueryPacket qp = new RmQueryPacket(-1, dmo.getID(), RmSession.getLevel(dmo.getType()), args, null);
            this.com.sendMsg((byte)41, tid, qp);
            this.com.waitForResponse(-41, tid);
        } else {
            this.transferFiles(this.getFilePaths(dmo.getComposites(null)));
        }
    }

    @Override
    public void save(DMiObject[] dmo, Hashtable prop) {
        for (int i = 0; i < dmo.length; ++i) {
            this.save(dmo[i], prop);
        }
    }

    private void transferFile(String filePath) {
        int tid = RmService.newTid();
        this.com.sendMsg((byte)11, tid, filePath);
        this.com.waitForResponse(-11, tid);
        this.fireEvent(new DMEvent(1, "install: " + filePath, filePath));
    }

    private void transferFiles(String[] filePaths) {
        for (int i = 0; i < filePaths.length; ++i) {
            this.transferFile(filePaths[i]);
        }
    }

    private String[] getFilePaths(DMiComposite[] dmc) {
        String[] paths = new String[dmc.length];
        for (int i = 0; i < dmc.length; ++i) {
            paths[i] = dmc[i].getFilePath();
        }
        return paths;
    }

    protected DMEventListener[] getDMEventListeners() {
        return this.listeners.toArray(new DMEventListener[this.listeners.size()]);
    }

    protected DMEventListener[] getErrorListeners() {
        return this.errorListeners.toArray(new DMEventListener[this.listeners.size()]);
    }

    protected void fireError(int id, String msg, Throwable t) {
        DMEventListener[] eventListeners = this.getErrorListeners();
        for (int i = 0; i < eventListeners.length; ++i) {
            eventListeners[i].actionPerformed(new DMEvent(id, msg, t));
        }
    }

    protected void fireEvent(DMEvent event) {
        DMEventListener[] eventListeners = this.getDMEventListeners();
        for (int i = 0; i < eventListeners.length; ++i) {
            eventListeners[i].actionPerformed(event);
        }
    }
}

