/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.archimed.dicom.codec.Compression;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiSequence;
import com.ge.med.terra.tap.dm.sessionFile.State;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.dm.sessionFile.fileImageBase;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.util.dicom.PersonName;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.logging.Level;

public class fileImage
extends fileImageBase
implements DMiImage {
    DMiComposite fc;
    int width;
    int height;
    int frame;
    String PName;
    String imgType;
    boolean invert;
    boolean explicitVr;
    boolean compressed;
    int bitsPerPix;
    Object imageBlock = new Object();
    Hashtable prop;
    public long fileOffset;
    String transferSyntax;
    boolean littleEndian;
    public volatile Exception imageException;
    int state;
    int access;

    @Override
    public Object getProperty(Object key) {
        return this.prop.get(key);
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setAccess(int access) {
        this.access = access;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void preLoad() {
        fileImageManager.getInstance().setPreLoad(this);
    }

    @Override
    public void preUnload() {
        fileImageManager.getInstance().setPreUnload(this);
    }

    @Override
    public Object getValue(DMTag tag2) {
        return this.fc.getValue(tag2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadImage() {
        try {
            this.buildImage();
            Object object = this.imageBlock;
            synchronized (object) {
                this.imageBlock.notifyAll();
            }
        }
        catch (Exception ex) {
            this.imageException = ex;
            Object object = this.imageBlock;
            synchronized (object) {
                this.imageBlock.notifyAll();
            }
        }
    }

    @Override
    public void unloadImage() {
        this.image = null;
    }

    @Override
    public void refresh() {
        this.image = null;
        this.loadImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void waitForImage() {
        if (this.image != null) {
            return;
        }
        try {
            State.setMustLoad(this);
            fileImageManager.getInstance().startLoading();
            Object object = this.imageBlock;
            synchronized (object) {
                while (this.image == null && this.imageException == null) {
                    this.imageBlock.wait();
                }
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Caught exception in waitForImage(): ", ex);
        }
        if (this.imageException != null) {
            Exception e = this.imageException;
            this.imageException = null;
            Tap.log.log(Level.WARNING, "Returning from waitForImage exception case", e);
            throw new RuntimeException(e);
        }
    }

    private int read32(DataInputStream is) {
        try {
            int t1 = is.readByte() & 0xFF;
            int t2 = is.readByte() & 0xFF;
            int t3 = is.readByte() & 0xFF;
            int t4 = is.readByte() & 0xFF;
            long acc = 0L;
            acc = this.littleEndian ? (long)(t1 | t2 << 8 | t3 << 16 | t4 << 24) : (long)(t1 << 24 | t2 << 16 | t3 << 8 | t4);
            return (int)(acc & 0xFFFFFFFFFFFFFFFFL);
        }
        catch (IOException ex) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildImageCompressedHtml(String path) {
        FilterInputStream dis = null;
        try {
            byte[] pixels;
            boolean JPEGLossless = false;
            boolean JPEGBaseline = false;
            if (this.transferSyntax.indexOf(DMUtils.TS_JPEGLossless) != -1) {
                JPEGLossless = true;
            } else if (this.transferSyntax.indexOf(DMUtils.TS_JPEGBaseline) != -1) {
                JPEGBaseline = true;
            } else {
                System.out.println("Unsupported compressedImage " + this.transferSyntax);
                throw new RuntimeException("Unsupported compressedImage " + this.transferSyntax);
            }
            int sizeOfGroupElemVrLen = 12;
            long offset = this.fileOffset + (long)sizeOfGroupElemVrLen;
            dis = new DataInputStream(new URL(path).openStream());
            this.skip(dis, offset + 4L);
            int tableLength = this.read32((DataInputStream)dis);
            if (tableLength != 0) {
                byte[] bbuff = new byte[tableLength * 4];
                this.readfull(dis, bbuff);
                ByteBuffer bf = ByteBuffer.wrap(bbuff);
                if (this.littleEndian) {
                    bf.order(ByteOrder.LITTLE_ENDIAN);
                } else {
                    bf.order(ByteOrder.BIG_ENDIAN);
                }
                this.skip(dis, 4L);
                int frameLength = this.read32((DataInputStream)dis);
                pixels = new byte[frameLength];
                this.readfull(dis, pixels);
            } else {
                int frameLength;
                for (int i = 0; i != this.frame; ++i) {
                    frameLength = this.read32((DataInputStream)dis);
                    this.skip(dis, frameLength);
                }
                frameLength = this.read32((DataInputStream)dis);
                pixels = new byte[frameLength];
                this.readfull(dis, pixels);
            }
            byte[] uncompressedFrame = JPEGLossless ? Compression.decompressFrame(8197, pixels, this.width, this.height) : (JPEGBaseline ? Compression.decompressFrame(8196, pixels, this.width, this.height) : Compression.decompressFrame(8198, pixels, this.width, this.height));
            switch (this.bitsPerPix) {
                case 16: {
                    ByteBuffer bb = ByteBuffer.wrap(uncompressedFrame);
                    short[] sdata = new short[this.width * this.height];
                    bb.asShortBuffer().get(sdata);
                    this.image = dicomImageGen.build16bitImage(this.width, this.height, sdata, 0, 0, (Hashtable)this.prop.clone());
                    return;
                }
                case 8: 
                case 32: {
                    this.image = dicomImageGen.build8bitImage(this.width, this.height, uncompressedFrame, 0, (Hashtable)this.prop.clone());
                    return;
                }
                default: {
                    System.out.println("Unsupported image " + this.bitsPerPix + " type-\"" + this.imgType + "\"");
                    throw new RuntimeException("Unsupported image " + this.bitsPerPix + " type-\"" + this.imgType + "\"");
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != dis) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildImageCompressed() {
        FileInputStream fis = null;
        try {
            String path = this.getFilePath();
            if (path.startsWith("http://")) {
                this.buildImageCompressedHtml(path);
                return;
            }
            boolean JPEGLossless = false;
            boolean JPEGBaseline = false;
            if (this.transferSyntax.indexOf(DMUtils.TS_JPEGLossless) != -1) {
                JPEGLossless = true;
            } else if (this.transferSyntax.indexOf(DMUtils.TS_JPEGBaseline) != -1) {
                JPEGBaseline = true;
            } else {
                System.out.println("Unsupported compressedImage " + this.transferSyntax);
                throw new RuntimeException("Unsupported compressedImage " + this.transferSyntax);
            }
            int sizeOfGroupElemVrLen = 12;
            long offset = this.fileOffset + (long)sizeOfGroupElemVrLen;
            fis = new FileInputStream(new File(path));
            FileChannel fc = fis.getChannel();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            if (this.littleEndian) {
                mbb.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                mbb.order(ByteOrder.BIG_ENDIAN);
            }
            mbb.position((int)offset);
            int group = mbb.getShort() & 0xFFFF;
            int elem = mbb.getShort() & 0xFFFF;
            if (group != 65534 || elem != 57344) return;
            int len = mbb.getInt();
            int[] tableValues = new int[len / 4];
            for (int i = 0; i < tableValues.length; ++i) {
                tableValues[i] = mbb.getInt();
            }
            int startingPosition = mbb.position();
            if (tableValues.length > 0) {
                mbb.position(startingPosition + tableValues[this.frame]);
            } else {
                for (int i = 0; i < this.frame; ++i) {
                    group = mbb.getShort() & 0xFFFF;
                    elem = mbb.getShort() & 0xFFFF;
                    if (group != 65534 || elem != 57344) continue;
                    int framLen = mbb.getInt();
                    mbb.position(mbb.position() + framLen);
                }
            }
            group = mbb.getShort() & 0xFFFF;
            elem = mbb.getShort() & 0xFFFF;
            if (group != 65534 || elem != 57344) return;
            len = mbb.getInt();
            byte[] data = new byte[len];
            mbb.get(data);
            byte[] uncompressedFrame = JPEGLossless ? Compression.decompressFrame(8197, data, this.width, this.height) : (JPEGBaseline ? Compression.decompressFrame(8196, data, this.width, this.height) : Compression.decompressFrame(8198, data, this.width, this.height));
            switch (this.bitsPerPix) {
                case 16: {
                    ByteBuffer bb = ByteBuffer.wrap(uncompressedFrame);
                    if (this.littleEndian) {
                        bb.order(ByteOrder.LITTLE_ENDIAN);
                    } else {
                        bb.order(ByteOrder.BIG_ENDIAN);
                    }
                    short[] sdata = new short[this.width * this.height];
                    bb.asShortBuffer().get(sdata);
                    this.image = dicomImageGen.build16bitImage(this.width, this.height, sdata, 0, 0, (Hashtable)this.prop.clone());
                    return;
                }
                case 8: 
                case 24: {
                    this.image = dicomImageGen.build8bitImage(this.width, this.height, uncompressedFrame, 0, (Hashtable)this.prop.clone());
                    return;
                }
                default: {
                    System.out.println("2Unsupported image " + this.bitsPerPix + " type-\"" + this.imgType + "\"");
                    throw new RuntimeException("2Unsupported image " + this.bitsPerPix + " type-\"" + this.imgType + "\"");
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildImage() {
        FileInputStream fis24;
        FileInputStream fis16;
        FileInputStream fis8;
        InputStream is24;
        InputStream is16;
        InputStream is8;
        block27: {
            if (this.compressed) {
                this.buildImageCompressed();
                return;
            }
            is8 = null;
            is16 = null;
            is24 = null;
            fis8 = null;
            fis16 = null;
            fis24 = null;
            try {
                int i;
                int read;
                int total;
                byte[] bbuf;
                short[] data;
                switch (this.bitsPerPix) {
                    case 16: {
                        data = new short[this.width * this.height];
                        String path = this.getFilePath();
                        if (path.startsWith("http://")) {
                            is16 = new URL(path).openStream();
                            bbuf = new byte[this.width * this.height * 2];
                            total = 0;
                            int sizeOfGroupElemVrLen = this.explicitVr ? 12 : 8;
                            this.skip(is16, this.fileOffset + (long)sizeOfGroupElemVrLen + (long)(this.width * this.height * 2 * this.frame));
                            break;
                        }
                        fis16 = new FileInputStream(path);
                        FileChannel fc = fis16.getChannel();
                        int sizeOfGroupElemVrLen = this.explicitVr ? 12 : 8;
                        long offset = this.fileOffset + (long)sizeOfGroupElemVrLen + (long)(this.width * this.height * 2 * this.frame);
                        int len = this.width * this.height * 2;
                        MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, offset, len);
                        boolean localinvert = this.invert;
                        try {
                            if (System.getProperty("TAP_BYTE_SWAP", "0").equals("1")) {
                                localinvert = !localinvert;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (localinvert) {
                            mbb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        mbb.asShortBuffer().get(data);
                        this.image = dicomImageGen.build16bitImage(this.width, this.height, data, 0, 0, (Hashtable)this.prop.clone());
                        break block27;
                    }
                    case 8: {
                        byte[] data2 = new byte[this.width * this.height];
                        String path = this.getFilePath();
                        int sizeOfGroupElemVrLen = this.explicitVr ? 12 : 8;
                        long offset = this.fileOffset + (long)sizeOfGroupElemVrLen + (long)(this.width * this.height * this.frame);
                        if (path.startsWith("http://")) {
                            is8 = new URL(path).openStream();
                            this.skip(is8, offset);
                            this.readfull(is8, data2);
                            this.image = dicomImageGen.build8bitImage(this.width, this.height, data2, 0, (Hashtable)this.prop.clone());
                            break block27;
                        } else {
                            fis8 = new FileInputStream(path);
                            FileChannel fc = fis8.getChannel();
                            int len = this.width * this.height * 1;
                            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, offset, len);
                            mbb.get(data2);
                            this.image = dicomImageGen.build8bitImage(this.width, this.height, data2, 0, (Hashtable)this.prop.clone());
                        }
                        break block27;
                    }
                    case 24: {
                        byte[] data3 = new byte[this.width * this.height * 3];
                        int sizeOfGroupElemVrLen = this.explicitVr ? 12 : 8;
                        long offset = this.fileOffset + (long)sizeOfGroupElemVrLen + (long)(this.width * this.height * 3 * this.frame);
                        String path = this.getFilePath();
                        if (path.startsWith("http://")) {
                            is24 = new URL(path).openStream();
                            this.skip(is24, offset);
                            this.readfull(is24, data3);
                            this.image = dicomImageGen.buildRGBImage(this.width, this.height, data3, 0, (Hashtable)this.prop.clone());
                            break block27;
                        } else {
                            fis24 = new FileInputStream(path);
                            FileChannel fc = fis24.getChannel();
                            int len = this.width * this.height * 3;
                            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, offset, len);
                            mbb.get(data3);
                            this.image = dicomImageGen.buildRGBImage(this.width, this.height, data3, 0, (Hashtable)this.prop.clone());
                        }
                        break block27;
                    }
                    default: {
                        System.out.println("1Unsupported image " + this.bitsPerPix + " type-\"" + this.imgType + "\"");
                        throw new RuntimeException("1Unsupported image " + this.bitsPerPix + " type-\"" + this.imgType + "\"");
                    }
                }
                for (total = 0; total < this.width * this.height * 2; total += read) {
                    read = is16.read(bbuf, total, this.width * this.height * 2 - total);
                    if (read != -1) continue;
                    throw new Error("read to much on" + this.getFilePath());
                }
                if (this.invert) {
                    for (i = 0; i < bbuf.length; i += 2) {
                        data[i >> 1] = (short)(bbuf[i] & 0xFF | (bbuf[i + 1] & 0xFF) << 8);
                    }
                } else {
                    for (i = 0; i < bbuf.length; i += 2) {
                        data[i >> 1] = (short)((bbuf[i] & 0xFF) << 8 | bbuf[i + 1] & 0xFF);
                    }
                }
                try {
                    if (System.getProperty("TAP_BYTE_SWAP", "0").equals("1")) {
                        fileImage.byteSwap(data);
                    }
                }
                catch (Exception i2) {
                    // empty catch block
                }
                this.image = dicomImageGen.build16bitImage(this.width, this.height, data, 0, 0, (Hashtable)this.prop.clone());
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException(ex);
                }
                catch (Throwable throwable) {
                    fileImage.closeStream(is8);
                    fileImage.closeStream(is16);
                    fileImage.closeStream(is24);
                    fileImage.closeStream(fis8);
                    fileImage.closeStream(fis16);
                    fileImage.closeStream(fis24);
                    throw throwable;
                }
            }
        }
        fileImage.closeStream(is8);
        fileImage.closeStream(is16);
        fileImage.closeStream(is24);
        fileImage.closeStream(fis8);
        fileImage.closeStream(fis16);
        fileImage.closeStream(fis24);
        return;
    }

    private static void closeStream(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void skip(InputStream s, long length) throws IOException {
        int total = 0;
        while ((long)total < length) {
            total = (int)((long)total + s.skip(length - (long)total));
        }
    }

    private void readfull(InputStream s, byte[] data) throws IOException {
        int read;
        for (int total = 0; total < data.length; total += read) {
            read = s.read(data, total, data.length - total);
            if (read != -1) continue;
            throw new Error("read to much on");
        }
    }

    @Override
    public DMiComposite getComposite() {
        return this.fc;
    }

    public String getFilePath() {
        return this.fc.getFilePath();
    }

    public static DMElement[] buildNeededTag(DMTag[] dmtags) {
        int i;
        int[][] tags = new int[][]{{2, 16}, {16, 16}, {24, 80}, {32, 50}, {32, 55}, {40, 2}, {40, 4}, {40, 8}, {40, 16}, {40, 17}, {40, 18}, {40, 48}, {40, 256}, {40, 257}, {40, 258}, {32736, 16}};
        int extra = dmtags != null ? dmtags.length : 0;
        Object[] tget = new DMElement[tags.length + extra];
        for (i = 0; i < tags.length; ++i) {
            tget[i] = new DMElement(tags[i][0], tags[i][1]);
            if (tags[i][0] != 32736 || tags[i][1] != 16) continue;
            ((tagValue)tget[i]).setFillValue(false);
        }
        if (dmtags != null) {
            for (i = 0; i < dmtags.length; ++i) {
                tget[tags.length + i] = new DMElement(dmtags[i].getGroup(), dmtags[i].getElement());
            }
            Arrays.sort(tget);
        }
        return tget;
    }

    public static DMElement[] getImageTags(DMiComposite fc, DMTag[] dmtags) {
        DMElement[] tget = fileImage.buildNeededTag(dmtags);
        fc.getValues(tget);
        return tget;
    }

    public static int getBitsPerPix(DMElement[] tget) {
        int bitsPerPix = 0;
        String imgType = ((String)dicomImageGen.get(tget, 40, 4)).trim();
        if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
            bitsPerPix = (Integer)dicomImageGen.get(tget, 40, 256) == 16 ? 16 : 8;
        } else if (imgType.equals("RGB")) {
            bitsPerPix = 24;
        } else if (imgType.equals("PALETTE COLOR")) {
            bitsPerPix = (Integer)dicomImageGen.get(tget, 40, 256) == 16 ? 16 : 8;
        } else {
            Tap.log.log(Level.WARNING, "Unable to parse \"{0}\"", imgType);
        }
        return bitsPerPix;
    }

    public static fileImage[] getImages(DMiComposite fc, DMTag[] dmtags) {
        return fileImage.getImages(fc, dmtags, -1);
    }

    public static fileImage[] getImages(DMiComposite fc, DMTag[] dmtags, int getFrame) {
        boolean littleEndian;
        int extra;
        tagValue[] tget = fileImage.getImageTags(fc, dmtags);
        int n = extra = dmtags != null ? dmtags.length : 0;
        if (dicomImageGen.get(tget, 40, 4) == null) {
            return new fileImage[0];
        }
        String imgType = ((String)dicomImageGen.get(tget, 40, 4)).trim();
        int dimy = (Integer)dicomImageGen.get(tget, 40, 16);
        int dimx = (Integer)dicomImageGen.get(tget, 40, 17);
        int frames = dicomImageGen.get(tget, 40, 8) != null ? Integer.parseInt((String)dicomImageGen.get(tget, 40, 8)) : 1;
        String name = null;
        try {
            name = PersonName.toFormattedString(((String)dicomImageGen.get(tget, 16, 16)).trim());
        }
        catch (Exception e) {
            System.out.println("Patient Name (0x0010,0x0010) not found!");
        }
        int pixeldataIndex = tget.length - 1;
        long offset = tget[pixeldataIndex].getOffset();
        boolean invert = littleEndian = tget[pixeldataIndex].isLittleEndian();
        boolean explicitVr = ((DMElement)tget[pixeldataIndex]).explicitVR;
        boolean compressed = false;
        String ts = (String)dicomImageGen.get(tget, 2, 16);
        if (ts != null && (ts.indexOf(DMUtils.TS_JPEGLossless) != -1 || ts.indexOf(DMUtils.TS_JPEGBaseline) != -1 || ts.indexOf(DMUtils.TS_RLELossless) != -1)) {
            compressed = true;
        }
        int bitsPerPix = fileImage.getBitsPerPix((DMElement[])tget);
        Hashtable<String, Object> base = new Hashtable<String, Object>(1 + extra);
        base.put("16,16", null != name ? name : "");
        for (int i = 0; i < extra; ++i) {
            Object value = dicomImageGen.get(tget, dmtags[i].getGroup(), dmtags[i].getElement());
            if (value == null) continue;
            if (value instanceof DMiSequence) {
                base.put(dmtags[i].getGroup() + "," + dmtags[i].getElement(), new DMSequence((DMiSequence)value));
                continue;
            }
            base.put(dmtags[i].getGroup() + "," + dmtags[i].getElement(), value);
        }
        fileImage[] dmimage = getFrame == -1 ? new fileImage[frames] : new fileImage[1];
        for (int i = 0; i < dmimage.length; ++i) {
            dmimage[i] = new fileImage();
            dmimage[i].fc = fc;
            dmimage[i].width = dimx;
            dmimage[i].height = dimy;
            dmimage[i].frame = getFrame == -1 ? i : getFrame;
            dmimage[i].PName = name;
            dmimage[i].bitsPerPix = bitsPerPix;
            dmimage[i].imgType = imgType;
            dmimage[i].fileOffset = offset;
            dmimage[i].prop = (Hashtable)base.clone();
            dmimage[i].prop.put("0,1", new Integer(1 + dmimage[i].frame));
            dmimage[i].invert = invert;
            dmimage[i].explicitVr = explicitVr;
            dmimage[i].compressed = compressed;
            dmimage[i].transferSyntax = ts;
            dmimage[i].littleEndian = littleEndian;
            fileImageManager.getInstance().addImage(dmimage[i]);
        }
        return dmimage;
    }

    private static void byteSwap(short[] b) {
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            b[i] = (short)((b[i] & 0xFF) << 8 | (b[i] & 0xFF00) >> 8);
        }
    }

    @Override
    public int getFrameNumber() {
        return this.frame;
    }

    @Override
    protected void fileImageManagerAccess() {
        fileImageManager.getInstance().access(this);
    }
}

