/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sql;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.sql.SqlComposite;
import com.ge.med.terra.tap.dm.sql.SqlImage;
import com.ge.med.terra.tap.dm.sql.SqlImageObject;
import com.ge.med.terra.tap.dm.sql.SqlSession;
import com.ge.med.terra.tap.dm.sql.SqlUtils;
import java.awt.image.BufferedImage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class SqlObject
implements DMiObject,
DMTagValueInterface {
    private static DateFormat timestampFormatter = new SimpleDateFormat("yyyyMMdd");
    protected SqlSession session;
    protected int level;
    protected String id;
    protected String parentId;
    protected final HashMap cache = new HashMap();
    protected SqlComposite composite;

    protected SqlObject(SqlSession session, ResultSet rs, Map columnMap) {
        this.session = session;
        for (String columnName : columnMap.keySet()) {
            try {
                Object o = rs.getObject(columnName);
                if (o instanceof Timestamp) {
                    o = timestampFormatter.format((Timestamp)o);
                }
                this.cache.put(columnMap.get(columnName), o != null ? o.toString() : o);
            }
            catch (Exception exception) {}
        }
    }

    protected abstract SqlObject getParent();

    protected abstract List getChildren(DMQuery var1);

    protected abstract SqlComposite getComposite();

    @Override
    public String getType() {
        return SqlUtils.LEVELS[this.level];
    }

    @Override
    public Object getValue(DMTag t) {
        if (this.cache.containsKey(t)) {
            return this.cache.get(t);
        }
        SqlComposite pc = this.getComposite();
        return pc.getValue(t);
    }

    @Override
    public void getValues(DMElement[] elements) {
        DMTag tag2;
        int i;
        int fillCount = 0;
        for (i = 0; i < elements.length; ++i) {
            tag2 = new DMTag(elements[i].group, elements[i].element);
            if (!this.cache.containsKey(tag2)) continue;
            elements[i].value = this.cache.get(tag2);
            elements[i].fileOffset = -1L;
            elements[i].len = -1;
            ++fillCount;
        }
        if (elements.length == fillCount) {
            return;
        }
        this.getComposite().getValues(elements);
        for (i = 0; i < elements.length; ++i) {
            if (elements[i].value != null || !this.cache.containsKey(tag2 = new DMTag(elements[i].group, elements[i].element))) continue;
            elements[i].value = this.cache.get(tag2);
            elements[i].fileOffset = -1L;
            elements[i].len = -1;
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        throw new UnsupportedOperationException("SqlObject:setValues() is not supported");
    }

    protected SqlComposite[] filterComposites(List list, DMQuery q) {
        if (q != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (q.valid((SqlComposite)iter.next())) continue;
                iter.remove();
            }
        }
        return list.toArray(new SqlComposite[list.size()]);
    }

    protected SqlComposite getComposite(String seriesId, String tableName) {
        List list = this.getComposites(null, seriesId, tableName, true);
        return list.size() > 0 ? (SqlComposite)list.get(0) : null;
    }

    protected List getComposites(DMQuery q, String seriesId, String tableName) {
        return this.getComposites(q, seriesId, tableName, false);
    }

    protected List getComposites(DMQuery q, String seriesId, String tableName, boolean limitToOne) {
        ArrayList<SqlComposite> list = new ArrayList<SqlComposite>();
        String str = SqlUtils.getSqlString(q, SqlImageObject.columnToTagMap);
        String limit = limitToOne ? " LIMIT 1" : "ORDER BY rank_in_series";
        String multiframe = SqlUtils.getMultiframeColumn(tableName);
        String sql = "SELECT object_id, local_path" + multiframe + " FROM " + tableName + " WHERE series_id = '" + seriesId + "'" + str + limit + ";";
        try {
            ResultSet rs = this.session.con.createStatement().executeQuery(sql);
            while (rs.next()) {
                String imageId = tableName + '|' + rs.getString(1);
                String localPath = rs.getString(2);
                int numberOfFrames = multiframe.length() > 0 ? rs.getInt(3) : 1;
                list.add(this.session.makeNewSqlComposite(localPath, imageId, numberOfFrames));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new DMException(e);
        }
        return list;
    }

    protected SqlComposite getComposite(DMQuery q, String seriesId, String tableName) {
        SqlComposite sqlComposite = null;
        String str = SqlUtils.getSqlString(q, SqlImageObject.columnToTagMap);
        String multiframe = SqlUtils.getMultiframeColumn(tableName);
        String sql = "SELECT object_id, local_path" + multiframe + " FROM " + tableName + " WHERE series_id = '" + seriesId + "'" + str + ";";
        try {
            ResultSet rs = this.session.con.createStatement().executeQuery(sql);
            if (rs.next()) {
                String id = tableName + '|' + rs.getString(1);
                String localPath = rs.getString(2);
                int numberOfFrames = multiframe.length() > 0 ? rs.getInt(3) : 1;
                sqlComposite = this.session.makeNewSqlComposite(localPath, id, numberOfFrames);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new DMException(e);
        }
        return sqlComposite;
    }

    @Override
    public int getNumberOfComposites(DMQuery q) {
        return this.getNumberOfRelated(SqlUtils.LEVELS[3], q);
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q, rcvr);
        return list.toArray(new DMiObject[list.size()]);
    }

    @Override
    public void getRelated(String type, DMQuery q, DMiObjectReceiver cb) {
        int delta = SqlUtils.getLevelIndex(this.getType()) - SqlUtils.getLevelIndex(type);
        if (delta < 0) {
            List children = this.getChildren(q);
            for (int i = 0; i < children.size(); ++i) {
                SqlObject so = (SqlObject)children.get(i);
                if (so.level == SqlUtils.getLevelIndex(type)) {
                    if (q != null && !q.valid(so) || cb.gotOne(so)) continue;
                    return;
                }
                so.getRelated(type, q, cb);
            }
        } else if (q == null || q.valid(this)) {
            if (delta == 0) {
                cb.gotOne(this);
            } else {
                SqlObject so = this;
                for (int i = 0; i < delta; ++i) {
                    so = so.getParent();
                }
                cb.gotOne(so);
            }
        }
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q) {
        return this.getRelated(ieType, q).length;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("SqlObject:delete() is not supported");
    }

    @Override
    public int getLock() {
        return 0;
    }

    @Override
    public void setLock(int lockType) {
    }

    @Override
    public DMTag[] getTags() {
        return this.getComposite().getTags();
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        DMiComposite[] composites = this.getComposites(null);
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>(composites.length);
        for (int i = 0; i < composites.length; ++i) {
            BufferedImage[] imgs = composites[i].getPixelData(tags);
            for (int j = 0; j < imgs.length; ++j) {
                list.add(imgs[j]);
            }
        }
        return list.toArray(new BufferedImage[list.size()]);
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        SqlComposite[] dmc = (SqlComposite[])this.getComposites(null);
        ArrayList<SqlImage> list = new ArrayList<SqlImage>(dmc.length);
        for (int i = 0; i < dmc.length; ++i) {
            SqlComposite c = dmc[i];
            SqlImage[] dmi = (SqlImage[])c.getImages(tags);
            for (int j = 0; j < dmi.length; ++j) {
                list.add(new SqlImage(c, j));
            }
        }
        return list.toArray(new DMiImage[list.size()]);
    }
}

